<?php

return array(

  'taxido' => 'تاكسيدو',
  'status' => 'الحالة',
  'search'=>'بحث',
  'clear' => 'مسح',
'ride' => [
            'admin' => [
                'email' => [
                    'subject' => 'تحديث الرحلة #{ride_number}: {status} 🚖',
                    'greeting' => 'مرحبًا أيها المدير،',
                    'body' => 'يتطلب تحديث حالة الرحلة انتباهك.',
                    'footer' => 'يرجى مراجعة التفاصيل في لوحة الإدارة.',
                ],
                'push' => [
                    'pending' => [
                        'title' => '📢 رحلة جديدة معلقة',
                        'body' => 'الرحلة #{ride_number} في انتظار المراجعة. يرجى المتابعة. 📋',
                    ],
                    'requested' => [
                        'title' => '🔔 تم استلام طلب رحلة',
                        'body' => 'تم طلب الرحلة #{ride_number}. في انتظار تعيين سائق. 🚖',
                    ],
                    'scheduled' => [
                        'title' => '📅 رحلة مجدولة',
                        'body' => 'الرحلة #{ride_number} مجدولة. تم تأكيد جميع التفاصيل. ✅',
                    ],
                    'accepted' => [
                        'title' => '✔️ تم قبول الرحلة',
                        'body' => 'تم قبول الرحلة #{ride_number} من قبل السائق. 🚗',
                    ],
                    'rejected' => [
                        'title' => '🚫 تم رفض الرحلة',
                        'body' => 'تم رفض الرحلة #{ride_number}. يرجى المراجعة لإعادة التعيين. 🔍',
                    ],
                    'arrived' => [
                        'title' => '📍 وصول السائق',
                        'body' => 'وصل السائق للرحلة #{ride_number}. جاهز للاستلام. 🏠',
                    ],
                    'started' => [
                        'title' => '🚀 بدء الرحلة',
                        'body' => 'الرحلة #{ride_number} قيد التقدم. تابع التحديثات. 🌟',
                    ],
                    'cancelled' => [
                        'title' => '❌ تم إلغاء الرحلة',
                        'body' => 'تم إلغاء الرحلة #{ride_number}. راجع التفاصيل. 📝',
                    ],
                    'completed' => [
                        'title' => '🎉 اكتمال الرحلة',
                        'body' => 'تم إكمال الرحلة #{ride_number} بنجاح. عمل رائع! 🥳',
                    ],
                ],
            ],
            'rider' => [
                'email' => [
                    'subject' => 'حالة الرحلة #{ride_number}: {status} 🚖',
                    'greeting' => 'مرحبًا {rider_name}،',
                    'body' => 'إليك آخر تحديث حول رحلتك.',
                    'extra' => 'شكرًا لاختيارك خدمتنا! نحن هنا لمساعدتك.',
                ],
                'push' => [
                    'pending' => [
                        'title' => '📢 الرحلة #{ride_number} معلقة',
                        'body' => 'رحلتك في انتظار التأكيد. سنخطرك قريبًا! ⏳',
                    ],
                    'requested' => [
                        'title' => '🔔 الرحلة #{ride_number} مطلوبة',
                        'body' => 'يتم معالجة طلب رحلتك. سيتم تعيين سائق قريبًا. 🚖',
                    ],
                    'scheduled' => [
                        'title' => '📅 الرحلة #{ride_number} مجدولة',
                        'body' => 'تم تأكيد رحلتك في {timestamp}. استعد! ✅',
                    ],
                    'accepted' => [
                        'title' => '✔️ الرحلة #{ride_number} مقبولة',
                        'body' => 'قبل السائق {driver_name} رحلتك. سيصل قريبًا إلى {pickup_location}. 🚗',
                    ],
                    'rejected' => [
                        'title' => '🚫 الرحلة #{ride_number} مرفوضة',
                        'body' => 'تم رفض رحلتك. نحن نعمل على إيجاد سائق آخر. 🔍',
                    ],
                    'arrived' => [
                        'title' => '📍 وصول السائق للرحلة #{ride_number}',
                        'body' => 'السائق {driver_name} في {pickup_location}. التقِ به الآن! 🏠',
                    ],
                    'started' => [
                        'title' => '🚀 الرحلة #{ride_number} بدأت',
                        'body' => 'رحلتك مع {driver_name} قيد التقدم. سفرًا آمنًا! 🌟',
                    ],
                    'cancelled' => [
                        'title' => '❌ الرحلة #{ride_number} ملغاة',
                        'body' => 'تم إلغاء رحلتك. يرجى حجز رحلة أخرى إذا لزم الأمر. 📝',
                    ],
                    'completed' => [
                        'title' => '🎉 الرحلة #{ride_number} مكتملة',
                        'body' => 'اكتملت رحلتك إلى {destination}. شكرًا لسفرك معنا! 🥳',
                    ],
                ],
            ],
            'driver' => [
                'email' => [
                    'subject' => 'تكليف الرحلة #{ride_number}: {status} 🚖',
                    'greeting' => 'مرحبًا {driver_name}،',
                    'body' => 'لديك تحديث جديد للرحلة.',
                    'extra' => 'شكرًا على خدمتك! استمر في عملك الرائع.',
                ],
                'push' => [
                    'pending' => [
                        'title' => '📢 رحلة جديدة #{ride_number} متاحة',
                        'body' => 'رحلة جديدة في انتظار القبول. تحقق من التفاصيل! ⏳',
                    ],
                    'requested' => [
                        'title' => '🔔 الرحلة #{ride_number} مطلوبة',
                        'body' => 'طلب رحلة جديد متاح. اقبله الآن! 🚖',
                    ],
                    'scheduled' => [
                        'title' => '📅 الرحلة #{ride_number} مجدولة',
                        'body' => 'رحلة مجدولة في {timestamp}. استعد وفقًا لذلك! ✅',
                    ],
                    'accepted' => [
                        'title' => '✔️ الرحلة #{ride_number} مقبولة',
                        'body' => 'لقد قبلت الرحلة #{ride_number}. توجه إلى {pickup_location}! 🚗',
                    ],
                    'rejected' => [
                        'title' => '🚫 الرحلة #{ride_number} مرفوضة',
                        'body' => 'لقد رفضت الرحلة #{ride_number}. تحقق من التكليفات الجديدة. 🔍',
                    ],
                    'arrived' => [
                        'title' => '📍 وصول إلى نقطة الاستلام للرحلة #{ride_number}',
                        'body' => 'أنت في {pickup_location}. انتظر {rider_name}. 🏠',
                    ],
                    'started' => [
                        'title' => '🚀 الرحلة #{ride_number} بدأت',
                        'body' => 'الرحلة مع {rider_name} قيد التقدم. قم بالقيادة بأمان! 🌟',
                    ],
                    'cancelled' => [
                        'title' => '❌ الرحلة #{ride_number} ملغاة',
                        'body' => 'تم إلغاء الرحلة #{ride_number}. تحقق من الرحلات الجديدة. 📝',
                    ],
                    'completed' => [
                        'title' => '🎉 الرحلة #{ride_number} مكتملة',
                        'body' => 'عمل رائع! اكتملت الرحلة إلى {destination}. 🥳',
                    ],
                ],
            ],
            'email' => [
                'details' => 'تفاصيل الرحلة:',
                'ride_id' => 'معرف الرحلة: {ride_number}',
                'status' => 'الحالة: {status}',
                'rider' => 'الراكب: {rider_name}',
                'driver' => 'السائق: {driver_name}',
                'pickup_location' => 'موقع الاستلام: {pickup_location}',
                'destination' => 'الوجهة: {destination}',
                'timestamp' => 'الطابع الزمني: {timestamp}',
                'salutation' => 'مع أطيب التحيات،
                فريق الرحلات',
            ],
        ],

  'yes' => 'نعم',
  'no' => 'لا',
  'wallet_feature_on' => 'ميزة المحفظة معطلة',
  'inactive' => 'غير نشط',
  'cab_management' => 'إدارة السيارات',
  'price_management' => 'إدارة الأسعار',
  'ride_management' => 'إدارة الرحلات',
  'cab' => 'سيارة',
  'vehicles' => 'المركبات',
  'demo_mode' => 'وضع التجربة',
  'save' => 'حفظ',
  'section' => 'إدارة تاكسيدو',
  'save_and_exit' => 'حفظ وخروج',
  'save' => 'حفظ',
  'active' => 'نشط',
  'deactive' => 'غير نشط',
  'ride_details' => 'تفاصيل الرحلة',
  'no_result' => 'لا توجد نتائج.',
  'driver_details' => 'تفاصيل السائق',
  'link' => 'رابط',
  'name' => 'الاسم',
  'here' => 'هنا',
  'submit' => 'إرسال',
  'see_details' => 'عرض التفاصيل',
  'cash_payments_is_disabled' => 'الدفع النقدي معطل، اتصل بالإدارة.',
  'online_payments_is_disabled' => 'الدفع عبر الإنترنت معطل، اتصل بالإدارة.',
  'drivers' => array (
    'general' => 'عام',
    'address' => 'العنوان',
    'all' => 'جميع السائقين',
    'location' => 'الموقع',
    'fleet_manager' => 'مدير الأسطول',
    'select_fleet_manager' => 'اختر مدير الأسطول',
    'is_online' => 'متواجد عبر الإنترنت',
    'is_verified' => 'تم التحقق',
    'is_on_ride' => 'في رحلة',
    'no_driver_found' => 'لم يتم العثور على سائق',
    'confirm_password' => 'تأكيد كلمة المرور',
    'new_password' => 'كلمة مرور جديدة',
    'enter_password' => 'أدخل كلمة المرور',
    'enter_confirm_password' => 'أدخل تأكيد كلمة المرور',
    'total_earnings' => 'الإيرادات الإجمالية',
    'current_driver_location' => 'موقع السائق',
    'wallet' => 'المحفظة',
    'pending_withdraw_request' => 'طلب سحب معلق',
    'contact_number' => 'رقم الاتصال',
    'drivers' => 'السائقون',
    'no_documents' => 'لا توجد وثائق سائق متاحة',
    'no_withdraw_requests' => 'لا توجد طلبات سحب متاحة',
    'vehicle_info' => 'لا توجد معلومات عن المركبة متاحة',
    'total_rides' => 'الرحلات الإجمالية',
    'select_rental_vehicle' => 'اختر مركبة الإيجار',
    'no_rental_message' => '*لإضافة مركبة إيجار جديدة، انقر فقط',
    'unverified_drivers' => 'سائقون غير متحققين',
    'enter_state' => 'أدخل الولاية',
    'create' => 'إنشاء سائق',
    'add' => 'إضافة سائق',
    'edit_profile' => 'تعديل الملف الشخصي',
    'document' => 'الوثيقة',
    'driver_documents' => 'وثائق السائق',
    'add_driver' => 'إضافة سائق',
    'edit' => 'تعديل السائق',
    'personal_information' => 'المعلومات الشخصية',
    'role_permissions' => 'الدور والصلاحيات',
    'profile_image' => 'صورة الملف الشخصي',
    'full_name' => 'الاسم الكامل',
    'email' => 'البريد الإلكتروني',
    'phone' => 'الهاتف',
    'other_details' => 'تفاصيل أخرى',
    'field' => 'الحقول',
    'value' => 'القيمة',
    'add_new' => 'إضافة جديد',
    'unverified_driver' => 'سائقون غير متحققين',
    'enter_full_name' => 'أدخل الاسم الكامل',
    'enter_email' => 'أدخل البريد الإلكتروني',
    'role' => 'الدور',
    'verified_drivers' => 'سائقون متحققون',
    'enter_phone' => 'أدخل الهاتف',
    'select_role' => 'اختر الدور',
    'reviews' => 'التعليقات',
    'notification' => 'إخطار السائق',
    'sentence' => 'إرسال بريد إلكتروني إلى السائق الجديد حول حسابه.',
    'vehicle' => 'المركبة',
    'vehicle_type' => 'نوع المركبة',
    'model' => 'الطراز',
    'enter_model' => 'أدخل طراز المركبة',
    'plate_number' => 'رقم اللوحة',
    'enter_plate_number' => 'أدخل رقم لوحة المركبة',
    'select_vehicle' => 'اختر نوع المركبة',
    'seat' => 'المقعد',
    'enter_seat' => 'أدخل مقعد المركبة',
    'color' => 'اللون',
    'enter_color' => 'أدخل لون المركبة',
    'publish' => 'نشر',
    'payout_details' => 'تفاصيل الدفع',
    'bank_account_no' => 'رقم الحساب البنكي',
    'enter_bank_account' => 'أدخل رقم الحساب البنكي',
    'bank_name' => 'اسم البنك',
    'enter_bank_name' => 'أدخل اسم البنك',
    'holder_name' => 'اسم الحامل',
    'enter_holder_name' => 'أدخل اسم الحامل',
    'swift' => 'سويفت',
    'enter_swift_code' => 'أدخل كود سويفت',
    'routing_number' => 'رقم التوجيه',
    'enter_routing_number' => 'أدخل رقم التوجيه',
    'paypal_email' => 'بريد باي بال',
    'enter_paypal_email' => 'أدخل بريد باي بال',
    'enter_address' => 'أدخل العنوان',
    'street_address' => 'عنوان الشارع',
    'enter_street_address' => 'أدخل عنوان الشارع',
    'area_locality' => 'المنطقة/المحلية',
    'no_zones_message' => '*لإضافة منطقة جديدة، انقر فقط',
    'enter_area_locality' => 'أدخل المنطقة أو المحلية',
    'country' => 'البلد',
    'select_country' => 'اختر البلد',
    'state' => 'الولاية',
    'select_state' => 'اختر الولاية',
    'city' => 'المدينة',
    'enter_city' => 'أدخل المدينة',
    'postal_code' => 'الرمز البريدي',
    'zones' => 'المناطق',
    'vehicle_information' => 'معلومات المركبة',
    'rules' => 'قواعد السائق',
    'seats' => 'المقاعد',
    'vehicle_color' => 'لون المركبة:',
    'vehicle_num' => 'رقم المركبة:',
    'vehicle_types' => 'نوع المركبة:',
    'no_vehicle_information' => 'لم يتم العثور على معلومات عن المركبة',
    'zone' => 'المنطقة:',
    'no_zones' => 'لا توجد مناطق متاحة',
    'bank_details' => 'تفاصيل البنك',
    'bank_names' => 'اسم البنك:',
    'ride_number' => 'رقم الرحلة',
    'service' => 'الخدمة',
    'service_category' => 'فئة الخدمة',
    'ride_status' => 'حالة الرحلة',
    'payment_method' => 'طريقة الدفع',
    'payment_status' => 'حالة الدفع',
    'total_amount' => 'المبلغ الإجمالي',
    'holder_names' => 'اسم الحامل:',
    'account_number' => 'رقم الحساب',
    'other_info' => 'معلومات أخرى:',
    'no_bank_details' => 'لم يتم العثور على تفاصيل بنكية',
    'intercity_ride_list' => 'رحلات بين المدن',
    'package_ride_list' => 'رحلات الحزم',
    'no_rides_available' => 'لا توجد رحلات متاحة',
    'intracity_ride_list' => 'رحلات داخل المدينة',
    'no_intercity_rides' => 'لم يتم العثور على رحلات بين المدن',
    'no_intercity_rides_available' => 'لا توجد رحلات بين المدن متاحة',
    'no_intracity_rides' => 'لم يتم العثور على رحلات داخل المدينة',
    'no_intracity_rides_available' => 'لا توجد رحلات داخل المدينة متاحة',
    'no_schedule_rides' => 'لم يتم العثور على رحلات مجدولة',
    'no_schedule_rides_available' => 'لا توجد رحلات مجدولة متاحة',
    'no_rental_rides' => 'لم يتم العثور على رحلات إيجار',
    'no_rental_rides_available' => 'لا توجد رحلات إيجار متاحة',
    'scheduled_rides' => 'رحلات مجدولة',
    'rental_rides' => 'رحلات إيجار',
    'profile_details' => 'تفاصيل الملف الشخصي',
    'wallet_balance' => 'رصيد المحفظة',
    'select_zones' => 'اختر المناطق',
    'enter_postal_code' => 'أدخل الرمز البريدي',
    'additional_info' => 'معلومات إضافية',
    'create_successfully' => 'تم إنشاء السائق بنجاح.',
    'update_successfully' => 'تم تحديث السائق بنجاح.',
    'delete_successfully' => 'تم حذف السائق بنجاح.',
    'restore_successfully' => 'تم استعادة السائق بنجاح.',
    'permanent_delete_successfully' => 'تم حذف السائق نهائيًا بنجاح.',
    'status_update_successfully' => 'تم تحديث حالة السائق بنجاح.',
    'system_reserved_not_editable' => 'هذا السائق محجوز من النظام وغير قابل للتعديل.',
    'system_reserved_not_deleted' => 'هذا السائق محجوز من النظام ولا يمكن حذفه.',
    'driver_list' => 'قائمة السائقين',
    'live_location' => 'الموقع الحي',
    'driver_location' => 'مواقع السائقين',
    'no_vehicle_type_message' => '*لإضافة نوع مركبة جديد، انقر فقط',
    'current_driver_not_found' => 'لم يتم العثور على السائق الحالي.',
    'driver_details' => 'تفاصيل السائق',
    'rider' => 'الراكب',
    'category' => 'الفئة',
    'total' => 'الإجمالي',
    'created_at' => 'تاريخ الإنشاء',
    'action' => 'الإجراء',
    'account_holder_name' => 'اسم الحامل',
    'swift_code' => 'كود سويفت',
    'driver_rules' => 'قواعد السائق',
    'view_all' => 'عرض الكل',
    'rider_reviews' => 'تعليقات الراكب',
    'rating' => 'التقييم',
    'message' => 'الرسالة',
    'withdraw_requests' => 'طلبات السحب',
    'amount' => 'المبلغ',
    'status' => 'الحالة',
    'payment_type' => 'نوع الدفع',
    'ambulance_name' => 'اسم الإسعاف',
    'ambulance_description' => 'وصف الإسعاف',
    'enter_ambulance_name' => 'أدخل اسم الإسعاف',
    'enter_ambulance_description' => 'أدخل وصف الإسعاف',
    'search_location' => 'البحث عن موقع',
    'max_seat' => 'أقصى مقعد',
  ),
  'auth' => array (
    'sended_otp_registered_numb' => 'لقد أرسلنا OTP إلى رقم الهاتف المسجل.',
    'sms_login_not_enable' => 'طريقة تسجيل الدخول عبر الرسائل النصية غير مفعلة حاليًا',
    'invalid_auth_token' => 'OTP المقدم غير صالح.',
    'no_account_linked' => 'لا يوجد حساب مرتبط بالرقم المعطى.',
    'no_linked_number' => 'لا يوجد حساب مرتبط بالرقم المعطى.',
    'disabled_account' => 'لا يمكنك تسجيل الدخول بحساب معطل.',
    'invalid_login_credentials' => 'بيانات تسجيل الدخول غير صالحة',
  ),
  'zones' => array (
    'zones' => 'المناطق',
    'all' => 'المناطق',
    'name' => 'اسم المنطقة',
    'select_payment_method' => 'اختر طريقة الدفع',
    'payment_method' => 'طريقة الدفع',
    'enter_name' => 'أدخل اسم المنطقة',
    'coordinates' => 'الإحداثيات',
    'place_points' => 'وضع النقاط',
    'map' => 'الخريطة',
    'weight_unit' => 'وحدة الوزن',
    'select_weight_unit' => 'اختر وحدة الوزن',
    'search_location' => 'البحث عن موقع',
    'search_locations' => 'البحث عن موقعك',
    'amount' => 'المبلغ',
    'enter_amount' => 'أدخل المبلغ',
    'add' => 'إضافة منطقة',
    'add_new' => 'إضافة جديد',
    'add_currency_message' => '*لإضافة عملة جديدة، انقر فقط ',
    'select-zone' => 'اختر المنطقة',
    'select_coordinates' => 'اختر الإحداثيات',
    'select_place_points' => 'اختر نقاط المكان',
    'distance_type' => 'نوع المسافة',
    'select_distance_type' => 'اختر نوع المسافة',
    'currency' => 'العملة',
    'select_currency' => 'اختر العملة',
    'create' => 'إنشاء منطقة',
    'edit' => 'تعديل المنطقة',
    'store' => 'تم إضافة المنطقة بنجاح.',
    'restore_successfully' => 'تم استعادة المنطقة بنجاح.',
    'permanent_delete_successfully' => 'تم حذف المنطقة نهائيًا بنجاح.',
    'created' => 'تم إنشاء المنطقة بنجاح.',
    'updated' => 'تم تحديث المنطقة بنجاح.',
    'deleted' => 'تم حذف المنطقة بنجاح.',
    'map_instruction_paragraph_1' => 'تحتاج إلى ثلاث نقاط على الأقل لإنشاء منطقة.',
    'map_instruction_paragraph_2' => 'ابدأ في إضافة دبابيس إلى الخريطة لتحديد المنطقة.',
    'map_instruction_title' => 'انقر على الخريطة للانتقال إلى الموقع المرغوب.',
    'map_instruction_heading' => 'التعليمات',
  ),
  'heatmaps' => array(
    'ride_request_heatmap' => 'خريطة حرارية لطلبات الرحلات',
    'heat_map' => 'خريطة حرارية',
    'text' => 'تمثل هذه الخريطة الحرارية بيانات طلبات الرحلات. المناطق ذات الطلبات الأعلى تظهر ساخنة (أحمر/برتقالي).',
    'heatmap' =>'تبديل الخريطة الحرارية',
    'gradient' => 'تغيير التدرج',
    'radius' => 'تغيير النصف قطر',
    'opacity' => 'تغيير الشفافية'
  ),
  'riders' => array (
    'all' => 'جميع الركاب',
    'riders' => 'الركاب',
    'rider_details' => 'تفاصيل الراكب',
    'create' => 'إنشاء راكب',
    'add' => 'إضافة راكب',
    'add_riders' => 'إضافة ركاب',
    'edit' => 'تعديل الراكب',
    'role_permissions' => 'الدور والصلاحيات',
    'full_name' => 'الاسم الكامل',
    'reviews' => 'التعليقات',
    'personal_information' => 'المعلومات الشخصية',
    'email' => 'البريد الإلكتروني',
    'rating' => 'التقييم',
    'total_rides' => 'الرحلات الإجمالية المكتملة',
    'contact_number' => 'رقم الاتصال',
    'emails' => 'البريد الإلكتروني',
    'driver' => 'السائق',
    'created_at' => 'تاريخ الإنشاء',
    'action' => 'الإجراء',
    'phone' => 'الهاتف',
    'zones' => 'المناطق',
    'no_reviews' => 'لا توجد تعليقات متاحة',
    'description' => 'الوصف',
    'wallet' => 'المحفظة',
    'city' => 'المدينة',
    'no_rides' => 'لا توجد رحلات متاحة',
    'driver_reviews' => 'تعليقات السائق',
    'country' => 'البلد',
    'parcel_otp_disabled' => 'OTP الطرود معطل لإكمال الرحلة.',
    'vehicle_information' => 'معلومات المركبة',
    'seats' => 'المقاعد',
    'payment_method' => 'طريقة الدفع',
    'payment_status' => 'حالة الدفع',
    'total_amount' => 'المبلغ الإجمالي',
    'holder_names' => 'اسم الحامل',
    'wallet_balance' => 'رصيد المحفظة',
    'other_info' => 'معلومات أخرى',
    'intercity_ride_list' => 'رحلات بين المدن',
    'package_ride_list' => 'رحلات الحزم',
    'ride_list' => 'الرحلات',
    'no_rides_available' => 'لا توجد رحلات متاحة',
    'ride_number' => 'رقم الرحلة',
    'account_holder_name' => 'اسم الحامل',
    'bank_name' => 'اسم البنك',
    'account_number' => 'رقم الحساب',
    'routing_code' => 'كود التوجيه',
    'branch_name' => 'اسم الفرع',
    'swift_code' => 'كود سويفت',
    'not_available' => 'غير متاح',
    'no_bank_details' => 'لا توجد تفاصيل بنكية متاحة',
    'other_details' => 'تفاصيل أخرى',
    'service' => 'الخدمة',
    'service_category' => 'فئة الخدمة',
    'ride_status' => 'حالة الرحلة',
    'intracity_ride_list' => 'رحلات داخل المدينة',
    'no_intercity_rides' => 'لم يتم العثور على رحلات بين المدن',
    'no_intercity_rides_available' => 'لا توجد رحلات بين المدن متاحة',
    'no_intracity_rides' => 'لم يتم العثور على رحلات داخل المدينة',
    'no_intracity_rides_available' => 'لا توجد رحلات داخل المدينة متاحة',
    'no_schedule_rides' => 'لم يتم العثور على رحلات مجدولة',
    'no_schedule_rides_available' => 'لا توجد رحلات مجدولة متاحة',
    'no_rental_rides' => 'لم يتم العثور على رحلات إيجار',
    'no_rental_rides_available' => 'لا توجد رحلات إيجار متاحة',
    'scheduled_rides' => 'رحلات مجدولة',
    'rental_rides' => 'رحلات إيجار',
    'profile_details' => 'تفاصيل الملف الشخصي',
    'vehicle_color' => 'لون المركبة:',
    'vehicle_num' => 'رقم المركبة',
    'vehicle_types' => 'نوع المركبة:',
    'no_vehicle_information' => 'لم يتم العثور على معلومات عن المركبة',
    'add_new' => 'إضافة جديد',
    'enter_full_name' => 'أدخل الاسم الكامل',
    'enter_email' => 'أدخل البريد الإلكتروني',
    'role' => 'الدور',
    'confirm_password' => 'تأكيد كلمة المرور',
    'new_password' => 'كلمة مرور جديدة',
    'bank_details' => 'تفاصيل البنك',
    'enter_phone' => 'أدخل الهاتف',
    'select_role' => 'اختر الدور',
    'enter_password' => 'أدخل كلمة المرور',
    'enter_confirm_password' => 'أدخل تأكيد كلمة المرور',
    'select_zones' => 'اختر المناطق',
    'notification' => 'إرسال إخطار للراكب',
    'sentence' => 'إرسال بريد إلكتروني إلى الراكب الجديد حول حسابه.',
    'create_successfully' => 'تم إنشاء الراكب بنجاح.',
    'update_successfully' => 'تم تحديث الراكب بنجاح.',
    'delete_successfully' => 'تم حذف الراكب بنجاح.',
    'name' => 'الاسم',
    'ratings' => 'التقييم',
    'restore_successfully' => 'تم استعادة الراكب بنجاح.',
    'permanent_delete_successfully' => 'تم حذف الراكب نهائيًا بنجاح.',
    'status_update_successfully' => 'تم تحديث حالة الراكب بنجاح.',
    'system_reserved_not_editable' => 'هذا الراكب محجوز من النظام وغير قابل للتعديل.',
    'system_reserved_not_deleted' => 'هذا الراكب محجوز من النظام ولا يمكن حذفه.',
  ),
  'banners' => array (
    'id' => 'المعرف',
    'save' => 'حفظ',
    'banners' => 'اللافتات',
    'title' => 'العنوان',
    'action' => 'الإجراء',
    'banner' => 'اللافتة',
    'active' => 'نشط',
    'deactive' => 'غير نشط',
    'all_zones' => 'جميع المناطق',
    'create' => 'إنشاء لافتة',
    'image' => 'الصورة',
    'status' => 'الحالة',
    'type' => 'نوع اللافتة',
    'category' => 'فئة اللافتة',
    'add_new' => 'إضافة جديد',
    'order' => 'الترتيب',
    'zones' => 'المناطق',
    'select_zones' => 'اختر المناطق',
    'add' => 'إضافة لافتة',
    'edit' => 'تعديل اللافتة',
    'all' => 'جميع اللافتات',
    'enter_title' => 'أدخل العنوان',
    'enter_order' => 'أدخل ترتيب اللافتة',
    'message' => 'الرسالة',
    'create_successfully' => 'تم إنشاء اللافتة بنجاح.',
    'update_successfully' => 'تم تحديث اللافتة بنجاح.',
    'delete_successfully' => 'تم حذف اللافتة بنجاح.',
    'restore_successfully' => 'تم استعادة اللافتة بنجاح.',
    'permanent_delete_successfully' => 'تم حذف اللافتة نهائيًا بنجاح',
    'status_update_successfully' => 'تم تحديث حالة اللافتة بنجاح.',
    'no_zones_message' => '*لإضافة منطقة جديدة، انقر فقط',
    'recommended'=> ' *تحميل حجم الصورة الموصى به 8268x4000 بكسل',
  ),
  'vehicle_types' => array (
    'all_zones' => 'جميع المناطق',
    'id' => 'المعرف',
    'name' => 'الاسم',
    'status' => 'الحالة',
    'vehicle' => 'نوع المركبة',
    'vehicles' => 'أنواع المركبات',
    'images' => 'صور المركبات',
    'fare_calculation_instructions' => 'تعليمات حساب الأجرة',
    'surge_price_calculation' => 'حساب سعر الزيادة',
    'surge_applied_based_on' => 'يتم تطبيق سعر الزيادة ديناميكيًا بناءً على:',
    'zone_example' => 'المنطقة – مثل سورات، لندن',
    'time_range_example' => 'نطاق الوقت – مثل الخميس (15:00 - 04:00)',
    'unit_example' => 'وحدة المسافة أو المدة – مثل روبية هندية لكل كم أو دولار أمريكي لكل ميل',
    'surge_condition' => 'إذا حدثت الرحلة ضمن نطاق وقت الزيادة في منطقة معينة، يتم إضافة المبلغ المكون للزيادة لكل وحدة.',
    'surge_example' => 'مثال:',
    'base_fare' => 'الأجرة الأساسية = ₹50',
    'distance' => 'المسافة = 5 كم',
    'price_per_km' => 'السعر لكل كم = ₹10',
    'surge_per_km' => 'الزيادة = ₹2 (لكل كم)',
    'total_fare_formula' => 'الأجرة الإجمالية = الأجرة الأساسية + (المسافة × (السعر لكل كم + الزيادة)) = ₹50 + (5 × (10 + 2)) = ₹110',

    'base_amount' => 'المبلغ الأساسي',
    'is_allow_airport_charge' => 'هل يُسمح بتكلفة المطار',
    'max_seat' => 'أقصى مقعد',
    'enter_max_seat' => 'أدخل أقصى مقعد',
    'vehicle_charge' => 'تكلفة المركبة',
    'total_per_distance_charge' => 'إجمالي تكلفة المسافة',
    'total_per_minute_charge' => 'إجمالي تكلفة الدقيقة',
    'enter_base_amount' => 'أدخل المبلغ الأساسي',
    'enter_name' => 'أدخل الاسم',
    'message' => 'الرسالة',
    'example_3_rental' => 'مثال 3: إيجار',
    'example_4_package' => 'مثال 4: حزمة',
    'services' => 'الخدمات',
    'select_services' => 'اختر الخدمات',
    'add' => 'إضافة نوع مركبة',
    'image' => 'الصورة',
    'vehicle_image' => 'صورة المركبة',
    'example_5_package' => 'مثال 5: طرود',
    'map_icon' => 'أيقونة خريطة المركبة',
    'service_categories' => 'فئات الخدمات',
    'select_service_categories' => 'اختر فئات الخدمات',
    'edit' => 'تعديل نوع المركبة',
    'All' => 'جميع أنواع المركبات',
    'commission_type' => 'نوع العمولة (نسبة مئوية أو ثابتة)',
    'commission_rate' => 'معدل العمولة (مثل، 10% أو $5)',
    'enter_commission_rate' => 'أدخل معدل العمولة',
    'select_commission_type' => 'اختر نوع العمولة',
    'min_per_unit_charge' => 'الحد الأدنى للتكلفة لكل كيلومتر/ميل',
    'max_per_unit_charge' => 'الحد الأقصى للتكلفة لكل كيلومتر/ميل',
    'enter_min_per_unit_charge' => 'أدخل الحد الأدنى للتكلفة للوحدة',
    'enter_max_per_unit_charge' => 'أدخل الحد الأقصى للتكلفة للوحدة',
    'waiting_time_charge' => 'تكلفة لكل دقيقة لوقت الانتظار',
    'enter_waiting_time_charge' => 'أدخل تكلفة الانتظار',
    'cancellation_charge' => 'تكلفة ثابتة لإلغاء الرحلة',
    'enter_cancellation_charge' => 'أدخل تكلفة الإلغاء',
    'select_zones' => 'اختر المناطق',
    'zones' => 'المناطق',
    'apply_service' => 'يتم تطبيقها في جميع الخدمات.',
    'apply_cab_and_freight_and_parcel_service' => 'تُستخدم في خدمات السيارة والشحن والطرود.',
    'apply_cancel_service' => 'تُطبق في جميع الخدمات عند إلغاء الرحلة.',
    'apply_cab_and_freight_service' => 'تُطبق في خدمات السيارة والشحن.',
    'apply_package_and_rental_service' => 'تُستخدم في خدمات الحزم والإيجار.',
    'apply_freight_and_parcel_service' => 'تُستخدم في خدمات الشحن والطرود.',
    'add_new' => 'إضافة جديد',
    'publish' => 'نشر',
    'tax' => 'الضريبة',
    'select_tax' => 'اختر الضريبة',
    'not_found_vehicles_by_points' => 'لم يتم العثور على نوع مركبة بناءً على الموقع المقدم',
    'create_successfully' => 'تم إنشاء نوع المركبة بنجاح.',
    'update_successfully' => 'تم تحديث نوع المركبة بنجاح.',
    'delete_successfully' => 'تم حذف نوع المركبة بنجاح.',
    'restore_successfully' => 'تم استعادة نوع المركبة بنجاح.',
    'permanent_delete_successfully' => 'تم حذف نوع المركبة نهائيًا بنجاح',
    'status_update_successfully' => 'تم تحديث حالة نوع المركبة بنجاح.',
    'no_zones_message' => '*لإضافة منطقة جديدة، انقر فقط',
    'no_tax_message' => '*لإضافة ضريبة جديدة، انقر فقط',
    'min_per_min_charge' => 'الحد الأدنى للتكلفة لكل دقيقة',
    'max_per_min_charge' => 'الحد الأقصى للتكلفة لكل دقيقة',
    'enter_min_per_min_charge' => 'أدخل الحد الأدنى للتكلفة للدقيقة',
    'enter_max_per_min_charge' => 'أدخل الحد الأقصى للتكلفة للدقيقة',
    'min_per_weight_charge' => 'الحد الأدنى للتكلفة لكل كيلوغرام',
    'max_per_weight_charge' => 'الحد الأقصى للتكلفة لكل كيلوغرام',
    'enter_min_per_weight_charge' => 'أدخل الحد الأدنى للتكلفة للوزن',
    'enter_max_per_weight_charge' => 'أدخل الحد الأقصى للتكلفة للوزن',
    'no_vehicle_types_found' => 'لم يتم العثور على أنواع مركبات',
    'search_vehicle_types' => 'البحث عن أنواع المركبات',
    'fare_calculation_instructions' => 'تعليمات حساب الأجرة',
    'key_fields_and_usage' => 'الحقول الرئيسية واستخدامها',
    'field' => 'الحقل',
    'description' => 'الوصف',
    'where_used' => 'أين يُستخدم',
    'tax_id' => 'معدل الضريبة المطبق على الأجرة',
    'bidding_details' => 'تفاصيل العروض',
    'example_calculation' => 'حسابات مثالية',
    'bidding_description' => 'يُستخدم العروض في خدمات السيارة والشحن عند تفعيل إعداد activation.bidding.',
    'bidding_active' => 'إذا كان العروض نشطًا، يتم تحديد الأجرة بواسطة عرض السائق.',
    'bidding_inactive' => 'إذا كان العروض غير نشط، يتم حساب الأجرة بناءً على min_per_unit_charge و max_per_unit_charge.',
    'example_1' => 'مثال 1: سيارة/رحلة',
    'scenario' => 'السيناريو',
    'scenario_description' => 'رحلة 15 كم بأجرة أساسية قدرها $20.',
    'calculation' => 'الحساب',
    'minimum_distance_charge' => 'تكلفة المسافة الدنيا',
    'minimum_distance_charge_amount' => '15 كم * $1.5/كم = $22.5',
    'fare_amount' => 'بما أن $22.5 > $20، الأجرة هي $22.5.',
    'example_2' => 'مثال 2: شحن/بين المدن',
    'freight_scenario_description' => 'توصيل شحن 50 كم بوزن 100 كجم.',
    'freight_distance_charge' => '50 كم * $1.5/كم = $75',
    'freight_total_fare' => 'الأجرة الإجمالية (بين المدن)',
    'freight_fare_amount' => '$75',
    'distance_charge' => 'تكلفة المسافة',
    'weight_charge' => 'تكلفة الوزن',
    'total_fare' => 'الأجرة الإجمالية',
    'prev_button' => 'السابق',
    'next_button' => 'التالي',
    'calculated' => 'كيف يتم حساب هذا؟',
    'rental_scenario_description' => 'رحلة إيجار لمدة 2 أيام مع 3 أيام إضافية من تكلفة الدقائق.',
    'rental_vehicle_charge' => '20 * 2 أيام = $50',
    'rental_total_per_minute_charge' => '10 * 3 أيام = $604',
    'rental_fare_amount' => '$50 + $604 = $654',
    'package_scenario_description' => 'توصيل حزمة بمسافة 10 كم و 20 كم لكل دقيقة تكلفة.',
    'package_distance_charge' => '10 كم * $3/كم = $30',
    'package_minute_charge'=> '20 كم * $3/دقيقة = $60',
    'package_fare_amount' => '$30 + $60 = $90',
    'parcel_scenario_description' => 'توصيل حزمة بمسافة 10 كم و 20 كم لكل دقيقة تكلفة.',
    'parcel_distance_charge' => '50 كم * $2.0/كم = $100',
    'parcel_weight_charge'=> '100 كجم * $1.0/كجم = $100',
    'parcel_fare_amount' => '$100 + $100 = $200'
  ),
  'documents' => array (
    'document' => 'الوثيقة',
    'documents' => 'الوثائق',
    'all' => 'جميع الوثائق',
    'edit' => 'تعديل الوثيقة',
    'need_expired_date' => 'تحتاج إلى تاريخ انتهاء الصلاحية',
    'add_new' => 'إضافة جديد',
    'add_document' => 'إضافة وثيقة',
    'message' => 'الرسالة',
    'name' => 'الاسم',
    'type' => 'النوع',
    'select_type' => 'اختر النوع',
    'enter_name' => 'أدخل الاسم',
    'enter_number' => 'أدخل الرقم',
    'is_required' => 'مطلوب',
    'status' => 'الحالة',
    'create_successfully' => 'تم إنشاء الوثيقة بنجاح.',
    'update_successfully' => 'تم تحديث الوثيقة بنجاح.',
    'delete_successfully' => 'تم حذف الوثيقة بنجاح.',
    'status_update_successfully' => 'تم تحديث حالة الوثيقة بنجاح.',
    'status_update_note' => 'هل أنت متأكد من تحديث حالة الوثيقة؟',
    'permanent_delete_successfully' => 'تم حذف الوثيقة نهائيًا بنجاح.',
    'restore_successfully' => 'تم استعادة الوثيقة بنجاح.',
  ),
  'driver_documents' => array (
    'driverDocument' => 'وثيقة السائق',
    'driver_documents' => 'وثائق السائق',
    'all' => 'جميع وثائق السائق',
    'edit' => 'تعديل وثيقة السائق',
    'add_new' => 'إضافة جديد',
    'add' => 'إضافة وثيقة السائق',
    'driver' => 'السائق',
    'select_driver' => 'اختر السائق',
    'document' => 'الوثيقة',
    'select_document' => 'اختر الوثيقة',
    'document_image' => 'صورة الوثيقة',
    'save' => 'حفظ',
    'status' => 'الحالة',
    'select_status' => 'اختر حالة الوثيقة',
    'approved' => 'معتمد',
    'rejected' => 'مرفوض',
    'pending' => 'معلق',
    'create_successfully' => 'تم إنشاء وثيقة السائق بنجاح.',
    'update_successfully' => 'تم تحديث وثيقة السائق بنجاح.',
    'delete_successfully' => 'تم حذف وثيقة السائق بنجاح.',
    'status_update_successfully' => 'تم تحديث حالة وثيقة السائق بنجاح.',
    'permanent_delete_successfully' => 'تم حذف وثيقة السائق نهائيًا بنجاح.',
    'restore_successfully' => 'تم استعادة وثيقة السائق بنجاح.',
    'no_documents_message' => '*لإضافة وثيقة جديدة، انقر فقط',
    'add_driver_message' => '*لإضافة سائق جديد، انقر فقط',
    'document_id' => 'معرف الوثيقة',
  ),
  'coupons' => array (
    'all' => 'جميع الكوبونات',
    'coupon' => 'كوبون',
    'coupons' => 'الكوبونات',
    'title' => 'العنوان',
    'usage' => 'الاستخدام',
    'code' => 'الكود',
    'services' => 'اختر الخدمات',
    'add_coupon' => 'إضافة كوبون',
    'edit_coupon' => 'تعديل الكوبون',
    'action' => 'الإجراء',
    'add_new' => 'إضافة جديد',
    'enter_title' => 'أدخل العنوان',
    'enter_description' => 'أدخل الوصف',
    'enter_coupon' => 'أدخل الكوبون',
    'enter_code' => 'أدخل الكود',
    'description' => 'الوصف',
    'type' => 'النوع',
    'select_type' => 'اختر النوع',
    'amount' => 'المبلغ',
    'select_date' => 'اختر التاريخ',
    'select_start_date' => 'اختر تاريخ البدء',
    'select_end_date' => 'اختر تاريخ الانتهاء',
    'enter_price' => 'أدخل السعر',
    'start_date' => 'تاريخ البدء',
    'end_date' => 'تاريخ الانتهاء',
    'select_service_category' => 'اختر فئة الخدمة',
    'select_service_categories' => 'اختر فئات الخدمات',
    'select_service' => 'اختر الخدمات',
    'select_services' => 'اختر الخدمات',
    'percentage' => 'نسبة مئوية',
    'enter_amount' => 'أدخل المبلغ',
    'enter_percentage' => 'أدخل النسبة المئوية',
    'is_expired' => 'منتهي الصلاحية',
    'status' => 'الحالة',
    'select_riders' => 'اختر الركاب',
    'general' => 'عام',
    'is_apply_all' => 'تطبيق على الكل',
    'select_zones' => 'اختر المناطق',
    'select_rider' => 'اختر الركاب',
    'service_category' => 'فئة الخدمة',
    'zone' => 'المنطقة',
    'select_vehicle_type' => 'اختر أنواع المركبات',
    'vehicle_type' => 'نوع المركبة',
    'restriction' => 'القيود',
    'minimum_ride_fare' => 'أدنى أجرة رحلة',
    'enter_minimum_ride_fare' => 'أدخل أدنى أجرة رحلة',
    'is_unlimited' => 'غير محدود',
    'usage_per_coupon' => 'الاستخدام لكل كوبون',
    'usage_per_rider' => 'الاستخدام لكل راكب',
    'enter_value' => 'أدخل القيمة',
    'no_riders_message' => '*لإضافة راكب جديد، انقر فقط',
    'no_zones_message' => '*لإضافة منطقة جديدة، انقر فقط',
    'no_vehicleType_message' => '*لإضافة نوع مركبة جديد، انقر فقط',
    'create_successfully' => 'تم إنشاء الكوبون بنجاح.',
    'update_successfully' => 'تم تحديث الكوبون بنجاح.',
    'delete_successfully' => 'تم حذف الكوبون بنجاح.',
    'status_update_successfully' => 'تم تحديث حالة الكوبون بنجاح.',
    'permanent_delete_successfully' => 'تم حذف الكوبون نهائيًا بنجاح.',
    'restore_successfully' => 'تم استعادة الكوبون بنجاح.',
    'to_apply_coupon' => 'لتطبيق كود الكوبون :code، يجب أن يكون إجمالي الرحلة :min_spend أو أعلى.',
    'coupon_feature_disabled' => 'لا يمكن استخدام كود الكوبون حيث أن ميزة الكوبون معطلة حاليًا.',
    'login_required' => 'تحتاج إلى تسجيل الدخول لتطبيق كود الكوبون :code.',
    'usage_limit_reached' => 'يمكن استخدام كود الكوبون :code حتى :usage مرات لكل كوبون.',
    'date_range' => 'كان كود الكوبون :code قابلاً للتطبيق من :start_date إلى :end_date',
    'to' => 'إلى',
  ),
  'rides' => array (
    'ride_request_not_found' => 'طلب الرحلة غير موجود في Firestore.',
    'rides' => 'الرحلات',
    'rider_invoice' => 'فاتورة الراكب',
    'driver_invoice' => 'فاتورة السائق',
    'driver' => 'السائق',
    'only_ambulance_ride_request' => 'يُسمح فقط بطلب رحلة إسعاف.',
    'driver_assign' => 'تعيين السائق',
    'manual' => 'يدوي',
    'riderequests' => 'طلبات الرحلات',
    'cancellation_charges' => 'تكاليف الإلغاء',
    'automatic' => 'تلقائي',
    'select_driver' => 'اختر السائق',
    'this_rental_vehicle_already_booked' => 'هذه المركبة الإيجار محجوزة بالفعل.',
    'rental_ride_request_not_found' => 'لم يتم العثور على طلب رحلة الإيجار هذا.',
    'ride_request_create_successfully' => 'تم إنشاء طلب الرحلة بنجاح',
    'ride_fare' => 'أجرة الرحلة',
    'start_date' => 'تاريخ البدء',
    'extra_charge' => 'تكلفة إضافية',
    'add_location' => 'إضافة موقع',
    'receiver_phone' => 'هاتف مستلم الطرد',
    'enter_receiver_phone' => 'أدخل هاتف مستلم الطرد',
    'start_time' => 'وقت البدء',
    'select_drivers' => 'اختر السائقين',
    'driver_no' => 'تعيين رقم السائق',
    'receiver_full_name' => 'الاسم الكامل لمستلم الطرد',
    'enter_receiver_full_name' => 'أدخل الاسم الكامل لمستلم الطرد',
    'drivers' => 'السائقون',
    'no_drivers_found' => 'لم يتم العثور على سائقين',
    'ambulance_name' => 'اسم الإسعاف',
    'selected_payment_module_not_found' => 'الوحدة الدفع المختارة غير موجودة',
    'ambulance' => 'إسعاف',
    'select_ambulance' => 'اختر الإسعاف',
    'no_of_days' => 'عدد الأيام',
    'ride_requests' => 'طلبات الرحلات',
    'no_driver_selected' => 'لم يتم اختيار سائق',
    'ride_requests' => 'جميع طلبات الرحلات',
    'locations_empty' => 'الموقع مطلوب',
    'ride_request_details' => 'تفاصيل طلب الرحلة',
    'minimum_2_locations_required' => 'يجب توفير إحداثيات موقعين على الأقل',
    'location_coordinates_empty' => 'إحداثيات الموقع مطلوبة',
    'select_payment_method' => 'اختر طريقة الدفع',
    'weight' => 'الوزن',
    'cargo_image' => 'صورة الشحن',
    'vehicle_name' => 'اسم المركبة',
    'assign_driver_nam  e' => 'اسم السائق المعين',
    'assign_driver_no' => 'رقم السائق المعين',
    'vehicle_registration_no' => 'رقم تسجيل المركبة',
    'enter_weight' => 'أدخل الوزن',
    'create' => 'إنشاء رحلة',
    'pickup_location' => 'موقع الالتقاط',
    'ambulance_not_found' => 'لم يتم العثور على الإسعاف أو لم يتم تعيين السائق.',
    'ambulance_location_not_found' => 'موقع الإسعاف غير متاح.',
    'distance_not_found' => 'لم يتم حساب المسافة بين الراكب والإسعاف.',
    'location_coordinates_not_array' => 'يجب أن تكون إحداثيات الموقع مصفوفة.',
    'all' => 'جميع الرحلات',
    'create_ride' => 'إنشاء رحلة',
    'rider_details' => 'تفاصيل الراكب',
    'locations' => 'المواقع',
    'enter_locations' => 'أدخل المواقع',
    'enter_destination_location' => 'أدخل موقع الوجهة',
    'destination_location' => 'موقع الوجهة',
    'enter_pickup_location' => 'أدخل موقع الالتقاط',
    'note' => 'ملاحظة',
    'rider' => 'الراكب',
    'start_address' => 'عنوان البدء',
    'end_address' => 'عنوان النهاية',
    'service' => 'الخدمة',
    'total_cancellation_charge' => 'إجمالي تكلفة الإلغاء',
    'select_service' => 'اختر الخدمة',
    'service_category' => 'فئة الخدمة',
    'select_service_category' => 'اختر فئة الخدمة',
    'driver' => 'السائق',
    'only_driver_can_accept_ride_request_directly' => 'يمكن للسائق فقط قبول طلب الرحلة مباشرة',
    'ride_request' => 'طلب الرحلة غير صالح.',
    'general_detail' => 'التفاصيل العامة',
    'billing_detail' => 'تفاصيل الفوترة',
    'service_detail' => 'تفاصيل الخدمة',
    'location_detail' => 'تفاصيل الموقع',
    'price_detail' => 'تفاصيل السعر',
    'ride_details' => 'تفاصيل الرحلة',
    'general_details' => 'التفاصيل العامة',
    'ride_number' => 'رقم الرحلة',
    'start_date_time' => 'تاريخ ووقت البدء',
    'end_date_time' => 'تاريخ ووقت النهاية',
    'payment_status' => 'حالة الدفع',
    'otp' => 'OTP بدء الرحلة ',
    'parcel_otp' => 'OTP تسليم الطرد ',
    'ride_distance' => 'المسافة الإجمالية ',
    'zone' => 'المنطقة',
    'payment_method' => 'طريقة الدفع',
    'driver_detail' => 'تفاصيل السائق',
    'ride_reviews' => 'تعليقات الرحلة',
    'customer_reviews' => 'تعليقات العميل',
    'customer_review' => 'تعليق العميل',
    'driver_reviews' => 'تعليقات السائق',
    'map_view' => 'عرض الخريطة',
    'biding_drivers_list' => 'قائمة السائقين المعروضين',
    'complaints' => 'الشكاوى',
    'greatest_ride' => 'أفضل رحلة',
    'no_reviews_found' => 'لم يتم العثور على تعليقات',
    'no_complaints_found' => 'لم يتم العثور على شكاوى',
    'ride_id' => 'رقم الرحلة',
    'ride_status' => 'حالة الرحلة',
    'total_amount' => 'المبلغ الإجمالي',
    'date_time' => 'التاريخ والوقت:',
    'transaction_id' => 'معرف المعاملة',
    'offer_price' => 'سعر العرض',
    'final_price' => 'السعر النهائي',
    'tax_calculation' => 'حساب الضريبة',
    'igst' => 'IGST',
    'cgst' => 'CGST',
    'notes' => '',
    'receiver_name' => 'اسم مستلم الطرد',
    'receiver_email' => 'بريد مستلم الطرد',
    'receiver_no' => 'رقم مستلم الطرد',
    'name' => 'الاسم:',
    'payable_amount' => 'المبلغ المستحق',
    'total_after_commission' => 'الإجمالي (بعد عمولة الإدارة)',
    'ride_type' => 'نوع الرحلة',
    'ride_time' => 'وقت الرحلة',
    'pickup_time' => 'وقت الالتقاط',
    'dropoff_time' => 'وقت الإنزال',
    'driver_name' => 'اسم السائق',
    'driver_email' => 'بريد السائق',
    'driver_phone' => 'هاتف السائق',
    'vehicle_model' => 'طراز المركبة',
    'parcel_otps' => 'OTP الطرود',
    'customer_name' => 'اسم العميل',
    'customer_email' => 'بريد العميل',
    'customer_phone' => 'هاتف العميل',
    'payment_date' => 'تاريخ الدفع',
    'payment_reference' => 'مرجع الدفع',
    'transaction_status' => 'حالة المعاملة',
    'additional_charges' => 'تكاليف إضافية',
    'discount' => 'الخصم',
    'currency' => 'العملة',
    'email' => 'البريد الإلكتروني ',
    'phone' => 'الهاتف ',
    'vehicle_type' => 'نوع المركبة',
    'vehicle_number' => 'رقم المركبة:',
    'vehicle_not_found' => 'لم يتم العثور على المركبة!',
    'zones' => 'المناطق:',
    'ride_price' => 'سعر الرحلة',
    'only_assigned_driver' => 'يمكن للسائق المعين فقط تحديث الرحلة.',
    'ride_cannot_cancel' => 'بعد بدء الرحلة، لا يمكن إلغاؤها.',
    'invalid_otp' => 'OTP غير صالح لبدء الرحلة.',
    'user_must_be_driver' => 'يجب أن يكون المستخدم سائقًا لبدء الرحلة.',
    'payment_module_not_found' => 'الوحدة الدفع المختارة غير موجودة أو غير مفعلة.',
    'invalid_payment_method' => 'طريقة دفع غير صالحة.',
    'invalid_details' => 'تفاصيل دفع غير صالحة.',
    'payment_methods_not_found' => 'لم يتم العثور على طريقة الدفع.',
    'negative_wallet_balance' => 'غير قادر على إنشاء طلب رحلة بسبب رصيد محفظة سلبي.',
    'ride_requests_not_accepted' => 'لا يتم قبول طلبات الرحلات في هذه المنطقة.',
    'no_driver_available' => 'لا يوجد سائق متاح في هذه المنطقة.',
    'update_permission' => 'يمكنك تحديث طلبات الرحلات التي قمت بإنشائها فقط.',
    'failed_to_create_ride' => 'فشل في إنشاء الرحلة.',
    'ride_already_cancelled' => 'تم إلغاء هذه الرحلة بالفعل ولا يمكن تحديثها.',
    'no_zone_ids' => 'يرجى تقديم معرفات المناطق لعرض طلبات الرحلات عند تسجيل الدخول كسائق.',
    'status_overviews' => 'نظرة عامة على حالات الرحلات',
    'requested' => 'الرحلات المطلوبة',
    'pending' => 'الرحلات المعلقة',
    'completed' => 'الرحلات المكتملة',
    'cancelled' => 'الرحلات الملغاة',
    'scheduled' => 'الرحلات المجدولة',
    'accepted' => 'الرحلات المقبولة',
    'started' => 'الرحلات المبدأة',
    'arrived' => 'الرحلات الوصول',
    'pos' => 'POS',
    'hourly_package' => 'حزمة ساعية',
    'select_package' => 'اختر حزمة ساعية',
    'rejected' => 'مرفوض',
    'service_not_allow_for_vehicle' => 'الخدمة المختارة غير متاحة لـ :vehicleType',
    'category_not_allow_for_vehicle' => 'فئة الخدمة المختارة غير متاحة لـ :vehicleType',
    'select_start_date_and_time' => 'اختر تاريخ ووقت البدء',
    'select_end_date_and_time' => 'اختر تاريخ ووقت النهاية',
    'total_biddings' => 'إجمالي العروض',
    'biddings' => 'العروض',
    'driver_information' => 'معلومات السائق',
    'rating' => 'التقييم',
    'contact_number' => 'رقم الاتصال',
    'rider_information' => 'معلومات الراكب',
    'price_details' => 'تفاصيل السعر',
    'view_all' => 'عرض الكل',
    'vehicle_charge' => 'تكلفة المركبة',
    'driver_charge' => 'تكلفة السائق',
    'processing_fee' => 'رسوم المعالجة',
    'platform_fee' => 'رسوم المنصة',
    'subtotal' => 'الإجمالي الفرعي',
    'coupon_discount' => 'خصم الكوبون',
    'tax' => 'الضريبة',
    'tip' => 'البقشيش',
    'total' => 'الإجمالي',
    'location_details' => 'تفاصيل الموقع',
    'rider_reviews' => 'تعليقات الراكب',
    'description' => 'الوصف',
    'bidding_request' => 'طلب عرض',
    'amount' => 'المبلغ',
    'status' => 'الحالة',
    'rental_vehicle' => 'مركبة الإيجار',
    'assigned_driver_name' => 'اسم السائق المعين',
    'assigned_driver_no' => 'رقم السائق المعين.',
    'days' => 'أيام',
    'admin_commission' => 'عمولة الإدارة',
    'driver_commission' => 'عمولة السائق',
    'driver_tip' => 'بقشيش السائق',
    'bill_summary' => 'ملخص الفاتورة',
    'invoice' => 'الفاتورة',
    'read_more' => 'اقرأ المزيد',
    'read_less' => 'اقرأ أقل',
    'cancellation_reason' => 'سبب الإلغاء',
    'default_cancel_reason' => 'لم يتم تقديم سبب',
    'download_invoice' => 'تنزيل الفاتورة',
    'vehicle_charges' => 'تكاليف المركبة',
    'driver_charges' => 'تكاليف السائق',
    'comments' => 'التعليقات',
    'no_comments' => 'لا توجد تعليقات متاحة',
    'total_per_distance_charge' => 'إجمالي تكلفة المسافة',
    'total_per_minute_charge' => 'إجمالي تكلفة الدقيقة',
    'vehicle_per_day_price' => 'سعر المركبة لكل يوم',
    'ride_fare' => 'أجرة الرحلة',
    'additional_distance_charge' => 'تكلفة مسافة إضافية',
    'additional_minute_charge' => 'تكلفة دقائق إضافية',
    'additional_weight_charge' => 'تكلفة وزن إضافي',
    'admin_commission' => 'عمولة الإدارة',
    'driver_commission' => 'عمولة السائق',
    'waiting_charges' => 'تكلفة الانتظار',
    'bid_extra_amount' => 'مبلغ عرض إضافي',
    'waiting_total_times' => 'أوقات الانتظار الإجمالية',
    'rider_cancellation_charge' => 'تكلفة إلغاء الراكب',
    'driver_cancellation_charge' => 'تكلفة إلغاء السائق',
    'minutes' => ' دقائق'
  ),
  'invoice' => array (
    'date' => 'التاريخ',
    'invoice_to' => 'الفاتورة إلى.',
    'name' => 'الاسم',
    'rider_contact' => 'اتصال الراكب',
    'ride_details' => 'تفاصيل الرحلة',
    'service' => 'الخدمة',
    'pickup_time' => 'وقت الالتقاط',
    'pickup_location' => 'موقع الالتقاط',
    'drop_off_location' => 'موقع الإنزال',
    'vehicle_driver_info' => 'معلومات المركبة والسائق',
    'vehicle_type' => 'نوع المركبة',
    'subtotal' => 'الإجمالي الفرعي',
    'vehicle_number' => 'رقم المركبة',
    'driver_name' => 'اسم السائق',
    'driver_contact' => 'اتصال السائق',
    'description' => 'الوصف',
    'rate_unit' => 'المعدل/الوحدة',
    'quantity' => 'الكمية',
    'payment_details' => 'تفاصيل الدفع',
    'waiting_charge' => 'تكلفة الانتظار',
    'rider_cancellation_charge' => 'تكلفة إلغاء الراكب',
    'driver_cancellation_charge' => 'تكلفة إلغاء السائق',
    'payment_method' => 'طريقة الدفع',
    'payment_status' => 'حالة الدفع',
    'amount' => 'المبلغ ',
    'additional_distance_charge' => 'تكلفة مسافة إضافية',
    'additional_minute_charge' => 'تكلفة دقيقة إضافية',
    'additional_weight_charge' => 'تكلفة وزن إضافي',
    'total' => 'الإجمالي',
    'base_fare' => 'الأجرة الأساسية',
    'distance_fare' => 'أجرة المسافة',
    'taxes' => 'الضرائب',
    'thank_you' => 'شكرًا لك!',
    'thank_you_msg' => 'شكرًا لاختيارنا. نتطلع إلى خدمتك مرة أخرى! للتعليقات أو الشكاوى.',
    'driver_tips' => 'بقشيش السائق',
    'tax' => 'الضريبة',
    'platform_fee' => 'رسوم المنصة',
    'processing_fee' => 'رسوم المعالجة',
    'coupon_discount' => 'خصم الكوبون',
    'driver_commission' => 'عمولة السائق',
    'commission' => 'عمولة الإدارة',
  ),
  'locations' => array (
    'locations' => 'المواقع',
    'status' => 'حالة السائق',
    'all' => 'الكل',
    'driver_location' => 'موقع السائق',
    'select_zone' => 'اختر المنطقة',
    'zone' => 'المنطقة',
    'filters' => 'المرشحات',
    'unrated' => 'غير مقيم',
    'online' => 'متواجد عبر الإنترنت',
    'onride' => 'في رحلة',
    'offline' => 'غير متصل',
    'taxi_drivers' => 'السائقون',
    'view_location' => 'عرض الموقع',
    'search_driver' => 'البحث عن سائق',
    'id' => 'المعرف',
    'service' => 'الخدمة:',
    'service_category' => 'فئة الخدمة:',
    'start_time' => 'وقت البدء:',
    'distance' => 'المسافة:',
    'duration' => 'المدة:',
    'min' => 'دقيقة',
    'view_more' => 'عرض المزيد',
    'rider_details' => 'تفاصيل الراكب',
    'no_rides_yet' => 'لا توجد رحلات بعد',
    'refresh' => 'تحديث',
  ),
  'soses' => array (
    'all' => 'الكل',
    'soses' => 'SOS',
    'sos' => 'SOS',
    'alert_id' => 'تنبيه SOS',
    'sos_status' => 'حالة SOS',
    'status' => 'الحالة',
    'created_by' => 'تم الإنشاء بواسطة',
    'alert_time' => 'وقت التنبيه',
    'location' => 'الموقع',
    'location_map' => 'خريطة الموقع',
    'title' => 'العنوان',
    'all_zones' => 'جميع المناطق',
    'enter_title' => 'أدخل العنوان',
    'add_new' => 'إضافة جديد',
    'add_sos' => 'إضافة SOS',
    'select_zones' => 'اختر المناطق',
    'phone' => 'الهاتف',
    'sos_alerts' => 'تنبيهات SOS',
    'enter_phone' => 'أدخل الهاتف',
    'sos_details' => 'تفاصيل تنبيه SOS',
    'add' => 'إضافة SOS',
    'edit' => 'تعديل SOS',
    'description' => 'الوصف',
    'enter_description' => 'أدخل الوصف',
    'create_successfully' => 'تم إنشاء SOS بنجاح.',
    'update_successfully' => 'تم تحديث SOS بنجاح.',
    'delete_successfully' => 'تم حذف SOS بنجاح.',
    'status_update_successfully' => 'تم تحديث حالة SOS بنجاح.',
    'permanent_delete_successfully' => 'تم حذف SOS نهائيًا بنجاح.',
    'restore_successfully' => 'تم استعادة SOS بنجاح.',
    'sos_image' => 'صورة SOS',
    'zones' => 'المناطق',
    'no_zones_message' => '*لإضافة منطقة جديدة، انقر فقط',
  ),
  'driver_rules' => array (
    'all' => 'الكل',
    'driverRule' => 'قاعدة السائق',
    'driver_rules' => 'قواعد السائق',
    'title' => 'العنوان',
    'add_new' => 'إضافة جديد',
    'enter_title' => 'أدخل العنوان',
    'add_driverRule' => 'إضافة قاعدة سائق',
    'add' => 'إضافة قاعدة سائق',
    'edit' => 'تعديل قاعدة السائق',
    'description' => 'الوصف',
    'select_vehicle_type' => 'اختر نوع المركبة',
    'image' => 'صورة القاعدة',
    'save' => 'حفظ',
    'status' => 'الحالة',
    'create_successfully' => 'تم إنشاء قاعدة السائق بنجاح.',
    'update_successfully' => 'تم تحديث قاعدة السائق بنجاح.',
    'delete_successfully' => 'تم حذف قاعدة السائق بنجاح.',
    'status_update_successfully' => 'تم تحديث حالة قاعدة السائق بنجاح.',
    'permanent_delete_successfully' => 'تم حذف قاعدة السائق نهائيًا بنجاح.',
    'restore_successfully' => 'تم استعادة قاعدة السائق بنجاح.',
    'no_vehicleType_message' => '*لإضافة نوع مركبة جديد، انقر فقط',
  ),
  'services' => array (
    'all' => 'الكل',
    'service' => 'الخدمة',
    'services' => 'الخدمات',
    'name' => 'الاسم',
    'enter_name' => 'أدخل الاسم',
    'type' => 'النوع',
    'add_new' => 'إضافة جديد',
    'is_primary' => 'أساسي',
    'add' => 'إضافة خدمة',
    'cab' => 'سيارة',
    'parcel' => 'طرد',
    'freight' => 'شحن',
    'ambulance' => 'سيارة إسعاف',
    'edit' => 'تعديل الخدمة',
    'select_type' => 'اختر النوع',
    'save' => 'حفظ',
    'image' => 'الصورة',
    'icon' => 'الأيقونة',
    'cab_description' => 'تُستخدم للسفر بين المدن',
    'parcel_description' => 'للسفر داخل المدينة سلس وموثوق',
    'create_successfully' => 'تم إنشاء الخدمة بنجاح.',
    'update_successfully' => 'تم تحديث الخدمة بنجاح.',
    'status_update_successfully' => 'تم تحديث حالة الخدمة بنجاح.',
  ),
  'service_categories' => array (
    'all' => 'الكل',
    'serviceCategory' => 'فئات الخدمات',
    'name' => 'الاسم',
    'select_services' => 'اختر الخدمات',
    'services' => 'الخدمات',
    'service' => 'الخدمة',
    'vehicles' => 'المركبات',
    'select_service' => 'اختر الخدمة',
    'description' => 'الوصف',
    'cab' => 'فئات الخدمات',
    'parcel' => 'فئات الخدمات',
    'freight' => 'فئات الخدمات',
    'enter_description' => 'أدخل الوصف',
    'intercity_desc' => 'خيارات السفر الطويلة المسافة التي تربط المدن، مثالية للركاب والشحنات.',
    'scheduled_dec' => 'خدمات النقل المجدولة للرحلات المخططة، تقدم خيارات للركاب والشحن.',
    'package_dec' => 'خدمات توصيل الحزم للطرود الصغيرة والكبيرة، ضمان نقل آمن وفي الوقت المحدد.',
    'intracity_dec' => 'للسفر داخل المدينة سلس وموثوق',
    'rental_desc' => 'إيجار المركبات للاستخدام قصير أو طويل الأمد، مناسب للاحتياجات الشخصية أو التجارية.',
    'scheduled_desc' => 'حجز رحلات مسبقًا للراحة',
    'enter_name' => 'أدخل الاسم',
    'edit' => 'تعديل فئة الخدمة',
    'type' => 'النوع',
    'select_type' => 'اختر النوع',
    'save' => 'حفظ',
    'service_image' => 'الصورة',
    'create_successfully' => 'تم إنشاء فئة الخدمة بنجاح.',
    'update_successfully' => 'تم تحديث فئة الخدمة بنجاح.',
    'status_update_successfully' => 'تم تحديث حالة فئة الخدمة بنجاح.',
    'restore_successfully' => 'تم استعادة فئة الخدمة بنجاح.',
  ),
  'settings' => array (
    'settings' => 'الإعدادات',
    'greeting' => 'التحية',
    'ride_setting' => 'إعدادات الرحلة',
    'enter_greeting' => 'أدخل رسالة التحية',
    'enter_find_driver_time_limit' => 'أدخل حد وقت البحث عن السائق',
    'enter_min_intracity_radius' => 'أدخل الحد الأدنى لنصف قطر داخل المدينة',
    'fleet_commission_rate' => 'معدل عمولة الأسطول',
    'fleet_commission_type' => 'نوع عمولة الأسطول',
    'select_fleet_commission_type' => 'اختر نوع عمولة الأسطول',
    'enter_fleet_commission_rate' => 'أدخل معدل عمولة الأسطول',
    'bidding_low_level' => 'مستوى العروض المنخفض (الأقل)',
    'full_address_location' => 'العنوان الكامل/الموقع',
    'parcel_weight_limit' => 'حد وزن الطرد',
    'enter_parcel_weight_limit' => 'أدخل حد وزن الطرد',
    'schedule_min_hour_limit' => 'حد وقت الجدول (ساعات)',
    'enter_schedule_min_hour_limit' => 'أدخل حد وقت الجدول بالساعات',
    'schedule_min_hour_limit_help' => 'حدد كم ساعة قبل يمكن جدولة الرحلة.',
    'enter_low_bidding' => 'أدخل قيمة عرض أدنى',
    'bidding_high_level' => 'مستوى العروض العالي (الأقصى)',
    'enter_high_bidding' => 'أدخل قيمة عرض أقصى',
    'bidding_range' => 'نطاق المبلغ من السعر الموصى به',
    'fleet_verification' => 'التحقق من الأسطول',
    'fleet_verifications_span' => 'فترة التحقق من الأسطول',
    'sos_enable' => 'تفعيل SOS',
    'maximum_seat' => 'أقصى مقعد',
    'enter_maximum_seat' => 'أدخل أقصى مقعد',
    'airport_price' => 'تفعيل سعر المطار',
    'enter_driver_ride_request_accept_time' => 'أدخل وقت قبول طلب الرحلة للسائق',
    'enter_driver_amb_rent_ride_req_time' => 'أدخل وقت قبول طلب رحلة الإسعاف/الإيجار',
    'enter_max_bidding_fare_driver' => 'أدخل أقصى أجرة عرض للسائق',
    'enter_max_bidding_fare_rider' => 'أدخل أقصى أجرة عرض للراكب',
    'surge_price' => 'تفعيل سعر الزيادة',
    'ride_request_time_driver' => 'وقت طلب الرحلة (السائق)',
    'rental_ambulance_request_time_span' => 'الوقت بالثواني الذي يجب على السائق قبول طلب رحلة إسعاف إيجار',
    'increase_amount_range_span' => 'المبلغ الأقصى الذي يمكن للسائق زيادته في العرض فوق الأجرة الأساسية.',
    'find_driver_time_limit_span' => 'الوقت بالثواني الذي سيحاول فيه النظام البحث عن سائقين قريبين لطلب راكب',
    'min_intracity_radius_span' => 'الحد الأدنى لنصف القطر بالأمتار لاعتبار الرحلة داخل المدينة',
    'max_bidding_fare_driver_span' => 'أقصى أجرة يمكن للسائق عرضها لطلب رحلة عرض',
    'weight_unit_span' => ' وحدة الوزن الافتراضية المستخدمة للرحلات القائمة على الشحن أو الطرود (مثل، كجم، رطل).',
    'distance_unit_span' => 'الوحدة المستخدمة لحساب المسافة وعرضها (مثل، كيلومترات أو أميال)',
    'enter_ride_request_time_driver' => 'أدخل وقت طلب الرحلة بالثواني',
    'rental_ambulance_request_time' => 'وقت طلب رحلة إسعاف إيجار (تطبيق السائق)',
    'enter_rental_ambulance_request_time' => 'أدخل وقت طلب رحلة إسعاف إيجار بالثواني',
    'increase_amount_range' => 'نطاق زيادة المبلغ',
    'enter_increase_amount_range' => 'أدخل نطاق زيادة المبلغ',
    'weight_unit' => 'وحدة الوزن',
    'select_country_code_span' => 'رمز الاتصال الدولي الافتراضي المستخدم لتنسيق أرقام الهواتف (مثل، +91).',
    'select_weight_unit' => 'اختر وحدة الوزن',
    'find_driver_time_limit' => 'وقت البحث عن سائق (الراكب)',
    'schedule_ride_request_lead_time' => 'وقت تقدم طلب الرحلة (دقائق)',
    'schedule_ride_request_lead_time_span' => 'حدد وقت التقدم (مثل، 15 دقيقة) قبل بدء الرحلة (مثل، 13:15) لإرسال طلب الرحلة إلى السائق (مثل، 13:00)، قابل للتعديل حسب الحاجة.',
    'enter_schedule_ride_request_lead_time' => 'أدخل وقت تقدم طلب الرحلة (دقائق)',
    'driver_max_online_hours' => 'أقصى ساعات على الإنترنت للسائق (ساعات)',
    'driver_max_online_hours_span' => 'حدد أقصى ساعات يمكن للسائق البقاء متواجدًا على الإنترنت قبل أن يتم وضع علامة غير متصل.',
    'enter_driver_max_online_hours' => 'أدخل أقصى ساعات على الإنترنت للسائق (ساعات)',
    'enter_find_driver_time' => 'أدخل حد وقت البحث عن سائق (دقائق)',
    'min_intracity_radius' => 'أدنى نصف قطر داخل المدينة (أمتار)',
    'enter_intracity_radius' => 'أدخل نصف قطر داخل المدينة (أمتار)',
    'max_bidding_fare_driver' => 'أقصى أجرة عرض (السائق)',
    'enter_max_bidding_fare_driver' => 'أدخل أقصى أجرة عرض',

    'driver_ride_request_accept_time' => 'وقت قبول طلب الرحلة للسائق (بالثواني)',
    'driver_amb_rent_ride_req_time' => 'وقت قبول طلب رحلة الإسعاف/الإيجار (بالثواني)',
    'max_bidding_fare_driver' => 'أقصى أجرة عرض (السائق)',
    'max_bidding_fare_rider' => 'أقصى أجرة عرض (الراكب)',
    'additional_minute_charge' => 'تكلفة دقيقة إضافية',
    'user_accept_reject_time_span' => 'يحدد أقصى وقت (بالثواني) الذي يجب على المستخدم قبول أو رفض عرض سائق قبل انتهاء صلاحيته.',
    'driver_accept_reject_time_span' => 'يحدد أقصى وقت (بالثواني) الذي يجب على السائق قبول أو رفض طلب رحلة قبل إعادة تعيينه.',
    'additional_distance_charge' => 'تكلفة مسافة إضافية',
    'additional_weight_charge' => 'تكلفة وزن إضافي',
    'bidding_range_rider'  => 'نطاق زيادة/تقليل المبلغ للراكب',
    'bidding_range_driver' => 'نطاق زيادة/تقليل المبلغ للسائق',
    'driver_ride_request_accept_time_span' => 'الوقت بالثواني الذي يجب على السائق قبول طلب رحلة عادية.',
    'driver_amb_rent_ride_req_time_span' => 'الوقت بالثواني لقبول طلبات رحلة الإسعاف أو الإيجار.',
    'max_bidding_fare_rider_span' => 'أقصى أجرة يُسمح للراكب بعرضها أثناء رحلات العروض.',
    'max_bidding_fare_driver_span' => 'أقصى أجرة يمكن للسائق عرضها أثناء رحلة عرض.',
    'additional_weight_charge_span' => 'تكلفة إضافية مطبقة لكل كجم للأمتعة التي تتجاوز الحد المسموح به.',
    'additional_distance_charge_span' => 'تكلفة إضافية لكل كم للمسافات التي تتجاوز حد الأجرة الأساسية.',
    'additional_minute_charge_span' => 'تكلفة إضافية لكل دقيقة تتجاوز المدة المقدرة للرحلة.',
    'surge_price_span' => 'نسبة مئوية مضافة أثناء أوقات الطلب العالي (الزيادة).',
    'airport_price_span' => 'تكلفة ثابتة مطبقة عندما تشمل الرحلة التقاط أو إنزال في المطار.',
    'enter_user_accept_reject_time' => 'أدخل وقت انتظار قبول/رفض عرض المستخدم',
    'driver_accept_reject_time' => 'وقت انتظار قبول/رفض عرض السائق (ثواني)',
    'adjust_price_range_from_recommended' => 'ضبط نطاق السعر من الموصى به',
    'enter_adjust_price_range_from_recommended' => 'أدخل قيمة ضبط نطاق السعر',
    'enter_driver_accept_reject_time' => 'أدخل وقت انتظار قبول/رفض عرض السائق',
    'distance_unit' => 'وحدة المسافة',
    'user_accept_reject_time' => 'وقت انتظار قبول/رفض عرض المستخدم (ثواني)',
    'country_code' => 'رمز البلد',
    'select_distance_unit' => 'اختر وحدة المسافة (كم أو ميل)',
    'enter_range_value'    => 'أدخل قيمة النطاق',
    'enter_range_value' => 'أدخل قيمة نطاق الزيادة/التقليل',
    'footer_hashtag' => 'هاشتاج التذييل',
    'footer_hashtag_help' => 'أدخل هاشتاج العلامة التجارية (#GoTaxido) لعرضه في تذييل الصفحة الرئيسية للتطبيق',
    'enter_hashtag' => '#GoTaxido',
    'country_code' => 'رمز البلد',
    'country_code_span' => 'رمز البلد',
    'driver_verification' => 'التحقق من السائق',
    'driver_verifications_span' => 'سيتم تفعيل التحقق من السائق فقط بعد التحقق من جميع وثائق المركبة المطلوبة.',
    'footer_attribution' => 'الإسناد في التذييل',
    'footer_attribution_help' => 'أدخل ائتمان المطور (❤️ صنع بواسطة Pixelstrap) لعرضه في تذييل الصفحة الرئيسية للتطبيق',
    'enter_attribution' => '❤️ صنع بواسطة Pixelstrap',
    'fleet_commission_span' => 'اختر نوع العمولة لمديري الأسطول: معدل ثابت أو قائم على النسبة المئوية.',
    'fleet_commission_rate_span' => 'حدد معدل العمولة الذي يتلقاه أصحاب الأسطول لكل رحلة، إما قيمة ثابتة أو نسبة مئوية من إجمالي الأجرة.',
    'add_greeting' => 'إضافة',
    'google_map_api_key' => 'مفتاح API خرائط جوجل',
    'enter_google_map_api_key' => 'أدخل مفتاح API خرائط جوجل',
    'splash_screen' => 'شاشة البداية للمستخدم',
    'splash_driver_screen' => 'شاشة البداية للسائق',
    'ride_settings' => 'إعدادات الرحلة',
    'app_settings' => 'إعدادات التطبيق',
    'driver_min_wallet_balance' => 'الحد الأدنى لرصيد محفظة السائق',
    'enter_driver_min_wallet_balance' => 'أدخل الحد الأدنى لرصيد محفظة السائق',
    'driver_min_wallet_balance_help' => 'حدد الحد الأدنى لرصيد المحفظة الذي يجب على السائق الحفاظ عليه لتلقي طلبات الرحلات.',
    'test_map' => 'اختبار الخريطة',
    'map_preview' => 'معاينة الخريطة',
    'ambulance_per_minute_charge' => 'تكلفة الإسعاف لكل دقيقة',
    'ambulance_per_minute_charge_span' =>'حدد التكلفة المفروضة لكل دقيقة بناءً على المنطقة والعملة لرحلات الإسعاف',
    'ambulance_per_km_charge_span' =>'حدد التكلفة المفروضة لكل مسافة بناءً على نوع المسافة والعملة لرحلات الإسعاف',
    'ambulance_commission_span'=>'اختر نوع العمولة لخدمات الإسعاف: معدل ثابت أو قائم على النسبة المئوية.',
    'ambulance_commission_rate_span' => 'حدد معدل العمولة للسائقين في خدمات الإسعاف، إما رسوم ثابتة أو نسبة مئوية من الأجرة.',
    'force_update_span' =>'طلب من المستخدمين تحديث التطبيق إلى الإصدار الأحدث قبل المتابعة.',
    'app_configuration' => 'تكوين التطبيق',
    'driver_app_version' => 'إصدار تطبيق السائق',
    'app_version' => 'إصدار تطبيق المستخدم',
    'user_app_span' => 'الإصدار الأدنى للتطبيق اللازم للمستخدمين. قد لا تعمل الإصدارات الأقدم بشكل صحيح.',
    'driver_app_span' => 'الإصدار الأدنى للتطبيق اللازم للسائقين. يرجى التحديث إذا كنت تستخدم إصدارًا أقدم.',
    'force_update' => 'فرض التحديث',
    'enter_version' => 'أدخل الإصدار',
    'ride_accept' => 'قبول الرحلة',
    'maximum_time' => 'الوقت الأقصى',
    'regular_ride' => 'الوقت الأقصى للبحث عن سائق لرحلة عادية بالدقائق',
    'enter_time' => 'الوقت الأقصى للبحث عن سائق لرحلة عادية بالدقائق',
    'ride_accept_decline' => 'قبول/رفض الرحلة',
    'enter_ride' => 'مدة قبول/رفض الرحلة للسائق بالثواني',
    'min_withdraw_amount' => 'الحد الأدنى للسحب',
    'enter_amount' => 'أدخل الحد الأدنى للسحب',
    'activation' => 'التفعيل',
    'platform_fees' => 'رسوم المنصة',
    'social_login_enable' => 'تفعيل تسجيل الدخول الاجتماعي',
    'wallet_enable' => 'تفعيل المحفظة',
    'rider_wallets' => 'السماح للركاب بإضافة أموال إلى محفظة واستخدام الرصيد للحجوزات والدفعات.',
    'online_payments' => 'السماح للمستخدمين بالدفع رقميًا باستخدام طرق دفع آمنة مثل البطاقات والمحافظ المتنقلة.',
    'cash_payments' => 'الدفع النقدي',
    'rider_wallet' => 'تفعيل محفظة الراكب',
    'referral_settings' => 'إعدادات الإحالة',
    'referral_amount' => 'مبلغ الإحالة',
    'first_ride_discount' => 'خصم الرحلة الأولى',
    'general' => 'عام',
    'bidding' => 'العروض',
    'location_settings' => 'إعدادات الموقع',
    'driver_commission' => 'العمولة',
    'enter_referral_amount' => 'أدخل مبلغ الإحالة',
    'enter_first_ride_discount' => 'أدخل خصم الرحلة الأولى',
    'status' => 'الحالة',
    'validity' => 'الصلاحية',
    'enter_validity' => 'أدخل الصلاحية',
    'select_map_type' => 'نوع الخريطة',
    'select_map' => 'اختر خيار التتبع: اختر من خرائط جوجل، ويز، فاندكس، أو التنقل داخل التطبيق',
    'select_map_tracking' => 'خيار التتبع',
    'select_map_tracking_option' => ' اختر خيار تتبع الخريطة',
    'select_type' => 'اختر النوع',
    'driver_location_update' => 'تحديث موقع السائق',
    'driver_location' => 'تحديث موقع السائق (أمتار)',
    'enter_meter' => 'أدخل الأمتار',
    'enter_value' => 'أدخل القيمة',
    'wallet' => 'إعدادات المحفظة',
    'online_payment' => 'الدفع عبر الإنترنت',
    'social_login' => 'تسجيل الدخول الاجتماعي',
    'ride_otp' => 'التحقق من OTP الرحلة',
    'parcel_otp' => 'التحقق من OTP الطرد',
    'otp_parcel' => 'إذا تم تفعيله، يدخل المستلم OTP للحصول على الطرد. إذا تم تعطيله، يحدث التسليم مباشرة.',
    'wallet_denominations' => 'فئات المحفظة',
    'enter_wallet_denominations' => 'أدخل فئات المحفظة',
    'tip_denominations' => 'فئات البقشيش',
    'enter_tip_denominations' => 'أدخل فئات البقشيش',
    'driver_threshold' => 'عتبة السائق',
    'enter_driver_threshold' => 'أدخل عتبة السائق',
    'driver_tips' => 'بقشيش السائق',
    'radius_meter' => 'نصف قطر الأمتار',
    'enter_radius_meter' => 'أدخل نصف قطر الأمتار',
    'radius_per_second' => 'نصف قطر لكل ثانية',
    'enter_radius_per_second' => 'أدخل نصف قطر لكل ثانية',
    'tips' => 'إذا تم تعطيله، لا يمكن للركاب إعطاء بقشيش. إذا تم تفعيله، يمكن للركاب إعطاء بقشيش للسائقين حسب تقديرهم',
    'negative_balance' => 'إذا تم تفعيله، يمكن للسائقين العمل برصيد سلبي. بمجرد الوصول إلى الحد، لا يمكنهم الانضمام إلى رحلات جديدة.',
    'otp_ride' => 'إذا تم تفعيله، تبدأ الرحلة فقط بعد إدخال OTP. إذا تم تعطيله، تبدأ الرحلة مباشرة.',
    'interval' => 'الفاصل الزمني',
    'days' => 'يوم',
    'months' => 'شهر',
    'enable_referral' => 'السماح للمستخدمين بدعوة الأصدقاء وكسب مكافآت عند الانضمام أو استخدام الخدمة.',
    'bid_span' => 'إذا تم تفعيله، يمكن للسائقين تقديم عروض للرحلات أو التوصيلات، مما يقدم أسعارًا تنافسية للمستخدمين. إذا تم تعطيله، لا يُسمح بالعروض.',
    'years' => 'سنة',
    'login' => 'تفعيل تسجيل الدخول الاجتماعي للوصول السريع والسهل إلى حساب السائق',
    'set_validity' => 'حدد حد زمني للخصم بعد التسجيل',
    'discount' => 'حدد مبلغ الخصم (مثل، 30) للمستخدمين في رحلتهم الأولى.',
    'map' => 'اختر نوع الخريطة. سيتم تطبيق خرائط جوجل أو OSM على الإدارة والتطبيق.',
    'radius' => 'حدد منطقة التغطية لخدماتك القائمة على الموقع',
    'radius_second' => 'حدد تكرار تعديلات نصف القطر لكل ثانية',
    'per_km_charge' => 'تكلفة لكل كم',
    'km_charge' => 'تفعيل أو تعطيل تكلفة الكيلومتر للرحلات',
    'referral_enable' => 'تفعيل الإحالة',
    'driver_locations' => 'إدارة مواقع السائقين في الوقت الفعلي وضمان تفعيل GPS لتتبع دقيق',
    'driver_threshold_help' => 'حدد العتبات لتحسين أداء السائق',
    'min_withdraw_text' => 'حدد الحد الأدنى للمبلغ الذي يمكن للسائق سحبه من أرباحه',
    'wallet_denominations_help' => 'إدارة فئات المحفظة لخيارات معاملات مرنة',
    'tip_denominations_help' => 'حدد فئات البقشيش لتوحيد خيارات الإكرامية للمستخدمين',
    'minimum_ride_amount' => 'الحد الأدنى لمبلغ الرحلة',
    'minimum_ride_amount_help' => 'حدد الحد الأدنى لمبلغ الرحلة المطلوب لتفعيل مكافآت الإحالة (مثل، 250).',
    'enter_minimum_ride_amount' => 'أدخل الحد الأدنى لمبلغ الرحلة',
    'referrer_bonus_percentage' => 'نسبة مكافأة المُحيل',
    'referrer_bonus_percentage_help' => 'نسبة مبلغ الرحلة التي سيحصل عليها المُحيل كمكافأة (0-100%).',
    'enter_referrer_bonus_percentage' => 'أدخل نسبة مكافأة المُحيل',
    'referred_bonus_percentage' => 'نسبة مكافأة المستخدم المُحال',
    'referred_bonus_percentage_help' => 'نسبة مبلغ الرحلة التي سيحصل عليها المستخدم المُحال كمكافأة (0-100%).',
    'enter_referred_bonus_percentage' => 'أدخل نسبة مكافأة المستخدم المُحال',
    'interval_help' => 'اختر الفاصل الزمني الذي سيتم تطبيق مكافأة الإحالة أو الخصم فيه',
    'ambulance_per_km_charge' => 'تكلفة الإسعاف لكل كم',
    'enter_ambulance_per_km_charge' => 'أدخل تكلفة الإسعاف لكل كم',
    'ambulance_commission_type' => 'نوع عمولة الإسعاف',
    'select_ambulance_commission_type'=> 'اختر نوع عمولة الإسعاف',
    'ambulance_commission_rate' => 'معدل عمولة الإسعاف',
    'enter_ambulance_commission_rate' => 'أدخل معدل عمولة الإسعاف',
    'driver_subscription' => 'اشتراك السائق',
    'rider_privacy_policy' => 'سياسة خصوصية الراكب',
    'driver_privacy_policy' => 'سياسة خصوصية السائق',
    'enter_privacy_policy_url' => 'أدخل رابط سياسة الخصوصية',
  ),
  'wallets' => array (
    'wallet' => 'المحفظة',
    'select_consumer' => 'اختر المستهلك',
    'add_amount' => 'أدخل المبلغ',
    'wallet_balance' => 'رصيد المحفظة',
    'credit' => 'إيداع',
    'confirmation' => 'التأكيد',
    'debit' => 'سحب',
    'select_rider' => 'اختر الراكب',
    'transactions' => 'المعاملات',
    'modal' => 'هل أنت متأكد من المتابعة؟',
    'select_driver' => 'اختر السائق',
    'yes' => 'نعم',
    'credit_debit' => 'إيداع/سحب المبلغ',
    'no' => 'لا',
    'select_fleet_manager' => 'اختر مدير الأسطول',
    'add_fleet_manager_message' => '*لإضافة مدير أسطول جديد، انقر فقط',
    'user_must_be' => 'يجب أن يكون المستخدم',
    'balance_credited' => 'تم إيداع الرصيد بنجاح',
    'balance_debited' => 'تم سحب الرصيد بنجاح',
    'transaction' => 'المعاملات',
    'wallet_feature_on' => 'ميزة المحفظة معطلة حاليًا. قم بتفعيلها في الإعدادات > التفعيل.',
    'wallet_balance_not_sufficient' => 'رصيد المحفظة غير كافٍ لهذه الرحلة.',
    'wallet_balance_ride' => 'خيار استخدام رصيد المحفظة للرحلة معطل حاليًا.',
    'wallet_balance_unable' => 'الركاب غير قادرين على استخدام رصيد المحفظة أثناء إنشاء الرحلات.',
    'add_note' => 'إضافة ملاحظة',
    'enter_note' => 'أدخل ملاحظة للمستخدم',
    'add_driver_message' => '*لإضافة سائق جديد، انقر فقط',
    'add_rider_message' => '*لإضافة راكب جديد، انقر فقط',
    'add_payment_account_before_withdrawal' => 'يرجى إنشاء حساب دفع قبل تقديم طلب سحب.',
    'add_paypal_email_before_withdrawal' => 'يرجى إضافة بريد باي بال قبل تقديم طلب سحب.',
    'add_bank_details_before_withdrawal' => 'يرجى إكمال تفاصيل البنك قبل تقديم طلب سحب.',
    'min_withdraw_amount' => 'تأكد من أن المبلغ المطلوب على الأقل :minWithdrawAmount.',
    'insufficient_wallet_balance' => 'رصيد محفظتك غير كافٍ لمعالجة هذا السحب.',
    'withdraw_request_submitted' => 'تم إنشاء طلب السحب بنجاح',
    'selected_user' => 'يجب أن يكون المستخدم المختار سائقًا',
  ),
  'withdraw_requests' => array (
    'withdraw_request' => 'طلب السحب',
    'title' => 'طلبات السحب',
    'pending_balance' => 'الرصيد المعلق',
    'wallet' => 'المحفظة',
    'message' => 'الرسالة',
    'amount' => 'المبلغ',
    'payment_type' => 'طريقة الدفع',
    'status' => 'الحالة',
    'send_withdrawRequest' => 'إرسال طلب سحب',
    'bank' => 'البنك',
    'paypal' => 'باي بال',
    'enter_message' => 'أدخل الرسالة',
  ),
  'push_notification' => array (
    'push_notification' => 'إشعارات الدفع',
    'all' => 'جميع إشعارات الدفع',
    'send' => 'إرسال إشعار دفع',
    'select_notification_send_to' => 'اختر إرسال الإشعار إلى',
    'send_notification' => 'إرسال الإشعار',
    'send_to' => 'إرسال إلى',
    'selected_service' => 'الكل/الخدمة المختارة',
    'title' => 'العنوان',
    'sent_notification' => ' تم إرسال إشعار الدفع بنجاح',
    'delete_successfully' => 'تم حذف إشعار الدفع بنجاح',
    'permanent_delete_successfully' => 'تم حذف إشعار الدفع نهائيًا بنجاح.',
    'enter_title' => 'أدخل العنوان',
    'enter_message' => 'أدخل الرسالة',
    'message' => 'الرسالة',
    'image' => 'الصورة',
    '3_min_ago' => 'منذ 3 دقائق',
    'url' => 'الرابط',
    'message_body' => 'جسم الرسالة',
    'enter_url' => 'أدخل الرابط',
    'zones' => 'المنطقة',
    'select_zones' => 'اختر المناطق',
    'no_zones_message' => '*لإضافة منطقة جديدة، انقر فقط',
    'recommended' => '*يُوصى بحجم صورة 100x100 بكسل',
    'schedule'=> 'جدول',
    'scheduleat'=>'جدولة',
    'select_start_date' => 'اختر تاريخ البدء',

  ),
  'hourly_package' => array (
    'add_new' => 'إضافة جديد',
    'add' => 'إضافة حزمة ساعية',
    'image' => 'الصورة',
    'create' => 'حزمة ساعية',
    'save' => 'حفظ',
    'title' => 'العنوان',
    'amount' => 'المبلغ',
    'hour_span' => '* أدخل كم ساعة تغطي هذه الحزمة. على سبيل المثال، 2 ساعات لرحلات المدينة السريعة',
    'distance_span' => '* حدد أقصى مسافة مسموحة في هذه الحزمة. على سبيل المثال، 50 كم ضمن 2 ساعات',
    'distance_type_span' => '* اختر كيفية قياس المسافة: كيلومترات أو أميال',
    'vehicle_type_span' => '* اختر أنواع المركبات المتاحة لهذه الحزمة. على سبيل المثال، سيدان، SUV، أو فان',
    'enter_amount' => 'أدخل المبلغ',
    'edit' => 'تعديل الحزمة الساعية',
    'enter_title' => 'أدخل العنوان',
    'hourly_package' => 'حزمة ساعية',
    'hourly_packages' => 'الحزم الساعية',
    'no_hourly_package_message' => '*لإضافة حزمة ساعية جديدة، انقر فقط',
    'distance' => 'المسافة',
    'hour' => 'ساعة',
    'distance_type' => 'نوع المسافة',
    'select_distance_type' => 'اختر نوع المسافة',
    'status' => 'الحالة',
    'enter_distance' => 'أدخل المسافة',
    'enter_hour' => 'أدخل الساعة',
    'extra_min_per_hour_rate' => 'معدل إضافي أدنى لكل ساعة',
    'enter_extra_min_per_hour_rate' => 'أدخل معدل إضافي أدنى لكل ساعة',
    'extra_min_per_hour_distance' => 'مسافة إضافية أدنى لكل ساعة',
    'enter_extra_min_per_hour_distance' => 'أدخل مسافة إضافية أدنى لكل ساعة',
    'create_successfully' => 'تم إنشاء الحزمة الساعية بنجاح.',
    'update_successfully' => 'تم تحديث الحزمة الساعية بنجاح.',
    'delete_successfully' => 'تم حذف الحزمة الساعية بنجاح.',
    'restore_successfully' => 'تم استعادة الحزمة الساعية بنجاح.',
    'permanent_delete_successfully' => 'تم حذف الحزمة الساعية نهائيًا بنجاح',
    'status_update_successfully' => 'تم تحديث حالة الحزمة الساعية بنجاح.',
    'select_vehicle_type' => 'اختر نوع المركبة',
    'no_vehicleType_message' => '*لإضافة نوع مركبة جديد، انقر فقط',
  ),
  'reports' => array (
    'reports' => 'التقارير',
    'user_reports' => 'تقارير المستخدم',
    'driver_reports' => 'تقارير السائق',
    'ride_reports' => 'تقارير الرحلات',
    'intercity_reports' => 'تقارير بين المدن',
    'select_driver' => 'اختر السائق',
    'select_user' => 'اختر المستخدم',
    'select_ride_status' => 'اختر حالة الرحلة',
    'select_payment_method' => 'اختر طريقة الدفع',
    'select_payment_status' => 'اختر حالة الدفع',
    'select_date' => 'اختر التاريخ',
    'select_zone' => 'اختر المنطقة',
    'select_service' => 'اختر الخدمة',
    'select_service_category' => 'اختر فئة الخدمة',
    'select_vehicle_type' => 'اختر نوع المركبة',
    'select_file_format' => 'اختر تنسيق الملف',
    'select_export_format' => 'اختر تنسيق التصدير',
    'driver' => 'السائق',
    'user' => 'المستخدم',
    'ride_status' => 'حالة الرحلة',
    'payment_method' => 'طريقة الدفع',
    'payment_status' => 'حالة الدفع',
    'date' => 'التاريخ',
    'zone' => 'المنطقة',
    'service' => 'الخدمة',
    'service_category' => 'فئة الخدمة',
    'vehicle_type' => 'نوع المركبة',
    'file_format' => 'تنسيق الملف',
    'all' => 'الكل',
    'filter' => 'تصفية',
    'CSV' => 'CSV',
    'SVG' => 'SVG',
    'ride_number' => 'رقم الرحلة',
    'zone_reports' => 'تقارير المناطق',
    'amount' => 'المبلغ',
    'rides' => 'الرحلات',
    'export' => 'تصدير',
    'export_data' => 'تصدير البيانات',
    'active_rides' => 'الرحلات النشطة',
    'cancelled_rides' => 'الرحلات الملغاة',
    'completed_rides' => 'الرحلات المكتملة',
    'contact' => 'الاتصال',
    'earnings' => 'الإيرادات',
    'ratings' => 'التقييمات',
    'scheduled_rides' => 'الرحلات المجدولة',
    'drivers' => 'السائقون',
    'name' => 'الاسم',
    'email' => 'البريد الإلكتروني',
    'coupon' => 'الكوبون',
    'select_coupon' => 'اختر الكوبون',
    'coupon_reports' => 'تقارير الكوبونات',
    'coupon_code' => 'كود الكوبون',
    'total_rides' => 'إجمالي الرحلات',
    'total_coupon_discount' => 'إجمالي خصم الكوبون',
    'total_ride_amount' => 'إجمالي مبلغ الرحلة',
    'total_drivers' => 'إجمالي السائقين',
    'total_vehicle_types' => 'إجمالي أنواع المركبات',
    'total_tax' => 'إجمالي الضريبة',
    'transaction_type' => 'نوع المعاملة',
    'select_transaction_type' => 'اختر نوع المعاملة',
    'ride' => 'رحلة',




    'subscription' => 'الاشتراك',
    'wallet' => 'المحفظة',
    'item_name' => 'اسم العنصر',
    'type' => 'النوع',
    'tansaction_id' => 'معرف المعاملة',
    'transaction_reports' => 'تقارير المعاملات',
    'Date'=>'تاريخ',
  ),
  'cancellation-reasons' => array (
    'cancellation-reasons' => 'أسباب الإلغاء',
    'add_new' => 'إضافة جديد',
    'add' => 'إضافة سبب إلغاء',
    'image' => 'الأيقونة',
    'edit' => 'تعديل سبب الإلغاء',
    'for' => 'لـ',
    'ride_start' => 'بدء الرحلة',
    'select_ride_start' => 'اختر بدء الرحلة',
    'select_type' => 'اختر لـ',
    'before' => 'قبل',
    'after' => 'بعد',
    'create' => 'سبب الإلغاء',
    'save' => 'حفظ',
    'title' => 'العنوان',
    'enter_title' => 'أدخل العنوان',
    'create_successfully' => 'تم إنشاء سبب الإلغاء بنجاح.',
    'update_successfully' => 'تم تحديث سبب الإلغاء بنجاح.',
    'delete_successfully' => 'تم حذف سبب الإلغاء بنجاح.',
    'status_update_successfully' => 'تم تحديث حالة سبب الإلغاء بنجاح.',
    'permanent_delete_successfully' => 'تم حذف سبب الإلغاء نهائيًا بنجاح.',
    'restore_successfully' => 'تم استعادة سبب الإلغاء بنجاح.',
  ),
  'bids' => array (
    'only_drivers_can_place_bids' => 'يمكن للسائقين فقط تقديم عروض.',
    'invalid_bidding_amount' => 'مبلغ عرض غير صالح.',
    'create_next_bid' => 'يمكنك تقديم عرض تالي بعد رفض العرض السابق.',
    'failed_to_create_ride' => 'فشل في إنشاء الرحلة.',
    'bid_status_already_changed' => 'حالة العرض هي بالفعل :status، لا يمكنك تغييرها مرة أخرى.',
  ),
  'reviews' => array (
    'reviews' => 'التعليقات',
    'delete_successfully' => 'تم حذف التعليق بنجاح.',
    'restore_successfully' => 'تم استعادة التعليق بنجاح.',
    'permanent_delete_successfully' => 'تم حذف التعليق نهائيًا بنجاح.',
    'ride_not_completed' => 'يرجى إكمال الرحلة قبل إضافة تعليق.',
    'already_reviewed' => 'تم تقديم تعليق لهذه الرحلة بالفعل.',
    'rider_reviews' => 'تعليقات الراكب',
    'driver_reviews' => 'تعليقات السائق',
  ),
  'notices' => array (
    'notices' => 'الإشعارات',
    'add_new' => 'إضافة جديد',
    'add_notice' => 'إضافة إشعار',
    'edit' => 'تعديل الإشعار',
    'zones' => 'المناطق',
    'notice' => 'الإشعارات',
    'select_zones' => 'اختر المناطق',
    'select_send_to' => 'اختر إرسال إلى',
    'color' => 'اللون',
    'select_color' =>'اختر اللون',
    'send_to' => 'إرسال إلى',
    'message' => 'الرسالة',
    'enter_message' => 'أدخل الرسالة',
    'no_zones_message' => '*لإضافة منطقة جديدة، انقر فقط',
    'no_drivers_message' => '*لإضافة سائق جديد، انقر فقط',
    'select_drivers' => 'اختر السائقين',
    'create_successfully' => 'تم إنشاء الإشعار بنجاح.',
    'update_successfully' => 'تم تحديث الإشعار بنجاح.',
    'delete_successfully' => 'تم حذف الإشعار بنجاح.',
    'restore_successfully' => 'تم استعادة الإشعار بنجاح.',
    'permanent_delete_successfully' => 'تم حذف الإشعار نهائيًا بنجاح',
    'status_update_successfully' => 'تم تحديث حالة الإشعار بنجاح.',
  ),
  'import' => array (
    'import' => 'استيراد',
    'csv_file_import' => 'تم استيراد ملف CSV بنجاح',
    'csv_file_allow' => 'يُسمح فقط بملفات CSV.',
    'upload_data' => 'رفع البيانات',
    'upload_instruction' => 'رفع ملف CSV لاستيراد البيانات.',
    'drag_drop' => 'سحب وإسقاط الملفات للرفع',
    'private_message' => 'ستبقى بياناتك خاصة حتى تنشرها.',
    'select_files' => 'اختر الملفات',
    'cancel' => 'إلغاء',
    'enter_link' => 'أدخل الرابط للرفع',
    'add' => 'إضافة',
    'google_shit_link' => 'رابط ورقة جوجل',
    'local_files' => 'ملف محلي',
    'enter_google_sheet_link' => 'أدخل رابط ورقة جوجل هنا',
    'example_csv' => 'يرجى تنزيل ملف CSV المثال من',
    'read_instructions' => 'ويرجى التأكد من قراءة التعليمات بعناية قبل بدء الاستيراد',
  ),
  'export' => array (
    'export' => 'تصدير',
    'csv_file_export' => 'تم تصدير ملف CSV بنجاح',
    'csv_file_allow' => 'يُسمح فقط بملفات CSV.',
    'export_drivers' => 'تصدير جميع السائقين',
    'export_data' => 'تصدير البيانات',
    'csv' => 'CSV',
    'excel' => 'Excel',
    'close' => 'إغلاق',
    'select_export_format' => 'اختر التصدير',
  ),
  'language' => array (
    'languages' => 'اللغات',
  ),
  'widget' => array (
    'ride_status_overviews' => 'نظرة عامة على حالات الرحلات',
    'statistics' => 'الإحصائيات',
    'total_riders' => 'إجمالي الركاب',
    'total_drivers' => 'إجمالي السائقين',
    'no_categories_available' => 'لا توجد فئات متاحة',
    'total_rides' => 'الرحلات',
    'ride_earnings' => 'إيرادات الرحلات',
    'average_revenue' => 'الإيراد المتوسط',
    'recent_rides' => 'الرحلات الأخيرة',
    'view_all' => 'عرض الكل',
    'revenue' => 'الإيراد',
    'ride_id' => 'رقم الرحلة',
    'driver_name' => 'السائق',
    'drop_off_location' => 'موقع الإنزال',
    'distance' => 'المسافة',
    'status' => 'الحالة',
    'total_verified_drivers' => 'إجمالي السائقين المتحققين',
    'total_unverified_drivers' => 'إجمالي السائقين غير المتحققين',
    'km' => 'كم',
    'no_data_available' => 'لا توجد بيانات متاحة',
    'service_categories' => 'فئات الخدمات',
    'than_today' => 'من اليوم',
    'top_drivers' => 'أفضل السائقين',
    'ratings' => 'التقييمات',
    'earnings' => 'الإيرادات',
    'online_status' => 'نشط عبر الإنترنت',
    'online_payment' => 'الدفع عبر الإنترنت',
    'offline_payment' => 'الدفع غير متصل',
    'withdraw_request' => 'طلب السحب',
    'Wallet_balance' => 'رصيد المحفظة',
    'reviews' => 'التعليقات',
    'documents' => 'الوثائق',
    'fleet_managers_info' =>'مديري الأسطول الكامل',
    'dispatcher'=>  'المرسلون',
    'peak_zone'=>'مناطق الذروة النشطة',
   'fleet_vehicle_type'=>'إجمالي مركبات الأسطول',
  ),
  'rental_vehicle' => array (
    'rental_vehicle' => 'مركبة الإيجار',
    'rental_vehicles' => 'مركبات الإيجار',
    'message' => 'يمكنك إضافة حتى 5 داخليات فقط.',
    'name' => 'الاسم',
    'images' => 'الصور',
    'fill_all_before_add' => 'يرجى إكمال جميع حقول الداخلية قبل إضافة أخرى.',
    'view_image_guide' => 'عرض دليل الصور',
    'normal_image' => 'صورة عادية',
    'normal_image_span' => 'صورة واضحة لمركبتك توفر عرضًا كاملاً',
    'front_view_span' => 'رفع صورة واضحة تظهر مقدمة مركبتك',
    'front_view' => 'صورة عرض أمامي',
    'side_view' => 'صورة عرض جانبي',
    'side_view_span' => 'قدم صورة جانبية للمركبة.',
    'boot_view' => 'صورة عرض الشنطة',
    'boot_view_span' => 'تأكد من أن الشنطة مفتوحة ومرئية بالكامل في الصورة.',
    'interior' => 'الداخلية',
    'interior_span' => 'إضافة صورة للداخلية تظهر الميزات الرئيسية مثل المقاعد واللوحة.',
    'enter_name' => 'أدخل الاسم (مثل: تويوتا كورولا)',
    'description' => 'الوصف',
    'enter_description' => 'أدخل الوصف (مثل: سيدان مريحة بـ5 مقاعد)',
    'vehicle_type' => 'نوع المركبة',
    'select_vehicle_type' => 'اختر نوع المركبة',
    'select_zones' => 'اختر المناطق',
    'interior_image' => 'صورة الداخلية',
    'vehicle_per_day_price' => 'سعر المركبة لكل يوم',
    'enter_vehicle_per_day_price' => 'أدخل سعر اليوم للمركبة (مثل: $50)',
    'with_driver' => 'مع سائق',
    'driver_details' => 'تفاصيل السائق',
    'enter_driver_details' => 'أدخل تفاصيل السائق (مثل: جون دو، مرخص وذو خبرة)',
    'driver_per_day_charge' => 'تكلفة السائق لكل يوم',
    'enter_driver_per_day_charge' => 'أدخل تكلفة اليوم للسائق (مثل: $20)',
    'car_type' => 'نوع السيارة',
    'enter_vehicle_subtype' => 'أدخل نوع فرعي للمركبة (مثل: سيدان)',
    'fuel_type' => 'نوع الوقود',
    'enter_fuel_type' => 'أدخل نوع الوقود (مثل: CNG)',
    'gear_type' => 'نوع التروس',
    'enter_gear_type' => 'أدخل نوع التروس (مثل: أوتوماتيكي)',
    'vehicle_speed' => 'سرعة المركبة',
    'enter_vehicle_speed' => 'أدخل سرعة المركبة (مثل: 120 كم/س)',
    'mileage' => 'الكيلومترات',
    'enter_mileage' => 'أدخل الكيلومترات (مثل: 15 كم/لتر)',
    'status' => 'الحالة',
    'save' => 'حفظ',
    'select_zone' => 'اختر المنطقة (مثل: مركز المدينة)',
    'zone' => 'المنطقة',
    'vehicle_subtype' => 'النوع الفرعي للمركبة',
    'add' => 'إضافة مركبة إيجار',
    'edit' => 'تعديل مركبة الإيجار',
    'enter_interior_detail' => 'أدخل تفاصيل الداخلية',
    'add_interior' => 'إضافة',
    'remove_interior' => 'إزالة',
    'deleted_successfully' => 'تم حذف مركبة الإيجار بنجاح',
    'registration_no' => 'رقم التسجيل',
    'enter_registration_no' => 'أدخل رقم التسجيل',
    'registration_image' => 'صورة التسجيل',
    'create_successfully' => 'تم إنشاء مركبة الإيجار بنجاح.',
    'update_successfully' => 'تم تحديث مركبة الإيجار بنجاح.',
    'delete_successfully' => 'تم حذف مركبة الإيجار بنجاح.',
    'restore_successfully' => 'تم استعادة مركبة الإيجار بنجاح.',
    'permanent_delete_successfully' => 'تم حذف مركبة الإيجار نهائيًا بنجاح',
    'status_update_successfully' => 'تم تحديث حالة مركبة الإيجار بنجاح.',
  ),
  'commission_histories' => array (
    'commission_histories' => 'تاريخ العمولات',
    'ride_commission_credited' => 'تم إيداع عمولة الرحلة #:ride_number.',
    'admin_debited_platform_fee' => 'تم سحب رسوم المنصة للرحلة #:ride_number بواسطة الإدارة.',
    'admin_debited_tax' => 'تم سحب الضريبة للرحلة #:ride_number بواسطة الإدارة.',
    'fleet_debited_commission' => 'تم سحب العمولة للرحلة #:ride_number بواسطة الأسطول.',
    'admin_debited_commission' => 'تم سحب العمولة للرحلة #:ride_number بواسطة الإدارة.',
    'ride_cancellation_charge_debited' => 'تكلفة إلغاء الرحلة #:ride_number.',
    'ride_cancellation_charge_credited' => 'تم إيداع تكلفة إلغاء الرحلة #:ride_number عبر الراكب.',
  ),
  'plans' => array (
    'plans' => 'الخطط',
    'name' => 'الاسم',
    'enter_name' => 'أدخل اسم الخطة',
    'add' => 'إضافة خطة',
    'edit' => 'تعديل الخطة',
    'description' => 'الوصف',
    'enter_description' => 'أدخل الوصف',
    'add_description' => 'إضافة وصف',
    'duration' => 'المدة',
    'price' => 'السعر',
    'enter_plan_price' => 'أدخل السعر',
    'select_duration' => 'اختر المدة',
    'all' => 'جميع الخطط',
    'add_new' => 'إضافة جديد',
    'save' => 'حفظ',
    'select_service_category' => 'اختر فئات الخدمات',
    'select_service_categories' => 'اختر فئات الخدمات',
    'status' => 'الحالة',
    'create_successfully' => 'تم إنشاء الخطة بنجاح.',
    'update_successfully' => 'تم تحديث الخطة بنجاح.',
    'delete_successfully' => 'تم حذف الخطة بنجاح.',
    'restore_successfully' => 'تم استعادة الخطة بنجاح.',
    'permanent_delete_successfully' => 'تم حذف الخطة نهائيًا بنجاح',
    'status_update_successfully' => 'تم تحديث حالة الخطة بنجاح.',
    'payment_not_allowed_for_plan' => 'الدفع المختار غير مسموح بشراء الخطة',
    'only_driver_can_purchase_plan' => 'يمكن للسائقين فقط شراء الخطة.',
    'invalid_payment_method' => 'طريقة الدفع المختارة غير صالحة.',
    'wallet_debit_success' => 'تم سحب مبلغ المحفظة بنجاح لشراء الخطة :plan_name.',
    'message' => 'يمكنك إضافة حتى 5 وصفات فقط.'
  ),
  'traits' => array (
    'invalid_weight_unit' => 'وحدة وزن غير صالحة مقدمة.',
    'fare_amount_outside_range' => 'يجب أن يكون مبلغ الأجرة بين :min و :max لمسار :distance :unit.',
    'invalid_package_fare' => 'يجب أن يكون مبلغ الأجرة بين :min و :max للحزمة المختارة.',
    'invalid_hourly_package' => 'حزمة ساعية مختارة غير صالحة.',
    'invalid_vehicle_for_package' => 'المركبة المختارة غير لخدمة الحزم.',
    'hourly_package_required' => 'يجب توفير حزمة ساعية لفئة الحزم.',
    'invalid_vehicle_for_parcel' => 'المركبة المختارة غير لخدمة الطرود.',
    'invalid_service' => 'الخدمة المختارة غير صالحة.',
    'admin_debited_commission' => 'تم سحب العمولة بواسطة الإدارة.',
    'fleet_debited_commission' => 'تم سحب العمولة بواسطة الأسطول.',
    'admin_debited_tax' => 'تم سحب مبلغ الضريبة بواسطة الإدارة',
    'admin_debited_platform_fee' => 'تم سحب مبلغ رسوم المنصة بواسطة الإدارة.',
  ),
  'modal' => array (
    'export_data' => 'تصدير البيانات',
    'select_export_format' => 'اختر تنسيق التصدير',
    'csv' => 'CSV',
    'excel' => 'Excel',
    'close' => 'إغلاق',
    'export' => 'تصدير',
  ),
  'subscriptions' => array (
    'driver_subscription' => 'اشتراكات السائق',
    'subscriptions' => 'الاشتراكات',
  ),
  'onboardings' => array(
    'onboardings' => 'شاشات الترحيب',
    'edit' => 'تعديل الترحيب',
    'image' => 'الصورة',
    'title' => 'العنوان',
    'save' => 'حفظ',
    'description' => 'الوصف',
    'enter_description' => 'أدخل الوصف',
    'type' => 'النوع',
    'select_type' => 'اختر النوع',
    'update_successfully' => 'تم تحديث الترحيب بنجاح.',
    'delete_successfully' => 'تم حذف الترحيب بنجاح.',
  ),
  'dispatchers' => array(
    'dispatchers' => 'المرسلون',
    'add_new' => 'إضافة جديد',
    'all' => 'جميع المرسلين',
    'add' => 'إضافة مرسلين',
    'rider_details' => 'تفاصيل الراكب',
    'create' => 'إنشاء مرسل',
    'add_dispatchers' => 'إضافة مرسلين',
    'edit' => 'تعديل المرسل',
    'full_name' => 'الاسم الكامل',
    'reviews' => 'التعليقات',
    'email' => 'البريد الإلكتروني',
    'enter_email' => 'أدخل البريد الإلكتروني',
    'contact_number' => 'رقم الاتصال',
    'emails' => 'البريد الإلكتروني',
    'select_zones' => 'اختر المناطق',
    'no_zones_message' => '*لإضافة منطقة جديدة، انقر فقط',
    'enter_full_name' => 'أدخل الاسم الكامل',
    'phone' => 'الهاتف',
    'zones' => 'المناطق',
    'enter_phone' => 'أدخل الهاتف',
    'enter_password' => 'أدخل كلمة المرور',
    'enter_confirm_password' => 'أدخل تأكيد كلمة المرور',
    'new_password' => 'كلمة مرور جديدة',
    'confirm_password' => 'تأكيد كلمة المرور',
    'notification' => 'إخطار المرسل',
    'sentence' => 'إرسال بريد إلكتروني إلى المرسل الجديد حول حسابه.',
    'create_successfully' => 'تم إنشاء المرسل بنجاح.',
    'update_successfully' => 'تم تحديث المرسل بنجاح.',
    'delete_successfully' => 'تم حذف المرسل بنجاح.',
    'restore_successfully' => 'تم استعادة المرسل بنجاح.',
    'permanent_delete_successfully' => 'تم حذف المرسل نهائيًا بنجاح.',
    'status_update_successfully' => 'تم تحديث حالة المرسل بنجاح.',
  ),
  'fleet_managers' => array(
    'profile_image' => 'صورة الملف الشخصي',
    'full_name' => 'الاسم الكامل',
    'personal_information' => 'المعلومات الشخصية',
    'email' => 'البريد الإلكتروني',
    'edit' => 'تعديل مدير الأسطول',
    'enter_phone' => 'أدخل الهاتف',
    'new_password' => 'كلمة مرور جديدة',
    'confirm_password' => 'تأكيد كلمة المرور',
    'contact_number' => 'رقم الاتصال',
    'emails' => 'البريد الإلكتروني',
    'created_at' => 'تاريخ الإنشاء',
    'action' => 'الإجراء',
    'enter_full_name' => 'أدخل الاسم الكامل',
    'address_details' => 'تفاصيل العنوان',
    'company_name' => 'اسم الشركة',
    'enter_company_name' => 'أدخل اسم الشركة',
    'company_email' => 'بريد الشركة',
    'enter_company_email' => 'أدخل بريد الشركة',
    'company_address' => 'عنوان الشركة',
    'enter_company_address' => 'أدخل عنوان الشركة',
    'city' => 'المدينة',
    'enter_city' => 'أدخل المدينة',
    'postal_code' => 'الرمز البريدي',
    'enter_postal_code' => 'أدخل الرمز البريدي',
    'enter_confirm_password' => 'أدخل تأكيد كلمة المرور',
    'enter_email' => 'أدخل البريد الإلكتروني',
    'sentence' => 'إرسال بريد إلكتروني إلى مدير الأسطول الجديد حول حسابه.',
    'enter_password' => 'أدخل كلمة المرور',
    'notification' => 'إخطار مدير الأسطول',
    'phone' => 'الهاتف',
    'zones' => 'المناطق',
    'no_reviews' => 'لا توجد تعليقات متاحة',
    'description' => 'الوصف',
    'fleet_managers' => 'مديرو الأساطيل',
    'add_new' => 'إضافة جديد',
    'payout_details' => 'تفاصيل الدفع',
    'general' => 'عام',
    'bank_account_no' => 'رقم الحساب البنكي',
    'enter_bank_account' => 'أدخل رقم الحساب البنكي',
    'bank_name' => 'اسم البنك',
    'enter_bank_name' => 'أدخل اسم البنك',
    'holder_name' => 'اسم الحامل',
    'enter_holder_name' => 'أدخل اسم الحامل',
    'swift' => 'سويفت',
    'enter_swift_code' => 'أدخل كود سويفت',
    'routing_number' => 'رقم التوجيه',
    'enter_routing_number' => 'أدخل رقم التوجيه',
    'all' => 'جميع مديري الأساطيل',
    'add' => 'إضافة مدير أسطول',
    'create_successfully' => 'تم إنشاء مدير الأسطول بنجاح.',
    'update_successfully' => 'تم تحديث مدير الأسطول بنجاح.',
    'delete_successfully' => 'تم حذف مدير الأسطول بنجاح.',
    'restore_successfully' => 'تم استعادة مدير الأسطول بنجاح.',
    'permanent_delete_successfully' => 'تم حذف مدير الأسطول نهائيًا بنجاح.',
    'status_update_successfully' => 'تم تحديث حالة مدير الأسطول بنجاح.',
  ),
  'sos_alerts' => array(
    'sos_alerts' => 'تنبيهات SOS',
  ),
  'fleet_withdraw_requests' => array(
    'title' => 'طلبات سحب الأسطول',
    'balance' => 'الرصيد',
    'pending_balance' => 'الرصيد المعلق',
    'send_withdrawRequest' => 'إرسال طلب سحب',
    'withdraw_request' => 'طلب السحب',
    'amount' => 'المبلغ',
    'payment_type' => 'نوع الدفع',
    'message' => 'الرسالة',
    'enter_message' => 'أدخل الرسالة',
    'bank' => 'البنك',
    'paypal' => 'باي بال',
    'status' => 'الحالة',
    'submit' => 'إرسال',
  ),
  'chats' => array(
    'recent_chats' => 'المحادثات الأخيرة',
    'chats' => 'المحادثات',
    'no_chats_found' => 'لم يتم العثور على محادثات',
    'view_all_chats' => 'عرض جميع المحادثات',
    'no_riders_found' => 'لم يتم العثور على ركاب',
    'no_driver_found' => 'لم يتم العثور على سائقين',
    'restore_chat' => 'استعادة المحادثة',
    'select_a_user' => 'اختر مستخدمًا',
    'offline' => 'غير متصل',
    'modal' => 'هل أنت متأكد من مسح هذه المحادثة؟',
    'confirmation' => 'التأكيد',
    'no_messages_yet' => ' لا توجد رسائل بعد',
    'load_message' => ' جارٍ تحميل الرسائل...',
    'search_user' => 'البحث عن مستخدمين...',
    'search_rider' => 'البحث عن ركاب...',
    'search_driver' => 'البحث عن سائقين...',
    'all' => 'الكل',
    'driver' => 'السائقون',
    'rider' => 'الركاب',
    'no' => 'لا',
    'yes' => 'نعم',
    'type_message' => 'اكتب الرسالة هنا..'
  ),
  'ambulances' => array(
    'ambulance' => 'الإسعاف',
    'ambulances' => 'الإسعافات'
  ),

  'surge_prices' => array(
      'surge_prices' => 'أسعار الزيادة',
      'surge_price' => 'سعر الزيادة',
      'add_new' => 'إضافة جديد',
      'zones' => 'المناطق',
      'select_zones' => 'اختر المناطق',
      'add' => 'إضافة سعر زيادة',
      'edit' => 'تعديل سعر الزيادة',
      'all' => 'جميع أسعار الزيادة',
      'enter_title' => 'أدخل العنوان',
      'enter_order' => 'أدخل الترتيب',
      'surge_price_calculation' => 'حساب سعر الزيادة',
      'day' => 'اليوم',
      'amount' => 'المبلغ',
      'select_day' => 'اختر الأيام',
      'start_time' => 'وقت البدء',
      'end_time' => 'وقت النهاية',
      'vehicle_surge_price' => 'أسعار زيادة المركبات',
      'how_is_this_calculated' => ' كيف يتم حساب هذا؟',
      'save_surge_prices' => 'حفظ أسعار الزيادة',
      'publish' => 'نشر',
      'bike' => 'دراجة',
      'additional_distance_charge' => 'تكلفة مسافة إضافية',
      'additional_minute_charge' => 'تكلفة دقيقة إضافية',
      'platform_fee' => 'رسوم المنصة',
      'tax' => 'الضريبة',
      'commission' => 'العمولة',
      'waiting_charges' => 'تكاليف الانتظار لـ',
      'cancellation_charge' => 'تكلفة الإلغاء',
      'base_fare_charge' => 'تكلفة الأجرة الأساسية',
      'amount' => 'المبلغ',
      'total' => 'الإجمالي',
      'message' => 'الرسالة',
      'create_successfully' => 'تم إنشاء سعر الزيادة بنجاح.',
      'update_successfully' => 'تم تحديث سعر الزيادة بنجاح.',
      'delete_successfully' => 'تم حذف سعر الزيادة بنجاح.',
      'restore_successfully' => 'تم استعادة سعر الزيادة بنجاح.',
      'permanent_delete_successfully' => 'تم حذف سعر الزيادة نهائيًا بنجاح.',
      'status_update_successfully' => 'تم تحديث حالة سعر الزيادة بنجاح.',
  ),

  'airports' => array(
    'airports' => 'المطارات',
    'airport' => 'المطار',
    'add_new' => 'إضافة جديد',
    'add' => 'إضافة مطار',
    'edit' => 'تعديل المطار',
    'all' => 'جميع المطارات',
    'enter_title' => 'أدخل العنوان',
    'enter_order' => 'أدخل الترتيب',
    'add_airport' => 'إضافة مطار',
    'location' => 'الموقع',
    'name' => 'اسم المطار',
    'enter_name' => 'أدخل اسم المطار',
    'coordinates' => 'الإحداثيات',
    'place_points' => 'وضع النقاط',
    'map' => 'الخريطة',
    'search_location' => 'البحث عن موقع',
    'select_place_points' => 'اختر نقاط المكان',
    'search_locations' => 'البحث عن موقعك',
    'add' => 'إضافة مطار',
    'add_new' => 'إضافة جديد',
    'select_location' => 'اختر الموقع',
    'create_successfully' => 'تم إنشاء المطار بنجاح.',
    'update_successfully' => 'تم تحديث المطار بنجاح.',
    'delete_successfully' => 'تم حذف المطار بنجاح.',
    'restore_successfully' => 'تم استعادة المطار بنجاح.',
    'permanent_delete_successfully' => 'تم حذف المطار نهائيًا بنجاح.',
    'status_update_successfully' => 'تم تحديث حالة المطار بنجاح.',
    ),

    'extra_charges' => array (
      'extra_charge' => 'تكلفة إضافية',
      'extra_charges' => 'التكاليف الإضافية',
      'all' => 'جميع التكاليف الإضافية',
      'add' => 'إضافة تكلفة إضافية',
      'edit' => 'تعديل التكلفة الإضافية',
      'add_new' => 'إضافة جديد',
      'message' => 'الرسالة',
      'name' => 'الاسم',
      'title' => 'العنوان',
      'enter_title' => 'أدخل العنوان',
      'enter_name' => 'أدخل الاسم',
      'amount' => 'المبلغ',
      'enter_amount' => 'أدخل المبلغ',
      'type' => 'النوع',
      'select_type' => 'اختر النوع',
      'status' => 'الحالة',
      'create_successfully' => 'تم إنشاء التكلفة الإضافية بنجاح.',
      'update_successfully' => 'تم تحديث التكلفة الإضافية بنجاح.',
      'delete_successfully' => 'تم حذف التكلفة الإضافية بنجاح.',
      'status_update_successfully' => 'تم تحديث حالة التكلفة الإضافية بنجاح.',
      'permanent_delete_successfully' => 'تم حذف التكلفة الإضافية نهائيًا بنجاح.',
      'restore_successfully' => 'تم استعادة التكلفة الإضافية بنجاح.',
    ),

    'vehicle_type_zones' => array(
      'vehicle_type_zone' => 'مناطق نوع المركبة',
      'zone_name' => 'اسم المنطقة',
      'currency_code' => 'رمز العملة',
      'distance_type' => 'نوع المسافة',
      'action' => 'الإجراء',
      'set_price_for' => 'تعيين السعر لـ',
      'base_fare_charge' => 'تكلفة الأجرة الأساسية',
      'base_distance' => 'المسافة الأساسية',
      'per_distance_charge' => 'تكلفة المسافة',
      'per_minute_charge' => 'تكلفة الدقيقة',
      'per_weight_charge' => 'تكلفة الوزن',
      'waiting_charge' => 'تكلفة الانتظار',
      'free_wait_time' => 'وقت الانتظار المجاني قبل بدء الرحلة (دقائق)',
      'free_Wait_time_after_start_ride' => 'وقت الانتظار المجاني بعد بدء الرحلة (دقائق)',
      'cancellation_charge_rider' => 'تكلفة الإلغاء للراكب',
      'cancellation_charge_driver' => 'تكلفة الإلغاء للسائق',
      'commission_type' => 'نوع العمولة',
      'commission_rate' => 'معدل العمولة',
      'allow_airport_charge' => 'السماح بتكلفة المطار',
      'charge_goes_to' => 'التكلفة تذهب إلى',
      'yes' => 'نعم',
      'no' => 'لا',
      'set_price' => 'تعيين السعر',
      'fixed' => 'ثابت',
      'allow_tax' => 'السماح بالضريبة',
      'tax' => 'الضريبة',
      'select_tax' => 'اختر ضريبة',
      'percentage' => 'نسبة مئوية',
      'admin' => 'الإدارة',
      'rider' => 'الراكب',
      'driver' => 'السائق',
      'company' => 'الأسطول',
      'airport_charge_rate' => 'معدل تكلفة المطار',
      'save_prices' => 'حفظ الأسعار',
      'close' => 'إغلاق',
    ),
    'referrals' => [
        'referrals' => 'الإحالات',
        'referrer' => 'المُحيل',
        'referred_user' => 'المستخدم المُحال',
        'referral_code' => 'كود الإحالة',
        'bonus_amount' => 'مبلغ المكافأة',
        'status' => 'الحالة',
        'credited_at' => 'تم التسجيل في',
        'created_at' => 'تم الإنشاء في',
        'pending' => 'معلق',
        'credited' => 'تم التسجيل',
        'all' => 'الكل',
        'trash' => 'سلة المحذوفات',
        'all_types' => 'جميع الأنواع',
        'rider_referrals' => 'إحالات الراكب',
        'driver_referrals' => 'إحالات السائق',
        'referrer_type' => 'نوع المُحيل',
        'referred_type' => 'نوع المُحال',
        'ride_amount' => 'مبلغ الرحلة',
        'referrer_bonus' => 'مكافأة المُحيل',
        'referred_bonus' => 'مكافأة المُحال',
        'referrer_percentage' => 'نسبة المُحيل %',
        'referred_percentage' => 'نسبة المُحال %',
        'rider' => 'راكب',
        'driver' => 'سائق',
    ],
    'rental_vehicle_zones' => array(
      'rental_vehicle_zones' => 'مناطق مركبات الإيجار',
      'zone_name' => 'اسم المنطقة',
      'currency_code' => 'رمز العملة',
      'distance_type' => 'نوع المسافة',
      'action' => 'الإجراء',
      'set_price_for' => 'تعيين السعر لـ',
      'base_fare_charge' => 'تكلفة الأجرة الأساسية',
      'base_distance' => 'المسافة الأساسية',
      'per_distance_charge' => 'تكلفة المسافة',
      'per_minute_charge' => 'تكلفة الدقيقة',
      'per_weight_charge' => 'تكلفة الوزن',
      'waiting_charge' => 'تكلفة الانتظار',
      'free_wait_time' => 'وقت الانتظار المجاني قبل بدء الرحلة (دقائق)',
      'free_Wait_time_after_start_ride' => 'وقت الانتظار المجاني بعد بدء الرحلة (دقائق)',
      'cancellation_charge_rider' => 'تكلفة الإلغاء للراكب',
      'cancellation_charge_driver' => 'تكلفة الإلغاء للسائق',
      'commission_type' => 'نوع العمولة',
      'commission_rate' => 'معدل العمولة',
      'allow_airport_charge' => 'السماح بتكلفة المطار',
      'charge_goes_to' => 'التكلفة تذهب إلى',
      'yes' => 'نعم',
      'no' => 'لا',
      'set_price' => 'تعيين السعر',
      'fixed' => 'ثابت',
      'allow_tax' => 'السماح بالضريبة',
      'vehicle_per_day_price' => 'سعر المركبة لكل يوم',
      'driver_per_day_charge' => 'تكلفة السائق لكل يوم',
      'tax' => 'الضريبة',
      'select_tax' => 'اختر ضريبة',
      'percentage' => 'نسبة مئوية',
      'rider' => 'الراكب',
      'driver' => 'السائق',
      'company' => 'الشركة',
      'airport_charge_rate' => 'معدل تكلفة المطار',
      'save_prices' => 'حفظ الأسعار',
      'close' => 'إغلاق',
      'google' => 'جوجل',
    ),
    'validation' => [
        'minimum_ride_amount_positive' => 'يجب أن يكون الحد الأدنى لمبلغ الرحلة رقمًا موجبًا.',
        'referrer_bonus_percentage_range' => 'يجب أن تكون نسبة مكافأة المُحيل بين 0 و 100.',
        'referred_bonus_percentage_range' => 'يجب أن تكون نسبة مكافأة المستخدم المُحال بين 0 و 100.',
    ],
);
