<?php

return [
    'taxido' => 'Taxido',
    'status' => 'Status',
    'yes' => 'Ja',
    'no' => 'Nein',
    'inactive' => 'Inaktiv',
      'ride' => [
            'admin' => [
                'email' => [
                    'subject' => 'Fahrt #{ride_number} Aktualisierung: {status} 🚖',
                    'greeting' => 'Hallo Admin,',
                    'body' => 'Eine Aktualisierung des Fahrtstatus erfordert Ihre Aufmerksamkeit.',
                    'footer' => 'Bitte überprüfen Sie die Details im Admin-Panel.',
                ],
                'push' => [
                    'pending' => [
                        'title' => '📢 Neue Fahrt ausstehend',
                        'body' => 'Fahrt #{ride_number} wartet auf Überprüfung. Bitte überwachen. 📋',
                    ],
                    'requested' => [
                        'title' => '🔔 Fahrtanfrage erhalten',
                        'body' => 'Fahrt #{ride_number} wurde angefordert. Warten auf Fahrerauswahl. 🚖',
                    ],
                    'scheduled' => [
                        'title' => '📅 Fahrt geplant',
                        'body' => 'Fahrt #{ride_number} ist geplant. Alle Details bestätigt. ✅',
                    ],
                    'accepted' => [
                        'title' => '✔️ Fahrt akzeptiert',
                        'body' => 'Fahrt #{ride_number} wurde vom Fahrer akzeptiert. 🚗',
                    ],
                    'rejected' => [
                        'title' => '🚫 Fahrt abgelehnt',
                        'body' => 'Fahrt #{ride_number} wurde abgelehnt. Bitte für Neuvergabe prüfen. 🔍',
                    ],
                    'arrived' => [
                        'title' => '📍 Fahrer angekommen',
                        'body' => 'Fahrer ist für Fahrt #{ride_number} angekommen. Bereit zur Abholung. 🏠',
                    ],
                    'started' => [
                        'title' => '🚀 Fahrt begonnen',
                        'body' => 'Fahrt #{ride_number} ist im Gange. Überwachen Sie Updates. 🌟',
                    ],
                    'cancelled' => [
                        'title' => '❌ Fahrt storniert',
                        'body' => 'Fahrt #{ride_number} wurde storniert. Details prüfen. 📝',
                    ],
                    'completed' => [
                        'title' => '🎉 Fahrt abgeschlossen',
                        'body' => 'Fahrt #{ride_number} wurde erfolgreich abgeschlossen. Gute Arbeit! 🥳',
                    ],
                ],
            ],
            'rider' => [
                'email' => [
                    'subject' => 'Fahrtstatus #{ride_number}: {status} 🚖',
                    'greeting' => 'Hallo {rider_name},',
                    'body' => 'Hier ist die neueste Aktualisierung zu Ihrer Fahrt.',
                    'extra' => 'Vielen Dank, dass Sie unseren Service gewählt haben! Wir sind hier, um Ihnen zu helfen.',
                ],
                'push' => [
                    'pending' => [
                        'title' => '📢 Fahrt #{ride_number} ausstehend',
                        'body' => 'Ihre Fahrt wartet auf Bestätigung. Wir benachrichtigen Sie bald! ⏳',
                    ],
                    'requested' => [
                        'title' => '🔔 Fahrt #{ride_number} angefordert',
                        'body' => 'Ihre Fahrtanfrage wird bearbeitet. Ein Fahrer wird bald zugewiesen. 🚖',
                    ],
                    'scheduled' => [
                        'title' => '📅 Fahrt #{ride_number} geplant',
                        'body' => 'Ihre Fahrt ist für {timestamp} bestätigt. Bereiten Sie sich vor! ✅',
                    ],
                    'accepted' => [
                        'title' => '✔️ Fahrt #{ride_number} akzeptiert',
                        'body' => 'Fahrer {driver_name} hat Ihre Fahrt akzeptiert. Er wird bald bei {pickup_location} ankommen. 🚗',
                    ],
                    'rejected' => [
                        'title' => '🚫 Fahrt #{ride_number} abgelehnt',
                        'body' => 'Ihre Fahrt wurde abgelehnt. Wir suchen nach einem anderen Fahrer. 🔍',
                    ],
                    'arrived' => [
                        'title' => '📍 Fahrer für Fahrt #{ride_number} angekommen',
                        'body' => 'Fahrer {driver_name} ist bei {pickup_location}. Treffen Sie ihn jetzt! 🏠',
                    ],
                    'started' => [
                        'title' => '🚀 Fahrt #{ride_number} begonnen',
                        'body' => 'Ihre Fahrt mit {driver_name} ist im Gange. Gute Reise! 🌟',
                    ],
                    'cancelled' => [
                        'title' => '❌ Fahrt #{ride_number} storniert',
                        'body' => 'Ihre Fahrt wurde storniert. Bitte buchen Sie bei Bedarf eine neue. 📝',
                    ],
                    'completed' => [
                        'title' => '🎉 Fahrt #{ride_number} abgeschlossen',
                        'body' => 'Ihre Fahrt nach {destination} ist abgeschlossen. Danke, dass Sie mit uns gefahren sind! 🥳',
                    ],
                ],
            ],
            'driver' => [
                'email' => [
                    'subject' => 'Fahrtzuweisung #{ride_number}: {status} 🚖',
                    'greeting' => 'Hallo {driver_name},',
                    'body' => 'Sie haben eine neue Fahrtaktualisierung.',
                    'extra' => 'Vielen Dank für Ihren Service! Machen Sie weiter so.',
                ],
                'push' => [
                    'pending' => [
                        'title' => '📢 Neue Fahrt #{ride_number} verfügbar',
                        'body' => 'Eine neue Fahrt ist ausstehend. Details prüfen, um zu akzeptieren! ⏳',
                    ],
                    'requested' => [
                        'title' => '🔔 Fahrt #{ride_number} angefordert',
                        'body' => 'Eine neue Fahrtanfrage ist verfügbar. Jetzt akzeptieren! 🚖',
                    ],
                    'scheduled' => [
                        'title' => '📅 Fahrt #{ride_number} geplant',
                        'body' => 'Fahrt geplant für {timestamp}. Bereiten Sie sich entsprechend vor! ✅',
                    ],
                    'accepted' => [
                        'title' => '✔️ Fahrt #{ride_number} akzeptiert',
                        'body' => 'Sie haben Fahrt #{ride_number} akzeptiert. Fahren Sie zu {pickup_location}! 🚗',
                    ],
                    'rejected' => [
                        'title' => '🚫 Fahrt #{ride_number} abgelehnt',
                        'body' => 'Sie haben Fahrt #{ride_number} abgelehnt. Prüfen Sie neue Zuweisungen. 🔍',
                    ],
                    'arrived' => [
                        'title' => '📍 An Abholort für Fahrt #{ride_number} angekommen',
                        'body' => 'Sie sind bei {pickup_location}. Warten Sie auf {rider_name}. 🏠',
                    ],
                    'started' => [
                        'title' => '🚀 Fahrt #{ride_number} begonnen',
                        'body' => 'Fahrt mit {rider_name} ist im Gange. Fahren Sie sicher! 🌟',
                    ],
                    'cancelled' => [
                        'title' => '❌ Fahrt #{ride_number} storniert',
                        'body' => 'Fahrt #{ride_number} wurde storniert. Prüfen Sie neue Fahrten. 📝',
                    ],
                    'completed' => [
                        'title' => '🎉 Fahrt #{ride_number} abgeschlossen',
                        'body' => 'Gute Arbeit! Fahrt nach {destination} ist abgeschlossen. 🥳',
                    ],
                ],
            ],
            'email' => [
                'details' => 'Fahrtdetails:',
                'ride_id' => 'Fahrt-ID: {ride_number}',
                'status' => 'Status: {status}',
                'rider' => 'Fahrgast: {rider_name}',
                'driver' => 'Fahrer: {driver_name}',
                'pickup_location' => 'Abholort: {pickup_location}',
                'destination' => 'Ziel: {destination}',
                'timestamp' => 'Zeitstempel: {timestamp}',
                'salutation' => 'Mit freundlichen Grüßen,
                Das Fahrt-Team',
            ],
        ],
    'drivers' => [
        'general' => 'Allgemein',
        'address' => 'Adresse',
        'all' => 'Alle Fahrer',
        'location' => 'Standort',
        'is_online' => 'Ist Online',
        'is_on_ride' => 'Ist auf Fahrt',
        'confirm_password' => 'Passwort bestätigen',
        'new_password' => 'Neues Passwort',
        'enter_password' => 'Passwort eingeben',
        'enter_confirm_password' => 'Passwort bestätigen eingeben',
        'total_earnings' => 'Gesamteinnahmen',
        'current_driver_location' => 'Fahrerstandort',
        'wallet' => 'Brieftasche',
        'pending_withdraw_request' => 'Ausstehende Auszahlungsanfrage',
        'contact_number' => 'Kontaktnummer',
        'drivers' => 'Fahrer',
        'no_documents' => 'Keine Fahrer-Dokumente verfügbar',
        'no_withdraw_requests' => 'Keine Auszahlungsanfrage verfügbar',
        'vehicle_info' => 'Keine Fahrzeuginformationen verfügbar',
        'total_rides' => 'Gesamtfahrten',
        'select_rental_vehicle' => 'Mietwagen auswählen',
        'no_rental_message' => '*Um ein neues Mietfahrzeug hinzuzufügen, klicken Sie einfach',
        'unverified_drivers' => 'Unverifizierte Fahrer',
        'create' => 'Fahrer erstellen',
        'add' => 'Fahrer hinzufügen',
        'edit_profile' => 'Profil bearbeiten',
        'document' => 'Dokument',
        'driver_documents' => 'Fahrer-Dokumente',
        'add_driver' => 'Fahrer hinzufügen',
        'edit' => 'Fahrer bearbeiten',
        'personal_information' => 'Persönliche Informationen',
        'role_permissions' => 'Rolle & Berechtigungen',
        'profile_image' => 'Profilbild',
        'full_name' => 'Vollständiger Name',
        'email' => 'E-Mail',
        'phone' => 'Telefon',
        'other_details' => 'Weitere Details',
        'field' => 'Felder',
        'value' => 'Wert',
        'add_new' => 'Neu hinzufügen',
        'unverified_driver' => 'Unverifizierte Fahrer',
        'enter_full_name' => 'Vollständigen Namen eingeben',
        'enter_email' => 'E-Mail eingeben',
        'role' => 'Rolle',
        'verified_drivers' => 'Verifizierte Fahrer',
        'enter_phone' => 'Telefon eingeben',
        'select_role' => 'Rolle auswählen',
        'reviews' => 'Bewertungen',
        'notification' => 'Fahrer benachrichtigen',
        'sentence' => 'Senden Sie dem neuen Fahrer eine E-Mail über sein Konto.',
        'vehicle' => 'Fahrzeug',
        'vehicle_type' => 'Fahrzeugtyp',
        'model' => 'Modell',
        'enter_model' => 'Fahrzeugmodell eingeben',
        'plate_number' => 'Kennzeichen',
        'enter_plate_number' => 'Fahrzeugkennzeichen eingeben',
        'select_vehicle' => 'Fahrzeugtyp auswählen',
        'seat' => 'Sitz',
        'enter_seat' => 'Fahrzeugsitz eingeben',
        'color' => 'Farbe',
        'enter_color' => 'Fahrzeugfarbe eingeben',
        'publish' => 'Veröffentlichen',
        'payout_details' => 'Auszahlungsdetails',
        'bank_account_no' => 'Bankkontonummer',
        'enter_bank_account' => 'Bankkontonummer eingeben',
        'bank_name' => 'Bankname',
        'enter_bank_name' => 'Bankname eingeben',
        'holder_name' => 'Kontoinhaber',
        'enter_holder_name' => 'Kontoinhaber eingeben',
        'swift' => 'SWIFT',
        'enter_swift_code' => 'SWIFT-Code eingeben',
        'routing_number' => 'Routing-Nummer',
        'enter_routing_number' => 'Routing-Nummer eingeben',

        'enter_address' => 'Adresse eingeben',
        'street_address' => 'Straßenadresse',
        'enter_street_address' => 'Straßenadresse eingeben',
        'area_locality' => 'Gebiet/Ort',
        'no_zones_message' => '*Um eine neue Zone hinzuzufügen, klicken Sie einfach',
        'enter_area_locality' => 'Gebiet oder Ort eingeben',
        'country' => 'Land',
        'select_country' => 'Land auswählen',
        'state' => 'Bundesland',
        'select_state' => 'Bundesland auswählen',
        'city' => 'Stadt',
        'enter_city' => 'Stadt eingeben',
        'postal_code' => 'Postleitzahl',
        'zones' => 'Zonen',
        'vehicle_information' => 'Fahrzeuginformationen',
        'rules' => 'Fahrerregeln',
        'seats' => 'Sitze',
        'vehicle_color' => 'Fahrzeugfarbe:',
        'vehicle_num' => 'Fahrzeugnummer:',
        'vehicle_types' => 'Fahrzeugtyp:',
        'no_vehicle_information' => 'Keine Fahrzeuginformationen gefunden',
        'zone' => 'Zone:',
        'no_zones' => 'Keine Zonen verfügbar',
        'bank_details' => 'Bankdetails',
        'bank_names' => 'Bankname:',
        'ride_number' => 'Fahrtnummer',
        'service' => 'Dienst',
        'service_category' => 'Dienstkategorie',
        'ride_status' => 'Fahrtstatus',
        'payment_method' => 'Zahlungsmethode',
        'payment_status' => 'Zahlungsstatus',
        'total_amount' => 'Gesamtbetrag',
        'holder_names' => 'Kontoinhaber:',
        'account_number' => 'Kontonummer',
        'other_info' => 'Weitere Informationen:',
        'no_bank_details' => 'Keine Bankdetails gefunden',
        'intercity_ride_list' => 'Intercity-Fahrten',
        'package_ride_list' => 'Paket-Fahrten',
        'no_rides_available' => 'Keine Fahrten verfügbar',
        'intracity_ride_list' => 'Innerstädtische Fahrten',
        'no_intercity_rides' => 'Keine Intercity-Fahrten gefunden',
        'no_intercity_rides_available' => 'Keine Intercity-Fahrten verfügbar',
        'no_intracity_rides' => 'Keine innerstädtischen Fahrten gefunden',
        'no_intracity_rides_available' => 'Keine innerstädtischen Fahrten verfügbar',
        'no_schedule_rides' => 'Keine geplanten Fahrten gefunden',
        'no_schedule_rides_available' => 'Keine geplanten Fahrten verfügbar',
        'no_rental_rides' => 'Keine Mietwagenfahrten gefunden',
        'no_rental_rides_available' => 'Keine Mietwagenfahrten verfügbar',
        'scheduled_rides' => 'Geplante Fahrten',
        'rental_rides' => 'Mietwagenfahrten',
        'profile_details' => 'Profildetails',
        'wallet_balance' => 'Brieftaschensaldo',
        'select_zones' => 'Zonen auswählen',
        'enter_postal_code' => 'Postleitzahl eingeben',
        'additional_info' => 'Zusätzliche Informationen',
        'create_successfully' => 'Fahrer erfolgreich erstellt.',
        'update_successfully' => 'Fahrer erfolgreich aktualisiert.',
        'delete_successfully' => 'Fahrer erfolgreich gelöscht.',
        'restore_successfully' => 'Fahrer erfolgreich wiederhergestellt.',
        'permanent_delete_successfully' => 'Fahrer dauerhaft erfolgreich gelöscht.',
        'status_update_successfully' => 'Fahrerstatus erfolgreich aktualisiert.',
        'system_reserved_not_editable' => 'Dieser Fahrer ist systemreserviert und nicht bearbeitbar.',
        'system_reserved_not_deleted' => 'Dieser Fahrer ist systemreserviert und kann nicht gelöscht werden.',
        'driver_list' => 'Fahrerstandort',
        'live_location' => 'Live-Standort',
        'driver_location' => 'Fahrerstandorte',
        'no_vehicle_type_message' => '*Um einen neuen Fahrzeugtyp hinzuzufügen, klicken Sie einfach',
        'current_driver_not_found' => 'Aktueller Fahrer nicht gefunden.',
        'driver_details' => 'Fahrerdetails',
        'rider' => 'Fahrgast',
        'category' => 'Kategorie',
        'total' => 'Gesamt',
        'created_at' => 'Erstellt am',
        'action' => 'Aktion',
        'account_holder_name' => 'Kontoinhabername',
        'routing_number' => 'Routing-Nummer',
        'swift_code' => 'SWIFT-Code',
        'driver_rules' => 'Fahrerregeln',
        'view_all' => 'Alle anzeigen',
        'rider_reviews' => 'Fahrgastbewertungen',
        'rating' => 'Bewertung',
        'message' => 'Nachricht',
        'withdraw_requests' => 'Auszahlungsanfragen',
        'amount' => 'Betrag',
        'status' => 'Status',
        'payment_type' => 'Zahlungsart',
    ],
    'cab_management' => 'Fahrzeugverwaltung',
    'ride_management' => 'Fahrtverwaltung',
    'cab' => 'Fahrzeug',
    'vehicles' => 'Fahrzeuge',
    'demo_mode' => 'Demomodus',
    'save' => '',
    'section' => 'Taxido-Verwaltung',
    'save_and_exit' => 'Speichern und Beenden',
    'active' => 'Aktiv',
    'deactive' => 'Inaktiv',
    'ride_details' => 'Fahrtdetails',
    'no_result' => 'Es wurden keine Ergebnisse gefunden.',
    'driver_details' => 'Fahrerdetails',
    'link' => 'Link',
    'name' => 'Name',
    'here' => 'hier',
    'submit' => 'Absenden',
    'see_details' => 'Details ansehen',
    'cash_payments_is_disabled' => 'Offline-Zahlungen sind deaktiviert, kontaktieren Sie den Administrator.',
    'online_payments_is_disabled' => 'Online-Zahlungen sind deaktiviert, kontaktieren Sie den Administrator.',
    'auth' => [
        'sended_otp_registered_numb' => 'Wir haben einen OTP an die registrierte Telefonnummer gesendet.',
        'sms_login_not_enable' => 'Die SMS-Anmeldemethode ist derzeit nicht aktiviert.',
        'invalid_auth_token' => 'Der angegebene OTP ist ungültig.',
        'no_account_linked' => 'Es gibt kein Konto, das mit der angegebenen Nummer verknüpft ist.',
        'no_linked_number' => 'Es gibt kein Konto, das mit der angegebenen Nummer verknüpft ist.',
        'disabled_account' => 'Sie können sich nicht mit einem deaktivierten Konto anmelden.',
        'invalid_login_credentials' => 'Ungültige Anmeldeinformationen',
    ],
    'zones' => [
        'zones' => 'Zonen',
        'all' => 'Zonen',
        'name' => 'Zonenname',
        'select_payment_method' => 'Zahlungsmethode auswählen',
        'payment_method' => 'Zahlungsmethode',
        'enter_name' => 'Zonenname eingeben',
        'coordinates' => 'Koordinaten',
        'place_points' => 'Punkte platzieren',
        'map' => 'Karte',
        'search_location' => 'Standort suchen',
        'search_locations' => 'Ihren Standort suchen',
        'amount' => 'Betrag',
        'enter_amount' => 'Betrag eingeben',
        'add' => 'Zone hinzufügen',
        'add_new' => 'Neu hinzufügen',
        'add_currency_message' => '*Um eine neue Währung hinzuzufügen, klicken Sie einfach',
        'select-zone' => 'Zone auswählen',
        'select_coordinates' => 'Koordinaten auswählen',
        'select_place_points' => 'Punkte auswählen',
        'distance_type' => 'Entfernungstyp',
        'select_distance_type' => 'Entfernungstyp auswählen',
        'currency' => 'Währung',
        'select_currency' => 'Währung auswählen',
        'create' => 'Zone erstellen',
        'edit' => 'Zone bearbeiten',
        'store' => 'Zone erfolgreich hinzugefügt.',
        'restore_successfully' => 'Zone erfolgreich wiederhergestellt.',
        'permanent_delete_successfully' => 'Zone dauerhaft erfolgreich gelöscht.',
        'created' => 'Zone erfolgreich erstellt.',
        'updated' => 'Zone erfolgreich aktualisiert.',
        'deleted' => 'Zone erfolgreich gelöscht.',
        'map_instruction_paragraph_1' => 'Sie benötigen mindestens drei Punkte, um eine Zone zu erstellen.',
        'map_instruction_paragraph_2' => 'Beginnen Sie, Pins auf der Karte hinzuzufügen, um eine Zone zu umreißen.',
        'map_instruction_title' => 'Klicken Sie auf die Karte, um zum gewünschten Standort zu wechseln.',
        'map_instruction_heading' => 'Anweisungen',
    ],
    'heatmaps' => [
        'ride_request_heatmap' => 'Fahrtanfrage-Heatmap',
        'heat_map' => 'Heatmap',
    ],
    'riders' => [
        'all' => 'Alle Fahrgäste',
        'riders' => 'Fahrgäste',
        'rider_details' => 'Fahrgastdetails',
        'create' => 'Fahrgast erstellen',
        'add' => 'Fahrgast hinzufügen',
        'add_riders' => 'Fahrgäste hinzufügen',
        'edit' => 'Fahrgast bearbeiten',
        'role_permissions' => 'Rolle & Berechtigungen',
        'full_name' => 'Vollständiger Name',
        'reviews' => 'Bewertungen',
        'personal_information' => 'Persönliche Informationen',
        'email' => 'E-Mail',
        'rating' => 'Bewertung',
        'total_rides' => 'Gesamt abgeschlossene Fahrten',
        'contact_number' => 'Kontaktnummer',
        'emails' => 'E-Mail',
        'driver' => 'Fahrer',
        'created_at' => 'Erstellt am',
        'action' => 'Aktion',
        'phone' => 'Telefon',
        'zones' => 'Zonen',
        'no_reviews' => 'Keine Bewertungen verfügbar',
        'description' => 'Beschreibung',
        'wallet' => 'Brieftasche',
        'city' => 'Stadt',
        'no_rides' => 'Keine Fahrten verfügbar',
        'driver_reviews' => 'Fahrerbewertungen',
        'country' => 'Land',
        'parcel_otp_disabled' => 'Paket-OTP für Fahrtabschluss deaktiviert.',
        'vehicle_information' => 'Fahrzeuginformationen',
        'seats' => 'Sitze',
        'payment_method' => 'Zahlungsmethode',
        'payment_status' => 'Zahlungsstatus',
        'total_amount' => 'Gesamtbetrag',
        'holder_names' => 'Kontoinhaber',
        'wallet_balance' => 'Brieftaschensaldo',
        'other_info' => 'Weitere Informationen',
        'intercity_ride_list' => 'Intercity-Fahrten',
        'package_ride_list' => 'Paket-Fahrten',
        'ride_list' => 'Fahrten',
        'no_rides_available' => 'Keine Fahrten verfügbar',
        'ride_number' => 'Fahrtnummer',
        'account_holder_name' => 'Kontoinhabername',
        'bank_name' => 'Bankname',
        'account_number' => 'Kontonummer',
        'routing_code' => 'Routing-Nummer',
        'branch_name' => 'Filialname',
        'swift_code' => 'SWIFT-Code',
        'not_available' => 'Nicht verfügbar',
        'no_bank_details' => 'Keine Bankdetails verfügbar',
        'other_details' => 'Weitere Details',
        'service' => 'Dienst',
        'service_category' => 'Dienstkategorie',
        'ride_status' => 'Fahrtstatus',
        'intracity_ride_list' => 'Innerstädtische Fahrten',
        'no_intercity_rides' => 'Keine Intercity-Fahrten gefunden',
        'no_intercity_rides_available' => 'Keine Intercity-Fahrten verfügbar',
        'no_intracity_rides' => 'Keine innerstädtischen Fahrten gefunden',
        'no_intracity_rides_available' => 'Keine innerstädtischen Fahrten verfügbar',
        'no_schedule_rides' => 'Keine geplanten Fahrten gefunden',
        'no_schedule_rides_available' => 'Keine geplanten Fahrten verfügbar',
        'no_rental_rides' => 'Keine Mietwagenfahrten gefunden',
        'no_rental_rides_available' => 'Keine Mietwagenfahrten verfügbar',
        'scheduled_rides' => 'Geplante Fahrten',
        'rental_rides' => 'Mietwagenfahrten',
        'profile_details' => 'Profildetails',
        'vehicle_color' => 'Fahrzeugfarbe:',
        'vehicle_num' => 'Fahrzeugnummer',
        'vehicle_types' => 'Fahrzeugtyp:',
        'no_vehicle_information' => 'Keine Fahrzeuginformationen gefunden',
        'add_new' => 'Neu hinzufügen',
        'enter_full_name' => 'Vollständigen Namen eingeben',
        'enter_email' => 'E-Mail eingeben',
        'role' => 'Rolle',
        'confirm_password' => 'Passwort bestätigen',
        'new_password' => 'Neues Passwort',
        'bank_details' => 'Bankdetails',
        'enter_phone' => 'Telefon eingeben',
        'select_role' => 'Rolle auswählen',
        'enter_password' => 'Passwort eingeben',
        'enter_confirm_password' => 'Passwort bestätigen eingeben',
        'select_zones' => 'Zonen auswählen',
        'notification' => 'Fahrgast benachrichtigen',
        'sentence' => 'Senden Sie dem neuen Fahrgast eine E-Mail über sein Konto.',
        'create_successfully' => 'Fahrgast erfolgreich erstellt.',
        'update_successfully' => 'Fahrgast erfolgreich aktualisiert.',
        'delete_successfully' => 'Fahrgast erfolgreich gelöscht.',
        'name' => 'Name',
        'ratings' => 'Bewertung',
        'restore_successfully' => 'Fahrgast erfolgreich wiederhergestellt.',
        'permanent_delete_successfully' => 'Fahrgast dauerhaft erfolgreich gelöscht.',
        'status_update_successfully' => 'Fahrgaststatus erfolgreich aktualisiert.',
        'system_reserved_not_editable' => 'Dieser Fahrgast ist systemreserviert und nicht bearbeitbar.',
        'system_reserved_not_deleted' => 'Dieser Fahrgast ist systemreserviert und kann nicht gelöscht werden.',
    ],
    'banners' => [
        'id' => 'ID',
        'save' => 'Speichern',
        'banners' => 'Banner',
        'title' => 'Titel',
        'action' => 'Aktion',
        'banner' => 'Banner',
        'active' => 'Aktiv',
        'deactive' => 'Inaktiv',
        'all_zones' => 'Alle Zonen',
        'create' => 'Banner erstellen',
        'image' => 'Bild',
        'status' => 'Status',
        'type' => 'Bannertyp',
        'category' => 'Bannerkategorie',
        'add_new' => 'Neu hinzufügen',
        'order' => 'Reihenfolge',
        'zones' => 'Zonen',
        'select_zones' => 'Zonen auswählen',
        'add' => 'Banner hinzufügen',
        'edit' => 'Banner bearbeiten',
        'all' => 'Alle Banner',
        'enter_title' => 'Titel eingeben',
        'enter_order' => 'Bannerreihenfolge eingeben',
        'message' => 'Nachricht',
        'create_successfully' => 'Banner erfolgreich erstellt.',
        'update_successfully' => 'Banner erfolgreich aktualisiert.',
        'delete_successfully' => 'Banner erfolgreich gelöscht.',
        'restore_successfully' => 'Banner erfolgreich wiederhergestellt.',
        'permanent_delete_successfully' => 'Banner dauerhaft erfolgreich gelöscht.',
        'status_update_successfully' => 'Bannerstatus erfolgreich aktualisiert.',
        'no_zones_message' => '*Um eine neue Zone hinzuzufügen, klicken Sie einfach',
        'recommended'=> '*Bildgröße für Uploads: 8268 x 4000 Pixel empfohlen',
    ],
    'vehicle_types' => [
        'all_zones' => 'Alle Zonen',
        'id' => 'ID',
        'name' => 'Name',
        'status' => 'Status',
        'vehicle' => 'Fahrzeugtyp',
        'vehicles' => 'Fahrzeugtypen',
        'images' => 'Fahrzeugbilder',
        'base_amount' => 'Grundbetrag',
        'vehicle_charge' => 'Fahrzeuggebühr',
        'total_per_distance_charge' => 'Gesamtgebühr pro Entfernung',
        'total_per_minute_charge' => 'Gesamtgebühr pro Minute',
        'enter_base_amount' => 'Grundbetrag eingeben',
        'enter_name' => 'Name eingeben',
        'message' => 'Nachricht',
        'example_3_rental' => 'Beispiel 3: MIETWAGEN',
        'example_4_package' => 'Beispiel 4: PAKET',
        'services' => 'Dienste',
        'select_services' => 'Dienste auswählen',
        'add' => 'Fahrzeugtyp hinzufügen',
        'image' => 'Bild',
        'vehicle_image' => 'Fahrzeugbild',
        'example_5_package' => 'Beispiel 5: PAKET',
        'map_icon' => 'Karten-Symbol für Fahrzeug',
        'service_categories' => 'Dienstkategorien',
        'select_service_categories' => 'Dienstkategorien auswählen',
        'edit' => 'Fahrzeugtyp bearbeiten',
        'All' => 'Alle Fahrzeugtypen',
        'commission_type' => 'Art der Provision (Prozentsatz oder fest)',
        'commission_rate' => 'Provisionssatz (z. B. 10% oder 5 €)',
        'enter_commission_rate' => 'Provisionssatz eingeben',
        'select_commission_type' => 'Provisionsart auswählen',
        'min_per_unit_charge' => 'Mindestgebühr pro Kilometer/Meile',
        'max_per_unit_charge' => 'Höchstgebühr pro Kilometer/Meile',
        'enter_min_per_unit_charge' => 'Mindestgebühr pro Einheit eingeben',
        'enter_max_per_unit_charge' => 'Höchstgebühr pro Einheit eingeben',
        'waiting_time_charge' => 'Gebühr pro Minute Wartezeit',
        'enter_waiting_time_charge' => 'Wartegebühr eingeben',
        'cancellation_charge' => 'Feste Gebühr für Fahrtstornierung',
        'enter_cancellation_charge' => 'Stornogebühr eingeben',
        'select_zones' => 'Zonen auswählen',
        'zones' => 'Zonen',
        'apply_service' => 'Auf alle Dienste angewendet.',
        'add_new' => 'Neu hinzufügen',
        'publish' => 'Veröffentlichen',
        'tax' => 'Steuer',
        'select_tax' => 'Steuer auswählen',
        'not_found_vehicles_by_points' => 'Fahrzeugtyp basierend auf angegebenem Standort nicht gefunden',
        'create_successfully' => 'Fahrzeugtyp erfolgreich erstellt.',
        'update_successfully' => 'Fahrzeugtyp erfolgreich aktualisiert.',
        'delete_successfully' => 'Fahrzeugtyp erfolgreich gelöscht.',
        'restore_successfully' => 'Fahrzeugtyp erfolgreich wiederhergestellt.',
        'permanent_delete_successfully' => 'Fahrzeugtyp dauerhaft erfolgreich gelöscht.',
        'status_update_successfully' => 'Fahrzeugtyp-Status erfolgreich aktualisiert.',
        'no_zones_message' => '*Um eine neue Zone hinzuzufügen, klicken Sie einfach',
        'no_tax_message' => '*Um eine neue Steuer hinzuzufügen, klicken Sie einfach',
        'min_per_min_charge' => 'Mindestgebühr pro Minute',
        'max_per_min_charge' => 'Höchstgebühr pro Minute',
        'enter_min_per_min_charge' => 'Mindestgebühr pro Minute eingeben',
        'enter_max_per_min_charge' => 'Höchstgebühr pro Minute eingeben',
        'min_per_weight_charge' => 'Mindestgebühr pro Kilogramm',
        'max_per_weight_charge' => 'Höchstgebühr pro Kilogramm',
        'enter_min_per_weight_charge' => 'Mindestgebühr pro Gewicht eingeben',
        'enter_max_per_weight_charge' => 'Höchstgebühr pro Gewicht eingeben',
        'no_vehicle_types_found' => 'Keine Fahrzeugtypen gefunden',
        'search_vehicle_types' => 'Fahrzeugtypen suchen',
        'fare_calculation_instructions' => 'Anweisungen zur Tarifberechnung',
        'key_fields_and_usage' => 'Schlüsselfelder und deren Verwendung',
        'field' => 'Feld',
        'description' => 'Beschreibung',
        'where_used' => 'Wo verwendet',
        'tax_id' => 'Steuersatz, der auf den Tarif angewendet wird',
        'bidding_details' => 'Gebotsdetails',
        'example_calculation' => 'Beispielberechnungen',
        'bidding_description' => 'Gebote werden bei TAXI- und FRACHT-Diensten verwendet, wenn die Einstellung activation.bidding aktiviert ist.',
        'bidding_active' => 'Wenn Gebote aktiv sind, wird der Tarif durch das Gebot des Fahrers bestimmt.',
        'bidding_inactive' => 'Wenn Gebote inaktiv sind, wird der Tarif basierend auf min_per_unit_charge und max_per_unit_charge berechnet.',
        'example_1' => 'Beispiel 1: TAXI/FAHRT',
        'scenario' => 'Szenario',
        'calculation' => 'Berechnung',
        'minimum_distance_charge' => 'Mindestentfernungsgebühr',
        'fare_amount' => 'Da 22,50 € > 20 € ist, beträgt der Tarif 22,50 €.',
        'example_2' => 'Beispiel 2: FRACHT/INTERCITY',
        'distance_charge' => 'Entfernungsgebühr',
        'weight_charge' => 'Gewichtsgebühr',
        'total_fare' => 'Gesamttarif',
        'prev_button' => 'Vorherige',
        'next_button' => 'Nächste',
        'calculated' => 'Wie wird dies berechnet?',
    ],
    'documents' => [
        'document' => 'Dokument',
        'documents' => 'Dokumente',
        'all' => 'Alle Dokumente',
        'edit' => 'Dokument bearbeiten',
        'add_new' => 'Neu hinzufügen',
        'add_document' => 'Dokument hinzufügen',
        'message' => 'Nachricht',
        'name' => 'Name',
        'enter_name' => 'Name eingeben',
        'enter_number' => 'Nummer eingeben',
        'is_required' => 'Ist erforderlich',
        'status' => 'Status',
        'create_successfully' => 'Dokument erfolgreich erstellt.',
        'update_successfully' => 'Dokument erfolgreich aktualisiert.',
        'delete_successfully' => 'Dokument erfolgreich gelöscht.',
        'status_update_successfully' => 'Dokumentstatus erfolgreich aktualisiert.',
        'permanent_delete_successfully' => 'Dokument dauerhaft erfolgreich gelöscht.',
        'restore_successfully' => 'Dokument erfolgreich wiederhergestellt.',
    ],
    'driver_documents' => [
        'driverDocument' => 'Fahrerdokument',
        'driver_documents' => 'Fahrerdokumente',
        'all' => 'Alle Fahrerdokumente',
        'edit' => 'Fahrerdokument bearbeiten',
        'add_new' => 'Neu hinzufügen',
        'add' => 'Fahrerdokument hinzufügen',
        'driver' => 'Fahrer',
        'select_driver' => 'Fahrer auswählen',
        'document' => 'Dokument',
        'select_document' => 'Dokument auswählen',
        'document_image' => 'Dokumentbild',
        'save' => 'Speichern',
        'status' => 'Status',
        'select_status' => 'Dokumentstatus auswählen',
        'approved' => 'Genehmigt',
        'rejected' => 'Abgelehnt',
        'pending' => 'Ausstehend',
        'create_successfully' => 'Fahrerdokument erfolgreich erstellt.',
        'update_successfully' => 'Fahrerdokument erfolgreich aktualisiert.',
        'delete_successfully' => 'Fahrerdokument erfolgreich gelöscht.',
        'status_update_successfully' => 'Fahrerdokumentstatus erfolgreich aktualisiert.',
        'permanent_delete_successfully' => 'Fahrerdokument dauerhaft erfolgreich gelöscht.',
        'restore_successfully' => 'Fahrerdokument erfolgreich wiederhergestellt.',
        'no_documents_message' => '*Um ein neues Dokument hinzuzufügen, klicken Sie einfach',
        'add_driver_message' => '*Um einen neuen Fahrer hinzuzufügen, klicken Sie einfach',
        'document_id' => 'Dokument-ID',
    ],
    'coupons' => [
        'all' => 'Alle Gutscheine',
        'coupon' => 'Gutschein',
        'coupons' => 'Gutscheine',
        'title' => 'Titel',
        'usage' => 'Verwendung',
        'code' => 'Code',
        'services' => 'Dienste auswählen',
        'add_coupon' => 'Gutschein hinzufügen',
        'edit_coupon' => 'Gutschein bearbeiten',
        'action' => 'Aktion',
        'add_new' => 'Neu hinzufügen',
        'enter_title' => 'Titel eingeben',
        'enter_description' => 'Beschreibung eingeben',
        'enter_coupon' => 'Gutschein eingeben',
        'enter_code' => 'Code eingeben',
        'description' => 'Beschreibung',
        'type' => 'Typ',
        'select_type' => 'Typ auswählen',
        'amount' => 'Betrag',
        'select_date' => 'Datum auswählen',
        'select_start_date' => 'Startdatum auswählen',
        'select_end_date' => 'Enddatum auswählen',
        'enter_price' => 'Preis eingeben',
        'start_date' => 'Startdatum',
        'end_date' => 'Enddatum',
        'select_service_category' => 'Dienstkategorie auswählen',
        'select_service_categories' => 'Dienstkategorien auswählen',
        'select_service' => 'Dienste auswählen',
        'select_services' => 'Dienste auswählen',
        'percentage' => 'Prozentsatz',
        'enter_amount' => 'Betrag eingeben',
        'enter_percentage' => 'Prozentsatz eingeben',
        'is_expired' => 'Ist abgelaufen',
        'status' => 'Status',
        'select_riders' => 'Fahrgäste auswählen',
        'general' => 'Allgemein',
        'is_apply_all' => 'Auf alle anwenden',
        'select_zones' => 'Zonen auswählen',
        'select_rider' => 'Fahrgäste auswählen',
        'service_category' => 'Dienstkategorie',
        'zone' => 'Zone',
        'select_vehicle_type' => 'Fahrzeugtypen auswählen',
        'vehicle_type' => 'Fahrzeugtyp',
        'restriction' => 'Einschränkung',
        'minimum_ride_fare' => 'Mindestfahrpreis',
        'enter_minimum_ride_fare' => 'Mindestfahrpreis eingeben',
        'is_unlimited' => 'Ist unbegrenzt',
        'usage_per_coupon' => 'Verwendung pro Gutschein',
        'usage_per_rider' => 'Verwendung pro Fahrgast',
        'enter_value' => 'Wert eingeben',
        'no_riders_message' => '*Um einen neuen Fahrgast hinzuzufügen, klicken Sie einfach',
        'no_zones_message' => '*Um eine neue Zone hinzuzufügen, klicken Sie einfach',
        'no_vehicleType_message' => '*Um einen neuen Fahrzeugtyp hinzuzufügen, klicken Sie einfach',
        'create_successfully' => 'Gutschein erfolgreich erstellt.',
        'update_successfully' => 'Gutschein erfolgreich aktualisiert.',
        'delete_successfully' => 'Gutschein erfolgreich gelöscht.',
        'status_update_successfully' => 'Gutscheinstatus erfolgreich aktualisiert.',
        'permanent_delete_successfully' => 'Gutschein dauerhaft erfolgreich gelöscht.',
        'restore_successfully' => 'Gutschein erfolgreich wiederhergestellt.',
        'to_apply_coupon' => 'Um den Gutscheincode :code anzuwenden, sollte Ihre Fahrt insgesamt :min_spend oder höher sein.',
        'coupon_feature_disabled' => 'Der Gutscheincode kann nicht verwendet werden, da die Gutschein-Funktion derzeit deaktiviert ist.',
        'login_required' => 'Sie müssen sich anmelden, um diesen Gutscheincode :code anzuwenden.',
        'usage_limit_reached' => 'Der Gutscheincode :code kann nur bis zu :usage Mal pro Gutschein verwendet werden.',
        'date_range' => 'Der Gutscheincode :code war vom :start_date bis :end_date gültig',
        'to' => 'bis',
    ],
    'rides' => [
        'rides' => 'Fahrten',
        'ride_request_create_successfully' => 'Fahrtanfrage erfolgreich erstellt',
        'ride_fare' => 'Fahrttarif',
        'start_date' => 'Startdatum',
        'extra_charge' => 'Zusätzliche Gebühr',
        'receiver_phone' => 'Telefon des Paketempfängers',
        'enter_receiver_phone' => 'Telefon des Paketempfängers eingeben',
        'start_time' => 'Startzeit',
        'select_drivers' => 'Fahrer auswählen',
        'driver_no' => 'Fahrernummer zuweisen',
        'receiver_full_name' => 'Vollständiger Name des Paketempfängers',
        'enter_receiver_full_name' => 'Vollständigen Namen des Paketempfängers eingeben',
        'drivers' => 'Fahrer',
        'no_of_days' => 'Anzahl der Tage',
        'riderequests' => 'Fahrtanfragen',
        'ride_requests' => 'Alle Fahrtanfragen',
        'locations_empty' => 'Standort ist erforderlich',
        'ride_request_details' => 'Fahrtanfragedetails',
        'minimum_2_locations_required' => 'Mindestens 2 Standortkoordinaten sind erforderlich',
        'location_coordinates_empty' => 'Standortkoordinaten sind erforderlich',
        'select_payment_method' => 'Zahlungsmethode auswählen',
        'weight' => 'Gewicht',
        'cargo_image' => 'Frachtbild',
        'vehicle_name' => 'Fahrzeugname',
        'assign_driver_name' => 'Zugeordneter Fahrernamen',
        'assign_driver_no' => 'Zugeordnete Fahrernummer',
        'vehicle_registration_no' => 'Fahrzeugregistrierungsnummer',
        'enter_weight' => 'Gewicht eingeben',
        'create' => 'Fahrt erstellen',
        'ambulance_not_found' => 'Krankenwagen nicht gefunden oder Fahrer nicht zugewiesen.',
        'ambulance_location_not_found' => 'Krankenwagenstandort nicht verfügbar.',
        'distance_not_found' => 'Entfernung zwischen Fahrgast und Krankenwagen konnte nicht berechnet werden.',
        'location_coordinates_not_array' => 'Die angegebenen Standortkoordinaten sind kein Array.',
        'all' => 'Alle Fahrten',
        'create_ride' => 'Fahrt erstellen',
        'rider_details' => 'Fahrgastdetails',
        'locations' => 'Standorte',
        'enter_locations' => 'Standorte eingeben',
        'enter_destination_location' => 'Zielort eingeben',
        'destination_location' => 'Zielort',
        'pickup_location' => 'Abholort',
        'enter_pickup_location' => 'Abholort eingeben',
        'rider' => 'Fahrgast',
        'start_address' => 'Startadresse',
        'end_address' => 'Endadresse',
        'service' => 'Dienst',
        'select_service' => 'Dienst auswählen',
        'service_category' => 'Dienstkategorie',
        'select_service_category' => 'Dienstkategorie auswählen',
        'driver' => 'Fahrer',
        'only_driver_can_accept_ride_request_directly' => 'Nur Fahrer können Fahrtanfragen direkt annehmen',
        'ride_request' => 'Fahrtanfrage ist ungültig.',
        'general_detail' => 'Allgemeine Details',
        'billing_detail' => 'Abrechnungsdetails',
        'service_detail' => 'Dienstdetails',
        'location_detail' => 'Standortdetails',
        'price_detail' => 'Preisdetails',
        'ride_details' => 'Fahrtdetails',
        'general_details' => 'Allgemeine Details',
        'ride_number' => 'Fahrtnummer',
        'start_date_time' => 'Startdatum & Zeit',
        'end_date_time' => 'Enddatum & Zeit',
        'payment_status' => 'Zahlungsstatus',
        'otp' => 'Fahrtstart-OTP',
        'parcel_otp' => 'Paket zugestellt OTP',
        'ride_distance' => 'Gesamtdistanz',
        'zone' => 'Zone',
        'payment_method' => 'Zahlungsmethode',
        'driver_detail' => 'Fahrerdetails',
        'ride_reviews' => 'Fahrtbewertungen',
        'customer_reviews' => 'Kundenbewertungen',
        'customer_review' => 'Kundenbewertung',
        'driver_reviews' => 'Fahrerbewertungen',
        'map_view' => 'Kartenansicht',
        'biding_drivers_list' => 'Gebotsfahrerliste',
        'complaints' => 'Beschwerden',
        'greatest_ride' => 'Beste Fahrt',
        'no_reviews_found' => 'Keine Bewertungen gefunden',
        'no_complaints_found' => 'Keine Beschwerden gefunden',
        'ride_id' => 'Fahrtnummer',
        'ride_status' => 'Fahrtstatus',
        'total_amount' => 'Gesamtbetrag',
        'date_time' => 'Datum & Zeit:',
        'transaction_id' => 'Transaktions-ID',
        'offer_price' => 'Angebotspreis',
        'final_price' => 'Endpreis',
        'tax_calculation' => 'Steuerberechnung',
        'igst' => 'IGST',
        'cgst' => 'CGST',
        'receiver_name' => 'Name des Paketempfängers',
        'receiver_email' => 'E-Mail des Paketempfängers',
        'receiver_no' => 'Nummer des Paketempfängers',
        'name' => 'Name:',
        'payable_amount' => 'Zahlbarer Betrag',
        'total_after_commission' => 'Gesamt (nach Admin-Provision)',
        'ride_type' => 'Fahrttyp',
        'ride_time' => 'Fahrtzeit',
        'pickup_time' => 'Abholzeit',
        'dropoff_time' => 'Absetzzeit',
        'driver_name' => 'Fahrernamen',
        'driver_email' => 'Fahrer-E-Mail',
        'driver_phone' => 'Fahrertelefon',
        'vehicle_model' => 'Fahrzeugmodell',
        'parcel_otps' => 'Paket-OTP',
        'customer_name' => 'Kundenname',
        'customer_email' => 'Kunden-E-Mail',
        'customer_phone' => 'Kundentelefon',
        'payment_date' => 'Zahlungsdatum',
        'payment_reference' => 'Zahlungsreferenz',
        'transaction_status' => 'Transaktionsstatus',
        'additional_charges' => 'Zusätzliche Gebühren',
        'discount' => 'Rabatt',
        'currency' => 'Währung',
        'email' => 'E-Mail',
        'phone' => 'Telefon',
        'vehicle_type' => 'Fahrzeugtyp',
        'vehicle_number' => 'Fahrzeugnummer:    ',
        'vehicle_not_found' => 'Fahrzeug nicht gefunden!',
        'zones' => 'Zonen:',
        'ride_price' => 'Fahrtpreis',
        'only_assigned_driver' => 'Nur der zugewiesene Fahrer kann die Fahrt aktualisieren.',
        'ride_cannot_cancel' => 'Nach Fahrtbeginn kann die Fahrt nicht storniert werden.',
        'invalid_otp' => 'Ungültiger OTP für den Fahrtstart.',
        'user_must_be_driver' => 'Benutzer muss Fahrer sein, um eine Fahrt zu starten.',
        'payment_module_not_found' => 'Ausgewähltes Zahlungsmodul nicht gefunden oder nicht aktiviert.',
        'invalid_payment_method' => 'Ungültige Zahlungsmethode.',
        'invalid_details' => 'Ungültige Zahlungsdetails.',
        'payment_methods_not_found' => 'Zahlungsmethode nicht gefunden.',
        'negative_wallet_balance' => 'Fahrtanfrage kann aufgrund eines negativen Brieftaschensaldos nicht erstellt werden.',
        'ride_requests_not_accepted' => 'Fahrtanfragen werden in dieser Zone nicht akzeptiert.',
        'no_driver_available' => 'In dieser Zone ist kein Fahrer verfügbar.',
        'update_permission' => 'Sie können nur Fahrtanfragen aktualisieren, die Sie erstellt haben.',
        'failed_to_create_ride' => 'Fahrt konnte nicht erstellt werden.',
        'ride_already_cancelled' => 'Diese Fahrt wurde bereits storntaxido::static.notifications.statuiert und kann nicht aktualisiert werden.',
        'no_zone_ids' => 'Bitte geben Sie Zonen-IDs an, um Fahrtanfragen als Fahrer anzuzeigen.',
        'status_overviews' => 'Fahrtstatusübersicht',
        'requested' => 'Angefragte Fahrten',
        'pending' => 'Ausstehende Fahrten',
        'completed' => 'Abgeschlossene Fahrten',
        'cancelled' => 'Stornierte Fahrten',
        'scheduled' => 'Geplante Fahrten',
        'accepted' => 'Angenommene Fahrten',
        'started' => 'Gestartete Fahrten',
        'arrived' => 'Angekommene Fahrten',
        'pos' => 'POS',
        'hourly_package' => 'Stundenpaket',
        'select_package' => 'Stundenpaket auswählen',
        'rejected' => 'Abgelehnt',
        'service_not_allow_for_vehicle' => 'Ausgewählter Dienst ist für :vehicleType nicht verfügbar',
        'category_not_allow_for_vehicle' => 'Ausgewählter Dienst ist für :vehicleType nicht verfügbar',
        'select_start_date_and_time' => 'Startdatum und Zeit auswählen',
        'select_end_date_and_time' => 'Enddatum und Zeit auswählen',
        'total_biddings' => 'Gesamtgebote',
        'biddings' => 'Gebote',
        'driver_information' => 'Fahrerinformationen',
        'rating' => 'Bewertung',
        'contact_number' => 'Kontaktnummer',
        'rider_information' => 'Fahrgastinformationen',
        'price_details' => 'Preisdetails',
        'view_all' => 'Alle anzeigen',
        'vehicle_charge' => 'Fahrzeuggebühr',
        'driver_charge' => 'Fahrergebühr',
        'processing_fee' => 'Bearbeitungsgebühr',
        'platform_fee' => 'Plattformgebühr',
        'subtotal' => 'Zwischensumme',
        'coupon_discount' => 'Gutscheinrabatt',
        'tax' => 'Steuer',
        'tip' => 'Trinkgeld',
        'total' => 'Gesamt',
        'location_details' => 'Standortdetails',
        'rider_reviews' => 'Fahrgastbewertungen',
        'description' => 'Beschreibung',
        'bidding_request' => 'Gebotsanfrage',
        'amount' => 'Betrag',
        'status' => 'Status',
        'rental_vehicle' => 'Mietwagen',
        'assigned_driver_name' => 'Zugeordneter Fahrernamen',
        'assigned_driver_no' => 'Zugeordnete Fahrernummer',
        'days' => 'Tage',
        'admin_commission' => 'Admin-Provision',
        'driver_commission' => 'Fahrerprovision',
        'driver_tip' => 'Fahrtrinkgeld',
        'bill_summary' => 'Rechnungsübersicht',
        'invoice' => 'Rechnung',
        'read_more' => 'Mehr lesen',
        'read_less' => 'Weniger lesen',
        'cancellation_reason' => 'Stornierungsgrund',
        'default_cancel_reason' => 'Kein Grund angegeben',
        'download_invoice' => 'Rechnung herunterladen',
        'vehicle_charges' => 'Fahrzeuggebühren',
        'driver_charges' => 'Fahrergebühren',
        'comments' => 'Kommentare',
        'no_comments' => 'Keine Kommentare verfügbar',
        'total_per_distance_charge' => 'Gesamtgebühr pro Entfernung',
        'total_per_minute_charge' => 'Gesamtgebühr pro Minute',
        'vehicle_per_day_price' => 'Fahrzeugpreis pro Tag',
    ],
    'invoice' => [
        'date' => 'Datum',
        'invoice_to' => 'Rechnung an',
        'name' => 'Name',
        'rider_contact' => 'Fahrgastkontakt',
        'ride_details' => 'Fahrtdetails',
        'service' => 'Dienst',
        'pickup_time' => 'Abholzeit',
        'pickup_location' => 'Abholort',
        'drop_off_location' => 'Absetzort',
        'vehicle_driver_info' => 'Fahrzeug- & Fahrerinformationen',
        'vehicle_type' => 'Fahrzeugtyp',
        'vehicle_number' => 'Fahrzeugnummer',
        'driver_name' => 'Fahrernamen',
        'driver_contact' => 'Fahrerkontakt',
        'description' => 'Beschreibung',
        'rate_unit' => 'Satz/Einheit',
        'quantity' => 'Menge',
        'payment_details' => 'Zahlungsdetails',
        'payment_method' => 'Zahlungsmethode',
        'amount' => 'Betrag',
        'total' => 'Gesamt',
        'base_fare' => 'Grundtarif',
        'distance_fare' => 'Entfernungstarif',
        'taxes' => 'Steuern',
        'thank_you' => 'Vielen Dank!',
        'thank_you_msg' => 'Vielen Dank, dass Sie uns gewählt haben. Wir freuen uns darauf, Sie wieder zu bedienen! Für Feedback oder Beschwerden.',
        'driver_tips' => 'Fahrtrinkgeld',
        'tax' => 'Steuer',
        'platform_fee' => 'Plattformgebühr',
        'processing_fee' => 'Bearbeitungsgebühr',
    ],
    'locations' => [
        'locations' => 'Standorte',
        'status' => 'Fahrerstatus',
        'all' => 'Alle',
        'driver_location' => 'Fahrerstandort',
        'select_zone' => 'Zone auswählen',
        'zone' => 'Zone',
        'filters' => 'Filter',
        'online' => 'Online',
        'onride' => 'Auf Fahrt',
        'offline' => 'Offline',
        'taxi_drivers' => 'Fahrer',
        'view_location' => 'Standort anzeigen',
        'id' => 'ID',
        'service' => 'Dienst:',
        'service_category' => 'Dienstkategorie:',
        'start_time' => 'Startzeit:',
        'distance' => 'Entfernung:',
        'duration' => 'Dauer:',
        'min' => 'Min',
        'view_more' => 'Mehr anzeigen',
        'rider_details' => 'Fahrgastdetails',
        'no_rides_yet' => 'Noch keine Fahrten',
        'refresh' => 'Aktualisieren',
    ],
    'soses' => [
        'all' => 'Alle',
        'soses' => 'SOS',
        'sos' => 'SOS',
        'alert_id' => 'SOS-Alarm',
        'sos_status' => 'SOS-Status',
        'location' => 'Standort',
        'location_map' => 'Standortkarte',
        'title' => 'Titel',
        'all_zones' => 'Alle Zonen',
        'enter_title' => 'Titel eingeben',
        'add_new' => 'Neu hinzufügen',
        'add_sos' => 'SOS hinzufügen',
        'select_zones' => 'Zonen auswählen',
        'phone' => 'Telefon',
        'sos_alerts' => 'SOS-Alarme',
        'enter_phone' => 'Telefon eingeben',
        'sos_details' => 'SOS-Alarmdetails',
        'add' => 'SOS hinzufügen',
        'edit' => 'SOS bearbeiten',
        'description' => 'Beschreibung',
        'enter_description' => 'Beschreibung eingeben',
        'create_successfully' => 'SOS erfolgreich erstellt.',
        'update_successfully' => 'SOS erfolgreich aktualisiert.',
        'delete_successfully' => 'SOS erfolgreich gelöscht.',
        'status_update_successfully' => 'SOS-Status erfolgreich aktualisiert.',
        'permanent_delete_successfully' => 'SOS dauerhaft erfolgreich gelöscht.',
        'restore_successfully' => 'SOS erfolgreich wiederhergestellt.',
        'sos_image' => 'SOS-Bild',
        'zones' => 'Zonen',
        'no_zones_message' => '*Um eine neue Zone hinzuzufügen, klicken Sie einfach',
    ],
    'driver_rules' => [
        'all' => 'Alle',
        'driverRule' => 'Fahrerregel',
        'driver_rules' => 'Fahrerregeln',
        'title' => 'Titel',
        'add_new' => 'Neu hinzufügen',
        'enter_title' => 'Titel eingeben',
        'add_driverRule' => 'Fahrerregel hinzufügen',
        'add' => 'Fahrerregel hinzufügen',
        'edit' => 'Fahrerregel bearbeiten',
        'description' => 'Beschreibung',
        'select_vehicle_type' => 'Fahrzeugtyp auswählen',
        'image' => 'Regelbild',
        'save' => 'Speichern',
        'status' => 'Status',
        'create_successfully' => 'Fahrerregel erfolgreich erstellt.',
        'update_successfully' => 'Fahrerregel erfolgreich aktualisiert.',
        'delete_successfully' => 'Fahrerregel erfolgreich gelöscht.',
        'status_update_successfully' => 'Fahrerregel-Status erfolgreich aktualisiert.',
        'permanent_delete_successfully' => 'Fahrerregel dauerhaft erfolgreich gelöscht.',
        'restore_successfully' => 'Fahrerregel erfolgreich wiederhergestellt.',
        'no_vehicleType_message' => '*Um einen neuen Fahrzeugtyp hinzuzufügen, klicken Sie einfach',
    ],
    'services' => [
        'all' => 'Alle',
        'service' => 'Dienst',
        'services' => 'Dienste',
        'name' => 'Name',
        'enter_name' => 'Name eingeben',
        'type' => 'Typ',
        'add_new' => 'Neu hinzufügen',
        'is_primary' => 'Primär',
        'add' => 'Dienst hinzufügen',
        'cab' => 'Taxi',
        'parcel' => 'Paket',
        'freight' => 'Fracht',
        'edit' => 'Dienst bearbeiten',
        'select_type' => 'Typ auswählen',
        'save' => 'Speichern',
        'image' => 'Bild',
        'icon' => 'Symbol',
        'cab_description' => 'Für Reisen zwischen Städten verwendet',
        'parcel_description' => 'Für reibungslose und zuverlässige Reisen innerhalb der Stadt',
        'create_successfully' => 'Dienst erfolgreich erstellt.',
        'update_successfully' => 'Dienst erfolgreich aktualisiert.',
        'status_update_successfully' => 'Dienststatus erfolgreich aktualisiert.',
    ],
    'service_categories' => [
        'all' => 'Alle',
        'serviceCategory' => 'Dienstkategorien',
        'name' => 'Name',
        'select_services' => 'Dienste auswählen',
        'services' => 'Dienste',
        'service' => 'Dienst',
        'vehicles' => 'Fahrzeuge',
        'select_service' => 'Dienst auswählen',
        'description' => 'Beschreibung',
        'cab' => 'Dienstkategorien',
        'parcel' => 'Dienstkategorien',
        'freight' => 'Dienstkategorien',
        'enter_description' => 'Beschreibung eingeben',
        'intercity_desc' => 'Langstrecken-Reiseoptionen, die Städte verbinden, ideal für Passagiere und Frachtsendungen.',
        'scheduled_dec' => 'Geplante Transportdienste für geplante Reisen, sowohl für Passagiere als auch für Fracht.',
        'package_dec' => 'Paketzustelldienste für kleine und große Pakete, die eine pünktliche und sichere Lieferung gewährleisten.',
        'intracity_dec' => 'Für reibungslose und zuverlässige Reisen innerhalb der Stadt',
        'rental_desc' => 'Fahrzeugvermietung für kurz- oder langfristige Nutzung, geeignet für persönliche oder geschäftliche Anforderungen.',
        'scheduled_desc' => 'Fahrten im Voraus buchen für Bequemlichkeit',
        'enter_name' => 'Name eingeben',
        'edit' => 'Dienstkategorie bearbeiten',
        'type' => 'Typ',
        'select_type' => 'Typ auswählen',
        'save' => 'Speichern',
        'service_image' => 'Bild',
        'create_successfully' => 'Dienstkategorie erfolgreich erstellt.',
        'update_successfully' => 'Dienstkategorie erfolgreich aktualisiert.',
        'status_update_successfully' => 'Dienstkategorie-Status erfolgreich aktualisiert.',
        'restore_successfully' => 'Dienstkategorie erfolgreich wiederhergestellt.',
    ],
    'settings' => [
        'settings' => 'Einstellungen',
        'greeting' => 'Begrüßung',
        'fleet_commission_rate' => 'Flottenprovisionssatz',
        'fleet_commission_type' => 'Flottenprovisionstyp',
        'select_fleet_commission_type' => 'Flottenprovisionstyp auswählen',
        'enter_fleet_commission_rate' => 'Flottenprovisionssatz eingeben',
        'footer_hashtag' => 'Footer-Hashtag',
        'footer_hashtag_help' => 'Geben Sie den Branding-Hashtag (#GoTaxido) ein, der im Footer der Startseite der App angezeigt wird',
        'enter_hashtag' => '#GoTaxido',
        'footer_attribution' => 'Footer-Zuschreibung',
        'footer_attribution_help' => 'Geben Sie den Entwickler-Credit (❤️ Erstellt von Pixelstrap) ein, der im Footer der Startseite der App angezeigt wird',
        'enter_attribution' => '❤️ Erstellt von Pixelstrap',
        'fleet_commission_span' => 'Wählen Sie den Provisionsstil für Flottenmanager: fester Betrag oder prozentual.',
        'fleet_commission_rate_span' => 'Legen Sie den Provisionssatz fest, den Flottenbesitzer pro Fahrt erhalten – entweder als fester Betrag oder als Prozentsatz des Gesamtfahrpreises.',

        'enter_greeting' => 'Begrüßungsnachricht eingeben',
        'add_greeting' => 'Hinzufügen',
        'google_map_api_key' => 'Google Maps API-Schlüssel',
        'enter_google_map_api_key' => 'Google Maps API-Schlüssel eingeben',
        'splash_screen' => 'Benutzer-Startbildschirm',
        'splash_driver_screen' => 'Fahrer-Startbildschirm',
        'ride_settings' => 'Fahrteinstellungen',
        'app_settings' => 'App-Einstellungen',
        'test_map' => 'Karte testen',
        'map_preview' => 'Kartenvorschau',
        'ambulance_per_km_charge_span' => 'Legen Sie die pro Kilometer berechneten Kosten für Krankenwagenfahrten fest',
        'ambulance_commission_span' => 'Wählen Sie die Provisionsart für Krankenwagendienste: Festpreis oder prozentbasiert.',
        'ambulance_commission_rate_span' => 'Legen Sie den Provisionssatz für Fahrer bei Krankenwagendiensten fest, entweder als Festgebühr oder als Prozentsatz des Tarifs.',
        'force_update_span' => 'Verlangen Sie von Benutzern, die App auf die neueste Version zu aktualisieren, bevor sie fortfahren.',
        'app_configuration' => 'App-Konfiguration',
        'driver_app_version' => 'Fahrer-App-Version',
        'app_version' => 'Benutzer-App-Version',
        'force_update' => 'Update erzwingen',
        'enter_version' => 'Version eingeben',
        'ride_accept' => 'Fahrtannahme',
        'maximum_time' => 'Maximale Zeit',
        'regular_ride' => 'Maximale Zeit für die Fahrersuche bei regulären Fahrten in Minuten',
        'enter_time' => 'Maximale Zeit für die Fahrersuche bei regulären Fahrten in Minuten',
        'ride_accept_decline' => 'Fahrt annehmen/ablehnen',
        'enter_ride' => 'Dauer für Fahrer zur Annahme/Ablehnung der Fahrt in Sekunden',
        'min_withdraw_amount' => 'Mindest-Auszahlungsbetrag',
        'enter_amount' => 'Mindest-Auszahlungsbetrag eingeben',
        'activation' => 'Aktivierung',
        'platform_fees' => 'Plattformgebühren',
        'social_login_enable' => 'Soziale Anmeldung aktivieren',
        'wallet_enable' => 'Brieftasche aktivieren',
        'rider_wallets' => 'Ermöglichen Sie Fahrgästen, Geld auf eine Brieftasche einzuzahlen und den Saldo für Buchungen und Zahlungen zu nutzen.',
        'online_payments' => 'Ermöglichen Sie Benutzern, digital mit sicheren Zahlungsmethoden wie Karten und mobilen Brieftaschen zu zahlen.',
        'cash_payments' => 'Barzahlungen',
        'rider_wallet' => 'Fahrgast-Brieftasche aktivieren',
        'referral_settings' => 'Empfehlungseinstellungen',
        'referral_amount' => 'Empfehlungsbetrag',
        'first_ride_discount' => 'Erste Fahrt Rabatt',
        'general' => 'Allgemein',
        'bidding' => 'Gebote',
        'location_settings' => 'Standorteinstellungen',
        'driver_commission' => 'Fahrerprovision',
        'enter_referral_amount' => 'Empfehlungsbetrag eingeben',
        'enter_first_ride_discount' => 'Rabatt für erste Fahrt eingeben',
        'status' => 'Status',
        'validity' => 'Gültigkeit',
        'enter_validity' => 'Gültigkeit eingeben',
        'select_map_type' => 'Kartentyp',
        'select_map' => 'Tracking-Option auswählen: Wählen Sie zwischen Google Maps, Waze, Vandex oder In-App-Navigation',
        'select_map_tracking' => 'Tracking-Option',
        'select_map_tracking_option' => 'Wählen Sie Ihre Karten-Tracking-Option',
        'select_type' => 'Typ auswählen',
        'driver_location_update' => 'Fahrerstandort',
        'driver_location' => 'Fahrerstandort-Aktualisierung (Meter)',
        'enter_meter' => 'Meter eingeben',
        'enter_value' => 'Wert eingeben',
        'wallet' => 'Brieftascheneinstellungen',
        'online_payment' => 'Online-Zahlungen',
        'social_login' => 'Soziale Anmeldung',
        'ride_otp' => 'Fahrt-OTP-Verifizierung',
        'parcel_otp' => 'Paket-OTP-Verifizierung',
        'otp_parcel' => 'Wenn aktiviert, gibt der Empfänger einen OTP ein, um das Paket zu erhalten. Wenn deaktiviert, erfolgt die Lieferung direkt.',
        'wallet_denominations' => 'Brieftaschennominale',
        'enter_wallet_denominations' => 'Brieftaschennominale eingeben',
        'tip_denominations' => 'Trinkgeldnominale',
        'enter_tip_denominations' => 'Trinkgeldnominale eingeben',
        'driver_threshold' => 'Fahrerschwellenwert',
        'enter_driver_threshold' => 'Fahrerschwellenwert eingeben',
        'driver_tips' => 'Fahrtrinkgeld',
        'radius_meter' => 'Radius Meter',
        'enter_radius_meter' => 'Radius Meter eingeben',
        'radius_per_second' => 'Radius pro Sekunde',
        'enter_radius_per_second' => 'Radius pro Sekunde eingeben',
        'tips' => 'Wenn deaktiviert, können Fahrgäste kein Trinkgeld geben. Wenn aktiviert, können Fahrgäste Fahrern nach eigenem Ermessen Trinkgeld geben.',
        'negative_balance' => 'Wenn aktiviert, können Fahrer mit einem negativen Saldo arbeiten. Sobald das Limit erreicht ist, können sie keine neuen Fahrten antreten.',
        'otp_ride' => 'Wenn aktiviert, startet die Fahrt erst nach Eingabe des OTP. Wenn deaktiviert, startet die Fahrt direkt.',
        'interval' => 'Intervall',
        'days' => 'Tag',
        'months' => 'Monat',
        'enable_referral' => 'Ermöglichen Sie Benutzern, Freunde einzuladen und Belohnungen zu erhalten, wenn diese sich anmelden oder den Dienst nutzen.',
        'bid_span' => 'Wenn aktiviert, können Fahrer Gebote für Fahrten oder Lieferungen abgeben, was den Nutzern wettbewerbsfähige Preise bietet. Wenn deaktiviert, sind Gebote nicht erlaubt.',
        'years' => 'Jahr',
        'login' => 'Soziale Anmeldung für schnellen und einfachen Fahrerzugang aktivieren',
        'set_validity' => 'Zeitlimit für Rabatt nach Registrierung festlegen',
        'discount' => 'Rabattbetrag (z. B. 30) für Benutzer bei ihrer ersten Fahrt festlegen.',
        'map' => 'Kartentyp auswählen. Google Maps oder OSM wird sowohl für Admin als auch für die App angewendet.',
        'radius' => 'Abdeckungsbereich für Ihre standortbasierten Dienste festlegen',
        'radius_second' => 'Häufigkeit der Radiusanpassungen pro Sekunde festlegen',
        'per_km_charge' => 'Gebühr pro Kilometer',
        'km_charge' => 'Gebühr pro Kilometer für Fahrten aktivieren oder deaktivieren',
        'referral_enable' => 'Empfehlung aktivieren',
        'driver_locations' => 'Echtzeit-Fahrerstandorte verwalten und sicherstellen, dass GPS für genaues Tracking aktiviert ist',
        'driver_threshold_help' => 'Schwellenwerte festlegen, um die Fahrerleistung zu optimieren',
        'min_withdraw_text' => 'Mindestbetrag angeben, den ein Fahrer von seinen Einnahmen abheben kann',
        'wallet_denominations_help' => 'Brieftaschennominale für flexible Transaktionsoptionen verwalten',
        'tip_denominations_help' => 'Trinkgeldnominale festlegen, um Trinkgeldoptionen für Benutzer zu standardisieren',
        'minimum_ride_amount' => 'Mindestfahrtbetrag',
        'minimum_ride_amount_help' => 'Mindestfahrtbetrag festlegen, der erforderlich ist, um Empfehlungsboni auszulösen (z. B. 250).',
        'enter_minimum_ride_amount' => 'Mindestfahrtbetrag eingeben',
        'referrer_bonus_percentage' => 'Empfehler-Bonusprozentsatz',
        'referrer_bonus_percentage_help' => 'Prozentsatz des Fahrtbetrags, den der Empfehler als Bonus erhält (0-100%).',
        'enter_referrer_bonus_percentage' => 'Empfehler-Bonusprozentsatz eingeben',
        'referred_bonus_percentage' => 'Empfohlener Benutzer-Bonusprozentsatz',
        'referred_bonus_percentage_help' => 'Prozentsatz des Fahrtbetrags, den der empfohlene Benutzer als Bonus erhält (0-100%).',
        'enter_referred_bonus_percentage' => 'Empfohlener Benutzer-Bonusprozentsatz eingeben',
        'interval_help' => 'Zeitintervall auswählen, wann die Empfehlungsbelohnung oder der Rabatt angewendet wird',
        'ambulance_per_km_charge' => 'Krankenwagen-Gebühr pro Kilometer',
        'enter_ambulance_per_km_charge' => 'Krankenwagen-Gebühr pro Kilometer eingeben',
        'ambulance_commission_type' => 'Krankenwagen-Provisionsart',
        'select_ambulance_commission_type' => 'Krankenwagen-Provisionsart auswählen',
        'ambulance_commission_rate' => 'Krankenwagen-Provisionssatz',
        'enter_ambulance_commission_rate' => 'Krankenwagen-Provisionssatz eingeben',
        'driver_subscription' => 'Fahrer-Abonnement',
        'rider_privacy_policy' => 'Datenschutzrichtlinie für Fahrgäste',
        'driver_privacy_policy' => 'Datenschutzrichtlinie für Fahrer',
        'enter_privacy_policy_url' => 'Geben Sie die URL der Datenschutzrichtlinie ein',
    ],
    'wallets' => [
        'wallet' => 'Brieftasche',
        'select_consumer' => 'Verbraucher auswählen',
        'add_amount' => 'Betrag eingeben',
        'wallet_balance' => 'Brieftaschensaldo',
        'credit' => 'Gutschrift',
        'confirmation' => 'Bestätigung',
        'debit' => 'Belastung',
        'select_rider' => 'Fahrgast auswählen',
        'transactions' => 'Transaktionen',
        'modal' => 'Sind Sie sicher, dass Sie fortfahren möchten?',
        'select_driver' => 'Fahrer auswählen',
        'yes' => 'Ja',
        'credit_debit' => 'Gutschrift/Belastungsbetrag',
        'no' => 'Nein',
        'select_fleet_manager' => 'Flottenmanager auswählen',
        'add_fleet_manager_message' => '*Um einen neuen Flottenmanager hinzuzufügen, klicken Sie einfach',
        'user_must_be' => 'Benutzer muss sein',
        'balance_credited' => 'Saldo erfolgreich gutgeschrieben',
        'balance_debited' => 'Saldo erfolgreich belastet',
        'transaction' => 'Transaktionen',
        'wallet_feature_on' => 'Brieftaschenfunktion derzeit deaktiviert. Aktivieren Sie sie in Einstellungen > Aktivierung.',
        'wallet_balance_not_sufficient' => 'Der Brieftaschensaldo ist für diese Fahrt nicht ausreichend.',
        'wallet_balance_ride' => 'Die Option, den Brieftaschensaldo für Fahrten zu nutzen, ist derzeit deaktiviert.',
        'wallet_balance_unable' => 'Fahrgäste können den Brieftaschensaldo beim Erstellen von Fahrten nicht nutzen.',
        'add_note' => 'Notiz hinzufügen',
        'enter_note' => 'Notiz für Benutzer eingeben',
        'add_driver_message' => '*Um einen neuen Fahrer hinzuzufügen, klicken Sie einfach',
        'add_rider_message' => '*Um einen neuen Fahrgast hinzuzufügen, klicken Sie einfach',
        'add_payment_account_before_withdrawal' => 'Bitte erstellen Sie ein Zahlungskonto, bevor Sie eine Auszahlung beantragen.',
        'add_paypal_email_before_withdrawal' => 'Bitte fügen Sie eine PayPal-E-Mail hinzu, bevor Sie eine Auszahlung beantragen.',
        'add_bank_details_before_withdrawal' => 'Bitte vervollständigen Sie die Bankdetails, bevor Sie eine Auszahlung beantragen.',
        'min_withdraw_amount' => 'Stellen Sie sicher, dass Ihr angeforderter Betrag mindestens :minWithdrawAmount beträgt.',
        'insufficient_wallet_balance' => 'Ihr Brieftaschensaldo ist nicht ausreichend, um diese Auszahlung zu verarbeiten.',
        'withdraw_request_submitted' => 'Auszahlungsanfrage erfolgreich generiert',
        'selected_user' => 'Ausgewählter Benutzer muss Fahrer sein',
    ],
    'withdraw_requests' => [
        'withdraw_request' => 'Auszahlungsanfrage',
        'title' => 'Auszahlungsanfragen',
        'pending_balance' => 'Ausstehender Saldo',
        'wallet' => 'Brieftasche',
        'message' => 'Nachricht',
        'amount' => 'Betrag',
        'payment_type' => 'Zahlungsmethode',
        'status' => 'Status',
        'send_withdrawRequest' => 'Auszahlungsanfrage senden',
        'bank' => 'Bank',
        'paypal' => 'PayPal',
        'enter_message' => 'Nachricht eingeben',
    ],
    'push_notification' => [
        'push_notification' => 'Push-Benachrichtigungen',
        'all' => 'Alle Push-Benachrichtigungen',
        'send' => 'Push-Benachrichtigung senden',
        'select_notification_send_to' => 'Empfänger der Benachrichtigung auswählen',
        'send_notification' => 'Benachrichtigung senden',
        'send_to' => 'Senden an',
        'selected_service' => 'Alle/Ausgewählter Dienst',
        'title' => 'Titel',
        'sent_notification' => 'Push-Benachrichtigung erfolgreich gesendet',
        'delete_successfully' => 'Push-Benachrichtigung erfolgreich gelöscht',
        'permanent_delete_successfully' => 'Push-Benachrichtigung dauerhaft erfolgreich gelöscht.',
        'enter_title' => 'Titel eingeben',
        'enter_message' => 'Nachricht eingeben',
        'message' => 'Nachricht',
        'image' => 'Bild',
        '3_min_ago' => 'Vor 3 Minuten',
        'url' => 'URL',
        'message_body' => 'Nachrichtentext',
        'enter_url' => 'URL eingeben',
        'zones' => 'Zone',
        'select_zones' => 'Zonen auswählen',
        'no_zones_message' => '*Um eine neue Zone hinzuzufügen, klicken Sie einfach',
        'schedule'=> 'Zeitplan',
        'scheduleat'=> 'Zeitplan',
        'select_start_date_and_time' => 'Startdatum und Zeit auswählen',
    ],
    'hourly_package' => [
        'add_new' => 'Neu hinzufügen',
        'add' => 'Stundenpaket hinzufügen',
        'image' => 'Bild',
        'create' => 'Stundenpaket',
        'save' => 'Speichern',
        'title' => 'Titel',
        'amount' => 'Betrag',
        'hour_span' => '*Geben Sie an, wie viele Stunden dieses Paket umfasst. Zum Beispiel 2 Stunden für kurze Stadtfahrten',
        'distance_span' => '*Legen Sie die maximale Entfernung fest, die in diesem Paket erlaubt ist. Zum Beispiel 50 km innerhalb von 2 Stunden',
        'distance_type_span' => '*Wählen Sie, wie die Entfernung gemessen wird: Kilometer oder Meilen',
        'vehicle_type_span' => '*Wählen Sie die Fahrzeugtypen aus, die für dieses Paket verfügbar sind. Zum Beispiel Limousine, SUV oder Van',
        'enter_amount' => 'Betrag eingeben',
        'edit' => 'Stundenpaket bearbeiten',
        'enter_title' => 'Titel eingeben',
        'hourly_package' => 'Stundenpaket',
        'hourly_packages' => 'Stundenpakete',
        'no_hourly_package_message' => '*Um ein neues Stundenpaket hinzuzufügen, klicken Sie einfach',
        'distance' => 'Entfernung',
        'hour' => 'Stunde',
        'distance_type' => 'Entfernungstyp',
        'select_distance_type' => 'Entfernungstyp auswählen',
        'status' => 'Status',
        'enter_distance' => 'Entfernung eingeben',
        'enter_hour' => 'Stunde eingeben',
        'extra_min_per_hour_rate' => 'Zusätzliche Mindestgebühr pro Stunde',
        'enter_extra_min_per_hour_rate' => 'Zusätzliche Mindestgebühr pro Stunde eingeben',
        'extra_min_per_hour_distance' => 'Zusätzliche Mindestentfernung pro Stunde',
        'enter_extra_min_per_hour_distance' => 'Zusätzliche Mindestentfernung pro Stunde eingeben',
        'create_successfully' => 'Stundenpaket erfolgreich erstellt.',
        'update_successfully' => 'Stundenpaket erfolgreich aktualisiert.',
        'delete_successfully' => 'Stundenpaket erfolgreich gelöscht.',
        'restore_successfully' => 'Stundenpaket erfolgreich wiederhergestellt.',
        'permanent_delete_successfully' => 'Stundenpaket dauerhaft erfolgreich gelöscht.',
        'status_update_successfully' => 'Stundenpaket-Status erfolgreich aktualisiert.',
        'select_vehicle_type' => 'Fahrzeugtyp auswählen',
        'no_vehicleType_message' => '*Um einen neuen Fahrzeugtyp hinzuzufügen, klicken Sie einfach',
    ],
    'reports' => [
        'reports' => 'Berichte',
        'user_reports' => 'Benutzerberichte',
        'driver_reports' => 'Fahrerberichte',
        'ride_reports' => 'Fahrtberichte',
        'intercity_reports' => 'Intercity-Berichte',
        'select_driver' => 'Fahrer auswählen',
        'select_user' => 'Benutzer auswählen',
        'select_ride_status' => 'Fahrtstatus auswählen',
        'select_payment_method' => 'Zahlungsmethode auswählen',
        'select_payment_status' => 'Zahlungsstatus auswählen',
        'select_date' => 'Datum auswählen',
        'select_zone' => 'Zone auswählen',
        'select_service' => 'Dienst auswählen',
        'select_service_category' => 'Dienstkategorie auswählen',
        'select_vehicle_type' => 'Fahrzeugtyp auswählen',
        'select_file_format' => 'Dateiformat auswählen',
        'select_export_format' => 'Exportformat auswählen',
        'driver' => 'Fahrer',
        'user' => 'Benutzer',
        'ride_status' => 'Fahrtstatus',
        'payment_method' => 'Zahlungsmethode',
        'payment_status' => 'Zahlungsstatus',
        'date' => 'Datum',
        'zone' => 'Zone',
        'service' => 'Dienst',
        'service_category' => 'Dienstkategorie',
        'vehicle_type' => 'Fahrzeugtyp',
        'file_format' => 'Dateiformat',
        'all' => 'Alle',
        'filter' => 'Filter',
        'CSV' => 'CSV',
        'SVG' => 'SVG',
        'ride_number' => 'Fahrtnummer',
        'zone_reports' => 'Zonenberichte',
        'amount' => 'Betrag',
        'rides' => 'Fahrten',
        'export' => 'Exportieren',
        'export_data' => 'Daten exportieren',
        'active_rides' => 'Aktive Fahrten',
        'cancelled_rides' => 'Stornierte Fahrten',
        'completed_rides' => 'Abgeschlossene Fahrten',
        'contact' => 'Kontakt',
        'earnings' => 'Einnahmen',
        'ratings' => 'Bewertungen',
        'scheduled_rides' => 'Geplante Fahrten',
        'drivers' => 'Fahrer',
        'name' => 'Name',
        'email' => 'E-Mail',
        'coupon' => 'Gutschein',
        'select_coupon' => 'Gutschein auswählen',
        'coupon_reports' => 'Gutscheinberichte',
        'coupon_code' => 'Gutscheincode',
        'total_rides' => 'Gesamtfahrten',
        'total_coupon_discount' => 'Gesamtrabatt durch Gutscheine',
        'total_ride_amount' => 'Gesamtfahrtbetrag',
        'total_drivers' => 'Gesamtfahrer',
        'total_vehicle_types' => 'Gesamtfahrzeugtypen',
        'total_tax' => 'Gesamtsteuer',
        'transaction_type' => 'Transaktionstyp',
        'select_transaction_type' => 'Transaktionstyp auswählen',
        'ride' => 'Fahrt',

        'subscription' => 'Abonnement',
        'wallet' => 'Brieftasche',
        'item_name' => 'Artikelname',
        'type' => 'Typ',
        'tansaction_id' => 'Transaktions-ID',
        'transaction_reports' => 'Transaktionsberichte',
        'Date'=> 'Datum',

    ],
    'cancellation-reasons' => [
        'cancellation-reasons' => 'Stornierungsgründe',
        'add_new' => 'Neu hinzufügen',
        'add' => 'Stornierungsgrund hinzufügen',
        'image' => 'Symbol',
        'edit' => 'Stornierungsgrund bearbeiten',
        'create' => 'Stornierungsgrund',
        'save' => 'Speichern',
        'title' => 'Titel',
        'enter_title' => 'Titel eingeben',
        'create_successfully' => 'Stornierungsgrund erfolgreich erstellt.',
        'update_successfully' => 'Stornierungsgrund erfolgreich aktualisiert.',
        'delete_successfully' => 'Stornierungsgrund erfolgreich gelöscht.',
        'status_update_successfully' => 'Stornierungsgrund-Status erfolgreich aktualisiert.',
        'permanent_delete_successfully' => 'Stornierungsgrund dauerhaft erfolgreich gelöscht.',
        'restore_successfully' => 'Stornierungsgrund erfolgreich wiederhergestellt.',
    ],
    'bids' => [
        'only_drivers_can_place_bids' => 'Nur Fahrer können Gebote abgeben.',
        'invalid_bidding_amount' => 'Ungültiger Gebotsbetrag.',
        'create_next_bid' => 'Sie können das nächste Gebot erstellen, nachdem das vorherige Gebot abgelehnt wurde.',
        'failed_to_create_ride' => 'Fahrt konnte nicht erstellt werden.',
        'bid_status_already_changed' => 'Der Gebotsstatus ist bereits :status, Sie können ihn nicht erneut ändern.',
    ],
    'reviews' => [
        'reviews' => 'Bewertungen',
        'delete_successfully' => 'Bewertung erfolgreich gelöscht.',
        'restore_successfully' => 'Bewertung erfolgreich wiederhergestellt.',
        'permanent_delete_successfully' => 'Bewertung dauerhaft erfolgreich gelöscht.',
        'ride_not_completed' => 'Bitte schließen Sie die Fahrt ab, bevor Sie eine Bewertung hinzufügen.',
        'already_reviewed' => 'Für diese Fahrt wurde bereits eine Bewertung abgegeben.',
        'rider_reviews' => 'Fahrgastbewertungen',
        'driver_reviews' => 'Fahrerbewertungen',
    ],
    'notices' => [
        'notices' => 'Hinweise',
        'add_new' => 'Neu hinzufügen',
        'add_notice' => 'Hinweis hinzufügen',
        'edit' => 'Hinweis bearbeiten',
        'zones' => 'Zonen',
        'notice' => 'Hinweise',
        'select_zones' => 'Zonen auswählen',
        'select_send_to' => 'Empfänger auswählen',
        'color' => 'Farbe',
        'send_to' => 'Senden an',
        'message' => 'Nachricht',
        'enter_message' => 'Nachricht eingeben',
        'no_zones_message' => '*Um eine neue Zone hinzuzufügen, klicken Sie einfach',
        'no_drivers_message' => '*Um einen neuen Fahrer hinzuzufügen, klicken Sie einfach',
        'select_drivers' => 'Fahrer auswählen',
        'create_successfully' => 'Hinweis erfolgreich erstellt.',
        'update_successfully' => 'Hinweis erfolgreich aktualisiert.',
        'delete_successfully' => 'Hinweis erfolgreich gelöscht.',
        'restore_successfully' => 'Hinweis erfolgreich wiederhergestellt.',
        'permanent_delete_successfully' => 'Hinweis dauerhaft erfolgreich gelöscht.',
        'status_update_successfully' => 'Hinweis-Status erfolgreich aktualisiert.',
    ],
    'import' => [
        'import' => 'Importieren',
        'csv_file_import' => 'CSV-Datei erfolgreich importiert',
        'csv_file_allow' => 'Nur CSV-Dateien sind erlaubt.',
        'upload_data' => 'Daten hochladen',
        'upload_instruction' => 'Laden Sie eine CSV-Datei hoch, um Daten zu importieren.',
        'drag_drop' => 'Dateien per Drag-and-Drop hochladen',
        'private_message' => 'Ihre Daten bleiben privat, bis Sie sie veröffentlichen.',
        'select_files' => 'Dateien auswählen',
        'cancel' => 'Abbrechen',
        'enter_link' => 'Link zum Hochladen eingeben',
        'add' => 'Hinzufügen',
        'google_shit_link' => 'Google Sheets-Link',
        'local_files' => 'Lokale Datei',
        'enter_google_sheet_link' => 'Google Sheets-Link hier eingeben',
        'example_csv' => 'Bitte laden Sie die Beispiel-CSV-Datei von',
        'read_instructions' => 'und stellen Sie sicher, dass Sie die Anweisungen vor dem Import sorgfältig lesen',
    ],
    'export' => [
        'export' => 'Exportieren',
        'csv_file_export' => 'CSV-Datei erfolgreich exportiert',
        'csv_file_allow' => 'Nur CSV-Dateien sind erlaubt.',
        'export_drivers' => 'Alle Fahrer exportieren',
        'export_data' => 'Daten exportieren',
        'csv' => 'CSV',
        'excel' => 'Excel',
        'close' => 'Schließen',
        'select_export_format' => 'Exportformat auswählen',
    ],
    'language' => [
        'languages' => 'Sprachen',
    ],
    'widget' => [
        'ride_status_overviews' => 'Fahrtstatusübersicht',
        'statistics' => 'Statistiken',
        'total_riders' => 'Gesamtfahrgäste',
        'total_drivers' => 'Gesamtfahrer',
        'total_rides' => 'Fahrten',
        'ride_earnings' => 'Fahrteinnahmen',
        'average_revenue' => 'Durchschnittlicher Umsatz',
        'recent_rides' => 'Kürzliche Fahrten',
        'view_all' => 'Alle anzeigen',
        'revenue' => 'Umsatz',
        'ride_id' => 'Fahrtnummer',
        'driver_name' => 'Fahrer',
        'drop_off_location' => 'Absetzort',
        'distance' => 'Entfernung',
        'status' => 'Status',
        'total_verified_drivers' => 'Gesamt verifizierte Fahrer',
        'total_unverified_drivers' => 'Gesamt unverifizierte Fahrer',
        'km' => 'Km',
        'no_data_available' => 'Keine Daten verfügbar',
        'service_categories' => 'Dienstkategorien',
        'than_today' => 'Als heute',
        'top_drivers' => 'Top-Fahrer',
        'ratings' => 'Bewertungen',
        'earnings' => 'Einnahmen',
        'online_status' => 'Aktiv Online',
        'online_payment' => 'Online-Zahlung',
        'offline_payment' => 'Offline-Zahlung',
        'withdraw_request' => 'Auszahlungsanfrage',
        'Wallet_balance' => 'Brieftaschensaldo',
        'reviews' => 'Bewertungen',
        'documents' => 'Dokumente',
        'fleet_managers_info'=>'Totale Flottenmanager', 
        'dispatcher'=>'Disponentinnen',
        'peak_zone'=>' Aktive Spitzenzonen',
        'fleet_vehicle_type'=>'Gesamte Flottenfahrzeuge'
    ],
    'rental_vehicle' => [
        'rental_vehicle' => 'Mietwagen',
        'rental_vehicles' => 'Mietwagen',
        'name' => 'Name',
        'images' => 'Bilder',
        'view_image_guide' => 'Bildanleitung anzeigen',
        'normal_image' => 'Normales Bild',
        'normal_image_span' => 'Klares Bild Ihres Fahrzeugs, das eine vollständige Ansicht bietet',
        'front_view_span' => 'Laden Sie ein klares Bild hoch, das die Vorderseite Ihres Fahrzeugs zeigt',
        'front_view' => 'Frontansicht Bild',
        'side_view' => 'Seitenansicht Bild',
        'side_view_span' => 'Stellen Sie ein Bild des Seitenprofils des Fahrzeugs bereit.',
        'boot_view' => 'Kofferraumansicht Bild',
        'boot_view_span' => 'Stellen Sie sicher, dass der Kofferraum geöffnet und vollständig sichtbar ist.',
        'interior' => 'Innenraum',
        'interior_span' => 'Fügen Sie ein Foto des Innenraums hinzu, das wichtige Merkmale wie Sitze und Armaturenbrett zeigt.',
        'enter_name' => 'Namen eingeben (z. B.: Toyota Corolla)',
        'description' => 'Beschreibung',
        'enter_description' => 'Beschreibung eingeben (z. B.: Komfortable 5-Sitzer-Limousine)',
        'vehicle_type' => 'Fahrzeugtyp',
        'select_vehicle_type' => 'Fahrzeugtyp auswählen',
        'select_zones' => 'Zonen auswählen',
        'interior_image' => 'Innenraumbild',
        'vehicle_per_day_price' => 'Fahrzeugpreis pro Tag',
        'enter_vehicle_per_day_price' => 'Tagespreis des Fahrzeugs eingeben (z. B.: 50 €)',
        'with_driver' => 'Mit Fahrer',
        'driver_details' => 'Fahrerdetails',
        'enter_driver_details' => 'Fahrerdetails eingeben (z. B.: John Doe, lizenziert und erfahren)',
        'driver_per_day_charge' => 'Fahrer Tagesgebühr',
        'enter_driver_per_day_charge' => 'Tagesgebühr für den Fahrer eingeben (z. B.: 20 €)',
        'car_type' => 'Fahrzeugtyp',
        'enter_vehicle_subtype' => 'Fahrzeuguntertyp eingeben (z. B.: Limousine)',
        'fuel_type' => 'Kraftstofftyp',
        'enter_fuel_type' => 'Kraftstofftyp eingeben (z. B.: CNG)',
        'gear_type' => 'Getriebetyp',
        'enter_gear_type' => 'Getriebetyp eingeben (z. B.: Automatik)',
        'vehicle_speed' => 'Fahrzeuggeschwindigkeit',
        'enter_vehicle_speed' => 'Fahrzeuggeschwindigkeit eingeben (z. B.: 120 km/h)',
        'mileage' => 'Kilometerleistung',
        'enter_mileage' => 'Kilometerleistung eingeben (z. B.: 15 km/l)',
        'status' => 'Status',
        'save' => 'Speichern',
        'select_zone' => 'Zone auswählen (z. B.: Stadtzentrum)',
        'zone' => 'Zone',
        'vehicle_subtype' => 'Fahrzeuguntertyp',
        'add' => 'Mietwagen hinzufügen',
        'edit' => 'Mietwagen bearbeiten',
        'enter_interior_detail' => 'Innenraumdetails eingeben',
        'add_interior' => 'Hinzufügen',
        'remove_interior' => 'Entfernen',
        'deleted_successfully' => 'Mietwagen erfolgreich gelöscht',
        'registration_no' => 'Registrierungsnummer',
        'enter_registration_no' => 'Registrierungsnummer eingeben',
        'registration_image' => 'Registrierungsbild',
        'create_successfully' => 'Mietwagen erfolgreich erstellt.',
        'update_successfully' => 'Mietwagen erfolgreich aktualisiert.',
        'delete_successfully' => 'Mietwagen erfolgreich gelöscht.',
        'restore_successfully' => 'Mietwagen erfolgreich wiederhergestellt.',
        'permanent_delete_successfully' => 'Mietwagen dauerhaft erfolgreich gelöscht.',
        'status_update_successfully' => 'Mietwagen-Status erfolgreich aktualisiert.',
    ],
    'commission_histories' => [
        'commission_histories' => 'Provisionsverläufe',
    ],
    'plans' => [
        'plans' => 'Pläne',
        'name' => 'Name',
        'enter_name' => 'Plannamen eingeben',
        'add' => 'Plan hinzufügen',
        'edit' => 'Plan bearbeiten',
        'description' => 'Beschreibung',
        'enter_description' => 'Beschreibung eingeben',
        'add_description' => 'Beschreibung hinzufügen',
        'duration' => 'Dauer',
        'price' => 'Preis',
        'enter_plan_price' => 'Preis eingeben',
        'select_duration' => 'Dauer auswählen',
        'all' => 'Alle Pläne',
        'add_new' => 'Neu hinzufügen',
        'save' => 'Speichern',
        'select_service_category' => 'Dienstkategorien auswählen',
        'select_service_categories' => 'Dienstkategorien auswählen',
        'status' => 'Status',
        'create_successfully' => 'Plan erfolgreich erstellt.',
        'update_successfully' => 'Plan erfolgreich aktualisiert.',
        'delete_successfully' => 'Plan erfolgreich gelöscht.',
        'restore_successfully' => 'Plan erfolgreich wiederhergestellt.',
        'permanent_delete_successfully' => 'Plan dauerhaft erfolgreich gelöscht.',
        'status_update_successfully' => 'Plan-Status erfolgreich aktualisiert.',
        'payment_not_allowed_for_plan' => 'Ausgewählte Zahlungsmethode nicht für den Kauf des Plans erlaubt.',
        'only_driver_can_purchase_plan' => 'Nur Fahrer können den Plan kaufen.',
        'invalid_payment_method' => 'Ausgewählte Zahlungsmethode ist ungültig.',
        'wallet_debit_success' => 'Brieftaschenbetrag erfolgreich für den Kauf des Plans :plan_name abgebucht.',
    ],
    'traits' => [
        'invalid_weight_unit' => 'Ungültige Gewichtseinheit angegeben.',
        'fare_amount_outside_range' => 'Der Fahrpreis muss zwischen :min und :max für eine :distance :unit Strecke liegen.',
        'invalid_package_fare' => 'Der Fahrpreis muss zwischen :min und :max für das ausgewählte Paket liegen.',
        'invalid_hourly_package' => 'Ausgewähltes Stundenpaket ungültig.',
        'invalid_vehicle_for_package' => 'Ausgewähltes Fahrzeug ist nicht für den Paketdienst geeignet.',
        'hourly_package_required' => 'Stundenpaket ist für die Paketkategorie erforderlich.',
        'invalid_vehicle_for_parcel' => 'Ausgewähltes Fahrzeug ist nicht für den Paketdienst geeignet.',
        'invalid_service' => 'Ausgewählter Dienst ist ungültig.',
        'admin_debited_commission' => 'Admin hat Provision abgebucht.',
        'admin_debited_tax' => 'Admin hat Steuerbetrag abgebucht.',
        'admin_debited_platform_fee' => 'Admin hat Plattformgebühr abgebucht.',
    ],
    'modal' => [
        'export_data' => 'Daten exportieren',
        'select_export_format' => 'Exportformat auswählen',
        'csv' => 'CSV',
        'excel' => 'Excel',
        'close' => 'Schließen',
        'export' => 'Exportieren',
    ],
    'subscriptions' => [
        'driver_subscription' => 'Fahrerabonnements',
        'subscriptions' => 'Abonnements',
    ],
    'onboardings' => [
        'onboardings' => 'Onboarding-Bildschirme',
        'edit' => 'Onboarding bearbeiten',
        'image' => 'Bild',
        'title' => 'Titel',
        'save' => 'Speichern',
        'description' => 'Beschreibung',
        'enter_description' => 'Beschreibung eingeben',
        'type' => 'Typ',
        'select_type' => 'Typ auswählen',
        'update_successfully' => 'Onboarding erfolgreich aktualisiert.',
        'delete_successfully' => 'Onboarding erfolgreich gelöscht.',
    ],
    'dispatchers' => [
        'dispatchers' => 'Disponenten',
        'add_new' => 'Neu hinzufügen',
        'all' => 'Alle Disponenten',
        'add' => 'Disponent hinzufügen',
        'rider_details' => 'Fahrgastdetails',
        'create' => 'Disponent erstellen',
        'add_dispatchers' => 'Disponenten hinzufügen',
        'edit' => 'Disponent bearbeiten',
        'full_name' => 'Vollständiger Name',
        'reviews' => 'Bewertungen',
        'email' => 'E-Mail',
        'enter_email' => 'E-Mail eingeben',
        'contact_number' => 'Kontaktnummer',
        'emails' => 'E-Mail',
        'select_zones' => 'Zonen auswählen',
        'enter_full_name' => 'Vollständigen Namen eingeben',
        'phone' => 'Telefon',
        'zones' => 'Zonen',
        'enter_phone' => 'Telefon eingeben',
        'enter_password' => 'Passwort eingeben',
        'enter_confirm_password' => 'Passwort bestätigen eingeben',
        'new_password' => 'Neues Passwort',
        'confirm_password' => 'Passwort bestätigen',
        'notification' => 'Disponent benachrichtigen',
        'sentence' => 'Senden Sie dem neuen Disponenten eine E-Mail über sein Konto.',
        'create_successfully' => 'Disponent erfolgreich erstellt.',
        'update_successfully' => 'Disponent erfolgreich aktualisiert.',
        'delete_successfully' => 'Disponent erfolgreich gelöscht.',
        'restore_successfully' => 'Disponent erfolgreich wiederhergestellt.',
        'permanent_delete_successfully' => 'Disponent dauerhaft erfolgreich gelöscht.',
        'status_update_successfully' => 'Disponent-Status erfolgreich aktualisiert.',
    ],
    'fleet_managers' => array(
    'full_name' => 'Vollständiger Name',
    'personal_information' => 'Persönliche Informationen',
    'email' => 'E-Mail',
    'edit' => 'Flottenmanager bearbeiten',
    'enter_phone' => 'Telefonnummer eingeben',
    'new_password' => 'Neues Passwort',
    'confirm_password' => 'Passwort bestätigen',
    'contact_number' => 'Kontakt Nummer',
    'emails' => 'E-Mail',
    'created_at' => 'Erstellt am',
    'action' => 'Aktion',
    'enter_full_name' => 'Vollständigen Namen eingeben',
    'enter_confirm_password' => 'Bestätigtes Passwort eingeben',
    'enter_email' => 'E-Mail eingeben',
    'sentence' => 'Senden Sie dem neuen Flottenmanager eine E-Mail über sein Konto.',
    'enter_password' => 'Passwort eingeben',
    'notification' => 'Flottenmanager benachrichtigen',
    'phone' => 'Telefon',
    'zones' => 'Zonen',
    'no_reviews' => 'Keine Bewertungen verfügbar',
    'description' => 'Beschreibung',
    'fleet_managers' => 'Flottenmanager',
    'add_new' => 'Neu hinzufügen',
    'payout_details' => 'Auszahlungsdetails',
    'general' => 'Allgemein',
    'bank_account_no' => 'Bankkontonummer',
    'enter_bank_account' => 'Bankkontonummer eingeben',
    'bank_name' => 'Bankname',
    'enter_bank_name' => 'Bankname eingeben',
    'holder_name' => 'Kontoinhaber',
    'enter_holder_name' => 'Kontoinhaber eingeben',
    'swift' => 'SWIFT',
    'enter_swift_code' => 'SWIFT-Code eingeben',
    'routing_number' => 'Routing-Nummer',
    'enter_routing_number' => 'Routing-Nummer eingeben',
    'all' => 'Alle Flottenmanager',
    'add' => 'Flottenmanager hinzufügen',
    'create_successfully' => 'Flottenmanager erfolgreich erstellt.',
    'update_successfully' => 'Flottenmanager erfolgreich aktualisiert.',
    'delete_successfully' => 'Flottenmanager erfolgreich gelöscht.',
    'restore_successfully' => 'Flottenmanager erfolgreich wiederhergestellt.',
    'permanent_delete_successfully' => 'Flottenmanager dauerhaft gelöscht.',
        'status_update_successfully' => 'Status des Flottenmanagers erfolgreich aktualisiert.',
    ),
    'sos_alerts' => [
        'sos_alerts' => 'SOS-Alarme',
    ],
    'referrals' => [
        'referrals' => 'Empfehlungen',
        'referrer' => 'Empfehler',
        'referred_user' => 'Empfohlener Benutzer',
        'referral_code' => 'Empfehlungscode',
        'bonus_amount' => 'Bonusbetrag',
        'status' => 'Status',
        'credited_at' => 'Gutgeschrieben am',
        'created_at' => 'Erstellt am',
        'pending' => 'Ausstehend',
        'credited' => 'Gutgeschrieben',
        'all' => 'Alle',
        'trash' => 'Papierkorb',
        'all_types' => 'Alle Typen',
        'rider_referrals' => 'Fahrgast-Empfehlungen',
        'driver_referrals' => 'Fahrer-Empfehlungen',
        'referrer_type' => 'Empfehler-Typ',
        'referred_type' => 'Empfohlener Typ',
        'ride_amount' => 'Fahrtbetrag',
        'referrer_bonus' => 'Empfehler-Bonus',
        'referred_bonus' => 'Empfohlener Bonus',
        'referrer_percentage' => 'Empfehler %',
        'referred_percentage' => 'Empfohlener %',
        'rider' => 'Fahrgast',
        'driver' => 'Fahrer',
    ],
    'validation' => [
        'minimum_ride_amount_positive' => 'Der Mindestfahrtbetrag muss eine positive Zahl sein.',
        'referrer_bonus_percentage_range' => 'Der Empfehler-Bonusprozentsatz muss zwischen 0 und 100 liegen.',
        'referred_bonus_percentage_range' => 'Der empfohlene Benutzer-Bonusprozentsatz muss zwischen 0 und 100 liegen.',
    ],

];
