<?php

return array(
  'taxido' => 'Taxido',
  'status' => 'Estado',
  'search' => 'Buscar',
  'clear' => 'Limpiar',
  'yes' => 'Sí',
  'ride' => [
    'admin' => [
      'email' => [
        'subject' => 'Actualización de viaje #{ride_number}: {status} 🚖',
        'greeting' => 'Hola Administrador,',
        'body' => 'Se requiere tu atención para una actualización del estado del viaje.',
        'footer' => 'Por favor, revisa los detalles en el panel de administración.',
      ],
      'push' => [
        'pending' => [
          'title' => '📢 Nuevo viaje pendiente',
          'body' => 'El viaje #{ride_number} está pendiente de revisión. Por favor, supervísalo. 📋',
        ],
        'requested' => [
          'title' => '🔔 Solicitud de viaje recibida',
          'body' => 'El viaje #{ride_number} ha sido solicitado. En espera de asignación de conductor. 🚖',
        ],
        'scheduled' => [
          'title' => '📅 Viaje programado',
          'body' => 'El viaje #{ride_number} está programado. Todos los detalles confirmados. ✅',
        ],
        'accepted' => [
          'title' => '✔️ Viaje aceptado',
          'body' => 'El viaje #{ride_number} ha sido aceptado por el conductor. 🚗',
        ],
        'rejected' => [
          'title' => '🚫 Viaje rechazado',
          'body' => 'El viaje #{ride_number} fue rechazado. Por favor, revisa para reasignación. 🔍',
        ],
        'arrived' => [
          'title' => '📍 Conductor llegado',
          'body' => 'El conductor ha llegado para el viaje #{ride_number}. Listo para recoger. 🏠',
        ],
        'started' => [
          'title' => '🚀 Viaje iniciado',
          'body' => 'El viaje #{ride_number} está en curso. Monitorea las actualizaciones. 🌟',
        ],
        'cancelled' => [
          'title' => '❌ Viaje cancelado',
          'body' => 'El viaje #{ride_number} ha sido cancelado. Revisa los detalles. 📝',
        ],
        'completed' => [
          'title' => '🎉 Viaje completado',
          'body' => 'El viaje #{ride_number} se ha completado con éxito. ¡Buen trabajo! 🥳',
        ],
      ],
    ],
    'rider' => [
      'email' => [
        'subject' => 'Estado del viaje #{ride_number}: {status} 🚖',
        'greeting' => 'Hola {rider_name},',
        'body' => 'Aquí tienes la última actualización de tu viaje.',
        'extra' => '¡Gracias por elegir nuestro servicio! Estamos aquí para ayudarte.',
      ],
      'push' => [
        'pending' => [
          'title' => '📢 Viaje #{ride_number} pendiente',
          'body' => 'Tu viaje está pendiente de confirmación. ¡Te notificaremos pronto! ⏳',
        ],
        'requested' => [
          'title' => '🔔 Viaje #{ride_number} solicitado',
          'body' => 'Tu solicitud de viaje está siendo procesada. Pronto se asignará un conductor. 🚖',
        ],
        'scheduled' => [
          'title' => '📅 Viaje #{ride_number} programado',
          'body' => 'Tu viaje está confirmado para {timestamp}. ¡Prepárate! ✅',
        ],
        'accepted' => [
          'title' => '✔️ Viaje #{ride_number} aceptado',
          'body' => 'El conductor {driver_name} ha aceptado tu viaje. Llegará pronto a {pickup_location}. 🚗',
        ],
        'rejected' => [
          'title' => '🚫 Viaje #{ride_number} rechazado',
          'body' => 'Tu viaje fue rechazado. Estamos buscando otro conductor. 🔍',
        ],
        'arrived' => [
          'title' => '📍 Conductor llegado para el viaje #{ride_number}',
          'body' => 'El conductor {driver_name} está en {pickup_location}. ¡Encuéntralo ahora! 🏠',
        ],
        'started' => [
          'title' => '🚀 Viaje #{ride_number} iniciado',
          'body' => 'Tu viaje con {driver_name} está en curso. ¡Buen viaje! 🌟',
        ],
        'cancelled' => [
          'title' => '❌ Viaje #{ride_number} cancelado',
          'body' => 'Tu viaje ha sido cancelado. Por favor, reserva otro si es necesario. 📝',
        ],
        'completed' => [
          'title' => '🎉 Viaje #{ride_number} completado',
          'body' => 'Tu viaje a {destination} está completo. ¡Gracias por viajar con nosotros! 🥳',
        ],
      ],
    ],
    'driver' => [
      'email' => [
        'subject' => 'Asignación de viaje #{ride_number}: {status} 🚖',
        'greeting' => 'Hola {driver_name},',
        'body' => 'Tienes una nueva actualización de viaje.',
        'extra' => '¡Gracias por tu servicio! Sigue con el gran trabajo.',
      ],
      'push' => [
        'pending' => [
          'title' => '📢 Nuevo viaje #{ride_number} disponible',
          'body' => 'Un nuevo viaje está pendiente. ¡Revisa los detalles para aceptar! ⏳',
        ],
        'requested' => [
          'title' => '🔔 Viaje #{ride_number} solicitado',
          'body' => 'Una nueva solicitud de viaje está disponible. ¡Acéptala ahora! 🚖',
        ],
        'scheduled' => [
          'title' => '📅 Viaje #{ride_number} programado',
          'body' => 'Viaje programado para {timestamp}. ¡Prepárate en consecuencia! ✅',
        ],
        'accepted' => [
          'title' => '✔️ Viaje #{ride_number} aceptado',
          'body' => 'Has aceptado el viaje #{ride_number}. ¡Dirígete a {pickup_location}! 🚗',
        ],
        'rejected' => [
          'title' => '🚫 Viaje #{ride_number} rechazado',
          'body' => 'Has rechazado el viaje #{ride_number}. Revisa nuevas asignaciones. 🔍',
        ],
        'arrived' => [
          'title' => '📍 Llegada al punto de recogida para el viaje #{ride_number}',
          'body' => 'Estás en {pickup_location}. Espera a {rider_name}. 🏠',
        ],
        'started' => [
          'title' => '🚀 Viaje #{ride_number} iniciado',
          'body' => 'El viaje con {rider_name} está en curso. ¡Conduce con seguridad! 🌟',
        ],
        'cancelled' => [
          'title' => '❌ Viaje #{ride_number} cancelado',
          'body' => 'El viaje #{ride_number} fue cancelado. Revisa nuevos viajes. 📝',
        ],
        'completed' => [
          'title' => '🎉 Viaje #{ride_number} completado',
          'body' => '¡Buen trabajo! El viaje a {destination} está completo. 🥳',
        ],
      ],
    ],
    'email' => [
      'details' => 'Detalles del viaje:',
      'ride_id' => 'ID del viaje: {ride_number}',
      'status' => 'Estado: {status}',
      'rider' => 'Pasajero: {rider_name}',
      'driver' => 'Conductor: {driver_name}',
      'pickup_location' => 'Lugar de recogida: {pickup_location}',
      'destination' => 'Destino: {destination}',
      'timestamp' => 'Marca de tiempo: {timestamp}',
      'salutation' => 'Atentamente,
                El equipo de viajes',
    ],
  ],
  'no' => 'No',
  'wallet_feature_on' => 'La función de billetera está desactivada',
  'inactive' => 'Inactivo',
  'cab_management' => 'Gestión de Taxis',
  'ride_management' => 'Gestión de Viajes',
  'cab' => 'Taxi',
  'vehicles' => 'Vehículos',
  'demo_mode' => 'Modo Demo',
  'save' => 'Guardar',
  'section' => 'Gestión de Taxido',
  'save_and_exit' => 'Guardar y Salir',
  'active' => 'Activo',
  'deactive' => 'Desactivado',
  'ride_details' => 'Detalles del Viaje',
  'no_result' => 'No se encontraron resultados.',
  'driver_details' => 'Detalles del Conductor',
  'link' => 'Enlace',
  'name' => 'Nombre',
  'here' => 'aquí',
  'submit' => 'Enviar',
  'see_details' => 'Ver Detalles',
  'cash_payments_is_disabled' => 'Los pagos en efectivo están desactivados, contacta al administrador.',
  'online_payments_is_disabled' => 'Los pagos en línea están desactivados, contacta al administrador.',
  'drivers' =>
  array(
    'general' => 'General',
    'address' => 'Dirección',
    'all' => 'Todos los Conductores',
    'location' => 'Ubicación',
    'fleet_manager' => 'Gerente de Flota',
    'select_fleet_manager' => 'Seleccionar Gerente de Flota',
    'is_online' => 'Está en Línea',
    'is_verified' => 'Está Verificada',
    'is_on_ride' => 'Está en Viaje',
    'no_driver_found' => 'No se Encontró Conductor',
    'confirm_password' => 'Confirmar Contraseña',
    'new_password' => 'Nueva Contraseña',
    'enter_password' => 'Ingresar Contraseña',
    'enter_confirm_password' => 'Ingresar Confirmación de Contraseña',
    'total_earnings' => 'Ganancias Totales',
    'current_driver_location' => 'Ubicación del Conductor',
    'wallet' => 'Billetera',
    'pending_withdraw_request' => 'Solicitud de Retiro Pendiente',
    'contact_number' => 'Número de Contacto',
    'drivers' => 'Conductores',
    'no_documents' => 'No hay Documentos de Conductor disponibles',
    'no_withdraw_requests' => 'No hay Solicitudes de Retiro disponibles',
    'vehicle_info' => 'No hay Información de Vehículo disponible',
    'total_rides' => 'Viajes Totales',
    'select_rental_vehicle' => 'Seleccionar Vehículo de Alquiler',
    'no_rental_message' => '*Para agregar un nuevo vehículo de alquiler, simplemente haz clic',
    'unverified_drivers' => 'Conductores No Verificados',
    'create' => 'Crear Conductor',
    'add' => 'Agregar Conductor',
    'edit_profile' => 'Editar Perfil',
    'document' => 'Documento',
    'driver_documents' => 'Documentos del Conductor',
    'add_driver' => 'Agregar Conductor',
    'edit' => 'Editar Conductor',
    'personal_information' => 'Información Personal',
    'role_permissions' => 'Rol y Permisos',
    'profile_image' => 'Imagen de Perfil',
    'full_name' => 'Nombre Completo',
    'email' => 'Correo Electrónico',
    'phone' => 'Teléfono',
    'other_details' => 'Otros Detalles',
    'field' => 'Campos',
    'value' => 'Valor',
    'add_new' => 'Agregar Nuevo',
    'unverified_driver' => 'Conductores No Verificados',
    'enter_full_name' => 'Ingresar Nombre Completo',
    'enter_email' => 'Ingresar Correo Electrónico',
    'role' => 'Rol',
    'verified_drivers' => 'Conductores Verificados',
    'enter_phone' => 'Ingresar Teléfono',
    'select_role' => 'Seleccionar Rol',
    'reviews' => 'Reseñas',
    'notification' => 'Notificar al Conductor',
    'sentence' => 'Enviar al nuevo conductor un correo electrónico sobre su cuenta.',
    'vehicle' => 'Vehículo',
    'vehicle_type' => 'Tipo de Vehículo',
    'model' => 'Modelo',
    'enter_model' => 'Ingresar Modelo de Vehículo',
    'plate_number' => 'Número de Placa',
    'enter_plate_number' => 'Ingresar Número de Placa del Vehículo',
    'select_vehicle' => 'Seleccionar Tipo de Vehículo',
    'seat' => 'Asiento',
    'enter_seat' => 'Ingresar Asiento del Vehículo',
    'color' => 'Color',
    'enter_color' => 'Ingresar Color del Vehículo',
    'publish' => 'Publicar',
    'payout_details' => 'Detalles de Pago',
    'bank_account_no' => 'Número de Cuenta Bancaria',
    'enter_bank_account' => 'Ingresar Número de Cuenta Bancaria',
    'bank_name' => 'Nombre del Banco',
    'enter_bank_name' => 'Ingresar Nombre del Banco',
    'holder_name' => 'Nombre del Titular',
    'enter_holder_name' => 'Ingresar Nombre del Titular',
    'swift' => 'Swift',
    'enter_swift_code' => 'Ingresar Código Swift',
    'routing_number' => 'Número de ruta',
    'enter_routing_number' => 'Ingrese el número de ruta',
    'enter_address' => 'Ingresar Dirección',
    'street_address' => 'Dirección de la Calle',
    'enter_street_address' => 'Ingresar Dirección de la Calle',
    'area_locality' => 'Área/Localidad',
    'no_zones_message' => '*Para agregar una nueva zona, simplemente haz clic',
    'enter_area_locality' => 'Ingresar Área o Localidad',
    'country' => 'País',
    'select_country' => 'Seleccionar País',
    'state' => 'Estado',
    'select_state' => 'Seleccionar Estado',
    'city' => 'Ciudad',
    'enter_city' => 'Ingresar Ciudad',
    'postal_code' => 'Código Postal',
    'zones' => 'Zonas',
    'vehicle_information' => 'Información del Vehículo',
    'rules' => 'Reglas del Conductor',
    'seats' => 'Asientos',
    'vehicle_color' => 'Color del Vehículo:',
    'vehicle_num' => 'Número del Vehículo:',
    'vehicle_types' => 'Tipo de Vehículo:',
    'no_vehicle_information' => 'No se Encontró Información del Vehículo',
    'zone' => 'Zona:',
    'no_zones' => 'No hay Zonas Disponibles',
    'bank_details' => 'Detalles Bancarios',
    'bank_names' => 'Nombre del Banco:',
    'ride_number' => 'Número de Viaje',
    'service' => 'Servicio',
    'service_category' => 'Categoría de Servicio',
    'ride_status' => 'Estado del Viaje',
    'payment_method' => 'Método de Pago',
    'payment_status' => 'Estado del Pago',
    'total_amount' => 'Monto Total',
    'holder_names' => 'Nombre del Titular:',
    'account_number' => 'Número de Cuenta',
    'other_info' => 'Otra Información:',
    'no_bank_details' => 'No se Encontraron Detalles Bancarios',
    'intercity_ride_list' => 'Viajes Interurbanos',
    'package_ride_list' => 'Viajes de Paquetes',
    'no_rides_available' => 'No hay Viajes Disponibles',
    'intracity_ride_list' => 'Viajes Intracitadinos',
    'no_intercity_rides' => 'No se encontraron viajes interurbanos',
    'no_intercity_rides_available' => 'No hay viajes interurbanos disponibles',
    'no_intracity_rides' => 'No se encontraron viajes intracitadinos',
    'no_intracity_rides_available' => 'No hay viajes intracitadinos disponibles',
    'no_schedule_rides' => 'No se encontraron viajes programados',
    'no_schedule_rides_available' => 'No hay viajes programados disponibles',
    'no_rental_rides' => 'No se encontraron viajes de alquiler',
    'no_rental_rides_available' => 'No hay viajes de alquiler disponibles',
    'scheduled_rides' => 'Viajes Programados',
    'rental_rides' => 'Viajes de Alquiler',
    'profile_details' => 'Detalles del Perfil',
    'wallet_balance' => 'Saldo de la Billetera',
    'select_zones' => 'Seleccionar Zonas',
    'enter_postal_code' => 'Ingresar Código Postal',
    'additional_info' => 'Información Adicional',
    'create_successfully' => 'Conductor Creado Exitosamente.',
    'update_successfully' => 'Conductor Actualizado Exitosamente.',
    'delete_successfully' => 'Conductor Eliminado Exitosamente.',
    'restore_successfully' => 'Conductor Restaurado Exitosamente.',
    'permanent_delete_successfully' => 'Conductor Eliminado Permanentemente Exitosamente.',
    'status_update_successfully' => 'Estado del Conductor Actualizado Exitosamente.',
    'system_reserved_not_editable' => 'Este conductor está reservado por el sistema y no es editable.',
    'system_reserved_not_deleted' => 'Este conductor está reservado por el sistema y no puede ser eliminado.',
    'driver_list' => 'Ubicación del Conductor',
    'live_location' => 'Ubicación en Vivo',
    'driver_location' => 'Ubicaciones de Conductores',
    'no_vehicle_type_message' => '*Para agregar un nuevo tipo de vehículo, simplemente haz clic',
    'current_driver_not_found' => 'Conductor actual no encontrado.',
    'driver_details' => 'Detalles del Conductor',
    'rider' => 'Pasajero',
    'category' => 'Categoría',
    'total' => 'Total',
    'created_at' => 'Creado En',
    'action' => 'Acción',
    'account_holder_name' => 'Nombre del Titular de la Cuenta',
    'swift_code' => 'Código Swift',
    'driver_rules' => 'Reglas del Conductor',
    'view_all' => 'Ver Todo',
    'rider_reviews' => 'Reseñas de Pasajeros',
    'rating' => 'Calificación',
    'message' => 'Mensaje',
    'withdraw_requests' => 'Solicitudes de Retiro',
    'amount' => 'Monto',
    'payment_type' => 'Tipo de Pago',
    'ambulance_name' => 'Nombre de la Ambulancia',
    'ambulance_description' => 'Descripción de la Ambulancia',
    'enter_ambulance_name' => 'Ingresar Nombre de la Ambulancia',
    'enter_ambulance_description' => 'Ingresar Descripción de la Ambulancia',
    'search_location' => 'Buscar una ubicación'
  ),
  'auth' =>
  array(
    'sended_otp_registered_numb' => 'Hemos enviado un OTP al número de teléfono registrado.',
    'sms_login_not_enable' => 'El método de inicio de sesión por SMS no está habilitado actualmente.',
    'invalid_auth_token' => 'El OTP proporcionado es inválido.',
    'no_account_linked' => 'No hay ninguna cuenta vinculada al número proporcionado.',
    'no_linked_number' => 'No hay ninguna cuenta vinculada al número proporcionado.',
    'disabled_account' => 'No puedes iniciar sesión con una cuenta desactivada.',
    'invalid_login_credentials' => 'Credenciales de inicio de sesión inválidas',
  ),
  'zones' =>
  array(
    'zones' => 'Zonas',
    'all' => 'Zonas',
    'name' => 'Nombre de la Zona',
    'select_payment_method' => 'Seleccionar Método de Pago',
    'payment_method' => 'Método de Pago',
    'enter_name' => 'Ingresar Nombre de la Zona',
    'coordinates' => 'Coordenadas',
    'place_points' => 'Puntos de Ubicación',
    'map' => 'Mapa',
    'search_location' => 'Buscar Ubicación',
    'search_locations' => 'Buscar tu Ubicación',
    'amount' => 'Monto',
    'enter_amount' => 'Ingresar Monto',
    'add' => 'Agregar Zona',
    'add_new' => 'Agregar Nuevo',
    'add_currency_message' => '*Para agregar una nueva moneda, simplemente haz clic',
    'select-zone' => 'Seleccionar Zona',
    'select_coordinates' => 'Seleccionar Coordenadas',
    'select_place_points' => 'Seleccionar Puntos de Ubicación',
    'distance_type' => 'Tipo de Distancia',
    'select_distance_type' => 'Seleccionar Tipo de Distancia',
    'currency' => 'Moneda',
    'select_currency' => 'Seleccionar Moneda',
    'create' => 'Crear Zona',
    'edit' => 'Editar Zona',
    'store' => 'Zona Agregada Exitosamente.',
    'restore_successfully' => 'Zona Restaurada Exitosamente.',
    'permanent_delete_successfully' => 'Zona Eliminada Permanentemente Exitosamente.',
    'created' => 'Zona Creada Exitosamente.',
    'updated' => 'Zona Actualizada Exitosamente.',
    'deleted' => 'Zona Eliminada Exitosamente.',
    'map_instruction_paragraph_1' => 'Necesitas al menos tres puntos para crear una zona.',
    'map_instruction_paragraph_2' => 'Comienza a agregar pines al mapa para delinear una zona.',
    'map_instruction_title' => 'Haz clic en el mapa para moverte a la ubicación deseada.',
    'map_instruction_heading' => 'Instrucciones',
  ),
  'heatmaps' =>
  array(
    'ride_request_heatmap' => 'Mapa de Calor de Solicitudes de Viaje',
    'heat_map' => 'Mapa de Calor',
    'text' => 'Este mapa de calor representa datos de solicitudes de viaje. Las áreas con mayor cantidad de solicitudes aparecen más calientes (rojo/naranja).',
    'heatmap' => 'Alternar Mapa de Calor',
    'gradient' => 'Cambiar Gradiente',
    'radius' => 'Cambiar Radio',
    'opacity' => 'Cambiar Opacidad'
  ),
  'riders' =>
  array(
    'all' => 'Todos los Pasajeros',
    'riders' => 'Pasajeros',
    'rider_details' => 'Detalles del Pasajero',
    'create' => 'Crear Pasajero',
    'add' => 'Agregar Pasajero',
    'add_riders' => 'Agregar Pasajeros',
    'edit' => 'Editar Pasajero',
    'role_permissions' => 'Rol y Permisos',
    'full_name' => 'Nombre Completo',
    'reviews' => 'Reseñas',
    'personal_information' => 'Información Personal',
    'email' => 'Correo Electrónico',
    'rating' => 'Calificación',
    'total_rides' => 'Viajes Totales Completados',
    'contact_number' => 'Número de Contacto',
    'emails' => 'Correo Electrónico',
    'driver' => 'Conductor',
    'created_at' => 'Creado En',
    'action' => 'Acción',
    'phone' => 'Teléfono',
    'zones' => 'Zonas',
    'no_reviews' => 'No hay reseñas disponibles',
    'description' => 'Descripción',
    'wallet' => 'Billetera',
    'city' => 'Ciudad',
    'no_rides' => 'No hay viajes disponibles',
    'driver_reviews' => 'Reseñas del Conductor',
    'country' => 'País',
    'parcel_otp_disabled' => 'OTP de paquete desactivado para completar el viaje.',
    'vehicle_information' => 'Información del Vehículo',
    'seats' => 'Asientos',
    'payment_method' => 'Método de Pago',
    'payment_status' => 'Estado del Pago',
    'total_amount' => 'Monto Total',
    'holder_names' => 'Nombre del Titular',
    'wallet_balance' => 'Saldo de la Billetera',
    'other_info' => 'Otra Información',
    'intercity_ride_list' => 'Viajes Interurbanos',
    'package_ride_list' => 'Viajes de Paquetes',
    'ride_list' => 'Viajes',
    'no_rides_available' => 'No hay Viajes Disponibles',
    'ride_number' => 'Número de Viaje',
    'account_holder_name' => 'Nombre del Titular',
    'bank_name' => 'Nombre del Banco',
    'account_number' => 'Número de Cuenta',
    'routing_code' => 'Número de ruta',
    'branch_name' => 'Nombre de la Sucursal',
    'swift_code' => 'Código Swift',
    'not_available' => 'No Disponible',
    'no_bank_details' => 'No hay detalles bancarios disponibles',
    'other_details' => 'Otros Detalles',
    'service' => 'Servicio',
    'service_category' => 'Categoría de Servicio',
    'ride_status' => 'Estado del Viaje',
    'intracity_ride_list' => 'Viajes Intracitadinos',
    'no_intercity_rides' => 'No se encontraron viajes interurbanos',
    'no_intercity_rides_available' => 'No hay viajes interurbanos disponibles',
    'no_intracity_rides' => 'No se encontraron viajes intracitadinos',
    'no_intracity_rides_available' => 'No hay viajes intracitadinos disponibles',
    'no_schedule_rides' => 'No se encontraron viajes programados',
    'no_schedule_rides_available' => 'No hay viajes programados disponibles',
    'no_rental_rides' => 'No se encontraron viajes de alquiler',
    'no_rental_rides_available' => 'No hay viajes de alquiler disponibles',
    'scheduled_rides' => 'Viajes Programados',
    'rental_rides' => 'Viajes de Alquiler',
    'profile_details' => 'Detalles del Perfil',
    'vehicle_color' => 'Color del Vehículo:',
    'vehicle_num' => 'Número del Vehículo',
    'vehicle_types' => 'Tipo de Vehículo:',
    'no_vehicle_information' => 'No se Encontró Información del Vehículo',
    'add_new' => 'Agregar Nuevo',
    'enter_full_name' => 'Ingresar Nombre Completo',
    'enter_email' => 'Ingresar Correo Electrónico',
    'role' => 'Rol',
    'confirm_password' => 'Confirmar Contraseña',
    'new_password' => 'Nueva Contraseña',
    'bank_details' => 'Detalles Bancarios',
    'enter_phone' => 'Ingresar Teléfono',
    'select_role' => 'Seleccionar Rol',
    'enter_password' => 'Ingresar Contraseña',
    'enter_confirm_password' => 'Ingresar Confirmación de Contraseña',
    'select_zones' => 'Seleccionar Zonas',
    'notification' => 'Notificar al Pasajero',
    'sentence' => 'Enviar al nuevo pasajero un correo electrónico sobre su cuenta.',
    'create_successfully' => 'Pasajero Creado Exitosamente.',
    'update_successfully' => 'Pasajero Actualizado Exitosamente.',
    'delete_successfully' => 'Pasajero Eliminado Exitosamente.',
    'name' => 'Nombre',
    'ratings' => 'Calificación',
    'restore_successfully' => 'Pasajero Restaurado Exitosamente.',
    'permanent_delete_successfully' => 'Pasajero Eliminado Permanentemente Exitosamente.',
    'status_update_successfully' => 'Estado del Pasajero Actualizado Exitosamente.',
    'system_reserved_not_editable' => 'Este pasajero está reservado por el sistema y no es editable.',
    'system_reserved_not_deleted' => 'Este pasajero está reservado por el sistema y no puede ser eliminado.',
  ),
  'banners' =>
  array(
    'id' => 'ID',
    'save' => 'Guardar',
    'banners' => 'Banners',
    'title' => 'Título',
    'action' => 'Acción',
    'banner' => 'Banner',
    'active' => 'Activo',
    'deactive' => 'Desactivado',
    'all_zones' => 'Todas las Zonas',
    'create' => 'Crear Banner',
    'image' => 'Imagen',
    'status' => 'Estado',
    'type' => 'Tipo de Banner',
    'category' => 'Categoría de Banner',
    'add_new' => 'Agregar Nuevo',
    'order' => 'Orden',
    'zones' => 'Zonas',
    'select_zones' => 'Seleccionar Zonas',
    'add' => 'Agregar Banner',
    'edit' => 'Editar Banner',
    'all' => 'Todos los Banners',
    'enter_title' => 'Ingresar Título',
    'enter_order' => 'Ingresar Orden del Banner',
    'message' => 'Mensaje',
    'create_successfully' => 'Banner Creado Exitosamente.',
    'update_successfully' => 'Banner Actualizado Exitosamente.',
    'delete_successfully' => 'Banner Eliminado Exitosamente.',
    'restore_successfully' => 'Banner Restaurado Exitosamente.',
    'permanent_delete_successfully' => 'Banner Eliminado Permanentemente Exitosamente',
    'status_update_successfully' => 'Estado del Banner Actualizado Exitosamente.',
    'no_zones_message' => '*Para agregar una nueva zona, simplemente haz clic',
    'recommended' => '*Se recomienda cargar imagen de tamaño 8268x4000px',
  ),
  'vehicle_types' =>
  array(
    'all_zones' => 'Todas las Zonas',
    'id' => 'Id',
    'name' => 'Nombre',
    'status' => 'Estado',
    'vehicle' => 'Tipo de Vehículo',
    'vehicles' => 'Tipos de Vehículos',
    'max_seat' => 'Asiento máximo',
    'enter_max_seat' => 'Ingrese el asiento máximo',
    'images' => 'Imágenes de Vehículos',
    'base_amount' => 'Monto Base',
    'vehicle_charge' => 'Carga del Vehículo',
    'total_per_distance_charge' => 'Carga Total por Distancia',
    'total_per_minute_charge' => 'Carga Total por Minuto',
    'enter_base_amount' => 'Ingresar Monto Base',
    'enter_name' => 'Ingresar Nombre',
    'message' => 'Mensaje',
    'example_3_rental' => 'Ejemplo 3: ALQUILER',
    'example_4_package' => 'Ejemplo 4: PAQUETE',
    'services' => 'Servicios',
    'select_services' => 'Seleccionar Servicios',
    'add' => 'Agregar Tipo de Vehículo',
    'image' => 'Imagen',
    'vehicle_image' => 'Imagen del Vehículo',
    'example_5_package' => 'Ejemplo 5: PAQUETE',
    'map_icon' => 'Ícono del Mapa del Vehículo',
    'service_categories' => 'Categorías de Servicio',
    'select_service_categories' => 'Seleccionar Categorías de Servicio',
    'edit' => 'Editar Tipo de Vehículo',
    'All' => 'Todos los Tipos de Vehículos',
    'commission_type' => 'Tipo de Comisión (porcentaje o fijo)',
    'commission_rate' => 'Tasa de Comisión (por ejemplo, 10% o $5)',
    'enter_commission_rate' => 'Ingresar Tasa de Comisión',
    'select_commission_type' => 'Seleccionar Tipo de Comisión',
    'min_per_unit_charge' => 'Carga mínima por kilómetro/milla',
    'max_per_unit_charge' => 'Carga máxima por kilómetro/milla',
    'enter_min_per_unit_charge' => 'Ingresar Carga Mínima por Unidad',
    'enter_max_per_unit_charge' => 'Ingresar Carga Máxima por Unidad',
    'waiting_time_charge' => 'Carga por minuto de tiempo de espera',
    'enter_waiting_time_charge' => 'Ingresar Carga por Espera',
    'cancellation_charge' => 'Carga fija por cancelación de viaje',
    'enter_cancellation_charge' => 'Ingresar Carga por Cancelación',
    'select_zones' => 'Seleccionar Zonas',
    'zones' => 'Zonas',
    'apply_service' => 'Aplicado en todos los servicios.',
    'apply_cab_and_freight_and_parcel_service' => 'Usado en servicios de TAXI, CARGA y PAQUETE.',
    'apply_cancel_service' => 'Aplicado en todos los servicios cuando se cancela un viaje.',
    'apply_cab_and_freight_service' => 'Aplicado en servicios de TAXI y CARGA.',
    'apply_package_and_rental_service' => 'Usado en servicios de PAQUETE y ALQUILER.',
    'apply_freight_and_parcel_service' => 'Usado en servicios de CARGA y PAQUETE.',
    'add_new' => 'Agregar Nuevo',
    'publish' => 'Publicar',
    'tax' => 'Impuesto',
    'select_tax' => 'Seleccionar Impuesto',
    'not_found_vehicles_by_points' => 'Tipo de Vehículo No Encontrado Basado en la Ubicación Proporcionada',
    'create_successfully' => 'Tipo de Vehículo Creado Exitosamente.',
    'update_successfully' => 'Tipo de Vehículo Actualizado Exitosamente.',
    'delete_successfully' => 'Tipo de Vehículo Eliminado Exitosamente.',
    'restore_successfully' => 'Tipo de Vehículo Restaurado Exitosamente.',
    'permanent_delete_successfully' => 'Tipo de Vehículo Eliminado Permanentemente Exitosamente',
    'status_update_successfully' => 'Estado del Tipo de Vehículo Actualizado Exitosamente.',
    'no_zones_message' => '*Para agregar una nueva zona, simplemente haz clic',
    'no_tax_message' => '*Para agregar un nuevo impuesto, simplemente haz clic',
    'min_per_min_charge' => 'Carga mínima por minuto',
    'max_per_min_charge' => 'Carga máxima por minuto',
    'enter_min_per_min_charge' => 'Ingresar Carga Mínima por Minuto',
    'enter_max_per_min_charge' => 'Ingresar Carga Máxima por Minuto',
    'min_per_weight_charge' => 'Carga mínima por kilogramo',
    'max_per_weight_charge' => 'Carga máxima por kilogramo',
    'enter_min_per_weight_charge' => 'Ingresar Carga Mínima por Peso',
    'enter_max_per_weight_charge' => 'Ingresar Carga Máxima por Peso',
    'no_vehicle_types_found' => 'No se encontraron tipos de vehículos',
    'search_vehicle_types' => 'Buscar Tipos de Vehículos',
    'fare_calculation_instructions' => 'Instrucciones de Cálculo de Tarifas',
    'key_fields_and_usage' => 'Campos Clave y su Uso',
    'field' => 'Campo',
    'description' => 'Descripción',
    'where_used' => 'Dónde se Usa',
    'tax_id' => 'Tasa de impuesto aplicada a la tarifa',
    'bidding_details' => 'Detalles de Puja',
    'example_calculation' => 'Cálculos de Ejemplo',
    'bidding_description' => 'La puja se usa en servicios de TAXI y CARGA cuando la configuración activation.bidding está habilitada.',
    'bidding_active' => 'Si la puja está activa, la tarifa se determina por la oferta del conductor.',
    'bidding_inactive' => 'Si la puja está inactiva, la tarifa se calcula basándose en min_per_unit_charge y max_per_unit_charge.',
    'example_1' => 'Ejemplo 1: TAXI/VIAJE',
    'scenario' => 'Escenario',
    'scenario_description' => 'Un viaje de 15 km con una tarifa base de $20.',
    'calculation' => 'Cálculo',
    'minimum_distance_charge' => 'Carga Mínima por Distancia',
    'minimum_distance_charge_amount' => '15 km * $1.5/km = $22.5',
    'fare_amount' => 'Dado que $22.5 > $20, la tarifa es $22.5.',
    'example_2' => 'Ejemplo 2: CARGA/INTERURBANO',
    'freight_scenario_description' => 'Una entrega de carga de 50 km con 100 kg de peso.',
    'freight_distance_charge' => '50 km * $1.5/km = $75',
    'freight_total_fare' => 'Tarifa Total (interurbano)',
    'freight_fare_amount' => '$75',
    'distance_charge' => 'Carga por Distancia',
    'weight_charge' => 'Carga por Peso',
    'total_fare' => 'Tarifa Total',
    'prev_button' => 'Anterior',
    'next_button' => 'Siguiente',
    'calculated' => '¿Cómo se calcula esto?',
    'rental_scenario_description' => 'Viaje de alquiler por 2 días con 3 días de cargos adicionales por minuto.',
    'rental_vehicle_charge' => '20 * 2 días = $50',
    'rental_total_per_minute_charge' => '10 * 3 días = $604',
    'rental_fare_amount' => '$50 + $604 = $654',
    'package_scenario_description' => 'Una entrega de paquete con 10 km de distancia y 20 km de cargos por minuto.',
    'package_distance_charge' => '10 km * $3/km = $30',
    'package_minute_charge' => '20 km * $3/min = $60',
    'package_fare_amount' => '$30 + $60 = $90',
    'parcel_scenario_description' => 'Una entrega de paquete con 10 km de distancia y 20 km de cargos por minuto.',
    'parcel_distance_charge' => '50 km * $2.0/km = $100',
    'parcel_weight_charge' => '100 kg * $1.0/kg = $100',
    'parcel_fare_amount' => '$100 + $100 = $200'
  ),
  'documents' =>
  array(
    'document' => 'Documento',
    'documents' => 'Documentos',
    'all' => 'Todos los Documentos',
    'edit' => 'Editar Documento',
    'add_new' => 'Agregar Nuevo',
    'add_document' => 'Agregar Documento',
    'message' => 'Mensaje',
    'name' => 'Nombre',
    'enter_name' => 'Ingresar nombre',
    'enter_number' => 'Ingresar número',
    'is_required' => 'Es Requerido',
    'status' => 'Estado',
    'create_successfully' => 'Documento Creado Exitosamente.',
    'update_successfully' => 'Documento Actualizado Exitosamente.',
    'delete_successfully' => 'Documento Eliminado Exitosamente.',
    'status_update_successfully' => 'Estado del Documento Actualizado Exitosamente.',
    'status_update_note' => '¿Está seguro de que desea actualizar el estado del documento?',
    'permanent_delete_successfully' => 'Documento Eliminado Permanentemente Exitosamente.',
    'restore_successfully' => 'Documento Restaurado Exitosamente.',
    'need_expired_date' => 'Necesita fecha de vencimiento',
    'type' => 'Tipo',
    'select_type' => 'Seleccionar tipo',
  ),
  'driver_documents' =>
  array(
    'driverDocument' => 'Documento del Conductor',
    'driver_documents' => 'Documentos del Conductor',
    'all' => 'Todos los Documentos del Conductor',
    'edit' => 'Editar Documento del Conductor',
    'add_new' => 'Agregar Nuevo',
    'add' => 'Agregar Documento del Conductor',
    'driver' => 'Conductor',
    'select_driver' => 'Seleccionar Conductor',
    'document' => 'Documento',
    'select_document' => 'Seleccionar Documento',
    'document_image' => 'Imagen del Documento',
    'save' => 'Guardar',
    'status' => 'Estado',
    'select_status' => 'Seleccionar Estado del Documento',
    'approved' => 'Aprobado',
    'rejected' => 'Rechazado',
    'pending' => 'Pendiente',
    'create_successfully' => 'Documento del Conductor Creado Exitosamente.',
    'update_successfully' => 'Documento del Conductor Actualizado Exitosamente.',
    'delete_successfully' => 'Documento del Conductor Eliminado Exitosamente.',
    'status_update_successfully' => 'Estado del Documento del Conductor Actualizado Exitosamente.',
    'permanent_delete_successfully' => 'Documento del Conductor Eliminado Permanentemente Exitosamente.',
    'restore_successfully' => 'Documento del Conductor Restaurado Exitosamente.',
    'no_documents_message' => '*Para agregar un nuevo documento, simplemente haz clic',
    'add_driver_message' => '*Para agregar un nuevo conductor, simplemente haz clic',
    'document_id' => 'ID del Documento',
  ),
  'coupons' =>
  array(
    'all' => 'Todos los Cupones',
    'coupon' => 'Cupón',
    'coupons' => 'Cupones',
    'title' => 'Título',
    'usage' => 'Uso',
    'code' => 'Código',
    'services' => 'Seleccionar Servicios',
    'add_coupon' => 'Agregar Cupón',
    'edit_coupon' => 'Editar Cupón',
    'action' => 'Acción',
    'add_new' => 'Agregar Nuevo',
    'enter_title' => 'Ingresar Título',
    'enter_description' => 'Ingresar Descripción',
    'enter_coupon' => 'Ingresar Cupón',
    'enter_code' => 'Ingresar Código',
    'description' => 'Descripción',
    'type' => 'Tipo',
    'select_type' => 'Seleccionar Tipo',
    'amount' => 'Monto',
    'select_date' => 'Seleccionar Fecha',
    'select_start_date' => 'Seleccionar Fecha de Inicio',
    'select_end_date' => 'Seleccionar Fecha de Fin',
    'enter_price' => 'Ingresar Precio',
    'start_date' => 'Fecha de Inicio',
    'end_date' => 'Fecha de Fin',
    'select_service_category' => 'Seleccionar Categoría de Servicio',
    'select_service_categories' => 'Seleccionar Categorías de Servicio',
    'select_service' => 'Seleccionar Servicios',
    'select_services' => 'Seleccionar Servicios',
    'percentage' => 'Porcentaje',
    'enter_amount' => 'Ingresar Monto',
    'enter_percentage' => 'Ingresar Porcentaje',
    'is_expired' => 'Está Expirado',
    'status' => 'Estado',
    'select_riders' => 'Seleccionar Pasajeros',
    'general' => 'General',
    'is_apply_all' => 'Se Aplica a Todos',
    'select_zones' => 'Seleccionar Zonas',
    'select_rider' => 'Seleccionar Pasajeros',
    'service_category' => 'Categoría de Servicio',
    'zone' => 'Zona',
    'select_vehicle_type' => 'Seleccionar Tipos de Vehículos',
    'vehicle_type' => 'Tipo de Vehículo',
    'restriction' => 'Restricción',
    'minimum_ride_fare' => 'Tarifa Mínima de Viaje',
    'enter_minimum_ride_fare' => 'Ingresar Tarifa Mínima de Viaje',
    'is_unlimited' => 'Es Ilimitado',
    'usage_per_coupon' => 'Uso por Cupón',
    'usage_per_rider' => 'Uso por Pasajero',
    'enter_value' => 'Ingresar Valor',
    'no_riders_message' => '*Para agregar un nuevo pasajero, simplemente haz clic',
    'no_zones_message' => '*Para agregar una nueva zona, simplemente haz clic',
    'no_vehicleType_message' => '*Para agregar un nuevo tipo de vehículo, simplemente haz clic',
    'create_successfully' => 'Cupón Creado Exitosamente.',
    'update_successfully' => 'Cupón Actualizado Exitosamente.',
    'delete_successfully' => 'Cupón Eliminado Exitosamente.',
    'status_update_successfully' => 'Estado del Cupón Actualizado Exitosamente.',
    'permanent_delete_successfully' => 'Cupón Eliminado Permanentemente Exitosamente.',
    'restore_successfully' => 'Cupón Restaurado Exitosamente.',
    'to_apply_coupon' => 'Para aplicar el código de cupón :code, el total de tu viaje debe ser :min_spend o superior.',
    'coupon_feature_disabled' => 'El código de cupón no se puede usar ya que la función de cupones está actualmente desactivada.',
    'login_required' => 'Necesitas iniciar sesión para aplicar este código de cupón :code.',
    'usage_limit_reached' => 'El código de cupón :code solo se puede usar hasta :usage veces por cupón.',
    'date_range' => 'El código de cupón :code fue aplicable desde :start_date hasta :end_date',
    'to' => 'hasta',
  ),
  'rides' =>
  array(
    'rides' => 'Viajes',
    'this_rental_vehicle_already_booked' => 'Este Vehículo de Alquiler Ya Está Reservado.',
    'rental_ride_request_not_found' => 'Esta Solicitud de Viaje de Alquiler No Se Encontró.',
    'ride_request_create_successfully' => 'Solicitud de Viaje Creada Exitosamente',
    'ride_fare' => 'Tarifa del Viaje',
    'start_date' => 'Fecha de Inicio',
    'extra_charge' => 'Cargo Extra',
    'add_location' => 'Agregar Ubicación',
    'receiver_phone' => 'Teléfono del Receptor de Paquete',
    'enter_receiver_phone' => 'Ingresar Teléfono del Receptor de Paquete',
    'start_time' => 'Hora de Inicio',
    'select_drivers' => 'Seleccionar Conductores',
    'driver_no' => 'Asignar Número de Conductor',
    'receiver_full_name' => 'Nombre Completo del Receptor de Paquete',
    'enter_receiver_full_name' => 'Ingresar Nombre Completo del Receptor de Paquete',
    'drivers' => 'Conductores',
    'ambulance_name' => 'Nombre de la Ambulancia',
    'ambulance' => 'Ambulancia',
    'select_ambulance' => 'Seleccionar Ambulancia',
    'no_of_days' => 'Número de Días',
    'riderequests' => 'Solicitudes de Viaje',
    'ride_requests' => 'Todas las Solicitudes de Viaje',
    'locations_empty' => 'La ubicación es requerida',
    'ride_request_details' => 'Detalles de la Solicitud de Viaje',
    'minimum_2_locations_required' => 'Se requieren al menos 2 coordenadas de ubicación',
    'location_coordinates_empty' => 'Se requieren coordenadas de ubicación',
    'select_payment_method' => 'Seleccionar Método de Pago',
    'weight' => 'Peso',
    'cargo_image' => 'Imagen de Carga',
    'vehicle_name' => 'Nombre del Vehículo',
    'assign_driver_name' => 'Asignar Nombre del Conductor',
    'assign_driver_no' => 'Asignar Número de Conductor',
    'vehicle_registration_no' => 'Número de Registro del Vehículo',
    'enter_weight' => 'Ingresar Peso',
    'create' => 'Crear Viaje',
    'ambulance_not_found' => 'Ambulancia no encontrada o conductor no asignado.',
    'ambulance_location_not_found' => 'Ubicación de la ambulancia no disponible.',
    'distance_not_found' => 'No se pudo calcular la distancia entre el pasajero y la ambulancia.',
    'location_coordinates_not_array' => 'Las coordenadas de ubicación deben ser un arreglo.',
    'all' => 'Todos los Viajes',
    'create_ride' => 'Crear Viaje',
    'rider_details' => 'Detalles del Pasajero',
    'locations' => 'Ubicaciones',
    'enter_locations' => 'Ingresar Ubicaciones',
    'enter_destination_location' => 'Ingresar Ubicación de Destino',
    'destination_location' => 'Ubicación de Destino',
    'pickup_location' => 'Ubicación de Recogida',
    'enter_pickup_location' => 'Ingresar Ubicación de Recogida',
    'rider' => 'Pasajero',
    'start_address' => 'Dirección de Inicio',
    'end_address' => 'Dirección de Fin',
    'service' => 'Servicio',
    'select_service' => 'Seleccionar Servicio',
    'service_category' => 'Categoría de Servicio',
    'select_service_category' => 'Seleccionar Categoría de Servicio',
    'driver' => 'Conductor',
    'only_driver_can_accept_ride_request_directly' => 'Solo el Conductor Puede Aceptar la Solicitud de Viaje Directamente',
    'ride_request' => 'La solicitud de viaje es inválida.',
    'general_detail' => 'Detalles Generales',
    'billing_detail' => 'Detalles de Facturación',
    'service_detail' => 'Detalles del Servicio',
    'location_detail' => 'Detalles de la Ubicación',
    'price_detail' => 'Detalles del Precio',
    'ride_details' => 'Detalles del Viaje',
    'general_details' => 'Detalles Generales',
    'ride_number' => 'Número de Viaje',
    'start_date_time' => 'Fecha y Hora de Inicio',
    'end_date_time' => 'Fecha y Hora de Fin',
    'payment_status' => 'Estado del Pago',
    'otp' => 'OTP para Iniciar Viaje',
    'parcel_otp' => 'OTP para Entrega de Paquete',
    'ride_distance' => 'Distancia Total',
    'zone' => 'Zona',
    'payment_method' => 'Método de Pago',
    'driver_detail' => 'Detalles del Conductor',
    'ride_reviews' => 'Reseñas del Viaje',
    'customer_reviews' => 'Reseñas del Cliente',
    'customer_review' => 'Reseña del Cliente',
    'driver_reviews' => 'Reseñas del Conductor',
    'map_view' => 'Vista de Mapa',
    'biding_drivers_list' => 'Lista de Conductores en Puja',
    'complaints' => 'Quejas',
    'greatest_ride' => 'El Mejor Viaje',
    'no_reviews_found' => 'No se Encontraron Reseñas',
    'no_complaints_found' => 'No se Encontraron Quejas',
    'ride_id' => 'Número de Viaje',
    'ride_status' => 'Estado del Viaje',
    'total_amount' => 'Monto Total',
    'date_time' => 'Fecha y Hora:',
    'transaction_id' => 'ID de Transacción',
    'offer_price' => 'Precio de Oferta',
    'final_price' => 'Precio Final',
    'tax_calculation' => 'Cálculo de Impuestos',
    'igst' => 'IGST',
    'cgst' => 'CGST',
    'notes' => '',
    'receiver_name' => 'Nombre del Receptor de Paquete',
    'receiver_email' => 'Correo Electrónico del Receptor de Paquete',
    'receiver_no' => 'Número del Receptor de Paquete',
    'name' => 'Nombre:',
    'payable_amount' => 'Monto a Pagar',
    'total_after_commission' => 'Total (Después de la Comisión del Administrador)',
    'ride_type' => 'Tipo de Viaje',
    'ride_time' => 'Tiempo de Viaje',
    'pickup_time' => 'Hora de Recogida',
    'dropoff_time' => 'Hora de Entrega',
    'driver_name' => 'Nombre del Conductor',
    'driver_email' => 'Correo Electrónico del Conductor',
    'driver_phone' => 'Teléfono del Conductor',
    'vehicle_model' => 'Modelo del Vehículo',
    'parcel_otps' => 'OTP de Paquete',
    'customer_name' => 'Nombre del Cliente',
    'customer_email' => 'Correo Electrónico del Cliente',
    'customer_phone' => 'Teléfono del Cliente',
    'payment_date' => 'Fecha de Pago',
    'payment_reference' => 'Referencia de Pago',
    'transaction_status' => 'Estado de la Transacción',
    'additional_charges' => 'Cargos Adicionales',
    'discount' => 'Descuento',
    'currency' => 'Moneda',
    'email' => 'Correo Electrónico',
    'phone' => 'Teléfono',
    'vehicle_type' => 'Tipo de Vehículo',
    'vehicle_number' => 'Número de Vehículo:',
    'vehicle_not_found' => '¡Vehículo No Encontrado!',
    'zones' => 'Zonas:',
    'ride_price' => 'Precio del Viaje',
    'only_assigned_driver' => 'Solo el conductor asignado puede actualizar el viaje.',
    'ride_cannot_cancel' => 'Después de que el viaje ha comenzado, no se puede cancelar.',
    'invalid_otp' => 'OTP inválido para iniciar el viaje.',
    'user_must_be_driver' => 'El usuario debe ser conductor para iniciar un viaje.',
    'payment_module_not_found' => 'El módulo de pago seleccionado no se encontró o no está habilitado.',
    'invalid_payment_method' => 'Método de pago inválido.',
    'invalid_details' => 'Detalles de pago inválidos.',
    'payment_methods_not_found' => 'Método de pago no encontrado.',
    'negative_wallet_balance' => 'No se puede crear la solicitud de viaje debido a un saldo de billetera negativo.',
    'ride_requests_not_accepted' => 'No se aceptan solicitudes de viaje en esta zona.',
    'no_driver_available' => 'No hay conductores disponibles en esta zona.',
    'update_permission' => 'Solo puedes actualizar las solicitudes de viaje que creaste.',
    'failed_to_create_ride' => 'No se pudo crear el viaje.',
    'ride_already_cancelled' => 'Este viaje ya ha sido cancelado y no se puede actualizar.',
    'no_zone_ids' => 'Proporciona IDs de zona para ver las solicitudes de viaje cuando inicies sesión como conductor.',
    'status_overviews' => 'Resumen del Estado del Viaje',
    'requested' => 'Viajes Solicitados',
    'pending' => 'Viajes Pendientes',
    'completed' => 'Viajes Completados',
    'cancelled' => 'Viajes Cancelados',
    'scheduled' => 'Viajes Programados',
    'accepted' => 'Viajes Aceptados',
    'started' => 'Viajes Iniciados',
    'arrived' => 'Viajes Llegados',
    'pos' => 'POS',
    'hourly_package' => 'Paquete por Horas',
    'select_package' => 'Seleccionar Paquete por Horas',
    'rejected' => 'Rechazado',
    'service_not_allow_for_vehicle' => 'El servicio seleccionado no está disponible para :vehicleType',
    'category_not_allow_for_vehicle' => 'La categoría de servicio seleccionada no está disponible para :vehicleType',
    'select_start_date_and_time' => 'Seleccionar fecha y hora de inicio',
    'select_end_date_and_time' => 'Seleccionar fecha y hora de fin',
    'total_biddings' => 'Pujas Totales',
    'biddings' => 'Pujas',
    'driver_information' => 'Información del Conductor',
    'rating' => 'Calificación',
    'contact_number' => 'Número de Contacto',
    'rider_information' => 'Información del Pasajero',
    'price_details' => 'Detalles del Precio',
    'view_all' => 'Ver Todo',
    'vehicle_charge' => 'Carga del Vehículo',
    'driver_charge' => 'Carga del Conductor',
    'processing_fee' => 'Tarifa de Procesamiento',
    'platform_fee' => 'Tarifa de Plataforma',
    'subtotal' => 'Subtotal',
    'coupon_discount' => 'Descuento de Cupón',
    'tax' => 'Impuesto',
    'tip' => 'Propina',
    'total' => 'Total',
    'location_details' => 'Detalles de la Ubicación',
    'rider_reviews' => 'Reseñas del Pasajero',
    'description' => 'Descripción',
    'bidding_request' => 'Solicitud de Puja',
    'amount' => 'Monto',
    'status' => 'Estado',
    'rental_vehicle' => 'Vehículo de Alquiler',
    'assigned_driver_name' => 'Nombre del Conductor Asignado',
    'assigned_driver_no' => 'Número del Conductor Asignado',
    'days' => 'días',
    'admin_commission' => 'Comisión del Administrador',
    'driver_commission' => 'Comisión del Conductor',
    'driver_tip' => 'Propina del Conductor',
    'bill_summary' => 'Resumen de Facturación',
    'invoice' => 'Factura',
    'read_more' => 'Leer Más',
    'read_less' => 'Leer Menos',
    'cancellation_reason' => 'Razón de Cancelación',
    'default_cancel_reason' => 'No se proporcionó ninguna razón',
    'download_invoice' => 'Descargar Factura',
    'vehicle_charges' => 'Cargas del Vehículo',
    'driver_charges' => 'Cargas del Conductor',
    'comments' => 'Comentarios',
    'no_comments' => 'No hay comentarios disponibles',
    'total_per_distance_charge' => 'Carga Total por Distancia',
    'total_per_minute_charge' => 'Carga Total por Minuto',
    'vehicle_per_day_price' => 'Precio por Día del Vehículo',
    'note' => 'Nota',
    'no_drivers_found' => 'No se encontraron controladores',
  ),
  'invoice' =>
  array(
    'date' => 'Fecha',
    'invoice_to' => 'Facturado a',
    'name' => 'Nombre',
    'rider_contact' => 'Contacto del Pasajero',
    'ride_details' => 'Detalles del Viaje',
    'service' => 'Servicio',
    'pickup_time' => 'Hora de Recogida',
    'pickup_location' => 'Ubicación de Recogida',
    'drop_off_location' => 'Ubicación de Entrega',
    'vehicle_driver_info' => 'Información del Vehículo y Conductor',
    'vehicle_type' => 'Tipo de Vehículo',
    'vehicle_number' => 'Número de Vehículo',
    'driver_name' => 'Nombre del Conductor',
    'driver_contact' => 'Contacto del Conductor',
    'description' => 'Descripción',
    'rate_unit' => 'Tarifa/Unidad',
    'quantity' => 'Cantidad',
    'payment_details' => 'Detalles de Pago',
    'payment_method' => 'Método de Pago',
    'payment_status' => 'Estado del Pago',
    'amount' => 'Monto',
    'total' => 'Total',
    'base_fare' => 'Tarifa Base',
    'distance_fare' => 'Tarifa por Distancia',
    'taxes' => 'Impuestos',
    'thank_you' => '¡Gracias!',
    'thank_you_msg' => 'Gracias por elegirnos. ¡Esperamos servirte de nuevo! Para comentarios o quejas.',
    'driver_tips' => 'Propina del Conductor',
    'tax' => 'Impuesto',
    'platform_fee' => 'Tarifa de Plataforma',
    'processing_fee' => 'Tarifa de Procesamiento',
    'coupon_discount' => 'Descuento de Cupón',
    'driver_commission' => 'Comisión del Conductor',
  ),
  'locations' =>
  array(
    'locations' => 'Ubicaciones',
    'status' => 'Estado del Conductor',
    'all' => 'Todos',
    'driver_location' => 'Ubicación del Conductor',
    'select_zone' => 'Seleccionar Zona',
    'zone' => 'Zona',
    'filters' => 'Filtros',
    'unrated' => 'Sin Calificación',
    'online' => 'En Línea',
    'onride' => 'En Viaje',
    'offline' => 'Fuera de Línea',
    'taxi_drivers' => 'Conductores',
    'view_location' => 'Ver Ubicación',
    'search_driver' => 'Buscar Conductor',
    'id' => 'ID',
    'service' => 'Servicio:',
    'service_category' => 'Categoría de Servicio:',
    'start_time' => 'Hora de Inicio:',
    'distance' => 'Distancia:',
    'duration' => 'Duración:',
    'min' => 'min',
    'view_more' => 'Ver Más',
    'rider_details' => 'Detalles del Pasajero',
    'no_rides_yet' => 'Aún No Hay Viajes',
    'refresh' => 'Actualizar',
  ),
  'soses' =>
  array(
    'all' => 'Todos',
    'soses' => 'SOS',
    'sos' => 'SOS',
    'alert_id' => 'Alerta SOS',
    'sos_status' => 'Estado SOS',
    'status' => 'Estado',
    'created_by' => 'Creado Por',
    'alert_time' => 'Hora de Alerta',
    'location' => 'Ubicación',
    'location_map' => 'Mapa de Ubicación',
    'title' => 'Título',
    'all_zones' => 'Todas las Zonas',
    'enter_title' => 'Ingresar Título',
    'add_new' => 'Agregar Nuevo',
    'add_sos' => 'Agregar SOS',
    'select_zones' => 'Seleccionar Zonas',
    'phone' => 'Teléfono',
    'sos_alerts' => 'Alertas SOS',
    'enter_phone' => 'Ingresar Teléfono',
    'sos_details' => 'Detalles de la Alerta SOS',
    'add' => 'Agregar SOS',
    'edit' => 'Editar SOS',
    'description' => 'Descripción',
    'enter_description' => 'Ingresar Descripción',
    'create_successfully' => 'SOS Creado Exitosamente.',
    'update_successfully' => 'SOS Actualizado Exitosamente.',
    'delete_successfully' => 'SOS Eliminado Exitosamente.',
    'status_update_successfully' => 'Estado SOS Actualizado Exitosamente.',
    'permanent_delete_successfully' => 'SOS Eliminado Permanentemente Exitosamente.',
    'restore_successfully' => 'SOS Restaurado Exitosamente.',
    'sos_image' => 'Imagen SOS',
    'zones' => 'Zonas',
    'no_zones_message' => '*Para agregar una nueva zona, simplemente haz clic',
  ),
  'driver_rules' =>
  array(
    'all' => 'Todos',
    'driverRule' => 'Regla del Conductor',
    'driver_rules' => 'Reglas del Conductor',
    'title' => 'Título',
    'add_new' => 'Agregar Nuevo',
    'enter_title' => 'Ingresar Título',
    'add_driverRule' => 'Agregar Regla del Conductor',
    'add' => 'Agregar Regla del Conductor',
    'edit' => 'Editar Regla del Conductor',
    'description' => 'Descripción',
    'select_vehicle_type' => 'Seleccionar Tipo de Vehículo',
    'image' => 'Imagen de Regla',
    'save' => 'Guardar',
    'status' => 'Estado',
    'create_successfully' => 'Regla del Conductor Creada Exitosamente.',
    'update_successfully' => 'Regla del Conductor Actualizada Exitosamente.',
    'delete_successfully' => 'Regla del Conductor Eliminada Exitosamente.',
    'status_update_successfully' => 'Estado de la Regla del Conductor Actualizado Exitosamente.',
    'permanent_delete_successfully' => 'Regla del Conductor Eliminada Permanentemente Exitosamente.',
    'restore_successfully' => 'Regla del Conductor Restaurada Exitosamente.',
    'no_vehicleType_message' => '*Para agregar un nuevo tipo de vehículo, simplemente haz clic',
  ),
  'services' =>
  array(
    'all' => 'Todos',
    'service' => 'Servicio',
    'services' => 'Servicios',
    'name' => 'Nombre',
    'enter_name' => 'Ingresar Nombre',
    'type' => 'Tipo',
    'add_new' => 'Agregar Nuevo',
    'is_primary' => 'Primario',
    'add' => 'Agregar Servicio',
    'cab' => 'Taxi',
    'parcel' => 'Paquete',
    'freight' => 'Carga',
    'edit' => 'Editar Servicio',
    'select_type' => 'Seleccionar Tipo',
    'save' => 'Guardar',
    'image' => 'Imagen',
    'icon' => 'Ícono',
    'cab_description' => 'Usado para viajes interurbanos',
    'parcel_description' => 'Para viajes interurbanos suaves y confiables',
    'create_successfully' => 'Servicio Creado Exitosamente.',
    'update_successfully' => 'Servicio Actualizado Exitosamente.',
    'status_update_successfully' => 'Estado del Servicio Actualizado Exitosamente.',
  ),
  'service_categories' =>
  array(
    'all' => 'Todos',
    'serviceCategory' => 'Categorías de Servicio',
    'name' => 'Nombre',
    'select_services' => 'Seleccionar Servicios',
    'services' => 'Servicios',
    'service' => 'Servicio',
    'vehicles' => 'Vehículos',
    'select_service' => 'Seleccionar Servicio',
    'description' => 'Descripción',
    'cab' => 'Categorías de Servicio',
    'parcel' => 'Categorías de Servicio',
    'freight' => 'Categorías de Servicio',
    'enter_description' => 'Ingresar Descripción',
    'intercity_desc' => 'Opciones de viaje de larga distancia que conectan ciudades, ideales tanto para pasajeros como para envíos de carga.',
    'scheduled_dec' => 'Servicios de transporte programados para viajes planificados, ofreciendo opciones tanto para pasajeros como para carga.',
    'package_dec' => 'Servicios de entrega de paquetes para paquetes pequeños y grandes, asegurando un transporte oportuno y seguro.',
    'intracity_dec' => 'Para viajes intracitadinos suaves y confiables',
    'rental_desc' => 'Alquileres de vehículos para uso a corto o largo plazo, adecuados para requisitos personales o comerciales.',
    'scheduled_desc' => 'Reserva previa de viajes para mayor comodidad',
    'enter_name' => 'Ingresar Nombre',
    'edit' => 'Editar Categoría de Servicio',
    'type' => 'Tipo',
    'select_type' => 'Seleccionar Tipo',
    'save' => 'Guardar',
    'service_image' => 'Imagen',
    'create_successfully' => 'Categoría de Servicio Creada Exitosamente.',
    'update_successfully' => 'Categoría de Servicio Actualizada Exitosamente.',
    'status_update_successfully' => 'Estado de la Categoría de Servicio Actualizado Exitosamente.',
    'restore_successfully' => 'Categoría de Servicio Restaurada Exitosamente.',
  ),
  'settings' =>
  array(
    'settings' => 'Configuraciones',
    'greeting' => 'Saludos',
    'fleet_commission_rate' => 'Tasa de Comisión de Flota',
    'fleet_commission_type' => 'Tipo de Comisión de Flota',
    'select_fleet_commission_type' => 'Seleccionar Tipo de Comisión de Flota',
    'enter_fleet_commission_rate' => 'Ingresar Tasa de Comisión de Flota',
    'footer_hashtag' => 'Hashtag de Pie de Página',
    'footer_hashtag_help' => 'Ingresa el hashtag de marca (#GoTaxido) para mostrar en el pie de página de la aplicación',
    'enter_hashtag' => '#GoTaxido',
    'driver_verification' => 'Verificación de Conductor',
    'driver_verifications_span' => 'La verificación de conductores se habilitará solo después de verificar todos los documentos de vehículo requeridos.',
    'footer_attribution' => 'Atribución de Pie de Página',
    'footer_attribution_help' => 'Ingresa el crédito del desarrollador (❤️ Hecho por Pixelstrap) para mostrar en el pie de página de la aplicación',
    'enter_attribution' => '❤️ Hecho por Pixelstrap',
    'fleet_commission_span' => 'Selecciona el tipo de comisión para los gerentes de flota: tasa fija o basada en porcentaje.',
    'fleet_commission_rate_span' => 'Establece la tasa de comisión que los propietarios de flotas reciben por viaje, ya sea como un valor fijo o un porcentaje de la tarifa total.',
    'enter_greeting' => 'Ingresar Mensaje de Saludo',
    'add_greeting' => 'Agregar',
    'google_map_api_key' => 'Clave de API de Google Maps',
    'enter_google_map_api_key' => 'Ingresar Clave de API de Google Maps',
    'splash_screen' => 'Pantalla de Inicio de Usuario',
    'splash_driver_screen' => 'Pantalla de Inicio de Conductor',
    'ride_settings' => 'Configuraciones de Viaje',
    'app_settings' => 'Configuraciones de la Aplicación',
    'driver_min_wallet_balance' => 'Saldo mínimo de la billetera del conductor',
    'enter_driver_min_wallet_balance' => 'Ingrese el saldo mínimo de billetera para la conductora',
    'driver_min_wallet_balance_help' => 'Establezca el saldo mínimo de billetera que debe mantener un conductor para recibir solicitudes de viaje.',
    'test_map' => 'Probar Mapa',
    'map_preview' => 'Vista Previa del Mapa',
    'ambulance_per_km_charge_span' => 'Establece el costo cobrado por kilómetro para viajes en ambulancia',
    'ambulance_commission_span' => 'Selecciona el tipo de comisión para servicios de ambulancia: tasa fija o basada en porcentaje.',
    'ambulance_commission_rate_span' => 'Establece la tasa de comisión para conductores en servicios de ambulancia, ya sea como una tarifa fija o un porcentaje de la tarifa.',
    'force_update_span' => 'Requiere que los usuarios actualicen la aplicación a la última versión antes de continuar.',
    'fleet_wallet' => 'Habilitar Billetera de Flota',
    'fleet_wallets' => 'Habilita la Billetera de Flota para que los propietarios de flotas gestionen ganancias, pagos a conductores y transacciones fácilmente.',
    'app_configuration' => 'Configuración de la Aplicación',
    'driver_app_version' => 'Versión de la Aplicación de Conductor',
    'app_version' => 'Versión de la Aplicación de Usuario',
    'user_app_span' => 'Versión mínima de la aplicación necesaria para los usuarios. Las versiones anteriores pueden no funcionar correctamente.',
    'driver_app_span' => 'Versión mínima de la aplicación necesaria para los conductores. Por favor actualiza si estás usando una versión anterior.',
    'force_update' => 'Forzar Actualización',
    'enter_version' => 'Ingresar Versión',
    'ride_accept' => 'Aceptar Viaje',
    'maximum_time' => 'Tiempo Máximo',
    'regular_ride' => 'Tiempo Máximo para Encontrar Conductor para Viaje Regular en Minutos',
    'enter_time' => 'Tiempo Máximo para Encontrar Conductor para Viaje Regular en Minutos',
    'ride_accept_decline' => 'Aceptar / Rechazar Viaje',
    'enter_ride' => 'Duración de Aceptar/Rechazar Viaje para Conductor en Segundos',
    'min_withdraw_amount' => 'Monto Mínimo de Retiro',
    'enter_amount' => 'Ingresar Monto Mínimo de Retiro',
    'activation' => 'Activación',
    'platform_fees' => 'Tarifas de Plataforma',
    'social_login_enable' => 'Habilitar Inicio de Sesión Social',
    'wallet_enable' => 'Habilitar Billetera',
    'online_payments' => 'Permite a los usuarios pagar digitalmente usando métodos de pago seguros como tarjetas y billeteras móviles.',
    'cash_payments' => 'Pagos en Efectivo',
    'referral_settings' => 'Configuraciones de Referidos',
    'referral_amount' => 'Monto de Referido',
    'first_ride_discount' => 'Descuento en el Primer Viaje',
    'general' => 'General',
    'bidding' => 'Puja',
    'location_settings' => 'Configuraciones de Ubicación',
    'driver_commission' => 'Comisión',
    'enter_referral_amount' => 'Ingresar Monto de Referido',
    'enter_first_ride_discount' => 'Ingresar Descuento en el Primer Viaje',
    'status' => 'Estado',
    'validity' => 'Validez',
    'enter_validity' => 'Ingresar Validez',
    'select_map_type' => 'Tipo de mapa',
    'select_map' => 'Seleccionar Opción de Seguimiento: elige entre Google Map, Waze, Vandex o navegación en la aplicación',
    'select_map_tracking' => 'Opción de seguimiento',
    'select_map_tracking_option' => 'Selecciona tu opción de seguimiento de mapa',
    'select_type' => 'Seleccionar Tipo',
    'driver_location_update' => 'Ubicación del Conductor',
    'driver_location' => 'Actualización de Ubicación del Conductor (Metros)',
    'enter_meter' => 'Ingresar Metros',
    'enter_value' => 'Ingresar Valor',
    'wallet' => 'Configuraciones de Billetera',
    'online_payment' => 'Pagos en Línea',
    'social_login' => 'Inicio de Sesión Social',
    'ride_otp' => 'Verificación OTP de Viaje',
    'parcel_otp' => 'Verificación OTP de Paquete',
    'otp_parcel' => 'Si está habilitado, el receptor ingresa un OTP para recibir el paquete. Si está desactivado, la entrega se realiza directamente.',
    'wallet_denominations' => 'Denominaciones de Billetera',
    'enter_wallet_denominations' => 'Ingresar Denominaciones de Billetera',
    'tip_denominations' => 'Denominaciones de Propina',
    'enter_tip_denominations' => 'Ingresar Denominaciones de Propina',
    'driver_threshold' => 'Umbral del Conductor',
    'enter_driver_threshold' => 'Ingresar Umbral del Conductor',
    'driver_tips' => 'Propinas del Conductor',
    'radius_meter' => 'Radio en Metros',
    'enter_radius_meter' => 'Ingresar Radio en Metros',
    'radius_per_second' => 'Radio por Segundos',
    'enter_radius_per_second' => 'Ingresar Radio por Segundos',
    'tips' => 'Si está desactivado, los pasajeros no pueden dar propinas. Si está habilitado, los pasajeros pueden dar propinas a los conductores a su discreción.',
    'negative_balance' => 'Si está habilitado, los conductores pueden operar con un saldo negativo. Una vez alcanzado el límite, no pueden unirse a nuevos viajes.',
    'otp_ride' => 'Si está habilitado, el viaje comienza solo después de ingresar el OTP. Si está desactivado, el viaje comienza directamente.',
    'interval' => 'Intervalo',
    'days' => 'Día',
    'months' => 'Mes',
    'enable_referral' => 'Permite a los usuarios invitar amigos y ganar recompensas cuando se unan o usen el servicio.',
    'bid_span' => 'Si está habilitado, los conductores pueden hacer pujas por viajes o entregas, ofreciendo precios competitivos a los usuarios. Si está desactivado, no se permite la puja.',
    'years' => 'Año',
    'login' => 'Habilita el inicio de sesión social para un acceso rápido y fácil a la cuenta de conductor',
    'set_validity' => 'Establece un límite de tiempo para el descuento después del registro',
    'discount' => 'Establece el monto del descuento (por ejemplo, 30) para los usuarios en su primer viaje.',
    'map' => 'Selecciona el tipo de mapa. Google Map o OSM se aplicará tanto al administrador como a la aplicación.',
    'radius' => 'Establece el área de cobertura para tus servicios basados en la ubicación',
    'radius_second' => 'Establece la frecuencia de ajustes de radio por segundo',
    'per_km_charge' => 'Carga por Kilómetro',
    'km_charge' => 'Habilita o deshabilita la carga por kilómetro para los viajes',
    'referral_enable' => 'Habilitar Referidos',
    'driver_locations' => 'Administra las ubicaciones de los conductores en tiempo real y asegúrate de que el GPS esté habilitado para un seguimiento preciso',
    'driver_threshold_help' => 'Establece umbrales para optimizar el rendimiento del conductor',
    'min_withdraw_text' => 'Especifica el monto mínimo que un conductor puede retirar de sus ganancias',
    'wallet_denominations_help' => 'Administra las denominaciones de la billetera para opciones de manejo de transacciones flexibles',
    'tip_denominations_help' => 'Establece denominaciones de propina para estandarizar las opciones de gratificación para los usuarios',
    'minimum_ride_amount' => 'Monto Mínimo de Viaje',
    'minimum_ride_amount_help' => 'Establece el monto mínimo de viaje requerido para activar bonos de referido (por ejemplo, 250).',
    'enter_minimum_ride_amount' => 'Ingresar Monto Mínimo de Viaje',
    'referrer_bonus_percentage' => 'Porcentaje de Bono del Referidor',
    'referrer_bonus_percentage_help' => 'Porcentaje del monto del viaje que el referidor recibirá como bono (0-100%).',
    'enter_referrer_bonus_percentage' => 'Ingresar Porcentaje de Bono del Referidor',
    'referred_bonus_percentage' => 'Porcentaje de Bono del Usuario Referido',
    'referred_bonus_percentage_help' => 'Porcentaje del monto del viaje que el usuario referido recibirá como bono (0-100%).',
    'enter_referred_bonus_percentage' => 'Ingresar Porcentaje de Bono del Usuario Referido',
    'interval_help' => 'Elige el intervalo de tiempo para cuando se aplicará la recompensa o descuento de referido',
    'ambulance_per_km_charge' => 'Carga por Kilómetro de Ambulancia',
    'enter_ambulance_per_km_charge' => 'Ingresar Carga por Kilómetro de Ambulancia',
    'ambulance_commission_type' => 'Tipo de Comisión de Ambulancia',
    'select_ambulance_commission_type' => 'Seleccionar Tipo de Comisión de Ambulancia',
    'ambulance_commission_rate' => 'Tasa de Comisión de Ambulancia',
    'enter_ambulance_commission_rate' => 'Ingresar Tasa de Comisión de Ambulancia',
    'driver_subscription' => 'Suscripción del conductor',
    'rider_privacy_policy' => 'Política de privacidad del pasajero',
    'driver_privacy_policy' => 'Política de privacidad del conductor',
    'enter_privacy_policy_url' => 'Ingrese la URL de la política de privacidad',
  ),
  'wallets' =>
  array(
    'wallet' => 'Billetera',
    'select_consumer' => 'Seleccionar Consumidor',
    'add_amount' => 'Ingresar Monto',
    'wallet_balance' => 'Saldo de la Billetera',
    'credit' => 'Crédito',
    'confirmation' => 'Confirmación',
    'debit' => 'Débito',
    'select_rider' => 'Seleccionar Pasajero',
    'transactions' => 'Transacciones',
    'modal' => '¿Estás seguro de que quieres proceder?',
    'select_driver' => 'Seleccionar Conductor',
    'yes' => 'Sí',
    'credit_debit' => 'Monto de crédito/débito',
    'no' => 'No',
    'select_fleet_manager' => 'Seleccionar Gerente de Flota',
    'add_fleet_manager_message' => '*Para agregar un nuevo gerente de flota, simplemente haz clic',
    'user_must_be' => 'El usuario debe ser',
    'balance_credited' => 'Saldo Acreditado Exitosamente',
    'balance_debited' => 'Saldo Debitado Exitosamente',
    'transaction' => 'Transacciones',
    'wallet_feature_on' => 'La función de billetera está actualmente desactivada. Actívala en Configuraciones > Activación.',
    'wallet_balance_not_sufficient' => 'El saldo de la billetera no es suficiente para este viaje.',
    'wallet_balance_ride' => 'La opción de usar el saldo de la billetera para el viaje está actualmente desactivada.',
    'wallet_balance_unable' => 'Los pasajeros no pueden usar el saldo de la billetera mientras crean viajes.',
    'add_note' => 'Agregar nota',
    'enter_note' => 'Ingresar nota al usuario',
    'add_driver_message' => '*Para agregar un nuevo conductor, simplemente haz clic',
    'add_rider_message' => '*Para agregar un nuevo pasajero, simplemente haz clic',
    'add_payment_account_before_withdrawal' => 'Por favor crea una cuenta de pago antes de solicitar un retiro.',
    'add_paypal_email_before_withdrawal' => 'Por favor agrega un correo electrónico de PayPal antes de solicitar un retiro.',
    'add_bank_details_before_withdrawal' => 'Por favor completa los detalles bancarios antes de solicitar un retiro.',
    'min_withdraw_amount' => 'Asegúrate de que el monto solicitado sea al menos :minWithdrawAmount.',
    'insufficient_wallet_balance' => 'Tu saldo de billetera no es suficiente para procesar este retiro.',
    'withdraw_request_submitted' => 'Solicitud de retiro generada exitosamente',
    'selected_user' => 'El usuario seleccionado debe ser Conductor',
  ),
  'withdraw_requests' =>
  array(
    'withdraw_request' => 'Solicitud de Retiro',
    'title' => 'Solicitudes de Retiro',
    'pending_balance' => 'Saldo Pendiente',
    'wallet' => 'Billetera',
    'message' => 'Mensaje',
    'amount' => 'Monto',
    'payment_type' => 'Método de Pago',
    'status' => 'Estado',
    'send_withdrawRequest' => 'Enviar Solicitud de Retiro',
    'bank' => 'Banco',
    'paypal' => 'PayPal',
    'enter_message' => 'Ingresar Mensaje',
  ),
  'push_notification' =>
  array(
    'push_notification' => 'Notificaciones Push',
    'all' => 'Todas las Notificaciones Push',
    'send' => 'Enviar Notificación Push',
    'select_notification_send_to' => 'Seleccionar Destinatario de la Notificación',
    'send_notification' => 'Enviar Notificación',
    'send_to' => 'Enviar a',
    'selected_service' => 'Todos/Servicio Seleccionado',
    'title' => 'Título',
    'sent_notification' => 'Notificación Push Enviada Exitosamente',
    'delete_successfully' => 'Notificación Push Eliminada Exitosamente',
    'permanent_delete_successfully' => 'Notificación Push Eliminada Permanentemente Exitosamente.',
    'enter_title' => 'Ingresar Título',
    'enter_message' => 'Ingresar Mensaje',
    'message' => 'Mensaje',
    'image' => 'Imagen',
    '3_min_ago' => 'Hace 3 minutos',
    'url' => 'URL',
    'message_body' => 'Cuerpo del Mensaje',
    'enter_url' => 'Ingresar URL',
    'zones' => 'Zona',
    'select_zones' => 'Seleccionar Zonas',
    'no_zones_message' => '*Para agregar una nueva zona, simplemente haz clic',
    'recommended' => '*Se recomienda subir una imagen de 100x100px',
    'schedule' => 'cronograma',
    'scheduleat' => 'programar',
    'select_start_date' => 'Seleccionar Fecha de Inicio',
  ),
  'hourly_package' =>
  array(
    'add_new' => 'Agregar Nuevo',
    'add' => 'Agregar Paquete por Horas',
    'image' => 'Imagen',
    'create' => 'Paquete por Horas',
    'save' => 'Guardar',
    'title' => 'Título',
    'amount' => 'Monto',
    'hour_span' => '*Ingresa cuántas horas cubre este paquete. Por ejemplo, 2 horas para viajes cortos en la ciudad',
    'distance_span' => '*Establece la distancia máxima permitida en este paquete. Por ejemplo, 50 km en 2 horas',
    'distance_type_span' => '*Elige cómo se mide la distancia: Kilómetros o Millas',
    'vehicle_type_span' => '*Selecciona los tipos de vehículos disponibles para este paquete. Por ejemplo, Sedán, SUV o Van',
    'enter_amount' => 'Ingresar Monto',
    'edit' => 'Editar Paquete por Horas',
    'enter_title' => 'Ingresar Título',
    'hourly_package' => 'Paquete por Horas',
    'hourly_packages' => 'Paquetes por Horas',
    'no_hourly_package_message' => '*Para agregar un nuevo paquete por horas, simplemente haz clic',
    'distance' => 'Distancia',
    'hour' => 'Hora',
    'distance_type' => 'Tipo de Distancia',
    'select_distance_type' => 'Seleccionar Tipo de Distancia',
    'status' => 'Estado',
    'enter_distance' => 'Ingresar Distancia',
    'enter_hour' => 'Ingresar Hora',
    'extra_min_per_hour_rate' => 'Tarifa Extra Mínima por Hora',
    'enter_extra_min_per_hour_rate' => 'Ingresar Tarifa Extra Mínima por Hora',
    'extra_min_per_hour_distance' => 'Distancia Extra Mínima por Hora',
    'enter_extra_min_per_hour_distance' => 'Ingresar Distancia Extra Mínima por Hora',
    'create_successfully' => 'Paquete por Horas Creado Exitosamente.',
    'update_successfully' => 'Paquete por Horas Actualizado Exitosamente.',
    'delete_successfully' => 'Paquete por Horas Eliminado Exitosamente.',
    'restore_successfully' => 'Paquete por Horas Restaurado Exitosamente.',
    'permanent_delete_successfully' => 'Paquete por Horas Eliminado Permanentemente Exitosamente',
    'status_update_successfully' => 'Estado del Paquete por Horas Actualizado Exitosamente.',
    'select_vehicle_type' => 'Seleccionar Tipo de Vehículo',
    'no_vehicleType_message' => '*Para agregar un nuevo tipo de vehículo, simplemente haz clic',
  ),
  'reports' =>
  array(
    'reports' => 'Reportes',
    'user_reports' => 'Reportes de Usuarios',
    'driver_reports' => 'Reportes de Conductores',
    'ride_reports' => 'Reportes de Viajes',
    'intercity_reports' => 'Reportes Interurbanos',
    'select_driver' => 'Seleccionar Conductor',
    'select_user' => 'Seleccionar Usuario',
    'select_ride_status' => 'Seleccionar Estado del Viaje',
    'select_payment_method' => 'Seleccionar Método de Pago',
    'select_payment_status' => 'Seleccionar Estado del Pago',
    'select_date' => 'Seleccionar Fecha',
    'select_zone' => 'Seleccionar Zona',
    'select_service' => 'Seleccionar Servicio',
    'select_service_category' => 'Seleccionar Categoría de Servicio',
    'select_vehicle_type' => 'Seleccionar Tipo de Vehículo',
    'select_file_format' => 'Seleccionar Formato de Archivo',
    'select_export_format' => 'Seleccionar Formato de Exportación',
    'driver' => 'Conductor',
    'user' => 'Usuario',
    'ride_status' => 'Estado del Viaje',
    'payment_method' => 'Método de Pago',
    'payment_status' => 'Estado del Pago',
    'date' => 'Fecha',
    'zone' => 'Zona',
    'service' => 'Servicio',
    'service_category' => 'Categoría de Servicio',
    'vehicle_type' => 'Tipo de Vehículo',
    'file_format' => 'Formato de Archivo',
    'all' => 'Todos',
    'filter' => 'Filtro',
    'CSV' => 'CSV',
    'SVG' => 'SVG',
    'ride_number' => 'Número de Viaje',
    'zone_reports' => 'Reportes de Zonas',
    'amount' => 'Monto',
    'rides' => 'Viajes',
    'export' => 'Exportar',
    'export_data' => 'Exportar Datos',
    'active_rides' => 'Viajes Activos',
    'cancelled_rides' => 'Viajes Cancelados',
    'completed_rides' => 'Viajes Completados',
    'contact' => 'Contacto',
    'earnings' => 'Ganancias',
    'ratings' => 'Calificaciones',
    'scheduled_rides' => 'Viajes Programados',
    'drivers' => 'Conductores',
    'name' => 'Nombre',
    'email' => 'Correo Electrónico',
    'coupon' => 'Cupón',
    'select_coupon' => 'Seleccionar Cupón',
    'coupon_reports' => 'Reportes de Cupones',
    'coupon_code' => 'Código de Cupón',
    'total_rides' => 'Viajes Totales',
    'total_coupon_discount' => 'Descuento Total de Cupones',
    'total_ride_amount' => 'Monto Total de Viajes',
    'total_drivers' => 'Conductores Totales',
    'total_vehicle_types' => 'Tipos de Vehículos Totales',
    'total_tax' => 'Impuesto Total',
    'transaction_type' => 'Tipo de Transacción',
    'select_transaction_type' => 'Seleccionar Tipo de Transacción',
    'ride' => 'Viaje',

    'subscription' => 'Suscripción',
    'wallet' => 'Billetera',
    'item_name' => 'Nombre del Artículo',
    'type' => 'Tipo',
    'tansaction_id' => 'ID de Transacción',
    'transaction_reports' => 'Reportes de Transacciones',
    'Date' => 'Fecha',
  ),
  'cancellation-reasons' =>
  array(
    'cancellation-reasons' => 'Razones de Cancelación',
    'add_new' => 'Agregar Nuevo',
    'add' => 'Agregar Razón de Cancelación',
    'image' => 'Ícono',
    'edit' => 'Editar Razón de Cancelación',
    'create' => 'Razón de Cancelación',
    'save' => 'Guardar',
    'title' => 'Título',
    'enter_title' => 'Ingresar Título',
    'create_successfully' => 'Razón de Cancelación Creada Exitosamente.',
    'update_successfully' => 'Razón de Cancelación Actualizada Exitosamente.',
    'delete_successfully' => 'Razón de Cancelación Eliminada Exitosamente.',
    'status_update_successfully' => 'Estado de la Razón de Cancelación Actualizado Exitosamente.',
    'permanent_delete_successfully' => 'Razón de Cancelación Eliminada Permanentemente Exitosamente.',
    'restore_successfully' => 'Razón de Cancelación Restaurada Exitosamente.',
  ),
  'bids' =>
  array(
    'only_drivers_can_place_bids' => 'Solo los conductores pueden realizar pujas.',
    'invalid_bidding_amount' => 'Monto de puja inválido.',
    'create_next_bid' => 'Puedes crear la siguiente puja después de rechazar la anterior.',
    'failed_to_create_ride' => 'No se pudo crear el viaje.',
    'bid_status_already_changed' => 'El estado de la puja ya es :status, no puedes cambiarlo nuevamente.',
  ),
  'reviews' =>
  array(
    'reviews' => 'Reseñas',
    'delete_successfully' => 'Reseña Eliminada Exitosamente.',
    'restore_successfully' => 'Reseña Restaurada Exitosamente.',
    'permanent_delete_successfully' => 'Reseña Eliminada Permanentemente Exitosamente.',
    'ride_not_completed' => 'Por favor completa el viaje antes de agregar una reseña.',
    'already_reviewed' => 'Ya se ha enviado una reseña para este viaje.',
    'rider_reviews' => 'Reseñas de Pasajeros',
    'driver_reviews' => 'Reseñas de Conductores',
  ),
  'notices' =>
  array(
    'notices' => 'Avisos',
    'add_new' => 'Agregar Nuevo',
    'add_notice' => 'Agregar Aviso',
    'edit' => 'Editar Aviso',
    'zones' => 'Zonas',
    'notice' => 'Avisos',
    'select_zones' => 'Seleccionar Zonas',
    'select_send_to' => 'Seleccionar Destinatario',
    'color' => 'Color',
    'select_color' => 'Seleccionar Color',
    'send_to' => 'Enviar a',
    'message' => 'Mensaje',
    'enter_message' => 'Ingresar Mensaje',
    'no_zones_message' => '*Para agregar una nueva zona, simplemente haz clic',
    'no_drivers_message' => '*Para agregar un nuevo conductor, simplemente haz clic',
    'select_drivers' => 'Seleccionar Conductores',
    'create_successfully' => 'Aviso Creado Exitosamente.',
    'update_successfully' => 'Aviso Actualizado Exitosamente.',
    'delete_successfully' => 'Aviso Eliminado Exitosamente.',
    'restore_successfully' => 'Aviso Restaurado Exitosamente.',
    'permanent_delete_successfully' => 'Aviso Eliminado Permanentemente Exitosamente',
    'status_update_successfully' => 'Estado del Aviso Actualizado Exitosamente.',
  ),
  'import' =>
  array(
    'import' => 'Importar',
    'csv_file_import' => 'Archivo CSV Importado Exitosamente',
    'csv_file_allow' => 'Solo se permiten archivos CSV.',
    'upload_data' => 'Subir Datos',
    'upload_instruction' => 'Sube un CSV para importar datos.',
    'drag_drop' => 'Arrastra y suelta archivos para subir',
    'private_message' => 'Tus datos serán privados hasta que los publiques.',
    'select_files' => 'Seleccionar archivos',
    'cancel' => 'Cancelar',
    'enter_link' => 'Ingresar enlace para subir',
    'add' => 'Agregar',
    'google_shit_link' => 'Enlace de Google Sheets',
    'local_files' => 'Archivo Local',
    'enter_google_sheet_link' => 'Ingresar enlace de Google Sheets aquí',
    'example_csv' => 'Por favor descarga el archivo CSV de ejemplo desde',
    'read_instructions' => 'y asegúrate de leer las instrucciones cuidadosamente antes de iniciar la importación',
  ),
  'export' =>
  array(
    'export' => 'Exportar',
    'csv_file_export' => 'Archivo CSV Exportado Exitosamente',
    'csv_file_allow' => 'Solo se permiten archivos CSV.',
    'export_drivers' => 'Exportar Todos los Conductores',
    'export_data' => 'Exportar Datos',
    'csv' => 'CSV',
    'excel' => 'Excel',
    'close' => 'Cerrar',
    'select_export_format' => 'Seleccionar Exportación',
  ),
  'language' =>
  array(
    'languages' => 'Idiomas',
  ),
  'widget' =>
  array(
    'ride_status_overviews' => 'Resumen del Estado de los Viajes',
    'statistics' => 'Estadísticas',
    'total_riders' => 'Pasajeros Totales',
    'total_drivers' => 'Conductores Totales',
    'total_rides' => 'Viajes',
    'ride_earnings' => 'Ganancias de Viajes',
    'average_revenue' => 'Ingresos Promedio',
    'recent_rides' => 'Viajes Recientes',
    'view_all' => 'Ver Todo',
    'revenue' => 'Ingresos',
    'ride_id' => 'Número de Viaje',
    'driver_name' => 'Conductor',
    'drop_off_location' => 'Ubicación de Entrega',
    'distance' => 'Distancia',
    'status' => 'Estado',
    'total_verified_drivers' => 'Conductores Verificados Totales',
    'total_unverified_drivers' => 'Conductores No Verificados Totales',
    'km' => 'Km',
    'no_data_available' => 'No hay datos disponibles',
    'service_categories' => 'Categorías de Servicio',
    'than_today' => 'Que hoy',
    'top_drivers' => 'Mejores Conductores',
    'ratings' => 'Calificaciones',
    'earnings' => 'Ganancias',
    'online_status' => 'Activo en Línea',
    'online_payment' => 'Pago en Línea',
    'offline_payment' => 'Pago Fuera de Línea',
    'withdraw_request' => 'Solicitud de Retiro',
    'Wallet_balance' => 'Saldo de la Billetera',
    'reviews' => 'Reseñas',
    'documents' => 'Documentos',
    'fleet_managers_info'=>'Gestores de flota totales', 
    'dispatcher'=>'Despachadores',
    'peak_zone'=>'Zonas pico activas',
    'fleet_vehicle_type'=>'Vehículos de flota total'
  ),
  'rental_vehicle' =>
  array(
    'rental_vehicle' => 'Vehículo de Alquiler',
    'rental_vehicles' => 'Vehículos de Alquiler',
    'message' => 'Puedes agregar hasta 5 interiores solamente.',
    'name' => 'Nombre',
    'images' => 'Imágenes',
    'view_image_guide' => 'Ver Guía de Imágenes',
    'normal_image' => 'Imagen Normal',
    'normal_image_span' => 'Imagen clara de tu vehículo que proporciona una vista completa',
    'front_view_span' => 'Sube una imagen clara que muestre el frente de tu vehículo',
    'front_view' => 'Imagen de Vista Frontal',
    'side_view' => 'Imagen de Vista Lateral',
    'side_view_span' => 'Proporciona una imagen del perfil lateral del vehículo.',
    'boot_view' => 'Imagen de Vista del Maletero',
    'boot_view_span' => 'Asegúrate de que el maletero esté abierto y completamente visible en la imagen.',
    'interior' => 'Interior',
    'interior_span' => 'Agrega una foto del interior que muestre características clave como asientos y tablero.',
    'enter_name' => 'Ingresar el nombre (Ej: Toyota Corolla)',
    'description' => 'Descripción',
    'enter_description' => 'Ingresar la descripción (Ej: Sedán cómodo de 5 plazas)',
    'vehicle_type' => 'Tipo de Vehículo',
    'select_vehicle_type' => 'Seleccionar Tipo de Vehículo',
    'select_zones' => 'Seleccionar Zonas',
    'interior_image' => 'Imagen del Interior',
    'vehicle_per_day_price' => 'Precio por Día del Vehículo',
    'enter_vehicle_per_day_price' => 'Ingresar el precio por día del vehículo (Ej: $50)',
    'with_driver' => 'Con Conductor',
    'driver_details' => 'Detalles del Conductor',
    'enter_driver_details' => 'Ingresar detalles del conductor (Ej: John Doe, Licenciado y Experimentado)',
    'driver_per_day_charge' => 'Carga por Día del Conductor',
    'enter_driver_per_day_charge' => 'Ingresar la carga por día del conductor (Ej: $20)',
    'car_type' => 'Tipo de Auto',
    'enter_vehicle_subtype' => 'Ingresar subtipo de vehículo (Ej: Sedán)',
    'fuel_type' => 'Tipo de Combustible',
    'enter_fuel_type' => 'Ingresar tipo de combustible (Ej: GNC)',
    'gear_type' => 'Tipo de Cambio',
    'enter_gear_type' => 'Ingresar tipo de cambio (Ej: Automático)',
    'vehicle_speed' => 'Velocidad del Vehículo',
    'enter_vehicle_speed' => 'Ingresar la velocidad del vehículo (Ej: 120 km/h)',
    'mileage' => 'Kilometraje',
    'enter_mileage' => 'Ingresar el kilometraje (Ej: 15 km/ltr)',
    'status' => 'Estado',
    'save' => 'Guardar',
    'select_zone' => 'Seleccionar zona (Ej: Centro de la Ciudad)',
    'zone' => 'Zona',
    'vehicle_subtype' => 'Subtipo de Vehículo',
    'add' => 'Agregar Vehículo de Alquiler',
    'edit' => 'Editar Vehículo de Alquiler',
    'enter_interior_detail' => 'Ingresar Detalle del Interior',
    'add_interior' => 'Agregar',
    'remove_interior' => 'Eliminar',
    'deleted_successfully' => 'Vehículo de Alquiler Eliminado Exitosamente',
    'registration_no' => 'Número de Registro',
    'enter_registration_no' => 'Ingresar Número de Registro',
    'registration_image' => 'Imagen de Registro',
    'create_successfully' => 'Vehículo de Alquiler Creado Exitosamente.',
    'update_successfully' => 'Vehículo de Alquiler Actualizado Exitosamente.',
    'delete_successfully' => 'Vehículo de Alquiler Eliminado Exitosamente.',
    'restore_successfully' => 'Vehículo de Alquiler Restaurado Exitosamente.',
    'permanent_delete_successfully' => 'Vehículo de Alquiler Eliminado Permanentemente Exitosamente',
    'status_update_successfully' => 'Estado del Vehículo de Alquiler Actualizado Exitosamente.',
    'max_seat' => 'Asiento máximo',
  ),
  'commission_histories' =>
  array(
    'commission_histories' => 'Historial de Comisiones',
  ),
  'plans' =>
  array(
    'plans' => 'Planes',
    'name' => 'Nombre',
    'enter_name' => 'Ingresar Nombre del Plan',
    'add' => 'Agregar Plan',
    'edit' => 'Editar Plan',
    'description' => 'Descripción',
    'enter_description' => 'Ingresar Descripción',
    'add_description' => 'Agregar Descripción',
    'duration' => 'Duración',
    'price' => 'Precio',
    'enter_plan_price' => 'Ingresar Precio',
    'select_duration' => 'Seleccionar Duración',
    'all' => 'Todos los Planes',
    'add_new' => 'Agregar Nuevo',
    'save' => 'Guardar',
    'select_service_category' => 'Seleccionar Categorías de Servicio',
    'select_service_categories' => 'Seleccionar Categorías de Servicio',
    'status' => 'Estado',
    'create_successfully' => 'Plan Creado Exitosamente.',
    'update_successfully' => 'Plan Actualizado Exitosamente.',
    'delete_successfully' => 'Plan Eliminado Exitosamente.',
    'restore_successfully' => 'Plan Restaurado Exitosamente.',
    'permanent_delete_successfully' => 'Plan Eliminado Permanentemente Exitosamente',
    'status_update_successfully' => 'Estado del Plan Actualizado Exitosamente.',
    'payment_not_allowed_for_plan' => 'El pago seleccionado no está permitido para comprar el plan',
    'only_driver_can_purchase_plan' => 'Solo los conductores pueden comprar el plan.',
    'invalid_payment_method' => 'El método de pago seleccionado es inválido.',
    'wallet_debit_success' => 'Monto de la billetera debitado exitosamente para la compra del plan :plan_name.',
    'message' => 'Puedes agregar hasta 5 descripciones solamente.',
  ),
  'traits' =>
  array(
    'invalid_weight_unit' => 'Unidad de peso proporcionada inválida.',
    'fare_amount_outside_range' => 'El monto de la tarifa debe estar entre :min y :max para una ruta de :distance :unit.',
    'invalid_package_fare' => 'El monto de la tarifa debe estar entre :min y :max para el paquete seleccionado.',
    'invalid_hourly_package' => 'Paquete por horas seleccionado inválido.',
    'invalid_vehicle_for_package' => 'El vehículo seleccionado no es para el servicio de paquete.',
    'hourly_package_required' => 'Se requiere un paquete por horas para la categoría de paquete.',
    'invalid_vehicle_for_parcel' => 'El vehículo seleccionado no es para el servicio de paquete.',
    'invalid_service' => 'El servicio seleccionado es inválido.',
    'admin_debited_commission' => 'El administrador ha debitado la comisión.',
    'fleet_debited_commission' => 'La flota ha debitado la comisión.',
    'admin_debited_tax' => 'El administrador ha debitado el monto del impuesto',
    'admin_debited_platform_fee' => 'El administrador ha debitado el monto de la tarifa de plataforma.',
  ),
  'modal' =>
  array(
    'export_data' => 'Exportar Datos',
    'select_export_format' => 'Seleccionar Formato de Exportación',
    'csv' => 'CSV',
    'excel' => 'Excel',
    'close' => 'Cerrar',
    'export' => 'Exportar',
  ),
  'subscriptions' =>
  array(
    'driver_subscription' => 'Suscripciones de Conductores',
    'subscriptions' => 'Suscripciones',
  ),
  'onboardings' =>
  array(
    'onboardings' => 'Pantallas de Incorporación',
    'edit' => 'Editar Incorporación',
    'image' => 'Imagen',
    'title' => 'Título',
    'save' => 'Guardar',
    'description' => 'Descripción',
    'enter_description' => 'Ingresar Descripción',
    'type' => 'Tipo',
    'select_type' => 'Seleccionar Tipo',
    'update_successfully' => 'Incorporación Actualizada Exitosamente.',
    'delete_successfully' => 'Incorporación Eliminada Exitosamente.',
  ),
  'dispatchers' =>
  array(
    'dispatchers' => 'Despachadores',
    'add_new' => 'Agregar Nuevo',
    'all' => 'Todos los Despachadores',
    'add' => 'Agregar Despachadores',
    'rider_details' => 'Detalles del Pasajero',
    'create' => 'Crear Despachador',
    'add_dispatchers' => 'Agregar Despachadores',
    'edit' => 'Editar Despachador',
    'full_name' => 'Nombre Completo',
    'reviews' => 'Reseñas',
    'email' => 'Correo Electrónico',
    'enter_email' => 'Ingresar Correo Electrónico',
    'contact_number' => 'Número de Contacto',
    'emails' => 'Correo Electrónico',
    'select_zones' => 'Seleccionar Zonas',
    'no_zones_message' => '*Para agregar una nueva zona, simplemente haz clic',
    'enter_full_name' => 'Ingresar Nombre Completo',
    'phone' => 'Teléfono',
    'zones' => 'Zonas',
    'enter_phone' => 'Ingresar Teléfono',
    'enter_password' => 'Ingresar Contraseña',
    'enter_confirm_password' => 'Ingresar Confirmación de Contraseña',
    'new_password' => 'Nueva Contraseña',
    'confirm_password' => 'Confirmar Contraseña',
    'notification' => 'Notificar al Despachador',
    'sentence' => 'Enviar al nuevo despachador un correo electrónico sobre su cuenta.',
    'create_successfully' => 'Despachador Creado Exitosamente.',
    'update_successfully' => 'Despachador Actualizado Exitosamente.',
    'delete_successfully' => 'Despachador Eliminado Exitosamente.',
    'restore_successfully' => 'Despachador Restaurado Exitosamente.',
    'permanent_delete_successfully' => 'Despachador Eliminado Permanentemente Exitosamente.',
    'status_update_successfully' => 'Estado del Despachador Actualizado Exitosamente.',
  ),
  'fleet_managers' =>
  array(
    'profile_image' => 'Imagen de Perfil',
    'full_name' => 'Nombre Completo',
    'personal_information' => 'Información Personal',
    'email' => 'Correo Electrónico',
    'edit' => 'Editar Gerente de Flota',
    'enter_phone' => 'Ingresar Teléfono',
    'new_password' => 'Nueva Contraseña',
    'confirm_password' => 'Confirmar Contraseña',
    'contact_number' => 'Número de Contacto',
    'emails' => 'Correo Electrónico',
    'created_at' => 'Creado En',
    'action' => 'Acción',
    'enter_full_name' => 'Ingresar Nombre Completo',
    'enter_confirm_password' => 'Ingresar Confirmación de Contraseña',
    'enter_email' => 'Ingresar Correo Electrónico',
    'sentence' => 'Enviar al nuevo gerente de flota un correo electrónico sobre su cuenta.',
    'enter_password' => 'Ingresar Contraseña',
    'notification' => 'Notificar al Gerente de Flota',
    'phone' => 'Teléfono',
    'zones' => 'Zonas',
    'no_reviews' => 'No hay reseñas disponibles',
    'description' => 'Descripción',
    'fleet_managers' => 'Gerentes de Flota',
    'add_new' => 'Agregar Nuevo',
    'payout_details' => 'Detalles de Pago',
    'general' => 'General',
    'bank_account_no' => 'Número de Cuenta Bancaria',
    'enter_bank_account' => 'Ingresar Número de Cuenta Bancaria',
    'bank_name' => 'Nombre del Banco',
    'enter_bank_name' => 'Ingresar Nombre del Banco',
    'holder_name' => 'Nombre del Titular',
    'enter_holder_name' => 'Ingresar Nombre del Titular',
    'swift' => 'Swift',
    'enter_swift_code' => 'Ingresar Código Swift',
    'routing_number' => 'Número de ruta',
    'enter_routing_number' => 'Ingrese el número de ruta',
    'all' => 'Todos los Gerentes de Flota',
    'add' => 'Agregar Gerente de Flota',
    'create_successfully' => 'Gerente de Flota Creado Exitosamente.',
    'update_successfully' => 'Gerente de Flota Actualizado Exitosamente.',
    'delete_successfully' => 'Gerente de Flota Eliminado Exitosamente.',
    'restore_successfully' => 'Gerente de Flota Restaurado Exitosamente.',
    'permanent_delete_successfully' => 'Gerente de Flota Eliminado Permanentemente Exitosamente.',
    'status_update_successfully' => 'Estado del Gerente de Flota Actualizado Exitosamente.',
  ),
  'sos_alerts' =>
  array(
    'sos_alerts' => 'Alertas SOS',
  ),
  'fleet_withdraw_requests' =>
  array(
    'title' => 'Solicitudes de Retiro de Flota',
    'balance' => 'Saldo',
    'pending_balance' => 'Saldo Pendiente',
    'send_withdrawRequest' => 'Enviar Solicitud de Retiro',
    'withdraw_request' => 'Solicitud de Retiro',
    'amount' => 'Monto',
    'payment_type' => 'Tipo de Pago',
    'message' => 'Mensaje',
    'enter_message' => 'Ingresar Mensaje',
    'bank' => 'Banco',
    'paypal' => 'PayPal',
    'status' => 'Estado',
    'submit' => 'Enviar',
  ),
  'chats' =>
  array(
    'recent_chats' => 'Chats Recientes',
    'chats' => 'Chats',
    'no_chats_found' => 'No se Encontraron Chats',
    'view_all_chats' => 'Ver Todos los Chats',
    'no_riders_found' => 'No se Encontraron Pasajeros',
    'no_driver_found' => 'No se Encontraron Conductores',
    'select_a_user' => 'Seleccionar un usuario',
    'offline' => 'Fuera de Línea',
    'modal' => '¿Estás seguro de que quieres borrar este chat?',
    'confirmation' => 'Confirmación',
    'no_messages_yet' => 'Aún no hay mensajes',
    'load_message' => 'Cargando mensajes...',
    'search_user' => 'Buscar usuarios...',
    'search_rider' => 'Buscar pasajeros...',
    'search_driver' => 'Buscar conductores...',
    'all' => 'Todos',
    'driver' => 'Conductores',
    'rider' => 'Pasajeros',
    'no' => 'No',
    'yes' => 'Sí',
    'type_message' => 'Escriba un mensaje aquí..'
  ),
  'ambulances' =>
  array(
    'ambulance' => 'Ambulancia',
    'ambulances' => 'Ambulancias',
  ),
  'referrals' => [
    'referrals' => 'Referidos',
    'referrer' => 'Referidor',
    'referred_user' => 'Usuario referido',
    'referral_code' => 'Código de referencia',
    'bonus_amount' => 'Monto del bono',
    'status' => 'Estado',
    'credited_at' => 'Acreditado el',
    'created_at' => 'Creado el',
    'pending' => 'Pendiente',
    'credited' => 'Acreditado',
    'all' => 'Todos',
    'trash' => 'Papelera',
    'all_types' => 'Todos los tipos',
    'rider_referrals' => 'Referencias de pasajeros',
    'driver_referrals' => 'Referencias de conductores',
    'referrer_type' => 'Tipo de referidor',
    'referred_type' => 'Tipo referido',
    'ride_amount' => 'Monto del viaje',
    'referrer_bonus' => 'Bono del referidor',
    'referred_bonus' => 'Bono referido',
    'referrer_percentage' => 'Referidor %',
    'referred_percentage' => 'Referido %',
    'rider' => 'Pasajero',
    'driver' => 'Conductor',
  ],
  'validation' => [
    'minimum_ride_amount_positive' => 'El monto mínimo de viaje debe ser un número positivo.',
    'referrer_bonus_percentage_range' => 'El porcentaje de bono del referidor debe estar entre 0 y 100.',
    'referred_bonus_percentage_range' => 'El porcentaje de bono del usuario referido debe estar entre 0 y 100.',
  ],
);
