<?php

namespace App\Enums;

enum AppLocale: string
{
  case EN_EN = 'en_EN';
  case AF_ZA = 'af_ZA';
  case SQ_AL = 'sq_AL';
  case AM_ET = 'am_ET';
  case AR_SA = 'ar_SA';
  case HY_AM = 'hy_AM';
  case AZ_AZ = 'az_AZ';
  case EU_ES = 'eu_ES';
  case BE_BY = 'be_BY';
  case BN_BD = 'bn_BD';
  case BS_BA = 'bs_BA';
  case BG_BG = 'bg_BG';
  case CA_ES = 'ca_ES';
  case CEB_PH = 'ceb_PH';
  case NY_MW = 'ny_MW';
  case ZH_CN = 'zh_CN';
  case CO_FR = 'co_FR';
  case HR_HR = 'hr_HR';
  case CS_CZ = 'cs_CZ';
  case DA_DK = 'da_DK';
  case NL_NL = 'nl_NL';
  case EO_XZ = 'eo_XZ';
  case ET_EE = 'et_EE';
  case TL_PH = 'tl_PH';
  case FI_FI = 'fi_FI';
  case FR_FR = 'fr_FR';
  case FY_NL = 'fy_NL';
  case GL_ES = 'gl_ES';
  case KA_GE = 'ka_GE';
  case DE_DE = 'de_DE';
  case EL_GR = 'el_GR';
  case GU_IN = 'gu_IN';
  case HT_HT = 'ht_HT';
  case HA_NG = 'ha_NG';
  case HAW_US = 'haw_US';
  case IW_IL = 'iw_IL';
  case HI_IN = 'hi_IN';
  case HMN_LA = 'hmn_LA';
  case HU_HU = 'hu_HU';
  case IS_IS = 'is_IS';
  case IG_NG = 'ig_NG';
  case ID_ID = 'id_ID';
  case GA_IE = 'ga_IE';
  case IT_IT = 'it_IT';
  case JA_JP = 'ja_JP';
  case JW_ID = 'jw_ID';
  case KN_IN = 'kn_IN';
  case KK_KZ = 'kk_KZ';
  case KM_KH = 'km_KH';
  case RW_RW = 'rw_RW';
  case KO_KR = 'ko_KR';
  case KU_TR = 'ku_TR';
  case KY_KG = 'ky_KG';
  case LO_LA = 'lo_LA';
  case LA_VA = 'la_VA';
  case LV_LV = 'lv_LV';
  case LT_LT = 'lt_LT';
  case LB_LU = 'lb_LU';
  case MK_MK = 'mk_MK';
  case MG_MG = 'mg_MG';
  case MS_MY = 'ms_MY';
  case ML_IN = 'ml_IN';
  case MT_MT = 'mt_MT';
  case MI_NZ = 'mi_NZ';
  case MR_IN = 'mr_IN';
  case MN_MN = 'mn_MN';
  case MY_MM = 'my_MM';
  case NE_NP = 'ne_NP';
  case NO_NO = 'no_NO';
  case OR_IN = 'or_IN';
  case PS_AF = 'ps_AF';
  case FA_IR = 'fa_IR';
  case PL_PL = 'pl_PL';
  case PT_PT = 'pt_PT';
  case PA_IN = 'pa_IN';
  case RO_RO = 'ro_RO';
  case RU_RU = 'ru_RU';
  case SM_WS = 'sm_WS';
  case GD_GB = 'gd_GB';
  case SR_RS = 'sr_RS';
  case ST_LS = 'st_LS';
  case SN_ZW = 'sn_ZW';
  case SD_PK = 'sd_PK';
  case SI_LK = 'si_LK';
  case SK_SK = 'sk_SK';
  case SL_SI = 'sl_SI';
  case SO_SO = 'so_SO';
  case ES_ES = 'es_ES';
  case SU_ID = 'su_ID';
  case SW_KE = 'sw_KE';
  case SV_SE = 'sv_SE';
  case TG_TJ = 'tg_TJ';
  case TA_IN = 'ta_IN';
  case TE_IN = 'te_IN';
  case TH_TH = 'th_TH';
  case TR_TR = 'tr_TR';
  case UK_UA = 'uk_UA';
  case UR_PK = 'ur_PK';
  case UG_CN = 'ug_CN';
  case UZ_UZ = 'uz_UZ';
  case VI_VN = 'vi_VN';
  case CY_GB = 'cy_GB';
  case XH_ZA = 'xh_ZA';
  case YI_001 = 'yi_001';
  case YO_NG = 'yo_NG';
  case ZU_ZA = 'zu_ZA';

  public function label(): string
  {
    return match ($this) {
      self::EN_EN => 'English (en_EN)',
      self::AF_ZA => 'Afrikaans (af_ZA)',
      self::SQ_AL => 'Albanian (sq_AL)',
      self::AM_ET => 'Amharic (am_ET)',
      self::AR_SA => 'Arabic (ar_SA)',
      self::HY_AM => 'Armenian (hy_AM)',
      self::AZ_AZ => 'Azerbaijani (az_AZ)',
      self::EU_ES => 'Basque (eu_ES)',
      self::BE_BY => 'Belarusian (be_BY)',
      self::BN_BD => 'Bengali (bn_BD)',
      self::BS_BA => 'Bosnian (bs_BA)',
      self::BG_BG => 'Bulgarian (bg_BG)',
      self::CA_ES => 'Catalan (ca_ES)',
      self::CEB_PH => 'Cebuano (ceb_PH)',
      self::NY_MW => 'Chichewa (ny_MW)',
      self::ZH_CN => 'Chinese (zh_CN)',
      self::CO_FR => 'Corsican (co_FR)',
      self::HR_HR => 'Croatian (hr_HR)',
      self::CS_CZ => 'Czech (cs_CZ)',
      self::DA_DK => 'Danish (da_DK)',
      self::NL_NL => 'Dutch (nl_NL)',
      self::EO_XZ => 'Esperanto (eo_XZ)',
      self::ET_EE => 'Estonian (et_EE)',
      self::TL_PH => 'Filipino (tl_PH)',
      self::FI_FI => 'Finnish (fi_FI)',
      self::FR_FR => 'French (fr_FR)',
      self::FY_NL => 'Frisian (fy_NL)',
      self::GL_ES => 'Galician (gl_ES)',
      self::KA_GE => 'Georgian (ka_GE)',
      self::DE_DE => 'German (de_DE)',
      self::EL_GR => 'Greek (el_GR)',
      self::GU_IN => 'Gujarati (gu_IN)',
      self::HT_HT => 'Haitian Creole (ht_HT)',
      self::HA_NG => 'Hausa (ha_NG)',
      self::HAW_US => 'Hawaiian (haw_US)',
      self::IW_IL => 'Hebrew (iw_IL)',
      self::HI_IN => 'Hindi (hi_IN)',
      self::HMN_LA => 'Hmong (hmn_LA)',
      self::HU_HU => 'Hungarian (hu_HU)',
      self::IS_IS => 'Icelandic (is_IS)',
      self::IG_NG => 'Igbo (ig_NG)',
      self::ID_ID => 'Indonesian (id_ID)',
      self::GA_IE => 'Irish (ga_IE)',
      self::IT_IT => 'Italian (it_IT)',
      self::JA_JP => 'Japanese (ja_JP)',
      self::JW_ID => 'Javanese (jw_ID)',
      self::KN_IN => 'Kannada (kn_IN)',
      self::KK_KZ => 'Kazakh (kk_KZ)',
      self::KM_KH => 'Khmer (km_KH)',
      self::RW_RW => 'Kinyarwanda (rw_RW)',
      self::KO_KR => 'Korean (ko_KR)',
      self::KU_TR => 'Kurdish (ku_TR)',
      self::KY_KG => 'Kyrgyz (ky_KG)',
      self::LO_LA => 'Lao (lo_LA)',
      self::LA_VA => 'Latin (la_VA)',
      self::LV_LV => 'Latvian (lv_LV)',
      self::LT_LT => 'Lithuanian (lt_LT)',
      self::LB_LU => 'Luxembourgish (lb_LU)',
      self::MK_MK => 'Macedonian (mk_MK)',
      self::MG_MG => 'Malagasy (mg_MG)',
      self::MS_MY => 'Malay (ms_MY)',
      self::ML_IN => 'Malayalam (ml_IN)',
      self::MT_MT => 'Maltese (mt_MT)',
      self::MI_NZ => 'Maori (mi_NZ)',
      self::MR_IN => 'Marathi (mr_IN)',
      self::MN_MN => 'Mongolian (mn_MN)',
      self::MY_MM => 'Myanmar (my_MM)',
      self::NE_NP => 'Nepali (ne_NP)',
      self::NO_NO => 'Norwegian (no_NO)',
      self::OR_IN => 'Odia (or_IN)',
      self::PS_AF => 'Pashto (ps_AF)',
      self::FA_IR => 'Persian (fa_IR)',
      self::PL_PL => 'Polish (pl_PL)',
      self::PT_PT => 'Portuguese (pt_PT)',
      self::PA_IN => 'Punjabi (pa_IN)',
      self::RO_RO => 'Romanian (ro_RO)',
      self::RU_RU => 'Russian (ru_RU)',
      self::SM_WS => 'Samoan (sm_WS)',
      self::GD_GB => 'Scots Gaelic (gd_GB)',
      self::SR_RS => 'Serbian (sr_RS)',
      self::ST_LS => 'Sesotho (st_LS)',
      self::SN_ZW => 'Shona (sn_ZW)',
      self::SD_PK => 'Sindhi (sd_PK)',
      self::SI_LK => 'Sinhala (si_LK)',
      self::SK_SK => 'Slovak (sk_SK)',
      self::SL_SI => 'Slovenian (sl_SI)',
      self::SO_SO => 'Somali (so_SO)',
      self::ES_ES => 'Spanish (es_ES)',
      self::SU_ID => 'Sundanese (su_ID)',
      self::SW_KE => 'Swahili (sw_KE)',
      self::SV_SE => 'Swedish (sv_SE)',
      self::TG_TJ => 'Tajik (tg_TJ)',
      self::TA_IN => 'Tamil (ta_IN)',
      self::TE_IN => 'Telugu (te_IN)',
      self::TH_TH => 'Thai (th_TH)',
      self::TR_TR => 'Turkish (tr_TR)',
      self::UK_UA => 'Ukrainian (uk_UA)',
      self::UR_PK => 'Urdu (ur_PK)',
      self::UG_CN => 'Uyghur (ug_CN)',
      self::UZ_UZ => 'Uzbek (uz_UZ)',
      self::VI_VN => 'Vietnamese (vi_VN)',
      self::CY_GB => 'Welsh (cy_GB)',
      self::XH_ZA => 'Xhosa (xh_ZA)',
      self::YI_001 => 'Yiddish (yi_001)',
      self::YO_NG => 'Yoruba (yo_NG)',
      self::ZU_ZA => 'Zulu (zu_ZA)',
    };
  }
}
