<?php

namespace App\Enums;

enum Locale: string
{
  case EN = 'en';
  case AF = 'af';
  case SQ = 'sq';
  case AM = 'am';
  case AR = 'ar';
  case HY = 'hy';
  case AZ = 'az';
  case EU = 'eu';
  case BE = 'be';
  case BN = 'bn';
  case BS = 'bs';
  case BG = 'bg';
  case CA = 'ca';
  case CEB = 'ceb';
  case NY = 'ny';
  case ZH = 'zh';
  case CO = 'co';
  case HR = 'hr';
  case CS = 'cs';
  case DA = 'da';
  case NL = 'nl';
  case EO = 'eo';
  case ET = 'et';
  case TL = 'tl';
  case FI = 'fi';
  case FR = 'fr';
  case FY = 'fy';
  case GL = 'gl';
  case KA = 'ka';
  case DE = 'de';
  case EL = 'el';
  case GU = 'gu';
  case HT = 'ht';
  case HA = 'ha';
  case HAW = 'haw';
  case IW = 'iw';
  case HI = 'hi';
  case HMN = 'hmn';
  case HU = 'hu';
  case IS = 'is';
  case IG = 'ig';
  case ID = 'id';
  case GA = 'ga';
  case IT = 'it';
  case JA = 'ja';
  case JW = 'jw';
  case KN = 'kn';
  case KK = 'kk';
  case KM = 'km';
  case RW = 'rw';
  case KO = 'ko';
  case KU = 'ku';
  case KY = 'ky';
  case LO = 'lo';
  case LA = 'la';
  case LV = 'lv';
  case LT = 'lt';
  case LB = 'lb';
  case MK = 'mk';
  case MG = 'mg';
  case MS = 'ms';
  case ML = 'ml';
  case MT = 'mt';
  case MI = 'mi';
  case MR = 'mr';
  case MN = 'mn';
  case MY = 'my';
  case NE = 'ne';
  case NO = 'no';
  case OR = 'or';
  case PS = 'ps';
  case FA = 'fa';
  case PL = 'pl';
  case PT = 'pt';
  case PA = 'pa';
  case RO = 'ro';
  case RU = 'ru';
  case SM = 'sm';
  case GD = 'gd';
  case SR = 'sr';
  case ST = 'st';
  case SN = 'sn';
  case SD = 'sd';
  case SI = 'si';
  case SK = 'sk';
  case SL = 'sl';
  case SO = 'so';
  case ES = 'es';
  case SU = 'su';
  case SW = 'sw';
  case SV = 'sv';
  case TG = 'tg';
  case TA = 'ta';
  case TE = 'te';
  case TH = 'th';
  case TR = 'tr';
  case UK = 'uk';
  case UR = 'ur';
  case UG = 'ug';
  case UZ = 'uz';
  case VI = 'vi';
  case CY = 'cy';
  case XH = 'xh';
  case YI = 'yi';
  case YO = 'yo';
  case ZU = 'zu';

  public function label(): string
  {
    return match ($this) {
      self::AF => 'Afrikaans (af)',
      self::SQ => 'Albanian (sq)',
      self::AM => 'Amharic (am)',
      self::AR => 'Arabic (ar)',
      self::HY => 'Armenian (hy)',
      self::AZ => 'Azerbaijani (az)',
      self::EU => 'Basque (eu)',
      self::BE => 'Belarusian (be)',
      self::BN => 'Bengali (bn)',
      self::BS => 'Bosnian (bs)',
      self::BG => 'Bulgarian (bg)',
      self::CA => 'Catalan (ca)',
      self::CEB => 'Cebuano (ceb)',
      self::NY => 'Chichewa (ny)',
      self::ZH => 'Chinese (Simplified) (zh)',
      self::CO => 'Corsican (co)',
      self::HR => 'Croatian (hr)',
      self::CS => 'Czech (cs)',
      self::DA => 'Danish (da)',
      self::NL => 'Dutch (nl)',
      self::EN => 'English (en)',
      self::EO => 'Esperanto (eo)',
      self::ET => 'Estonian (et)',
      self::TL => 'Filipino (tl)',
      self::FI => 'Finnish (fi)',
      self::FR => 'French (fr)',
      self::FY => 'Frisian (fy)',
      self::GL => 'Galician (gl)',
      self::KA => 'Georgian (ka)',
      self::DE => 'German (de)',
      self::EL => 'Greek (el)',
      self::GU => 'Gujarati (gu)',
      self::HT => 'Haitian Creole (ht)',
      self::HA => 'Hausa (ha)',
      self::HAW => 'Hawaiian (haw)',
      self::IW => 'Hebrew (iw)',
      self::HI => 'Hindi (hi)',
      self::HMN => 'Hmong (hmn)',
      self::HU => 'Hungarian (hu)',
      self::IS => 'Icelandic (is)',
      self::IG => 'Igbo (ig)',
      self::ID => 'Indonesian (id)',
      self::GA => 'Irish (ga)',
      self::IT => 'Italian (it)',
      self::JA => 'Japanese (ja)',
      self::JW => 'Javanese (jw)',
      self::KN => 'Kannada (kn)',
      self::KK => 'Kazakh (kk)',
      self::KM => 'Khmer (km)',
      self::RW => 'Kinyarwanda (rw)',
      self::KO => 'Korean (ko)',
      self::KU => 'Kurdish (ku)',
      self::KY => 'Kyrgyz (ky)',
      self::LO => 'Lao (lo)',
      self::LA => 'Latin (la)',
      self::LV => 'Latvian (lv)',
      self::LT => 'Lithuanian (lt)',
      self::LB => 'Luxembourgish (lb)',
      self::MK => 'Macedonian (mk)',
      self::MG => 'Malagasy (mg)',
      self::MS => 'Malay (ms)',
      self::ML => 'Malayalam (ml)',
      self::MT => 'Maltese (mt)',
      self::MI => 'Maori (mi)',
      self::MR => 'Marathi (mr)',
      self::MN => 'Mongolian (mn)',
      self::MY => 'Burmese (my)',
      self::NE => 'Nepali (ne)',
      self::NO => 'Norwegian (no)',
      self::OR => 'Odia (or)',
      self::PS => 'Pashto (ps)',
      self::FA => 'Persian (fa)',
      self::PL => 'Polish (pl)',
      self::PT => 'Portuguese (pt)',
      self::PA => 'Punjabi (pa)',
      self::RO => 'Romanian (ro)',
      self::RU => 'Russian (ru)',
      self::SM => 'Samoan (sm)',
      self::GD => 'Scots Gaelic (gd)',
      self::SR => 'Serbian (sr)',
      self::ST => 'Sesotho (st)',
      self::SN => 'Shona (sn)',
      self::SD => 'Sindhi (sd)',
      self::SI => 'Sinhala (si)',
      self::SK => 'Slovak (sk)',
      self::SL => 'Slovenian (sl)',
      self::SO => 'Somali (so)',
      self::ES => 'Spanish (es)',
      self::SU => 'Sundanese (su)',
      self::SW => 'Swahili (sw)',
      self::SV => 'Swedish (sv)',
      self::TG => 'Tajik (tg)',
      self::TA => 'Tamil (ta)',
      self::TE => 'Telugu (te)',
      self::TH => 'Thai (th)',
      self::TR => 'Turkish (tr)',
      self::UK => 'Ukrainian (uk)',
      self::UR => 'Urdu (ur)',
      self::UG => 'Uyghur (ug)',
      self::UZ => 'Uzbek (uz)',
      self::VI => 'Vietnamese (vi)',
      self::CY => 'Welsh (cy)',
      self::XH => 'Xhosa (xh)',
      self::YI => 'Yiddish (yi)',
      self::YO => 'Yoruba (yo)',
      self::ZU => 'Zulu (zu)',
    };
  }
}
