<?php

namespace App\Enums;

enum TimeZone: string
{
    case UTC = 'UTC';
    case AFRICA_ABIDJAN = 'Africa/Abidjan';
    case AFRICA_ACCRA = 'Africa/Accra';
    case AFRICA_ADDIS_ABABA = 'Africa/Addis_Ababa';
    case AFRICA_ALGIERS = 'Africa/Algiers';
    case AFRICA_ASMARA = 'Africa/Asmara';
    case AFRICA_BAMAKO = 'Africa/Bamako';
    case AFRICA_BANGUI = 'Africa/Bangui';
    case AFRICA_BANJUL = 'Africa/Banjul';
    case AFRICA_BISSAU = 'Africa/Bissau';
    case AFRICA_BLANTYRE = 'Africa/Blantyre';
    case AFRICA_BRAZZAVILLE = 'Africa/Brazzaville';
    case AFRICA_BUJUMBURA = 'Africa/Bujumbura';
    case AFRICA_CAIRO = 'Africa/Cairo';
    case AFRICA_CASABLANCA = 'Africa/Casablanca';
    case AFRICA_CEUTA = 'Africa/Ceuta';
    case AFRICA_CONAKRY = 'Africa/Conakry';
    case AFRICA_DAKAR = 'Africa/Dakar';
    case AFRICA_DAR_ES_SALAAM = 'Africa/Dar_es_Salaam';
    case AFRICA_DJIBOUTI = 'Africa/Djibouti';
    case AFRICA_DOUALA = 'Africa/Douala';
    case AFRICA_EL_AAIUN = 'Africa/El_Aaiun';
    case AFRICA_FREETOWN = 'Africa/Freetown';
    case AFRICA_GABORONE = 'Africa/Gaborone';
    case AFRICA_HARARE = 'Africa/Harare';
    case AFRICA_JOHANNESBURG = 'Africa/Johannesburg';
    case AFRICA_JUBA = 'Africa/Juba';
    case AFRICA_KAMPALA = 'Africa/Kampala';
    case AFRICA_KHARTOUM = 'Africa/Khartoum';
    case AFRICA_KIGALI = 'Africa/Kigali';
    case AFRICA_KINSHASA = 'Africa/Kinshasa';
    case AFRICA_LAGOS = 'Africa/Lagos';
    case AFRICA_LIBREVILLE = 'Africa/Libreville';
    case AFRICA_LOME = 'Africa/Lome';
    case AFRICA_LUANDA = 'Africa/Luanda';
    case AFRICA_LUBUMBASHI = 'Africa/Lubumbashi';
    case AFRICA_LUSAKA = 'Africa/Lusaka';
    case AFRICA_MALABO = 'Africa/Malabo';
    case AFRICA_MAPUTO = 'Africa/Maputo';
    case AFRICA_MASERU = 'Africa/Maseru';
    case AFRICA_MBABANE = 'Africa/Mbabane';
    case AFRICA_MOGADISHU = 'Africa/Mogadishu';
    case AFRICA_MONROVIA = 'Africa/Monrovia';
    case AFRICA_NAIROBI = 'Africa/Nairobi';
    case AFRICA_NDJAMENA = 'Africa/Ndjamena';
    case AFRICA_NIAMEY = 'Africa/Niamey';
    case AFRICA_NOUAKCHOTT = 'Africa/Nouakchott';
    case AFRICA_OUAGADOUGOU = 'Africa/Ouagadougou';
    case AFRICA_PORTO_NOVO = 'Africa/Porto-Novo';
    case AFRICA_SAO_TOME = 'Africa/Sao_Tome';
    case AFRICA_TRIPOLI = 'Africa/Tripoli';
    case AFRICA_TUNIS = 'Africa/Tunis';
    case AFRICA_WINDHOEK = 'Africa/Windhoek';
    case AMERICA_ADAK = 'America/Adak';
    case AMERICA_ANCHORAGE = 'America/Anchorage';
    case AMERICA_ANGUILLA = 'America/Anguilla';
    case AMERICA_ANTIGUA = 'America/Antigua';
    case AMERICA_ARAGUAINA = 'America/Araguaina';
    case AMERICA_ARGENTINA_BUENOS_AIRES = 'America/Argentina/Buenos_Aires';
    case AMERICA_ARGENTINA_CATAMARCA = 'America/Argentina/Catamarca';
    case AMERICA_ARGENTINA_CORDOBA = 'America/Argentina/Cordoba';
    case AMERICA_ARGENTINA_JUJUY = 'America/Argentina/Jujuy';
    case AMERICA_ARGENTINA_LA_RIOJA = 'America/Argentina/La_Rioja';
    case AMERICA_ARGENTINA_MENDOZA = 'America/Argentina/Mendoza';
    case AMERICA_ARGENTINA_RIO_GALLEGOS = 'America/Argentina/Rio_Gallegos';
    case AMERICA_ARGENTINA_SALTA = 'America/Argentina/Salta';
    case AMERICA_ARGENTINA_SAN_JUAN = 'America/Argentina/San_Juan';
    case AMERICA_ARGENTINA_SAN_LUIS = 'America/Argentina/San_Luis';
    case AMERICA_ARGENTINA_TUCUMAN = 'America/Argentina/Tucuman';
    case AMERICA_ARGENTINA_USHUAIA = 'America/Argentina/Ushuaia';
    case AMERICA_ARUBA = 'America/Aruba';
    case AMERICA_ASUNCION = 'America/Asuncion';
    case AMERICA_ATIKOKAN = 'America/Atikokan';
    case AMERICA_BAHIA = 'America/Bahia';
    case AMERICA_BAHIA_BANDERAS = 'America/Bahia_Banderas';
    case AMERICA_BARBADOS = 'America/Barbados';
    case AMERICA_BELEM = 'America/Belem';
    case AMERICA_BELIZE = 'America/Belize';
    case AMERICA_BLANC_SABLON = 'America/Blanc-Sablon';
    case AMERICA_BOA_VISTA = 'America/Boa_Vista';
    case AMERICA_BOGOTA = 'America/Bogota';
    case AMERICA_BOISE = 'America/Boise';
    case AMERICA_CAMBRIDGE_BAY = 'America/Cambridge_Bay';
    case AMERICA_CAMPO_GRANDE = 'America/Campo_Grande';
    case AMERICA_CANCUN = 'America/Cancun';
    case AMERICA_CARACAS = 'America/Caracas';
    case AMERICA_CAYENNE = 'America/Cayenne';
    case AMERICA_CAYMAN = 'America/Cayman';
    case AMERICA_CHICAGO = 'America/Chicago';
    case AMERICA_CHIHUAHUA = 'America/Chihuahua';
    case AMERICA_CIUDAD_JUAREZ = 'America/Ciudad_Juarez';
    case AMERICA_COSTA_RICA = 'America/Costa_Rica';
    case AMERICA_CRESTON = 'America/Creston';
    case AMERICA_CUIABA = 'America/Cuiaba';
    case AMERICA_CURACAO = 'America/Curacao';
    case AMERICA_DANMARKSHAVN = 'America/Danmarkshavn';
    case AMERICA_DAWSON = 'America/Dawson';
    case AMERICA_DAWSON_CREEK = 'America/Dawson_Creek';
    case AMERICA_DENVER = 'America/Denver';
    case AMERICA_DETROIT = 'America/Detroit';
    case AMERICA_DOMINICA = 'America/Dominica';
    case AMERICA_EDMONTON = 'America/Edmonton';
    case AMERICA_EIRUNEPE = 'America/Eirunepe';
    case AMERICA_EL_SALVADOR = 'America/El_Salvador';
    case AMERICA_FORT_NELSON = 'America/Fort_Nelson';
    case AMERICA_FORTALEZA = 'America/Fortaleza';
    case AMERICA_GLACE_BAY = 'America/Glace_Bay';
    case AMERICA_GOOSE_BAY = 'America/Goose_Bay';
    case AMERICA_GRAND_TURK = 'America/Grand_Turk';
    case AMERICA_GRENADA = 'America/Grenada';
    case AMERICA_GUADELOUPE = 'America/Guadeloupe';
    case AMERICA_GUATEMALA = 'America/Guatemala';
    case AMERICA_GUAYAQUIL = 'America/Guayaquil';
    case AMERICA_GUYANA = 'America/Guyana';
    case AMERICA_HALIFAX = 'America/Halifax';
    case AMERICA_HAVANA = 'America/Havana';
    case AMERICA_HERMOSILLO = 'America/Hermosillo';
    case AMERICA_INDIANA_INDIANAPOLIS = 'America/Indiana/Indianapolis';
    case AMERICA_INDIANA_KNOX = 'America/Indiana/Knox';
    case AMERICA_INDIANA_MARENGO = 'America/Indiana/Marengo';
    case AMERICA_INDIANA_PETERSBURG = 'America/Indiana/Petersburg';
    case AMERICA_INDIANA_TELL_CITY = 'America/Indiana/Tell_City';
    case AMERICA_INDIANA_VEVAY = 'America/Indiana/Vevay';
    case AMERICA_INDIANA_VINCENNES = 'America/Indiana/Vincennes';
    case AMERICA_INDIANA_WINAMAC = 'America/Indiana/Winamac';
    case AMERICA_INUVIK = 'America/Inuvik';
    case AMERICA_IQALUIT = 'America/Iqaluit';
    case AMERICA_JAMAICA = 'America/Jamaica';
    case AMERICA_JUNEAU = 'America/Juneau';
    case AMERICA_KENTUCKY_LOUISVILLE = 'America/Kentucky/Louisville';
    case AMERICA_KENTUCKY_MONTICELLO = 'America/Kentucky/Monticello';
    case AMERICA_KRALENDIJK = 'America/Kralendijk';
    case AMERICA_LA_PAZ = 'America/La_Paz';
    case AMERICA_LIMA = 'America/Lima';
    case AMERICA_LOS_ANGELES = 'America/Los_Angeles';
    case AMERICA_LOWER_PRINCES = 'America/Lower_Princes';
    case AMERICA_MACEIO = 'America/Maceio';
    case AMERICA_MANAGUA = 'America/Managua';
    case AMERICA_MANAUS = 'America/Manaus';
    case AMERICA_MARIGOT = 'America/Marigot';
    case AMERICA_MARTINIQUE = 'America/Martinique';
    case AMERICA_MATAMOROS = 'America/Matamoros';
    case AMERICA_MAZATLAN = 'America/Mazatlan';
    case AMERICA_MENOMINEE = 'America/Menominee';
    case AMERICA_MERIDA = 'America/Merida';
    case AMERICA_METLAKATLA = 'America/Metlakatla';
    case AMERICA_MEXICO_CITY = 'America/Mexico_City';
    case AMERICA_MIQUELON = 'America/Miquelon';
    case AMERICA_MONCTON = 'America/Moncton';
    case AMERICA_MONTERREY = 'America/Monterrey';
    case AMERICA_MONTEVIDEO = 'America/Montevideo';
    case AMERICA_MONTSERRAT = 'America/Montserrat';
    case AMERICA_NASSAU = 'America/Nassau';
    case AMERICA_NEW_YORK = 'America/New_York';
    case AMERICA_NOME = 'America/Nome';
    case AMERICA_NORONHA = 'America/Noronha';
    case AMERICA_NORTH_DAKOTA_BEULAH = 'America/North_Dakota/Beulah';
    case AMERICA_NORTH_DAKOTA_CENTER = 'America/North_Dakota/Center';
    case AMERICA_NORTH_DAKOTA_NEW_SALEM = 'America/North_Dakota/New_Salem';
    case AMERICA_NUUK = 'America/Nuuk';
    case AMERICA_OJINAGA = 'America/Ojinaga';
    case AMERICA_PANAMA = 'America/Panama';
    case AMERICA_PARAMARIBO = 'America/Paramaribo';
    case AMERICA_PHOENIX = 'America/Phoenix';
    case AMERICA_PORT_AU_PRINCE = 'America/Port-au-Prince';
    case AMERICA_PORT_OF_SPAIN = 'America/Port_of_Spain';
    case AMERICA_PORTO_VELHO = 'America/Porto_Velho';
    case AMERICA_PUERTO_RICO = 'America/Puerto_Rico';
    case AMERICA_PUNTA_ARENAS = 'America/Punta_Arenas';
    case AMERICA_RANKIN_INLET = 'America/Rankin_Inlet';
    case AMERICA_RECIFE = 'America/Recife';
    case AMERICA_REGINA = 'America/Regina';
    case AMERICA_RESOLUTE = 'America/Resolute';
    case AMERICA_RIO_BRANCO = 'America/Rio_Branco';
    case AMERICA_SANTAREM = 'America/Santarem';
    case AMERICA_SANTIAGO = 'America/Santiago';
    case AMERICA_SANTO_DOMINGO = 'America/Santo_Domingo';
    case AMERICA_SAO_PAULO = 'America/Sao_Paulo';
    case AMERICA_SCORESBYSUND = 'America/Scoresbysund';
    case AMERICA_SITKA = 'America/Sitka';
    case AMERICA_ST_BARTHELEMY = 'America/St_Barthelemy';
    case AMERICA_ST_JOHNS = 'America/St_Johns';
    case AMERICA_ST_KITTS = 'America/St_Kitts';
    case AMERICA_ST_LUCIA = 'America/St_Lucia';
    case AMERICA_ST_THOMAS = 'America/St_Thomas';
    case AMERICA_ST_VINCENT = 'America/St_Vincent';
    case AMERICA_SWIFT_CURRENT = 'America/Swift_Current';
    case AMERICA_TEGUCIGALPA = 'America/Tegucigalpa';
    case AMERICA_THULE = 'America/Thule';
    case AMERICA_TIJUANA = 'America/Tijuana';
    case AMERICA_TORONTO = 'America/Toronto';
    case AMERICA_TORTOLA = 'America/Tortola';
    case AMERICA_VANCOUVER = 'America/Vancouver';
    case AMERICA_WHITEHORSE = 'America/Whitehorse';
    case AMERICA_WINNIPEG = 'America/Winnipeg';
    case AMERICA_YAKUTAT = 'America/Yakutat';
    case ANTARCTICA_CASEY = 'Antarctica/Casey';
    case ANTARCTICA_DAVIS = 'Antarctica/Davis';
    case ANTARCTICA_DUMONTDURVILLE = 'Antarctica/DumontDUrville';
    case ANTARCTICA_MACQUARIE = 'Antarctica/Macquarie';
    case ANTARCTICA_MAWSON = 'Antarctica/Mawson';
    case ANTARCTICA_MCMURDO = 'Antarctica/McMurdo';
    case ANTARCTICA_PALMER = 'Antarctica/Palmer';
    case ANTARCTICA_ROTHERA = 'Antarctica/Rothera';
    case ANTARCTICA_SYOWA = 'Antarctica/Syowa';
    case ANTARCTICA_TROLL = 'Antarctica/Troll';
    case ANTARCTICA_VOSTOK = 'Antarctica/Vostok';
    case ARCTIC_LONGYEARBYEN = 'Arctic/Longyearbyen';
    case ASIA_ADEN = 'Asia/Aden';
    case ASIA_ALMATY = 'Asia/Almaty';
    case ASIA_AMMAN = 'Asia/Amman';
    case ASIA_ANADYR = 'Asia/Anadyr';
    case ASIA_AQTAU = 'Asia/Aqtau';
    case ASIA_AQTOBE = 'Asia/Aqtobe';
    case ASIA_ASHGABAT = 'Asia/Ashgabat';
    case ASIA_ATYRAU = 'Asia/Atyrau';
    case ASIA_BAGHDAD = 'Asia/Baghdad';
    case ASIA_BAHRAIN = 'Asia/Bahrain';
    case ASIA_BAKU = 'Asia/Baku';
    case ASIA_BANGKOK = 'Asia/Bangkok';
    case ASIA_BARNAUL = 'Asia/Barnaul';
    case ASIA_BEIRUT = 'Asia/Beirut';
    case ASIA_BISHKEK = 'Asia/Bishkek';
    case ASIA_BRUNEI = 'Asia/Brunei';
    case ASIA_CHITA = 'Asia/Chita';
    case ASIA_CHOIBALSAN = 'Asia/Choibalsan';
    case ASIA_COLOMBO = 'Asia/Colombo';
    case ASIA_DAMASCUS = 'Asia/Damascus';
    case ASIA_DHAKA = 'Asia/Dhaka';
    case ASIA_DILI = 'Asia/Dili';
    case ASIA_DUBAI = 'Asia/Dubai';
    case ASIA_DUSHANBE = 'Asia/Dushanbe';
    case ASIA_FAMAGUSTA = 'Asia/Famagusta';
    case ASIA_GAZA = 'Asia/Gaza';
    case ASIA_HEBRON = 'Asia/Hebron';
    case ASIA_HO_CHI_MINH = 'Asia/Ho_Chi_Minh';
    case ASIA_HONG_KONG = 'Asia/Hong_Kong';
    case ASIA_HOVD = 'Asia/Hovd';
    case ASIA_IRKUTSK = 'Asia/Irkutsk';
    case ASIA_JAKARTA = 'Asia/Jakarta';
    case ASIA_JAYAPURA = 'Asia/Jayapura';
    case ASIA_JERUSALEM = 'Asia/Jerusalem';
    case ASIA_KABUL = 'Asia/Kabul';
    case ASIA_KAMCHATKA = 'Asia/Kamchatka';
    case ASIA_KARACHI = 'Asia/Karachi';
    case ASIA_KATHMANDU = 'Asia/Kathmandu';
    case ASIA_KHANDYGA = 'Asia/Khandyga';
    case ASIA_KOLKATA = 'Asia/Kolkata';
    case ASIA_KRASNOYARSK = 'Asia/Krasnoyarsk';
    case ASIA_KUALA_LUMPUR = 'Asia/Kuala_Lumpur';
    case ASIA_KUCHING = 'Asia/Kuching';
    case ASIA_KUWAIT = 'Asia/Kuwait';
    case ASIA_MACAU = 'Asia/Macau';
    case ASIA_MAGADAN = 'Asia/Magadan';
    case ASIA_MAKASSAR = 'Asia/Makassar';
    case ASIA_MANILA = 'Asia/Manila';
    case ASIA_MUSCAT = 'Asia/Muscat';
    case ASIA_NICOSIA = 'Asia/Nicosia';
    case ASIA_NOVOKUZNETSK = 'Asia/Novokuznetsk';
    case ASIA_NOVOSIBIRSK = 'Asia/Novosibirsk';
    case ASIA_OMSK = 'Asia/Omsk';
    case ASIA_ORAL = 'Asia/Oral';
    case ASIA_PHNOM_PENH = 'Asia/Phnom_Penh';
    case ASIA_PONTIANAK = 'Asia/Pontianak';
    case ASIA_PYONGYANG = 'Asia/Pyongyang';
    case ASIA_QATAR = 'Asia/Qatar';
    case ASIA_QOSTANAY = 'Asia/Qostanay';
    case ASIA_QYZYLORDA = 'Asia/Qyzylorda';
    case ASIA_RIYADH = 'Asia/Riyadh';
    case ASIA_SAKHALIN = 'Asia/Sakhalin';
    case ASIA_SAMARKAND = 'Asia/Samarkand';
    case ASIA_SEOUL = 'Asia/Seoul';
    case ASIA_SHANGHAI = 'Asia/Shanghai';
    case ASIA_SINGAPORE = 'Asia/Singapore';
    case ASIA_SREDNEKOLYMSK = 'Asia/Srednekolymsk';
    case ASIA_TAIPEI = 'Asia/Taipei';
    case ASIA_TASHKENT = 'Asia/Tashkent';
    case ASIA_TBILISI = 'Asia/Tbilisi';
    case ASIA_TEHRAN = 'Asia/Tehran';
    case ASIA_THIMPHU = 'Asia/Thimphu';
    case ASIA_TOKYO = 'Asia/Tokyo';
    case ASIA_TOMSK = 'Asia/Tomsk';
    case ASIA_ULAANBAATAR = 'Asia/Ulaanbaatar';
    case ASIA_URUMQI = 'Asia/Urumqi';
    case ASIA_UST_NERA = 'Asia/Ust-Nera';
    case ASIA_VIENTIANE = 'Asia/Vientiane';
    case ASIA_VLADIVOSTOK = 'Asia/Vladivostok';
    case ASIA_YAKUTSK = 'Asia/Yakutsk';
    case ASIA_YANGON = 'Asia/Yangon';
    case ASIA_YEKATERINBURG = 'Asia/Yekaterinburg';
    case ASIA_YEREVAN = 'Asia/Yerevan';
    case ATLANTIC_AZORES = 'Atlantic/Azores';
    case ATLANTIC_BERMUDA = 'Atlantic/Bermuda';
    case ATLANTIC_CANARY = 'Atlantic/Canary';
    case ATLANTIC_CAPE_VERDE = 'Atlantic/Cape_Verde';
    case ATLANTIC_FAROE = 'Atlantic/Faroe';
    case ATLANTIC_MADEIRA = 'Atlantic/Madeira';
    case ATLANTIC_REYKJAVIK = 'Atlantic/Reykjavik';
    case ATLANTIC_SOUTH_GEORGIA = 'Atlantic/South_Georgia';
    case ATLANTIC_ST_HELENA = 'Atlantic/St_Helena';
    case ATLANTIC_STANLEY = 'Atlantic/Stanley';
    case AUSTRALIA_ADELAIDE = 'Australia/Adelaide';
    case AUSTRALIA_BRISBANE = 'Australia/Brisbane';
    case AUSTRALIA_BROKEN_HILL = 'Australia/Broken_Hill';
    case AUSTRALIA_DARWIN = 'Australia/Darwin';
    case AUSTRALIA_EUCLA = 'Australia/Eucla';
    case AUSTRALIA_HOBART = 'Australia/Hobart';
    case AUSTRALIA_LINDEMAN = 'Australia/Lindeman';
    case AUSTRALIA_LORD_HOWE = 'Australia/Lord_Howe';
    case AUSTRALIA_MELBOURNE = 'Australia/Melbourne';
    case AUSTRALIA_PERTH = 'Australia/Perth';
    case AUSTRALIA_SYDNEY = 'Australia/Sydney';
    case EUROPE_AMSTERDAM = 'Europe/Amsterdam';
    case EUROPE_ANDORRA = 'Europe/Andorra';
    case EUROPE_ASTRAKHAN = 'Europe/Astrakhan';
    case EUROPE_ATHENS = 'Europe/Athens';
    case EUROPE_BELGRADE = 'Europe/Belgrade';
    case EUROPE_BERLIN = 'Europe/Berlin';
    case EUROPE_BRATISLAVA = 'Europe/Bratislava';
    case EUROPE_BRUSSELS = 'Europe/Brussels';
    case EUROPE_BUCHAREST = 'Europe/Bucharest';
    case EUROPE_BUDAPEST = 'Europe/Budapest';
    case EUROPE_BUSINGEN = 'Europe/Busingen';
    case EUROPE_CHISINAU = 'Europe/Chisinau';
    case EUROPE_COPENHAGEN = 'Europe/Copenhagen';
    case EUROPE_DUBLIN = 'Europe/Dublin';
    case EUROPE_GIBRALTAR = 'Europe/Gibraltar';
    case EUROPE_GUERNSEY = 'Europe/Guernsey';
    case EUROPE_HELSINKI = 'Europe/Helsinki';
    case EUROPE_ISLE_OF_MAN = 'Europe/Isle_of_Man';
    case EUROPE_ISTANBUL = 'Europe/Istanbul';
    case EUROPE_JERSEY = 'Europe/Jersey';
    case EUROPE_KALININGRAD = 'Europe/Kaliningrad';
    case EUROPE_KIROV = 'Europe/Kirov';
    case EUROPE_KYIV = 'Europe/Kyiv';
    case EUROPE_LISBON = 'Europe/Lisbon';
    case EUROPE_LJUBLJANA = 'Europe/Ljubljana';
    case EUROPE_LONDON = 'Europe/London';
    case EUROPE_LUXEMBOURG = 'Europe/Luxembourg';
    case EUROPE_MADRID = 'Europe/Madrid';
    case EUROPE_MALTA = 'Europe/Malta';
    case EUROPE_MARIEHAMN = 'Europe/Mariehamn';
    case EUROPE_MINSK = 'Europe/Minsk';
    case EUROPE_MONACO = 'Europe/Monaco';
    case EUROPE_MOSCOW = 'Europe/Moscow';
    case EUROPE_OSLO = 'Europe/Oslo';
    case EUROPE_PARIS = 'Europe/Paris';
    case EUROPE_PODGORICA = 'Europe/Podgorica';
    case EUROPE_PRAGUE = 'Europe/Prague';
    case EUROPE_RIGA = 'Europe/Riga';
    case EUROPE_ROME = 'Europe/Rome';
    case EUROPE_SAMARA = 'Europe/Samara';
    case EUROPE_SAN_MARINO = 'Europe/San_Marino';
    case EUROPE_SARAJEVO = 'Europe/Sarajevo';
    case EUROPE_SARATOV = 'Europe/Saratov';
    case EUROPE_SIMFEROPOL = 'Europe/Simferopol';
    case EUROPE_SKOPJE = 'Europe/Skopje';
    case EUROPE_SOFIA = 'Europe/Sofia';
    case EUROPE_STOCKHOLM = 'Europe/Stockholm';
    case EUROPE_TALLINN = 'Europe/Tallinn';
    case EUROPE_TIRANE = 'Europe/Tirane';
    case EUROPE_ULYANOVSK = 'Europe/Ulyanovsk';
    case EUROPE_VADUZ = 'Europe/Vaduz';
    case EUROPE_VATICAN = 'Europe/Vatican';
    case EUROPE_VIENNA = 'Europe/Vienna';
    case EUROPE_VILNIUS = 'Europe/Vilnius';
    case EUROPE_VOLGOGRAD = 'Europe/Volgograd';
    case EUROPE_WARSAW = 'Europe/Warsaw';
    case EUROPE_ZAGREB = 'Europe/Zagreb';
    case EUROPE_ZURICH = 'Europe/Zurich';
    case INDIAN_ANTANANARIVO = 'Indian/Antananarivo';
    case INDIAN_CHAGOS = 'Indian/Chagos';
    case INDIAN_CHRISTMAS = 'Indian/Christmas';
    case INDIAN_COCOS = 'Indian/Cocos';
    case INDIAN_COMORO = 'Indian/Comoro';
    case INDIAN_KERGUELEN = 'Indian/Kerguelen';
    case INDIAN_MAHE = 'Indian/Mahe';
    case INDIAN_MALDIVES = 'Indian/Maldives';
    case INDIAN_MAURITIUS = 'Indian/Mauritius';
    case INDIAN_MAYOTTE = 'Indian/Mayotte';
    case INDIAN_REUNION = 'Indian/Reunion';
    case PACIFIC_APIA = 'Pacific/Apia';
    case PACIFIC_AUCKLAND = 'Pacific/Auckland';
    case PACIFIC_BOUGAINVILLE = 'Pacific/Bougainville';
    case PACIFIC_CHATHAM = 'Pacific/Chatham';
    case PACIFIC_CHUUK = 'Pacific/Chuuk';
    case PACIFIC_EASTER = 'Pacific/Easter';
    case PACIFIC_EFATE = 'Pacific/Efate';
    case PACIFIC_FAKAOFO = 'Pacific/Fakaofo';
    case PACIFIC_FIJI = 'Pacific/Fiji';
    case PACIFIC_FUNAFUTI = 'Pacific/Funafuti';
    case PACIFIC_GALAPAGOS = 'Pacific/Galapagos';
    case PACIFIC_GAMBIER = 'Pacific/Gambier';
    case PACIFIC_GUADALCANAL = 'Pacific/Guadalcanal';
    case PACIFIC_GUAM = 'Pacific/Guam';
    case PACIFIC_HONOLULU = 'Pacific/Honolulu';
    case PACIFIC_KANTON = 'Pacific/Kanton';
    case PACIFIC_KIRITIMATI = 'Pacific/Kiritimati';
    case PACIFIC_KOSRAE = 'Pacific/Kosrae';
    case PACIFIC_KWAJALEIN = 'Pacific/Kwajalein';
    case PACIFIC_MAJURO = 'Pacific/Majuro';
    case PACIFIC_MARQUESAS = 'Pacific/Marquesas';
    case PACIFIC_MIDWAY = 'Pacific/Midway';
    case PACIFIC_NAURU = 'Pacific/Nauru';
    case PACIFIC_NIUE = 'Pacific/Niue';
    case PACIFIC_NORFOLK = 'Pacific/Norfolk';
    case PACIFIC_NOUMEA = 'Pacific/Noumea';
    case PACIFIC_PAGO_PAGO = 'Pacific/Pago_Pago';
    case PACIFIC_PALAU = 'Pacific/Palau';
    case PACIFIC_PITCAIRN = 'Pacific/Pitcairn';
    case PACIFIC_POHNPEI = 'Pacific/Pohnpei';
    case PACIFIC_PORT_MORESBY = 'Pacific/Port_Moresby';
    case PACIFIC_RAROTONGA = 'Pacific/Rarotonga';
    case PACIFIC_SAIPAN = 'Pacific/Saipan';
    case PACIFIC_TAHITI = 'Pacific/Tahiti';
    case PACIFIC_TARAWA = 'Pacific/Tarawa';
    case PACIFIC_TONGATAPU = 'Pacific/Tongatapu';
    case PACIFIC_WAKE = 'Pacific/Wake';
    case PACIFIC_WALLIS = 'Pacific/Wallis';

    public function label(): string
    {
        return match($this) {
            self::UTC => 'UTC',
            self::AFRICA_ABIDJAN => 'Abidjan',
            self::AFRICA_ACCRA => 'Accra',
            self::AFRICA_ADDIS_ABABA => 'Addis Ababa (EAT)',
            self::AFRICA_ALGIERS => 'Algiers',
            self::AFRICA_ASMARA => 'Asmara (EAT)',
            self::AFRICA_BAMAKO => 'Bamako',
            self::AFRICA_BANGUI => 'Bangui',
            self::AFRICA_BANJUL => 'Banjul',
            self::AFRICA_BISSAU => 'Bissau',
            self::AFRICA_BLANTYRE => 'Blantyre',
            self::AFRICA_BRAZZAVILLE => 'Brazzaville',
            self::AFRICA_BUJUMBURA => 'Bujumbura',
            self::AFRICA_CAIRO => 'Cairo',
            self::AFRICA_CASABLANCA => 'Casablanca',
            self::AFRICA_CEUTA => 'Ceuta',
            self::AFRICA_CONAKRY => 'Conakry',
            self::AFRICA_DAKAR => 'Dakar',
            self::AFRICA_DAR_ES_SALAAM => 'Dar es Salaam (EAT)',
            self::AFRICA_DJIBOUTI => 'Djibouti (EAT)',
            self::AFRICA_DOUALA => 'Douala',
            self::AFRICA_EL_AAIUN => 'El Aaiun',
            self::AFRICA_FREETOWN => 'Freetown',
            self::AFRICA_GABORONE => 'Gaborone',
            self::AFRICA_HARARE => 'Harare',
            self::AFRICA_JOHANNESBURG => 'Johannesburg',
            self::AFRICA_JUBA => 'Juba',
            self::AFRICA_KAMPALA => 'Kampala (EAT)',
            self::AFRICA_KHARTOUM => 'Khartoum (EAT)',
            self::AFRICA_KIGALI => 'Kigali',
            self::AFRICA_KINSHASA => 'Kinshasa',
            self::AFRICA_LAGOS => 'Lagos',
            self::AFRICA_LIBREVILLE => 'Libreville',
            self::AFRICA_LOME => 'Lome',
            self::AFRICA_LUANDA => 'Luanda',
            self::AFRICA_LUBUMBASHI => 'Lubumbashi',
            self::AFRICA_LUSAKA => 'Lusaka',
            self::AFRICA_MALABO => 'Malabo',
            self::AFRICA_MAPUTO => 'Maputo',
            self::AFRICA_MASERU => 'Maseru',
            self::AFRICA_MBABANE => 'Mbabane',
            self::AFRICA_MOGADISHU => 'Mogadishu (EAT)',
            self::AFRICA_MONROVIA => 'Monrovia',
            self::AFRICA_NAIROBI => 'Nairobi (EAT)',
            self::AFRICA_NDJAMENA => 'Ndjamena',
            self::AFRICA_NIAMEY => 'Niamey',
            self::AFRICA_NOUAKCHOTT => 'Nouakchott',
            self::AFRICA_OUAGADOUGOU => 'Ouagadougou',
            self::AFRICA_PORTO_NOVO => 'Porto-Novo',
            self::AFRICA_SAO_TOME => 'Sao Tome',
            self::AFRICA_TRIPOLI => 'Tripoli',
            self::AFRICA_TUNIS => 'Tunis',
            self::AFRICA_WINDHOEK => 'Windhoek',
            self::AMERICA_ADAK => 'Adak',
            self::AMERICA_ANCHORAGE => 'Anchorage',
            self::AMERICA_ANGUILLA => 'Anguilla',
            self::AMERICA_ANTIGUA => 'Antigua',
            self::AMERICA_ARAGUAINA => 'Araguaina',
            self::AMERICA_ARGENTINA_BUENOS_AIRES => 'Buenos Aires',
            self::AMERICA_ARGENTINA_CATAMARCA => 'Catamarca',
            self::AMERICA_ARGENTINA_CORDOBA => 'Cordoba',
            self::AMERICA_ARGENTINA_JUJUY => 'Jujuy',
            self::AMERICA_ARGENTINA_LA_RIOJA => 'La Rioja',
            self::AMERICA_ARGENTINA_MENDOZA => 'Mendoza',
            self::AMERICA_ARGENTINA_RIO_GALLEGOS => 'Rio Gallegos',
            self::AMERICA_ARGENTINA_SALTA => 'Salta',
            self::AMERICA_ARGENTINA_SAN_JUAN => 'San Juan',
            self::AMERICA_ARGENTINA_SAN_LUIS => 'San Luis',
            self::AMERICA_ARGENTINA_TUCUMAN => 'Tucuman',
            self::AMERICA_ARGENTINA_USHUAIA => 'Ushuaia',
            self::AMERICA_ARUBA => 'Aruba',
            self::AMERICA_ASUNCION => 'Asuncion',
            self::AMERICA_ATIKOKAN => 'Atikokan',
            self::AMERICA_BAHIA => 'Bahia',
            self::AMERICA_BAHIA_BANDERAS => 'Bahia Banderas',
            self::AMERICA_BARBADOS => 'Barbados',
            self::AMERICA_BELEM => 'Belem',
            self::AMERICA_BELIZE => 'Belize',
            self::AMERICA_BLANC_SABLON => 'Blanc-Sablon',
            self::AMERICA_BOA_VISTA => 'Boa Vista',
            self::AMERICA_BOGOTA => 'Bogota',
            self::AMERICA_BOISE => 'Boise',
            self::AMERICA_CAMBRIDGE_BAY => 'Cambridge Bay',
            self::AMERICA_CAMPO_GRANDE => 'Campo Grande',
            self::AMERICA_CANCUN => 'Cancun',
            self::AMERICA_CARACAS => 'Caracas',
            self::AMERICA_CAYENNE => 'Cayenne',
            self::AMERICA_CAYMAN => 'Cayman',
            self::AMERICA_CHICAGO => 'Chicago',
            self::AMERICA_CHIHUAHUA => 'Chihuahua',
            self::AMERICA_CIUDAD_JUAREZ => 'Ciudad Juarez',
            self::AMERICA_COSTA_RICA => 'Costa Rica',
            self::AMERICA_CRESTON => 'Creston',
            self::AMERICA_CUIABA => 'Cuiaba',
            self::AMERICA_CURACAO => 'Curacao',
            self::AMERICA_DANMARKSHAVN => 'Danmarkshavn',
            self::AMERICA_DAWSON => 'Dawson',
            self::AMERICA_DAWSON_CREEK => 'Dawson Creek',
            self::AMERICA_DENVER => 'Denver',
            self::AMERICA_DETROIT => 'Detroit',
            self::AMERICA_DOMINICA => 'Dominica',
            self::AMERICA_EDMONTON => 'Edmonton',
            self::AMERICA_EIRUNEPE => 'Eirunepe',
            self::AMERICA_EL_SALVADOR => 'El Salvador',
            self::AMERICA_FORT_NELSON => 'Fort Nelson',
            self::AMERICA_FORTALEZA => 'Fortaleza',
            self::AMERICA_GLACE_BAY => 'Glace Bay',
            self::AMERICA_GOOSE_BAY => 'Goose Bay',
            self::AMERICA_GRAND_TURK => 'Grand Turk',
            self::AMERICA_GRENADA => 'Grenada',
            self::AMERICA_GUADELOUPE => 'Guadeloupe',
            self::AMERICA_GUATEMALA => 'Guatemala',
            self::AMERICA_GUAYAQUIL => 'Guayaquil',
            self::AMERICA_GUYANA => 'Guyana',
            self::AMERICA_HALIFAX => 'Halifax',
            self::AMERICA_HAVANA => 'Havana',
            self::AMERICA_HERMOSILLO => 'Hermosillo',
            self::AMERICA_INDIANA_INDIANAPOLIS => 'Indianapolis',
            self::AMERICA_INDIANA_KNOX => 'Knox',
            self::AMERICA_INDIANA_MARENGO => 'Marengo',
            self::AMERICA_INDIANA_PETERSBURG => 'Petersburg',
            self::AMERICA_INDIANA_TELL_CITY => 'Tell City',
            self::AMERICA_INDIANA_VEVAY => 'Vevay',
            self::AMERICA_INDIANA_VINCENNES => 'Vincennes',
            self::AMERICA_INDIANA_WINAMAC => 'Winamac',
            self::AMERICA_INUVIK => 'Inuvik',
            self::AMERICA_IQALUIT => 'Iqaluit',
            self::AMERICA_JAMAICA => 'Jamaica',
            self::AMERICA_JUNEAU => 'Juneau',
            self::AMERICA_KENTUCKY_LOUISVILLE => 'Louisville',
            self::AMERICA_KENTUCKY_MONTICELLO => 'Monticello',
            self::AMERICA_KRALENDIJK => 'Kralendijk',
            self::AMERICA_LA_PAZ => 'La Paz',
            self::AMERICA_LIMA => 'Lima',
            self::AMERICA_LOS_ANGELES => 'Los Angeles',
            self::AMERICA_LOWER_PRINCES => 'Lower Princes',
            self::AMERICA_MACEIO => 'Maceio',
            self::AMERICA_MANAGUA => 'Managua',
            self::AMERICA_MANAUS => 'Manaus',
            self::AMERICA_MARIGOT => 'Marigot',
            self::AMERICA_MARTINIQUE => 'Martinique',
            self::AMERICA_MATAMOROS => 'Matamoros',
            self::AMERICA_MAZATLAN => 'Mazatlan',
            self::AMERICA_MENOMINEE => 'Menominee',
            self::AMERICA_MERIDA => 'Merida',
            self::AMERICA_METLAKATLA => 'Metlakatla',
            self::AMERICA_MEXICO_CITY => 'Mexico City',
            self::AMERICA_MIQUELON => 'Miquelon',
            self::AMERICA_MONCTON => 'Moncton',
            self::AMERICA_MONTERREY => 'Monterrey',
            self::AMERICA_MONTEVIDEO => 'Montevideo',
            self::AMERICA_MONTSERRAT => 'Montserrat',
            self::AMERICA_NASSAU => 'Nassau',
            self::AMERICA_NEW_YORK => 'New York',
            self::AMERICA_NOME => 'Nome',
            self::AMERICA_NORONHA => 'Noronha',
            self::AMERICA_NORTH_DAKOTA_BEULAH => 'Beulah',
            self::AMERICA_NORTH_DAKOTA_CENTER => 'Center',
            self::AMERICA_NORTH_DAKOTA_NEW_SALEM => 'New Salem',
            self::AMERICA_NUUK => 'Nuuk',
            self::AMERICA_OJINAGA => 'Ojinaga',
            self::AMERICA_PANAMA => 'Panama',
            self::AMERICA_PARAMARIBO => 'Paramaribo',
            self::AMERICA_PHOENIX => 'Phoenix',
            self::AMERICA_PORT_AU_PRINCE => 'Port-au-Prince',
            self::AMERICA_PORT_OF_SPAIN => 'Port of Spain',
            self::AMERICA_PORTO_VELHO => 'Porto Velho',
            self::AMERICA_PUERTO_RICO => 'Puerto Rico',
            self::AMERICA_PUNTA_ARENAS => 'Punta Arenas',
            self::AMERICA_RANKIN_INLET => 'Rankin Inlet',
            self::AMERICA_RECIFE => 'Recife',
            self::AMERICA_REGINA => 'Regina',
            self::AMERICA_RESOLUTE => 'Resolute',
            self::AMERICA_RIO_BRANCO => 'Rio Branco',
            self::AMERICA_SANTAREM => 'Santarem',
            self::AMERICA_SANTIAGO => 'Santiago',
            self::AMERICA_SANTO_DOMINGO => 'Santo Domingo',
            self::AMERICA_SAO_PAULO => 'Sao Paulo',
            self::AMERICA_SCORESBYSUND => 'Scoresbysund',
            self::AMERICA_SITKA => 'Sitka',
            self::AMERICA_ST_BARTHELEMY => 'St Barthelemy',
            self::AMERICA_ST_JOHNS => 'St Johns',
            self::AMERICA_ST_KITTS => 'St Kitts',
            self::AMERICA_ST_LUCIA => 'St Lucia',
            self::AMERICA_ST_THOMAS => 'St Thomas',
            self::AMERICA_ST_VINCENT => 'St Vincent',
            self::AMERICA_SWIFT_CURRENT => 'Swift Current',
            self::AMERICA_TEGUCIGALPA => 'Tegucigalpa',
            self::AMERICA_THULE => 'Thule',
            self::AMERICA_TIJUANA => 'Tijuana',
            self::AMERICA_TORONTO => 'Toronto',
            self::AMERICA_TORTOLA => 'Tortola',
            self::AMERICA_VANCOUVER => 'Vancouver',
            self::AMERICA_WHITEHORSE => 'Whitehorse',
            self::AMERICA_WINNIPEG => 'Winnipeg',
            self::AMERICA_YAKUTAT => 'Yakutat',
            self::ANTARCTICA_CASEY => 'Casey',
            self::ANTARCTICA_DAVIS => 'Davis',
            self::ANTARCTICA_DUMONTDURVILLE => 'DumontDUrville',
            self::ANTARCTICA_MACQUARIE => 'Macquarie',
            self::ANTARCTICA_MAWSON => 'Mawson',
            self::ANTARCTICA_MCMURDO => 'McMurdo',
            self::ANTARCTICA_PALMER => 'Palmer',
            self::ANTARCTICA_ROTHERA => 'Rothera',
            self::ANTARCTICA_SYOWA => 'Syowa',
            self::ANTARCTICA_TROLL => 'Troll',
            self::ANTARCTICA_VOSTOK => 'Vostok',
            self::ARCTIC_LONGYEARBYEN => 'Longyearbyen',
            self::ASIA_ADEN => 'Aden',
            self::ASIA_ALMATY => 'Almaty',
            self::ASIA_AMMAN => 'Amman',
            self::ASIA_ANADYR => 'Anadyr',
            self::ASIA_AQTAU => 'Aqtau',
            self::ASIA_AQTOBE => 'Aqtobe',
            self::ASIA_ASHGABAT => 'Ashgabat',
            self::ASIA_ATYRAU => 'Atyrau',
            self::ASIA_BAGHDAD => 'Baghdad',
            self::ASIA_BAHRAIN => 'Bahrain',
            self::ASIA_BAKU => 'Baku',
            self::ASIA_BANGKOK => 'Bangkok',
            self::ASIA_BARNAUL => 'Barnaul',
            self::ASIA_BEIRUT => 'Beirut',
            self::ASIA_BISHKEK => 'Bishkek',
            self::ASIA_BRUNEI => 'Brunei',
            self::ASIA_CHITA => 'Chita',
            self::ASIA_CHOIBALSAN => 'Choibalsan',
            self::ASIA_COLOMBO => 'Colombo',
            self::ASIA_DAMASCUS => 'Damascus',
            self::ASIA_DHAKA => 'Dhaka',
            self::ASIA_DILI => 'Dili',
            self::ASIA_DUBAI => 'Dubai',
            self::ASIA_DUSHANBE => 'Dushanbe',
            self::ASIA_FAMAGUSTA => 'Famagusta',
            self::ASIA_GAZA => 'Gaza',
            self::ASIA_HEBRON => 'Hebron',
            self::ASIA_HO_CHI_MINH => 'Ho Chi Minh',
            self::ASIA_HONG_KONG => 'Hong Kong',
            self::ASIA_HOVD => 'Hovd',
            self::ASIA_IRKUTSK => 'Irkutsk',
            self::ASIA_JAKARTA => 'Jakarta',
            self::ASIA_JAYAPURA => 'Jayapura',
            self::ASIA_JERUSALEM => 'Jerusalem',
            self::ASIA_KABUL => 'Kabul',
            self::ASIA_KAMCHATKA => 'Kamchatka',
            self::ASIA_KARACHI => 'Karachi',
            self::ASIA_KATHMANDU => 'Kathmandu',
            self::ASIA_KHANDYGA => 'Khandyga',
            self::ASIA_KOLKATA => 'Kolkata',
            self::ASIA_KRASNOYARSK => 'Krasnoyarsk',
            self::ASIA_KUALA_LUMPUR => 'Kuala Lumpur',
            self::ASIA_KUCHING => 'Kuching',
            self::ASIA_KUWAIT => 'Kuwait',
            self::ASIA_MACAU => 'Macau',
            self::ASIA_MAGADAN => 'Magadan',
            self::ASIA_MAKASSAR => 'Makassar',
            self::ASIA_MANILA => 'Manila',
            self::ASIA_MUSCAT => 'Muscat',
            self::ASIA_NICOSIA => 'Nicosia',
            self::ASIA_NOVOKUZNETSK => 'Novokuznetsk',
            self::ASIA_NOVOSIBIRSK => 'Novosibirsk',
            self::ASIA_OMSK => 'Omsk',
            self::ASIA_ORAL => 'Oral',
            self::ASIA_PHNOM_PENH => 'Phnom Penh',
            self::ASIA_PONTIANAK => 'Pontianak',
            self::ASIA_PYONGYANG => 'Pyongyang',
            self::ASIA_QATAR => 'Qatar',
            self::ASIA_QOSTANAY => 'Qostanay',
            self::ASIA_QYZYLORDA => 'Qyzylorda',
            self::ASIA_RIYADH => 'Riyadh',
            self::ASIA_SAKHALIN => 'Sakhalin',
            self::ASIA_SAMARKAND => 'Samarkand',
            self::ASIA_SEOUL => 'Seoul',
            self::ASIA_SHANGHAI => 'Shanghai',
            self::ASIA_SINGAPORE => 'Singapore',
            self::ASIA_SREDNEKOLYMSK => 'Srednekolymsk',
            self::ASIA_TAIPEI => 'Taipei',
            self::ASIA_TASHKENT => 'Tashkent',
            self::ASIA_TBILISI => 'Tbilisi',
            self::ASIA_TEHRAN => 'Tehran',
            self::ASIA_THIMPHU => 'Thimphu',
            self::ASIA_TOKYO => 'Tokyo',
            self::ASIA_TOMSK => 'Tomsk',
            self::ASIA_ULAANBAATAR => 'Ulaanbaatar',
            self::ASIA_URUMQI => 'Urumqi',
            self::ASIA_UST_NERA => 'Ust-Nera',
            self::ASIA_VIENTIANE => 'Vientiane',
            self::ASIA_VLADIVOSTOK => 'Vladivostok',
            self::ASIA_YAKUTSK => 'Yakutsk',
            self::ASIA_YANGON => 'Yangon',
            self::ASIA_YEKATERINBURG => 'Yekaterinburg',
            self::ASIA_YEREVAN => 'Yerevan',
            self::ATLANTIC_AZORES => 'Azores',
            self::ATLANTIC_BERMUDA => 'Bermuda',
            self::ATLANTIC_CANARY => 'Canary',
            self::ATLANTIC_CAPE_VERDE => 'Cape Verde',
            self::ATLANTIC_FAROE => 'Faroe',
            self::ATLANTIC_MADEIRA => 'Madeira',
            self::ATLANTIC_REYKJAVIK => 'Reykjavik',
            self::ATLANTIC_SOUTH_GEORGIA => 'South Georgia',
            self::ATLANTIC_ST_HELENA => 'St Helena',
            self::ATLANTIC_STANLEY => 'Stanley',
            self::AUSTRALIA_ADELAIDE => 'Adelaide',
            self::AUSTRALIA_BRISBANE => 'Brisbane',
            self::AUSTRALIA_BROKEN_HILL => 'Broken Hill',
            self::AUSTRALIA_DARWIN => 'Darwin',
            self::AUSTRALIA_EUCLA => 'Eucla',
            self::AUSTRALIA_HOBART => 'Hobart',
            self::AUSTRALIA_LINDEMAN => 'Lindeman',
            self::AUSTRALIA_LORD_HOWE => 'Lord Howe',
            self::AUSTRALIA_MELBOURNE => 'Melbourne',
            self::AUSTRALIA_PERTH => 'Perth',
            self::AUSTRALIA_SYDNEY => 'Sydney',
            self::EUROPE_AMSTERDAM => 'Amsterdam',
            self::EUROPE_ANDORRA => 'Andorra',
            self::EUROPE_ASTRAKHAN => 'Astrakhan',
            self::EUROPE_ATHENS => 'Athens',
            self::EUROPE_BELGRADE => 'Belgrade',
            self::EUROPE_BERLIN => 'Berlin',
            self::EUROPE_BRATISLAVA => 'Bratislava',
            self::EUROPE_BRUSSELS => 'Brussels',
            self::EUROPE_BUCHAREST => 'Bucharest',
            self::EUROPE_BUDAPEST => 'Budapest',
            self::EUROPE_BUSINGEN => 'Busingen',
            self::EUROPE_CHISINAU => 'Chisinau',
            self::EUROPE_COPENHAGEN => 'Copenhagen',
            self::EUROPE_DUBLIN => 'Dublin',
            self::EUROPE_GIBRALTAR => 'Gibraltar',
            self::EUROPE_GUERNSEY => 'Guernsey',
            self::EUROPE_HELSINKI => 'Helsinki',
            self::EUROPE_ISLE_OF_MAN => 'Isle of Man',
            self::EUROPE_ISTANBUL => 'Istanbul',
            self::EUROPE_JERSEY => 'Jersey',
            self::EUROPE_KALININGRAD => 'Kaliningrad',
            self::EUROPE_KIROV => 'Kirov',
            self::EUROPE_KYIV => 'Kyiv',
            self::EUROPE_LISBON => 'Lisbon',
            self::EUROPE_LJUBLJANA => 'Ljubljana',
            self::EUROPE_LONDON => 'London',
            self::EUROPE_LUXEMBOURG => 'Luxembourg',
            self::EUROPE_MADRID => 'Madrid',
            self::EUROPE_MALTA => 'Malta',
            self::EUROPE_MARIEHAMN => 'Mariehamn',
            self::EUROPE_MINSK => 'Minsk',
            self::EUROPE_MONACO => 'Monaco',
            self::EUROPE_MOSCOW => 'Moscow',
            self::EUROPE_OSLO => 'Oslo',
            self::EUROPE_PARIS => 'Paris',
            self::EUROPE_PODGORICA => 'Podgorica',
            self::EUROPE_PRAGUE => 'Prague',
            self::EUROPE_RIGA => 'Riga',
            self::EUROPE_ROME => 'Rome',
            self::EUROPE_SAMARA => 'Samara',
            self::EUROPE_SAN_MARINO => 'San Marino',
            self::EUROPE_SARAJEVO => 'Sarajevo',
            self::EUROPE_SARATOV => 'Saratov',
            self::EUROPE_SIMFEROPOL => 'Simferopol',
            self::EUROPE_SKOPJE => 'Skopje',
            self::EUROPE_SOFIA => 'Sofia',
            self::EUROPE_STOCKHOLM => 'Stockholm',
            self::EUROPE_TALLINN => 'Tallinn',
            self::EUROPE_TIRANE => 'Tirane',
            self::EUROPE_ULYANOVSK => 'Ulyanovsk',
            self::EUROPE_VADUZ => 'Vaduz',
            self::EUROPE_VATICAN => 'Vatican',
            self::EUROPE_VIENNA => 'Vienna',
            self::EUROPE_VILNIUS => 'Vilnius',
            self::EUROPE_VOLGOGRAD => 'Volgograd',
            self::EUROPE_WARSAW => 'Warsaw',
            self::EUROPE_ZAGREB => 'Zagreb',
            self::EUROPE_ZURICH => 'Zurich',
            self::INDIAN_ANTANANARIVO => 'Antananarivo (EAT)',
            self::INDIAN_CHAGOS => 'Chagos',
            self::INDIAN_CHRISTMAS => 'Christmas',
            self::INDIAN_COCOS => 'Cocos',
            self::INDIAN_COMORO => 'Comoro (EAT)',
            self::INDIAN_KERGUELEN => 'Kerguelen',
            self::INDIAN_MAHE => 'Mahe',
            self::INDIAN_MALDIVES => 'Maldives',
            self::INDIAN_MAURITIUS => 'Mauritius',
            self::INDIAN_MAYOTTE => 'Mayotte (EAT)',
            self::INDIAN_REUNION => 'Reunion',
            self::PACIFIC_APIA => 'Apia',
            self::PACIFIC_AUCKLAND => 'Auckland',
            self::PACIFIC_BOUGAINVILLE => 'Bougainville',
            self::PACIFIC_CHATHAM => 'Chatham',
            self::PACIFIC_CHUUK => 'Chuuk',
            self::PACIFIC_EASTER => 'Easter',
            self::PACIFIC_EFATE => 'Efate',
            self::PACIFIC_FAKAOFO => 'Fakaofo',
            self::PACIFIC_FIJI => 'Fiji',
            self::PACIFIC_FUNAFUTI => 'Funafuti',
            self::PACIFIC_GALAPAGOS => 'Galapagos',
            self::PACIFIC_GAMBIER => 'Gambier',
            self::PACIFIC_GUADALCANAL => 'Guadalcanal',
            self::PACIFIC_GUAM => 'Guam',
            self::PACIFIC_HONOLULU => 'Honolulu',
            self::PACIFIC_KANTON => 'Kanton',
            self::PACIFIC_KIRITIMATI => 'Kiritimati',
            self::PACIFIC_KOSRAE => 'Kosrae',
            self::PACIFIC_KWAJALEIN => 'Kwajalein',
            self::PACIFIC_MAJURO => 'Majuro',
            self::PACIFIC_MARQUESAS => 'Marquesas',
            self::PACIFIC_MIDWAY => 'Midway',
            self::PACIFIC_NAURU => 'Nauru',
            self::PACIFIC_NIUE => 'Niue',
            self::PACIFIC_NORFOLK => 'Norfolk',
            self::PACIFIC_NOUMEA => 'Noumea',
            self::PACIFIC_PAGO_PAGO => 'Pago Pago',
            self::PACIFIC_PALAU => 'Palau',
            self::PACIFIC_PITCAIRN => 'Pitcairn',
            self::PACIFIC_POHNPEI => 'Pohnpei',
            self::PACIFIC_PORT_MORESBY => 'Port Moresby',
            self::PACIFIC_RAROTONGA => 'Rarotonga',
            self::PACIFIC_SAIPAN => 'Saipan',
            self::PACIFIC_TAHITI => 'Tahiti',
            self::PACIFIC_TARAWA => 'Tarawa',
            self::PACIFIC_TONGATAPU => 'Tongatapu',
            self::PACIFIC_WAKE => 'Wake',
            self::PACIFIC_WALLIS => 'Wallis',
        };
    }
}